// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package appconfigiface provides an interface to enable mocking the Amazon AppConfig service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package appconfigiface

import (
	"github.com/aws/aws-sdk-go-v2/service/appconfig"
)

// ClientAPI provides an interface to enable mocking the
// appconfig.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AppConfig.
//    func myFunc(svc appconfigiface.ClientAPI) bool {
//        // Make svc.CreateApplication request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := appconfig.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        appconfigiface.ClientPI
//    }
//    func (m *mockClientClient) CreateApplication(input *appconfig.CreateApplicationInput) (*appconfig.CreateApplicationOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateApplicationRequest(*appconfig.CreateApplicationInput) appconfig.CreateApplicationRequest

	CreateConfigurationProfileRequest(*appconfig.CreateConfigurationProfileInput) appconfig.CreateConfigurationProfileRequest

	CreateDeploymentStrategyRequest(*appconfig.CreateDeploymentStrategyInput) appconfig.CreateDeploymentStrategyRequest

	CreateEnvironmentRequest(*appconfig.CreateEnvironmentInput) appconfig.CreateEnvironmentRequest

	DeleteApplicationRequest(*appconfig.DeleteApplicationInput) appconfig.DeleteApplicationRequest

	DeleteConfigurationProfileRequest(*appconfig.DeleteConfigurationProfileInput) appconfig.DeleteConfigurationProfileRequest

	DeleteDeploymentStrategyRequest(*appconfig.DeleteDeploymentStrategyInput) appconfig.DeleteDeploymentStrategyRequest

	DeleteEnvironmentRequest(*appconfig.DeleteEnvironmentInput) appconfig.DeleteEnvironmentRequest

	GetApplicationRequest(*appconfig.GetApplicationInput) appconfig.GetApplicationRequest

	GetConfigurationRequest(*appconfig.GetConfigurationInput) appconfig.GetConfigurationRequest

	GetConfigurationProfileRequest(*appconfig.GetConfigurationProfileInput) appconfig.GetConfigurationProfileRequest

	GetDeploymentRequest(*appconfig.GetDeploymentInput) appconfig.GetDeploymentRequest

	GetDeploymentStrategyRequest(*appconfig.GetDeploymentStrategyInput) appconfig.GetDeploymentStrategyRequest

	GetEnvironmentRequest(*appconfig.GetEnvironmentInput) appconfig.GetEnvironmentRequest

	ListApplicationsRequest(*appconfig.ListApplicationsInput) appconfig.ListApplicationsRequest

	ListConfigurationProfilesRequest(*appconfig.ListConfigurationProfilesInput) appconfig.ListConfigurationProfilesRequest

	ListDeploymentStrategiesRequest(*appconfig.ListDeploymentStrategiesInput) appconfig.ListDeploymentStrategiesRequest

	ListDeploymentsRequest(*appconfig.ListDeploymentsInput) appconfig.ListDeploymentsRequest

	ListEnvironmentsRequest(*appconfig.ListEnvironmentsInput) appconfig.ListEnvironmentsRequest

	ListTagsForResourceRequest(*appconfig.ListTagsForResourceInput) appconfig.ListTagsForResourceRequest

	StartDeploymentRequest(*appconfig.StartDeploymentInput) appconfig.StartDeploymentRequest

	StopDeploymentRequest(*appconfig.StopDeploymentInput) appconfig.StopDeploymentRequest

	TagResourceRequest(*appconfig.TagResourceInput) appconfig.TagResourceRequest

	UntagResourceRequest(*appconfig.UntagResourceInput) appconfig.UntagResourceRequest

	UpdateApplicationRequest(*appconfig.UpdateApplicationInput) appconfig.UpdateApplicationRequest

	UpdateConfigurationProfileRequest(*appconfig.UpdateConfigurationProfileInput) appconfig.UpdateConfigurationProfileRequest

	UpdateDeploymentStrategyRequest(*appconfig.UpdateDeploymentStrategyInput) appconfig.UpdateDeploymentStrategyRequest

	UpdateEnvironmentRequest(*appconfig.UpdateEnvironmentInput) appconfig.UpdateEnvironmentRequest

	ValidateConfigurationRequest(*appconfig.ValidateConfigurationInput) appconfig.ValidateConfigurationRequest
}

var _ ClientAPI = (*appconfig.Client)(nil)
