// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListManagedSchemaArnsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The response for ListManagedSchemaArns. When this parameter is used, all
	// minor version ARNs for a major version are listed.
	SchemaArn *string `type:"string"`
}

// String returns the string representation
func (s ListManagedSchemaArnsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListManagedSchemaArnsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListManagedSchemaArnsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListManagedSchemaArnsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SchemaArn != nil {
		v := *s.SchemaArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SchemaArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListManagedSchemaArnsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The ARNs for all AWS managed schemas.
	SchemaArns []string `type:"list"`
}

// String returns the string representation
func (s ListManagedSchemaArnsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListManagedSchemaArnsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SchemaArns != nil {
		v := s.SchemaArns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SchemaArns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

const opListManagedSchemaArns = "ListManagedSchemaArns"

// ListManagedSchemaArnsRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Lists the major version families of each managed schema. If a major version
// ARN is provided as SchemaArn, the minor version revisions in that family
// are listed instead.
//
//    // Example sending a request using ListManagedSchemaArnsRequest.
//    req := client.ListManagedSchemaArnsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListManagedSchemaArns
func (c *Client) ListManagedSchemaArnsRequest(input *ListManagedSchemaArnsInput) ListManagedSchemaArnsRequest {
	op := &aws.Operation{
		Name:       opListManagedSchemaArns,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/managed",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListManagedSchemaArnsInput{}
	}

	req := c.newRequest(op, input, &ListManagedSchemaArnsOutput{})
	return ListManagedSchemaArnsRequest{Request: req, Input: input, Copy: c.ListManagedSchemaArnsRequest}
}

// ListManagedSchemaArnsRequest is the request type for the
// ListManagedSchemaArns API operation.
type ListManagedSchemaArnsRequest struct {
	*aws.Request
	Input *ListManagedSchemaArnsInput
	Copy  func(*ListManagedSchemaArnsInput) ListManagedSchemaArnsRequest
}

// Send marshals and sends the ListManagedSchemaArns API request.
func (r ListManagedSchemaArnsRequest) Send(ctx context.Context) (*ListManagedSchemaArnsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListManagedSchemaArnsResponse{
		ListManagedSchemaArnsOutput: r.Request.Data.(*ListManagedSchemaArnsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListManagedSchemaArnsRequestPaginator returns a paginator for ListManagedSchemaArns.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListManagedSchemaArnsRequest(input)
//   p := clouddirectory.NewListManagedSchemaArnsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListManagedSchemaArnsPaginator(req ListManagedSchemaArnsRequest) ListManagedSchemaArnsPaginator {
	return ListManagedSchemaArnsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListManagedSchemaArnsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListManagedSchemaArnsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListManagedSchemaArnsPaginator struct {
	aws.Pager
}

func (p *ListManagedSchemaArnsPaginator) CurrentPage() *ListManagedSchemaArnsOutput {
	return p.Pager.CurrentPage().(*ListManagedSchemaArnsOutput)
}

// ListManagedSchemaArnsResponse is the response type for the
// ListManagedSchemaArns API operation.
type ListManagedSchemaArnsResponse struct {
	*ListManagedSchemaArnsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListManagedSchemaArns request.
func (r *ListManagedSchemaArnsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
