// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type RegisterWebhookWithThirdPartyInput struct {
	_ struct{} `type:"structure"`

	// The name of an existing webhook created with PutWebhook to register with
	// a supported third party.
	WebhookName *string `locationName:"webhookName" min:"1" type:"string"`
}

// String returns the string representation
func (s RegisterWebhookWithThirdPartyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterWebhookWithThirdPartyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterWebhookWithThirdPartyInput"}
	if s.WebhookName != nil && len(*s.WebhookName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WebhookName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RegisterWebhookWithThirdPartyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterWebhookWithThirdPartyOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterWebhookWithThirdParty = "RegisterWebhookWithThirdParty"

// RegisterWebhookWithThirdPartyRequest returns a request value for making API operation for
// AWS CodePipeline.
//
// Configures a connection between the webhook that was created and the external
// tool with events to be detected.
//
//    // Example sending a request using RegisterWebhookWithThirdPartyRequest.
//    req := client.RegisterWebhookWithThirdPartyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/RegisterWebhookWithThirdParty
func (c *Client) RegisterWebhookWithThirdPartyRequest(input *RegisterWebhookWithThirdPartyInput) RegisterWebhookWithThirdPartyRequest {
	op := &aws.Operation{
		Name:       opRegisterWebhookWithThirdParty,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterWebhookWithThirdPartyInput{}
	}

	req := c.newRequest(op, input, &RegisterWebhookWithThirdPartyOutput{})
	return RegisterWebhookWithThirdPartyRequest{Request: req, Input: input, Copy: c.RegisterWebhookWithThirdPartyRequest}
}

// RegisterWebhookWithThirdPartyRequest is the request type for the
// RegisterWebhookWithThirdParty API operation.
type RegisterWebhookWithThirdPartyRequest struct {
	*aws.Request
	Input *RegisterWebhookWithThirdPartyInput
	Copy  func(*RegisterWebhookWithThirdPartyInput) RegisterWebhookWithThirdPartyRequest
}

// Send marshals and sends the RegisterWebhookWithThirdParty API request.
func (r RegisterWebhookWithThirdPartyRequest) Send(ctx context.Context) (*RegisterWebhookWithThirdPartyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterWebhookWithThirdPartyResponse{
		RegisterWebhookWithThirdPartyOutput: r.Request.Data.(*RegisterWebhookWithThirdPartyOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterWebhookWithThirdPartyResponse is the response type for the
// RegisterWebhookWithThirdParty API operation.
type RegisterWebhookWithThirdPartyResponse struct {
	*RegisterWebhookWithThirdPartyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterWebhookWithThirdParty request.
func (r *RegisterWebhookWithThirdPartyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
