// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codestar

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Location and destination information about the source code files provided
// with the project request. The source code is uploaded to the new project
// source repository after project creation.
type Code struct {
	_ struct{} `type:"structure"`

	// The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit
	// or GitHub. After AWS CodeStar provisions the new repository, the source code
	// files provided with the project request are placed in the repository.
	//
	// Destination is a required field
	Destination *CodeDestination `locationName:"destination" type:"structure" required:"true"`

	// The location where the source code files provided with the project request
	// are stored. AWS CodeStar retrieves the files during project creation.
	//
	// Source is a required field
	Source *CodeSource `locationName:"source" type:"structure" required:"true"`
}

// String returns the string representation
func (s Code) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Code) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Code"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}

	if s.Source == nil {
		invalidParams.Add(aws.NewErrParamRequired("Source"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(aws.ErrInvalidParams))
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the AWS CodeCommit repository to be created in AWS CodeStar.
// This is where the source code files provided with the project request will
// be uploaded after project creation.
type CodeCommitCodeDestination struct {
	_ struct{} `type:"structure"`

	// The name of the AWS CodeCommit repository to be created in AWS CodeStar.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CodeCommitCodeDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeCommitCodeDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeCommitCodeDestination"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The repository to be created in AWS CodeStar. Valid values are AWS CodeCommit
// or GitHub. After AWS CodeStar provisions the new repository, the source code
// files provided with the project request are placed in the repository.
type CodeDestination struct {
	_ struct{} `type:"structure"`

	// Information about the AWS CodeCommit repository to be created in AWS CodeStar.
	// This is where the source code files provided with the project request will
	// be uploaded after project creation.
	CodeCommit *CodeCommitCodeDestination `locationName:"codeCommit" type:"structure"`

	// Information about the GitHub repository to be created in AWS CodeStar. This
	// is where the source code files provided with the project request will be
	// uploaded after project creation.
	GitHub *GitHubCodeDestination `locationName:"gitHub" type:"structure"`
}

// String returns the string representation
func (s CodeDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeDestination"}
	if s.CodeCommit != nil {
		if err := s.CodeCommit.Validate(); err != nil {
			invalidParams.AddNested("CodeCommit", err.(aws.ErrInvalidParams))
		}
	}
	if s.GitHub != nil {
		if err := s.GitHub.Validate(); err != nil {
			invalidParams.AddNested("GitHub", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The location where the source code files provided with the project request
// are stored. AWS CodeStar retrieves the files during project creation.
type CodeSource struct {
	_ struct{} `type:"structure"`

	// Information about the Amazon S3 location where the source code files provided
	// with the project request are stored.
	//
	// S3 is a required field
	S3 *S3Location `locationName:"s3" type:"structure" required:"true"`
}

// String returns the string representation
func (s CodeSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeSource"}

	if s.S3 == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3"))
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about the GitHub repository to be created in AWS CodeStar. This
// is where the source code files provided with the project request will be
// uploaded after project creation.
type GitHubCodeDestination struct {
	_ struct{} `type:"structure"`

	// Description for the GitHub repository to be created in AWS CodeStar. This
	// description displays in GitHub after the repository is created.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Whether to enable issues for the GitHub repository.
	//
	// IssuesEnabled is a required field
	IssuesEnabled *bool `locationName:"issuesEnabled" type:"boolean" required:"true"`

	// Name of the GitHub repository to be created in AWS CodeStar.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The GitHub username for the owner of the GitHub repository to be created
	// in AWS CodeStar. If this repository should be owned by a GitHub organization,
	// provide its name.
	//
	// Owner is a required field
	Owner *string `locationName:"owner" min:"1" type:"string" required:"true"`

	// Whether the GitHub repository is to be a private repository.
	//
	// PrivateRepository is a required field
	PrivateRepository *bool `locationName:"privateRepository" type:"boolean" required:"true"`

	// The GitHub user's personal access token for the GitHub repository.
	//
	// Token is a required field
	Token *string `locationName:"token" min:"1" type:"string" required:"true" sensitive:"true"`

	// The type of GitHub repository to be created in AWS CodeStar. Valid values
	// are User or Organization.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation
func (s GitHubCodeDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GitHubCodeDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GitHubCodeDestination"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.IssuesEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("IssuesEnabled"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Owner == nil {
		invalidParams.Add(aws.NewErrParamRequired("Owner"))
	}
	if s.Owner != nil && len(*s.Owner) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Owner", 1))
	}

	if s.PrivateRepository == nil {
		invalidParams.Add(aws.NewErrParamRequired("PrivateRepository"))
	}

	if s.Token == nil {
		invalidParams.Add(aws.NewErrParamRequired("Token"))
	}
	if s.Token != nil && len(*s.Token) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Token", 1))
	}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An indication of whether a project creation or deletion is failed or successful.
type ProjectStatus struct {
	_ struct{} `type:"structure"`

	// In the case of a project creation or deletion failure, a reason for the failure.
	Reason *string `locationName:"reason" type:"string"`

	// The phase of completion for a project creation or deletion.
	//
	// State is a required field
	State *string `locationName:"state" type:"string" required:"true"`
}

// String returns the string representation
func (s ProjectStatus) String() string {
	return awsutil.Prettify(s)
}

// Information about the metadata for a project.
type ProjectSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the project.
	ProjectArn *string `locationName:"projectArn" type:"string"`

	// The ID of the project.
	ProjectId *string `locationName:"projectId" min:"2" type:"string"`
}

// String returns the string representation
func (s ProjectSummary) String() string {
	return awsutil.Prettify(s)
}

// Information about a resource for a project.
type Resource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// Id is a required field
	Id *string `locationName:"id" min:"11" type:"string" required:"true"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// The Amazon S3 location where the source code files provided with the project
// request are stored.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 object key where the source code files provided with the project
	// request are stored.
	BucketKey *string `locationName:"bucketKey" type:"string"`

	// The Amazon S3 bucket name where the source code files provided with the project
	// request are stored.
	BucketName *string `locationName:"bucketName" min:"3" type:"string"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Location"}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a team member in a project.
type TeamMember struct {
	_ struct{} `type:"structure"`

	// The role assigned to the user in the project. Project roles have different
	// levels of access. For more information, see Working with Teams (http://docs.aws.amazon.com/codestar/latest/userguide/working-with-teams.html)
	// in the AWS CodeStar User Guide.
	//
	// ProjectRole is a required field
	ProjectRole *string `locationName:"projectRole" type:"string" required:"true"`

	// Whether the user is allowed to remotely access project resources using an
	// SSH public/private key pair.
	RemoteAccessAllowed *bool `locationName:"remoteAccessAllowed" type:"boolean"`

	// The Amazon Resource Name (ARN) of the user in IAM.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s TeamMember) String() string {
	return awsutil.Prettify(s)
}

// The toolchain template file provided with the project request. AWS CodeStar
// uses the template to provision the toolchain stack in AWS CloudFormation.
type Toolchain struct {
	_ struct{} `type:"structure"`

	// The service role ARN for AWS CodeStar to use for the toolchain template during
	// stack provisioning.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// The Amazon S3 location where the toolchain template file provided with the
	// project request is stored. AWS CodeStar retrieves the file during project
	// creation.
	//
	// Source is a required field
	Source *ToolchainSource `locationName:"source" type:"structure" required:"true"`

	// The list of parameter overrides to be passed into the toolchain template
	// during stack provisioning, if any.
	StackParameters map[string]string `locationName:"stackParameters" type:"map"`
}

// String returns the string representation
func (s Toolchain) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Toolchain) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Toolchain"}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}

	if s.Source == nil {
		invalidParams.Add(aws.NewErrParamRequired("Source"))
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Amazon S3 location where the toolchain template file provided with the
// project request is stored. AWS CodeStar retrieves the file during project
// creation.
type ToolchainSource struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket where the toolchain template file provided with the
	// project request is stored.
	//
	// S3 is a required field
	S3 *S3Location `locationName:"s3" type:"structure" required:"true"`
}

// String returns the string representation
func (s ToolchainSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ToolchainSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ToolchainSource"}

	if s.S3 == nil {
		invalidParams.Add(aws.NewErrParamRequired("S3"))
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Information about a user's profile in AWS CodeStar.
type UserProfileSummary struct {
	_ struct{} `type:"structure"`

	// The display name of a user in AWS CodeStar. For example, this could be set
	// to both first and last name ("Mary Major") or a single name ("Mary"). The
	// display name is also used to generate the initial icon associated with the
	// user in AWS CodeStar projects. If spaces are included in the display name,
	// the first character that appears after the space will be used as the second
	// character in the user initial icon. The initial icon displays a maximum of
	// two characters, so a display name with more than one space (for example "Mary
	// Jane Major") would generate an initial icon using the first character and
	// the first character after the space ("MJ", not "MM").
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The email address associated with the user.
	EmailAddress *string `locationName:"emailAddress" min:"3" type:"string" sensitive:"true"`

	// The SSH public key associated with the user in AWS CodeStar. If a project
	// owner allows the user remote access to project resources, this public key
	// will be used along with the user's private key for SSH access.
	SshPublicKey *string `locationName:"sshPublicKey" type:"string"`

	// The Amazon Resource Name (ARN) of the user in IAM.
	UserArn *string `locationName:"userArn" min:"32" type:"string"`
}

// String returns the string representation
func (s UserProfileSummary) String() string {
	return awsutil.Prettify(s)
}
