// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentity

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Input to the DescribeIdentity action.
type DescribeIdentityInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier in the format REGION:GUID.
	//
	// IdentityId is a required field
	IdentityId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeIdentityInput"}

	if s.IdentityId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IdentityId"))
	}
	if s.IdentityId != nil && len(*s.IdentityId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdentityId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A description of the identity.
type DescribeIdentityOutput struct {
	_ struct{} `type:"structure"`

	// Date on which the identity was created.
	CreationDate *time.Time `type:"timestamp"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// Date on which the identity was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The provider names.
	Logins []string `type:"list"`
}

// String returns the string representation
func (s DescribeIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeIdentity = "DescribeIdentity"

// DescribeIdentityRequest returns a request value for making API operation for
// Amazon Cognito Identity.
//
// Returns metadata related to the given identity, including when the identity
// was created and any associated linked logins.
//
// You must use AWS Developer credentials to call this API.
//
//    // Example sending a request using DescribeIdentityRequest.
//    req := client.DescribeIdentityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-identity-2014-06-30/DescribeIdentity
func (c *Client) DescribeIdentityRequest(input *DescribeIdentityInput) DescribeIdentityRequest {
	op := &aws.Operation{
		Name:       opDescribeIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIdentityInput{}
	}

	req := c.newRequest(op, input, &DescribeIdentityOutput{})
	return DescribeIdentityRequest{Request: req, Input: input, Copy: c.DescribeIdentityRequest}
}

// DescribeIdentityRequest is the request type for the
// DescribeIdentity API operation.
type DescribeIdentityRequest struct {
	*aws.Request
	Input *DescribeIdentityInput
	Copy  func(*DescribeIdentityInput) DescribeIdentityRequest
}

// Send marshals and sends the DescribeIdentity API request.
func (r DescribeIdentityRequest) Send(ctx context.Context) (*DescribeIdentityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeIdentityResponse{
		DescribeIdentityOutput: r.Request.Data.(*DescribeIdentityOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeIdentityResponse is the response type for the
// DescribeIdentity API operation.
type DescribeIdentityResponse struct {
	*DescribeIdentityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeIdentity request.
func (r *DescribeIdentityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
