// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to list devices, as an administrator.
type AdminListDevicesInput struct {
	_ struct{} `type:"structure"`

	// The limit of the devices request.
	Limit *int64 `type:"integer"`

	// The pagination token.
	PaginationToken *string `min:"1" type:"string"`

	// The user pool ID.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`

	// The user name.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s AdminListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AdminListDevicesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AdminListDevicesInput"}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PaginationToken", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if s.Username == nil {
		invalidParams.Add(aws.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Username", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Lists the device's response, as an administrator.
type AdminListDevicesOutput struct {
	_ struct{} `type:"structure"`

	// The devices in the list of devices response.
	Devices []DeviceType `type:"list"`

	// The pagination token.
	PaginationToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AdminListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

const opAdminListDevices = "AdminListDevices"

// AdminListDevicesRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Lists devices, as an administrator.
//
// Calling this action requires developer credentials.
//
//    // Example sending a request using AdminListDevicesRequest.
//    req := client.AdminListDevicesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/AdminListDevices
func (c *Client) AdminListDevicesRequest(input *AdminListDevicesInput) AdminListDevicesRequest {
	op := &aws.Operation{
		Name:       opAdminListDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AdminListDevicesInput{}
	}

	req := c.newRequest(op, input, &AdminListDevicesOutput{})
	return AdminListDevicesRequest{Request: req, Input: input, Copy: c.AdminListDevicesRequest}
}

// AdminListDevicesRequest is the request type for the
// AdminListDevices API operation.
type AdminListDevicesRequest struct {
	*aws.Request
	Input *AdminListDevicesInput
	Copy  func(*AdminListDevicesInput) AdminListDevicesRequest
}

// Send marshals and sends the AdminListDevices API request.
func (r AdminListDevicesRequest) Send(ctx context.Context) (*AdminListDevicesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AdminListDevicesResponse{
		AdminListDevicesOutput: r.Request.Data.(*AdminListDevicesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AdminListDevicesResponse is the response type for the
// AdminListDevices API operation.
type AdminListDevicesResponse struct {
	*AdminListDevicesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AdminListDevices request.
func (r *AdminListDevicesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
