// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ReloadTablesInput struct {
	_ struct{} `type:"structure"`

	// Options for reload. Specify data-reload to reload the data and re-validate
	// it if validation is enabled. Specify validate-only to re-validate the table.
	// This option applies only when validation is enabled for the task.
	//
	// Valid values: data-reload, validate-only
	//
	// Default value is data-reload.
	ReloadOption ReloadOptionValue `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) of the replication task.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`

	// The name and schema of the table to be reloaded.
	//
	// TablesToReload is a required field
	TablesToReload []TableToReload `type:"list" required:"true"`
}

// String returns the string representation
func (s ReloadTablesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReloadTablesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReloadTablesInput"}

	if s.ReplicationTaskArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReplicationTaskArn"))
	}

	if s.TablesToReload == nil {
		invalidParams.Add(aws.NewErrParamRequired("TablesToReload"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ReloadTablesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`
}

// String returns the string representation
func (s ReloadTablesOutput) String() string {
	return awsutil.Prettify(s)
}

const opReloadTables = "ReloadTables"

// ReloadTablesRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// Reloads the target database table with the source data.
//
//    // Example sending a request using ReloadTablesRequest.
//    req := client.ReloadTablesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables
func (c *Client) ReloadTablesRequest(input *ReloadTablesInput) ReloadTablesRequest {
	op := &aws.Operation{
		Name:       opReloadTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReloadTablesInput{}
	}

	req := c.newRequest(op, input, &ReloadTablesOutput{})
	return ReloadTablesRequest{Request: req, Input: input, Copy: c.ReloadTablesRequest}
}

// ReloadTablesRequest is the request type for the
// ReloadTables API operation.
type ReloadTablesRequest struct {
	*aws.Request
	Input *ReloadTablesInput
	Copy  func(*ReloadTablesInput) ReloadTablesRequest
}

// Send marshals and sends the ReloadTables API request.
func (r ReloadTablesRequest) Send(ctx context.Context) (*ReloadTablesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ReloadTablesResponse{
		ReloadTablesOutput: r.Request.Data.(*ReloadTablesOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ReloadTablesResponse is the response type for the
// ReloadTables API operation.
type ReloadTablesResponse struct {
	*ReloadTablesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ReloadTables request.
func (r *ReloadTablesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
