// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dataexchange

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListRevisionAssetsInput struct {
	_ struct{} `type:"structure"`

	// DataSetId is a required field
	DataSetId *string `location:"uri" locationName:"DataSetId" type:"string" required:"true"`

	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// RevisionId is a required field
	RevisionId *string `location:"uri" locationName:"RevisionId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRevisionAssetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRevisionAssetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRevisionAssetsInput"}

	if s.DataSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataSetId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.RevisionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RevisionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRevisionAssetsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DataSetId != nil {
		v := *s.DataSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "DataSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RevisionId != nil {
		v := *s.RevisionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "RevisionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListRevisionAssetsOutput struct {
	_ struct{} `type:"structure"`

	Assets []AssetEntry `type:"list"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListRevisionAssetsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRevisionAssetsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Assets != nil {
		v := s.Assets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Assets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListRevisionAssets = "ListRevisionAssets"

// ListRevisionAssetsRequest returns a request value for making API operation for
// AWS Data Exchange.
//
// This operation lists a revision's assets sorted alphabetically in descending
// order.
//
//    // Example sending a request using ListRevisionAssetsRequest.
//    req := client.ListRevisionAssetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dataexchange-2017-07-25/ListRevisionAssets
func (c *Client) ListRevisionAssetsRequest(input *ListRevisionAssetsInput) ListRevisionAssetsRequest {
	op := &aws.Operation{
		Name:       opListRevisionAssets,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/data-sets/{DataSetId}/revisions/{RevisionId}/assets",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRevisionAssetsInput{}
	}

	req := c.newRequest(op, input, &ListRevisionAssetsOutput{})
	return ListRevisionAssetsRequest{Request: req, Input: input, Copy: c.ListRevisionAssetsRequest}
}

// ListRevisionAssetsRequest is the request type for the
// ListRevisionAssets API operation.
type ListRevisionAssetsRequest struct {
	*aws.Request
	Input *ListRevisionAssetsInput
	Copy  func(*ListRevisionAssetsInput) ListRevisionAssetsRequest
}

// Send marshals and sends the ListRevisionAssets API request.
func (r ListRevisionAssetsRequest) Send(ctx context.Context) (*ListRevisionAssetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRevisionAssetsResponse{
		ListRevisionAssetsOutput: r.Request.Data.(*ListRevisionAssetsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRevisionAssetsRequestPaginator returns a paginator for ListRevisionAssets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRevisionAssetsRequest(input)
//   p := dataexchange.NewListRevisionAssetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRevisionAssetsPaginator(req ListRevisionAssetsRequest) ListRevisionAssetsPaginator {
	return ListRevisionAssetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRevisionAssetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRevisionAssetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRevisionAssetsPaginator struct {
	aws.Pager
}

func (p *ListRevisionAssetsPaginator) CurrentPage() *ListRevisionAssetsOutput {
	return p.Pager.CurrentPage().(*ListRevisionAssetsOutput)
}

// ListRevisionAssetsResponse is the response type for the
// ListRevisionAssets API operation.
type ListRevisionAssetsResponse struct {
	*ListRevisionAssetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRevisionAssets request.
func (r *ListRevisionAssetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
