// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for CancelBundleTask.
type CancelBundleTaskInput struct {
	_ struct{} `type:"structure"`

	// The ID of the bundle task.
	//
	// BundleId is a required field
	BundleId *string `type:"string" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`
}

// String returns the string representation
func (s CancelBundleTaskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelBundleTaskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CancelBundleTaskInput"}

	if s.BundleId == nil {
		invalidParams.Add(aws.NewErrParamRequired("BundleId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of CancelBundleTask.
type CancelBundleTaskOutput struct {
	_ struct{} `type:"structure"`

	// Information about the bundle task.
	BundleTask *BundleTask `locationName:"bundleInstanceTask" type:"structure"`
}

// String returns the string representation
func (s CancelBundleTaskOutput) String() string {
	return awsutil.Prettify(s)
}

const opCancelBundleTask = "CancelBundleTask"

// CancelBundleTaskRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Cancels a bundling operation for an instance store-backed Windows instance.
//
//    // Example sending a request using CancelBundleTaskRequest.
//    req := client.CancelBundleTaskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CancelBundleTask
func (c *Client) CancelBundleTaskRequest(input *CancelBundleTaskInput) CancelBundleTaskRequest {
	op := &aws.Operation{
		Name:       opCancelBundleTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelBundleTaskInput{}
	}

	req := c.newRequest(op, input, &CancelBundleTaskOutput{})
	return CancelBundleTaskRequest{Request: req, Input: input, Copy: c.CancelBundleTaskRequest}
}

// CancelBundleTaskRequest is the request type for the
// CancelBundleTask API operation.
type CancelBundleTaskRequest struct {
	*aws.Request
	Input *CancelBundleTaskInput
	Copy  func(*CancelBundleTaskInput) CancelBundleTaskRequest
}

// Send marshals and sends the CancelBundleTask API request.
func (r CancelBundleTaskRequest) Send(ctx context.Context) (*CancelBundleTaskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CancelBundleTaskResponse{
		CancelBundleTaskOutput: r.Request.Data.(*CancelBundleTaskOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CancelBundleTaskResponse is the response type for the
// CancelBundleTask API operation.
type CancelBundleTaskResponse struct {
	*CancelBundleTaskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CancelBundleTask request.
func (r *CancelBundleTaskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
