// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of a CreateCacheSecurityGroup operation.
type CreateCacheSecurityGroupInput struct {
	_ struct{} `type:"structure"`

	// A name for the cache security group. This value is stored as a lowercase
	// string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters. Cannot
	// be the word "Default".
	//
	// Example: mysecuritygroup
	//
	// CacheSecurityGroupName is a required field
	CacheSecurityGroupName *string `type:"string" required:"true"`

	// A description for the cache security group.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCacheSecurityGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCacheSecurityGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCacheSecurityGroupInput"}

	if s.CacheSecurityGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CacheSecurityGroupName"))
	}

	if s.Description == nil {
		invalidParams.Add(aws.NewErrParamRequired("Description"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateCacheSecurityGroupOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of one of the following operations:
	//
	//    * AuthorizeCacheSecurityGroupIngress
	//
	//    * CreateCacheSecurityGroup
	//
	//    * RevokeCacheSecurityGroupIngress
	CacheSecurityGroup *CacheSecurityGroup `type:"structure"`
}

// String returns the string representation
func (s CreateCacheSecurityGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateCacheSecurityGroup = "CreateCacheSecurityGroup"

// CreateCacheSecurityGroupRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Creates a new cache security group. Use a cache security group to control
// access to one or more clusters.
//
// Cache security groups are only used when you are creating a cluster outside
// of an Amazon Virtual Private Cloud (Amazon VPC). If you are creating a cluster
// inside of a VPC, use a cache subnet group instead. For more information,
// see CreateCacheSubnetGroup (https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html).
//
//    // Example sending a request using CreateCacheSecurityGroupRequest.
//    req := client.CreateCacheSecurityGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/CreateCacheSecurityGroup
func (c *Client) CreateCacheSecurityGroupRequest(input *CreateCacheSecurityGroupInput) CreateCacheSecurityGroupRequest {
	op := &aws.Operation{
		Name:       opCreateCacheSecurityGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCacheSecurityGroupInput{}
	}

	req := c.newRequest(op, input, &CreateCacheSecurityGroupOutput{})
	return CreateCacheSecurityGroupRequest{Request: req, Input: input, Copy: c.CreateCacheSecurityGroupRequest}
}

// CreateCacheSecurityGroupRequest is the request type for the
// CreateCacheSecurityGroup API operation.
type CreateCacheSecurityGroupRequest struct {
	*aws.Request
	Input *CreateCacheSecurityGroupInput
	Copy  func(*CreateCacheSecurityGroupInput) CreateCacheSecurityGroupRequest
}

// Send marshals and sends the CreateCacheSecurityGroup API request.
func (r CreateCacheSecurityGroupRequest) Send(ctx context.Context) (*CreateCacheSecurityGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCacheSecurityGroupResponse{
		CreateCacheSecurityGroupOutput: r.Request.Data.(*CreateCacheSecurityGroupOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCacheSecurityGroupResponse is the response type for the
// CreateCacheSecurityGroup API operation.
type CreateCacheSecurityGroupResponse struct {
	*CreateCacheSecurityGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCacheSecurityGroup request.
func (r *CreateCacheSecurityGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
