// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
type DeleteMatchmakingRuleSetInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a matchmaking rule set to be deleted. (Note: The rule
	// set name is different from the optional "name" field in the rule set body.)
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteMatchmakingRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMatchmakingRuleSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteMatchmakingRuleSetInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
type DeleteMatchmakingRuleSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteMatchmakingRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteMatchmakingRuleSet = "DeleteMatchmakingRuleSet"

// DeleteMatchmakingRuleSetRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Deletes an existing matchmaking rule set. To delete the rule set, provide
// the rule set name. Rule sets cannot be deleted if they are currently being
// used by a matchmaking configuration.
//
// Learn more
//
//    * Build a Rule Set (https://docs.aws.amazon.com/gamelift/latest/developerguide/match-rulesets.html)
//
// Related operations
//
//    * CreateMatchmakingConfiguration
//
//    * DescribeMatchmakingConfigurations
//
//    * UpdateMatchmakingConfiguration
//
//    * DeleteMatchmakingConfiguration
//
//    * CreateMatchmakingRuleSet
//
//    * DescribeMatchmakingRuleSets
//
//    * ValidateMatchmakingRuleSet
//
//    * DeleteMatchmakingRuleSet
//
//    // Example sending a request using DeleteMatchmakingRuleSetRequest.
//    req := client.DeleteMatchmakingRuleSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingRuleSet
func (c *Client) DeleteMatchmakingRuleSetRequest(input *DeleteMatchmakingRuleSetInput) DeleteMatchmakingRuleSetRequest {
	op := &aws.Operation{
		Name:       opDeleteMatchmakingRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMatchmakingRuleSetInput{}
	}

	req := c.newRequest(op, input, &DeleteMatchmakingRuleSetOutput{})
	return DeleteMatchmakingRuleSetRequest{Request: req, Input: input, Copy: c.DeleteMatchmakingRuleSetRequest}
}

// DeleteMatchmakingRuleSetRequest is the request type for the
// DeleteMatchmakingRuleSet API operation.
type DeleteMatchmakingRuleSetRequest struct {
	*aws.Request
	Input *DeleteMatchmakingRuleSetInput
	Copy  func(*DeleteMatchmakingRuleSetInput) DeleteMatchmakingRuleSetRequest
}

// Send marshals and sends the DeleteMatchmakingRuleSet API request.
func (r DeleteMatchmakingRuleSetRequest) Send(ctx context.Context) (*DeleteMatchmakingRuleSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteMatchmakingRuleSetResponse{
		DeleteMatchmakingRuleSetOutput: r.Request.Data.(*DeleteMatchmakingRuleSetOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteMatchmakingRuleSetResponse is the response type for the
// DeleteMatchmakingRuleSet API operation.
type DeleteMatchmakingRuleSetResponse struct {
	*DeleteMatchmakingRuleSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteMatchmakingRuleSet request.
func (r *DeleteMatchmakingRuleSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
