// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glacier

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Provides options for retrieving metadata for a specific vault in Amazon Glacier.
type DescribeVaultInput struct {
	_ struct{} `type:"structure"`

	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single '-' (hyphen),
	// in which case Amazon S3 Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you use an account ID, do not include
	// any hyphens ('-') in the ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	//
	// VaultName is a required field
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeVaultInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeVaultInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeVaultInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.VaultName == nil {
		invalidParams.Add(aws.NewErrParamRequired("VaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeVaultInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VaultName != nil {
		v := *s.VaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "vaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains the Amazon S3 Glacier response to your request.
type DescribeVaultOutput struct {
	_ struct{} `type:"structure"`

	// The Universal Coordinated Time (UTC) date when the vault was created. This
	// value should be a string in the ISO 8601 date format, for example 2012-03-20T17:03:43.221Z.
	CreationDate *string `type:"string"`

	// The Universal Coordinated Time (UTC) date when Amazon S3 Glacier completed
	// the last vault inventory. This value should be a string in the ISO 8601 date
	// format, for example 2012-03-20T17:03:43.221Z.
	LastInventoryDate *string `type:"string"`

	// The number of archives in the vault as of the last inventory date. This field
	// will return null if an inventory has not yet run on the vault, for example
	// if you just created the vault.
	NumberOfArchives *int64 `type:"long"`

	// Total size, in bytes, of the archives in the vault as of the last inventory
	// date. This field will return null if an inventory has not yet run on the
	// vault, for example if you just created the vault.
	SizeInBytes *int64 `type:"long"`

	// The Amazon Resource Name (ARN) of the vault.
	VaultARN *string `type:"string"`

	// The name of the vault.
	VaultName *string `type:"string"`
}

// String returns the string representation
func (s DescribeVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeVaultOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationDate != nil {
		v := *s.CreationDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastInventoryDate != nil {
		v := *s.LastInventoryDate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastInventoryDate", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NumberOfArchives != nil {
		v := *s.NumberOfArchives

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NumberOfArchives", protocol.Int64Value(v), metadata)
	}
	if s.SizeInBytes != nil {
		v := *s.SizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SizeInBytes", protocol.Int64Value(v), metadata)
	}
	if s.VaultARN != nil {
		v := *s.VaultARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VaultARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VaultName != nil {
		v := *s.VaultName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VaultName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opDescribeVault = "DescribeVault"

// DescribeVaultRequest returns a request value for making API operation for
// Amazon Glacier.
//
// This operation returns information about a vault, including the vault's Amazon
// Resource Name (ARN), the date the vault was created, the number of archives
// it contains, and the total size of all the archives in the vault. The number
// of archives and their total size are as of the last inventory generation.
// This means that if you add or remove an archive from a vault, and then immediately
// use Describe Vault, the change in contents will not be immediately reflected.
// If you want to retrieve the latest inventory of the vault, use InitiateJob.
// Amazon S3 Glacier generates vault inventories approximately daily. For more
// information, see Downloading a Vault Inventory in Amazon S3 Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html).
//
// An AWS account has full permission to perform all operations (actions). However,
// AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, see Retrieving Vault
// Metadata in Amazon S3 Glacier (https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html)
// and Describe Vault (https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-get.html)
// in the Amazon Glacier Developer Guide.
//
//    // Example sending a request using DescribeVaultRequest.
//    req := client.DescribeVaultRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DescribeVaultRequest(input *DescribeVaultInput) DescribeVaultRequest {
	op := &aws.Operation{
		Name:       opDescribeVault,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}",
	}

	if input == nil {
		input = &DescribeVaultInput{}
	}

	req := c.newRequest(op, input, &DescribeVaultOutput{})
	return DescribeVaultRequest{Request: req, Input: input, Copy: c.DescribeVaultRequest}
}

// DescribeVaultRequest is the request type for the
// DescribeVault API operation.
type DescribeVaultRequest struct {
	*aws.Request
	Input *DescribeVaultInput
	Copy  func(*DescribeVaultInput) DescribeVaultRequest
}

// Send marshals and sends the DescribeVault API request.
func (r DescribeVaultRequest) Send(ctx context.Context) (*DescribeVaultResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeVaultResponse{
		DescribeVaultOutput: r.Request.Data.(*DescribeVaultOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeVaultResponse is the response type for the
// DescribeVault API operation.
type DescribeVaultResponse struct {
	*DescribeVaultOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeVault request.
func (r *DescribeVaultResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
