// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetAccountAuthorizationDetailsInput struct {
	_ struct{} `type:"structure"`

	// A list of entity types used to filter the results. Only the entities that
	// match the types you specify are included in the output. Use the value LocalManagedPolicy
	// to include customer managed policies.
	//
	// The format for this parameter is a comma-separated (if more than one) list
	// of strings. Each string value in the list must be one of the valid values
	// listed below.
	Filter []EntityType `type:"list"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, the number of items defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true, and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GetAccountAuthorizationDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccountAuthorizationDetailsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAccountAuthorizationDetailsInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful GetAccountAuthorizationDetails request.
type GetAccountAuthorizationDetailsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing information about IAM groups.
	GroupDetailList []GroupDetail `type:"list"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `type:"string"`

	// A list containing information about managed policies.
	Policies []ManagedPolicyDetail `type:"list"`

	// A list containing information about IAM roles.
	RoleDetailList []RoleDetail `type:"list"`

	// A list containing information about IAM users.
	UserDetailList []UserDetail `type:"list"`
}

// String returns the string representation
func (s GetAccountAuthorizationDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAccountAuthorizationDetails = "GetAccountAuthorizationDetails"

// GetAccountAuthorizationDetailsRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Retrieves information about all IAM users, groups, roles, and policies in
// your AWS account, including their relationships to one another. Use this
// API to obtain a snapshot of the configuration of IAM permissions (users,
// groups, roles, and policies) in your account.
//
// Policies returned by this API are URL-encoded compliant with RFC 3986 (https://tools.ietf.org/html/rfc3986).
// You can use a URL decoding method to convert the policy back to plain JSON
// text. For example, if you use Java, you can use the decode method of the
// java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs
// provide similar functionality.
//
// You can optionally filter the results using the Filter parameter. You can
// paginate the results using the MaxItems and Marker parameters.
//
//    // Example sending a request using GetAccountAuthorizationDetailsRequest.
//    req := client.GetAccountAuthorizationDetailsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails
func (c *Client) GetAccountAuthorizationDetailsRequest(input *GetAccountAuthorizationDetailsInput) GetAccountAuthorizationDetailsRequest {
	op := &aws.Operation{
		Name:       opGetAccountAuthorizationDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &GetAccountAuthorizationDetailsInput{}
	}

	req := c.newRequest(op, input, &GetAccountAuthorizationDetailsOutput{})
	return GetAccountAuthorizationDetailsRequest{Request: req, Input: input, Copy: c.GetAccountAuthorizationDetailsRequest}
}

// GetAccountAuthorizationDetailsRequest is the request type for the
// GetAccountAuthorizationDetails API operation.
type GetAccountAuthorizationDetailsRequest struct {
	*aws.Request
	Input *GetAccountAuthorizationDetailsInput
	Copy  func(*GetAccountAuthorizationDetailsInput) GetAccountAuthorizationDetailsRequest
}

// Send marshals and sends the GetAccountAuthorizationDetails API request.
func (r GetAccountAuthorizationDetailsRequest) Send(ctx context.Context) (*GetAccountAuthorizationDetailsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAccountAuthorizationDetailsResponse{
		GetAccountAuthorizationDetailsOutput: r.Request.Data.(*GetAccountAuthorizationDetailsOutput),
		response:                             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetAccountAuthorizationDetailsRequestPaginator returns a paginator for GetAccountAuthorizationDetails.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetAccountAuthorizationDetailsRequest(input)
//   p := iam.NewGetAccountAuthorizationDetailsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetAccountAuthorizationDetailsPaginator(req GetAccountAuthorizationDetailsRequest) GetAccountAuthorizationDetailsPaginator {
	return GetAccountAuthorizationDetailsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetAccountAuthorizationDetailsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetAccountAuthorizationDetailsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetAccountAuthorizationDetailsPaginator struct {
	aws.Pager
}

func (p *GetAccountAuthorizationDetailsPaginator) CurrentPage() *GetAccountAuthorizationDetailsOutput {
	return p.Pager.CurrentPage().(*GetAccountAuthorizationDetailsOutput)
}

// GetAccountAuthorizationDetailsResponse is the response type for the
// GetAccountAuthorizationDetails API operation.
type GetAccountAuthorizationDetailsResponse struct {
	*GetAccountAuthorizationDetailsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAccountAuthorizationDetails request.
func (r *GetAccountAuthorizationDetailsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
