// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotanalytics

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// An activity that adds other attributes based on existing attributes in the
// message.
type AddAttributesActivity struct {
	_ struct{} `type:"structure"`

	// A list of 1-50 "AttributeNameMapping" objects that map an existing attribute
	// to a new attribute.
	//
	// The existing attributes remain in the message, so if you want to remove the
	// originals, use "RemoveAttributeActivity".
	//
	// Attributes is a required field
	Attributes map[string]string `locationName:"attributes" min:"1" type:"map" required:"true"`

	// The name of the 'addAttributes' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s AddAttributesActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddAttributesActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AddAttributesActivity"}

	if s.Attributes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil && len(s.Attributes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Attributes", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AddAttributesActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "attributes", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Next != nil {
		v := *s.Next

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "next", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains informations about errors.
type BatchPutMessageErrorEntry struct {
	_ struct{} `type:"structure"`

	// The code associated with the error.
	ErrorCode *string `locationName:"errorCode" type:"string"`

	// The message associated with the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The ID of the message that caused the error. (See the value corresponding
	// to the "messageId" key in the message object.)
	MessageId *string `locationName:"messageId" min:"1" type:"string"`
}

// String returns the string representation
func (s BatchPutMessageErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchPutMessageErrorEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorCode != nil {
		v := *s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "messageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A collection of data from an MQTT topic. Channels archive the raw, unprocessed
// messages before publishing the data to a pipeline.
type Channel struct {
	_ struct{} `type:"structure"`

	// The ARN of the channel.
	Arn *string `locationName:"arn" type:"string"`

	// When the channel was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// When the channel was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The name of the channel.
	Name *string `locationName:"name" min:"1" type:"string"`

	// How long, in days, message data is kept for the channel.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// The status of the channel.
	Status ChannelStatus `locationName:"status" type:"string" enum:"true"`

	// Where channel data is stored. You may choose one of "serviceManagedS3" or
	// "customerManagedS3" storage. If not specified, the default is "serviceManagedS3".
	// This cannot be changed after creation of the channel.
	Storage *ChannelStorage `locationName:"storage" type:"structure"`
}

// String returns the string representation
func (s Channel) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Channel) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RetentionPeriod != nil {
		v := s.RetentionPeriod

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "retentionPeriod", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Storage != nil {
		v := s.Storage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "storage", v, metadata)
	}
	return nil
}

// The activity that determines the source of the messages to be processed.
type ChannelActivity struct {
	_ struct{} `type:"structure"`

	// The name of the channel from which the messages are processed.
	//
	// ChannelName is a required field
	ChannelName *string `locationName:"channelName" min:"1" type:"string" required:"true"`

	// The name of the 'channel' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s ChannelActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ChannelActivity"}

	if s.ChannelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChannelName"))
	}
	if s.ChannelName != nil && len(*s.ChannelName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChannelName", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChannelActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChannelName != nil {
		v := *s.ChannelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Next != nil {
		v := *s.Next

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "next", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Statistics information about the channel.
type ChannelStatistics struct {
	_ struct{} `type:"structure"`

	// The estimated size of the channel.
	Size *EstimatedResourceSize `locationName:"size" type:"structure"`
}

// String returns the string representation
func (s ChannelStatistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChannelStatistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.Size != nil {
		v := s.Size

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "size", v, metadata)
	}
	return nil
}

// Where channel data is stored. You may choose one of "serviceManagedS3" or
// "customerManagedS3" storage. If not specified, the default is "serviceManagedS3".
// This cannot be changed after creation of the channel.
type ChannelStorage struct {
	_ struct{} `type:"structure"`

	// Use this to store channel data in an S3 bucket that you manage. If customer
	// managed storage is selected, the "retentionPeriod" parameter is ignored.
	// The choice of service-managed or customer-managed S3 storage cannot be changed
	// after creation of the channel.
	CustomerManagedS3 *CustomerManagedChannelS3Storage `locationName:"customerManagedS3" type:"structure"`

	// Use this to store channel data in an S3 bucket managed by the AWS IoT Analytics
	// service. The choice of service-managed or customer-managed S3 storage cannot
	// be changed after creation of the channel.
	ServiceManagedS3 *ServiceManagedChannelS3Storage `locationName:"serviceManagedS3" type:"structure"`
}

// String returns the string representation
func (s ChannelStorage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChannelStorage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ChannelStorage"}
	if s.CustomerManagedS3 != nil {
		if err := s.CustomerManagedS3.Validate(); err != nil {
			invalidParams.AddNested("CustomerManagedS3", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChannelStorage) MarshalFields(e protocol.FieldEncoder) error {
	if s.CustomerManagedS3 != nil {
		v := s.CustomerManagedS3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "customerManagedS3", v, metadata)
	}
	if s.ServiceManagedS3 != nil {
		v := s.ServiceManagedS3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "serviceManagedS3", v, metadata)
	}
	return nil
}

// Where channel data is stored.
type ChannelStorageSummary struct {
	_ struct{} `type:"structure"`

	// Used to store channel data in an S3 bucket that you manage.
	CustomerManagedS3 *CustomerManagedChannelS3StorageSummary `locationName:"customerManagedS3" type:"structure"`

	// Used to store channel data in an S3 bucket managed by the AWS IoT Analytics
	// service.
	ServiceManagedS3 *ServiceManagedChannelS3StorageSummary `locationName:"serviceManagedS3" type:"structure"`
}

// String returns the string representation
func (s ChannelStorageSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChannelStorageSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CustomerManagedS3 != nil {
		v := s.CustomerManagedS3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "customerManagedS3", v, metadata)
	}
	if s.ServiceManagedS3 != nil {
		v := s.ServiceManagedS3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "serviceManagedS3", v, metadata)
	}
	return nil
}

// A summary of information about a channel.
type ChannelSummary struct {
	_ struct{} `type:"structure"`

	// The name of the channel.
	ChannelName *string `locationName:"channelName" min:"1" type:"string"`

	// Where channel data is stored.
	ChannelStorage *ChannelStorageSummary `locationName:"channelStorage" type:"structure"`

	// When the channel was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The last time the channel was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The status of the channel.
	Status ChannelStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s ChannelSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ChannelSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ChannelName != nil {
		v := *s.ChannelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "channelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ChannelStorage != nil {
		v := s.ChannelStorage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "channelStorage", v, metadata)
	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information needed to run the "containerAction" to produce data set contents.
type ContainerDatasetAction struct {
	_ struct{} `type:"structure"`

	// The ARN of the role which gives permission to the system to access needed
	// resources in order to run the "containerAction". This includes, at minimum,
	// permission to retrieve the data set contents which are the input to the containerized
	// application.
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `locationName:"executionRoleArn" min:"20" type:"string" required:"true"`

	// The ARN of the Docker container stored in your account. The Docker container
	// contains an application and needed support libraries and is used to generate
	// data set contents.
	//
	// Image is a required field
	Image *string `locationName:"image" type:"string" required:"true"`

	// Configuration of the resource which executes the "containerAction".
	//
	// ResourceConfiguration is a required field
	ResourceConfiguration *ResourceConfiguration `locationName:"resourceConfiguration" type:"structure" required:"true"`

	// The values of variables used within the context of the execution of the containerized
	// application (basically, parameters passed to the application). Each variable
	// must have a name and a value given by one of "stringValue", "datasetContentVersionValue",
	// or "outputFileUriValue".
	Variables []Variable `locationName:"variables" type:"list"`
}

// String returns the string representation
func (s ContainerDatasetAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContainerDatasetAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ContainerDatasetAction"}

	if s.ExecutionRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ExecutionRoleArn", 20))
	}

	if s.Image == nil {
		invalidParams.Add(aws.NewErrParamRequired("Image"))
	}

	if s.ResourceConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceConfiguration"))
	}
	if s.ResourceConfiguration != nil {
		if err := s.ResourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ResourceConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ContainerDatasetAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExecutionRoleArn != nil {
		v := *s.ExecutionRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "executionRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Image != nil {
		v := *s.Image

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "image", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceConfiguration != nil {
		v := s.ResourceConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resourceConfiguration", v, metadata)
	}
	if s.Variables != nil {
		v := s.Variables

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "variables", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Use this to store channel data in an S3 bucket that you manage. If customer
// managed storage is selected, the "retentionPeriod" parameter is ignored.
// The choice of service-managed or customer-managed S3 storage cannot be changed
// after creation of the channel.
type CustomerManagedChannelS3Storage struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket in which channel data is stored.
	//
	// Bucket is a required field
	Bucket *string `locationName:"bucket" min:"3" type:"string" required:"true"`

	// [Optional] The prefix used to create the keys of the channel data objects.
	// Each object in an Amazon S3 bucket has a key that is its unique identifier
	// within the bucket (each object in a bucket has exactly one key). The prefix
	// must end with a '/'.
	KeyPrefix *string `locationName:"keyPrefix" min:"1" type:"string"`

	// The ARN of the role which grants AWS IoT Analytics permission to interact
	// with your Amazon S3 resources.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CustomerManagedChannelS3Storage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomerManagedChannelS3Storage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CustomerManagedChannelS3Storage"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 3))
	}
	if s.KeyPrefix != nil && len(*s.KeyPrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyPrefix", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomerManagedChannelS3Storage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KeyPrefix != nil {
		v := *s.KeyPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Used to store channel data in an S3 bucket that you manage.
type CustomerManagedChannelS3StorageSummary struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket in which channel data is stored.
	Bucket *string `locationName:"bucket" min:"3" type:"string"`

	// [Optional] The prefix used to create the keys of the channel data objects.
	// Each object in an Amazon S3 bucket has a key that is its unique identifier
	// within the bucket (each object in a bucket has exactly one key). The prefix
	// must end with a '/'.
	KeyPrefix *string `locationName:"keyPrefix" min:"1" type:"string"`

	// The ARN of the role which grants AWS IoT Analytics permission to interact
	// with your Amazon S3 resources.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`
}

// String returns the string representation
func (s CustomerManagedChannelS3StorageSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomerManagedChannelS3StorageSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KeyPrefix != nil {
		v := *s.KeyPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Use this to store data store data in an S3 bucket that you manage. When customer
// managed storage is selected, the "retentionPeriod" parameter is ignored.
// The choice of service-managed or customer-managed S3 storage cannot be changed
// after creation of the data store.
type CustomerManagedDatastoreS3Storage struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket in which data store data is stored.
	//
	// Bucket is a required field
	Bucket *string `locationName:"bucket" min:"3" type:"string" required:"true"`

	// [Optional] The prefix used to create the keys of the data store data objects.
	// Each object in an Amazon S3 bucket has a key that is its unique identifier
	// within the bucket (each object in a bucket has exactly one key). The prefix
	// must end with a '/'.
	KeyPrefix *string `locationName:"keyPrefix" min:"1" type:"string"`

	// The ARN of the role which grants AWS IoT Analytics permission to interact
	// with your Amazon S3 resources.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CustomerManagedDatastoreS3Storage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomerManagedDatastoreS3Storage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CustomerManagedDatastoreS3Storage"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 3))
	}
	if s.KeyPrefix != nil && len(*s.KeyPrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyPrefix", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomerManagedDatastoreS3Storage) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KeyPrefix != nil {
		v := *s.KeyPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Used to store data store data in an S3 bucket that you manage.
type CustomerManagedDatastoreS3StorageSummary struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket in which data store data is stored.
	Bucket *string `locationName:"bucket" min:"3" type:"string"`

	// [Optional] The prefix used to create the keys of the data store data objects.
	// Each object in an Amazon S3 bucket has a key that is its unique identifier
	// within the bucket (each object in a bucket has exactly one key). The prefix
	// must end with a '/'.
	KeyPrefix *string `locationName:"keyPrefix" min:"1" type:"string"`

	// The ARN of the role which grants AWS IoT Analytics permission to interact
	// with your Amazon S3 resources.
	RoleArn *string `locationName:"roleArn" min:"20" type:"string"`
}

// String returns the string representation
func (s CustomerManagedDatastoreS3StorageSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CustomerManagedDatastoreS3StorageSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KeyPrefix != nil {
		v := *s.KeyPrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyPrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a data set.
type Dataset struct {
	_ struct{} `type:"structure"`

	// The "DatasetAction" objects that automatically create the data set contents.
	Actions []DatasetAction `locationName:"actions" min:"1" type:"list"`

	// The ARN of the data set.
	Arn *string `locationName:"arn" type:"string"`

	// When data set contents are created they are delivered to destinations specified
	// here.
	ContentDeliveryRules []DatasetContentDeliveryRule `locationName:"contentDeliveryRules" type:"list"`

	// When the data set was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The last time the data set was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The name of the data set.
	Name *string `locationName:"name" min:"1" type:"string"`

	// [Optional] How long, in days, message data is kept for the data set.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// The status of the data set.
	Status DatasetStatus `locationName:"status" type:"string" enum:"true"`

	// The "DatasetTrigger" objects that specify when the data set is automatically
	// updated.
	Triggers []DatasetTrigger `locationName:"triggers" type:"list"`

	// [Optional] How many versions of data set contents are kept. If not specified
	// or set to null, only the latest version plus the latest succeeded version
	// (if they are different) are kept for the time period specified by the "retentionPeriod"
	// parameter. (For more information, see https://docs.aws.amazon.com/iotanalytics/latest/userguide/getting-started.html#aws-iot-analytics-dataset-versions)
	VersioningConfiguration *VersioningConfiguration `locationName:"versioningConfiguration" type:"structure"`
}

// String returns the string representation
func (s Dataset) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Dataset) MarshalFields(e protocol.FieldEncoder) error {
	if s.Actions != nil {
		v := s.Actions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "actions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ContentDeliveryRules != nil {
		v := s.ContentDeliveryRules

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "contentDeliveryRules", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RetentionPeriod != nil {
		v := s.RetentionPeriod

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "retentionPeriod", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Triggers != nil {
		v := s.Triggers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "triggers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.VersioningConfiguration != nil {
		v := s.VersioningConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "versioningConfiguration", v, metadata)
	}
	return nil
}

// A "DatasetAction" object that specifies how data set contents are automatically
// created.
type DatasetAction struct {
	_ struct{} `type:"structure"`

	// The name of the data set action by which data set contents are automatically
	// created.
	ActionName *string `locationName:"actionName" min:"1" type:"string"`

	// Information which allows the system to run a containerized application in
	// order to create the data set contents. The application must be in a Docker
	// container along with any needed support libraries.
	ContainerAction *ContainerDatasetAction `locationName:"containerAction" type:"structure"`

	// An "SqlQueryDatasetAction" object that uses an SQL query to automatically
	// create data set contents.
	QueryAction *SqlQueryDatasetAction `locationName:"queryAction" type:"structure"`
}

// String returns the string representation
func (s DatasetAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DatasetAction"}
	if s.ActionName != nil && len(*s.ActionName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ActionName", 1))
	}
	if s.ContainerAction != nil {
		if err := s.ContainerAction.Validate(); err != nil {
			invalidParams.AddNested("ContainerAction", err.(aws.ErrInvalidParams))
		}
	}
	if s.QueryAction != nil {
		if err := s.QueryAction.Validate(); err != nil {
			invalidParams.AddNested("QueryAction", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatasetAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.ActionName != nil {
		v := *s.ActionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "actionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ContainerAction != nil {
		v := s.ContainerAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "containerAction", v, metadata)
	}
	if s.QueryAction != nil {
		v := s.QueryAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "queryAction", v, metadata)
	}
	return nil
}

// Information about the action which automatically creates the data set's contents.
type DatasetActionSummary struct {
	_ struct{} `type:"structure"`

	// The name of the action which automatically creates the data set's contents.
	ActionName *string `locationName:"actionName" min:"1" type:"string"`

	// The type of action by which the data set's contents are automatically created.
	ActionType DatasetActionType `locationName:"actionType" type:"string" enum:"true"`
}

// String returns the string representation
func (s DatasetActionSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatasetActionSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.ActionName != nil {
		v := *s.ActionName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "actionName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ActionType) > 0 {
		v := s.ActionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "actionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The destination to which data set contents are delivered.
type DatasetContentDeliveryDestination struct {
	_ struct{} `type:"structure"`

	// Configuration information for delivery of data set contents to AWS IoT Events.
	IotEventsDestinationConfiguration *IotEventsDestinationConfiguration `locationName:"iotEventsDestinationConfiguration" type:"structure"`

	// Configuration information for delivery of data set contents to Amazon S3.
	S3DestinationConfiguration *S3DestinationConfiguration `locationName:"s3DestinationConfiguration" type:"structure"`
}

// String returns the string representation
func (s DatasetContentDeliveryDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetContentDeliveryDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DatasetContentDeliveryDestination"}
	if s.IotEventsDestinationConfiguration != nil {
		if err := s.IotEventsDestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("IotEventsDestinationConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3DestinationConfiguration != nil {
		if err := s.S3DestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3DestinationConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatasetContentDeliveryDestination) MarshalFields(e protocol.FieldEncoder) error {
	if s.IotEventsDestinationConfiguration != nil {
		v := s.IotEventsDestinationConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "iotEventsDestinationConfiguration", v, metadata)
	}
	if s.S3DestinationConfiguration != nil {
		v := s.S3DestinationConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "s3DestinationConfiguration", v, metadata)
	}
	return nil
}

// When data set contents are created they are delivered to destination specified
// here.
type DatasetContentDeliveryRule struct {
	_ struct{} `type:"structure"`

	// The destination to which data set contents are delivered.
	//
	// Destination is a required field
	Destination *DatasetContentDeliveryDestination `locationName:"destination" type:"structure" required:"true"`

	// The name of the data set content delivery rules entry.
	EntryName *string `locationName:"entryName" type:"string"`
}

// String returns the string representation
func (s DatasetContentDeliveryRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetContentDeliveryRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DatasetContentDeliveryRule"}

	if s.Destination == nil {
		invalidParams.Add(aws.NewErrParamRequired("Destination"))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatasetContentDeliveryRule) MarshalFields(e protocol.FieldEncoder) error {
	if s.Destination != nil {
		v := s.Destination

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "destination", v, metadata)
	}
	if s.EntryName != nil {
		v := *s.EntryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "entryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The state of the data set contents and the reason they are in this state.
type DatasetContentStatus struct {
	_ struct{} `type:"structure"`

	// The reason the data set contents are in this state.
	Reason *string `locationName:"reason" type:"string"`

	// The state of the data set contents. Can be one of "READY", "CREATING", "SUCCEEDED"
	// or "FAILED".
	State DatasetContentState `locationName:"state" type:"string" enum:"true"`
}

// String returns the string representation
func (s DatasetContentStatus) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatasetContentStatus) MarshalFields(e protocol.FieldEncoder) error {
	if s.Reason != nil {
		v := *s.Reason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "reason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "state", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Summary information about data set contents.
type DatasetContentSummary struct {
	_ struct{} `type:"structure"`

	// The time the dataset content status was updated to SUCCEEDED or FAILED.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp"`

	// The actual time the creation of the data set contents was started.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The time the creation of the data set contents was scheduled to start.
	ScheduleTime *time.Time `locationName:"scheduleTime" type:"timestamp"`

	// The status of the data set contents.
	Status *DatasetContentStatus `locationName:"status" type:"structure"`

	// The version of the data set contents.
	Version *string `locationName:"version" min:"7" type:"string"`
}

// String returns the string representation
func (s DatasetContentSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatasetContentSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CompletionTime != nil {
		v := *s.CompletionTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "completionTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ScheduleTime != nil {
		v := *s.ScheduleTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "scheduleTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Status != nil {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "status", v, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The data set whose latest contents are used as input to the notebook or application.
type DatasetContentVersionValue struct {
	_ struct{} `type:"structure"`

	// The name of the data set whose latest contents are used as input to the notebook
	// or application.
	//
	// DatasetName is a required field
	DatasetName *string `locationName:"datasetName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DatasetContentVersionValue) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetContentVersionValue) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DatasetContentVersionValue"}

	if s.DatasetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatasetName"))
	}
	if s.DatasetName != nil && len(*s.DatasetName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatasetName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatasetContentVersionValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.DatasetName != nil {
		v := *s.DatasetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "datasetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The reference to a data set entry.
type DatasetEntry struct {
	_ struct{} `type:"structure"`

	// The pre-signed URI of the data set item.
	DataURI *string `locationName:"dataURI" type:"string"`

	// The name of the data set item.
	EntryName *string `locationName:"entryName" type:"string"`
}

// String returns the string representation
func (s DatasetEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatasetEntry) MarshalFields(e protocol.FieldEncoder) error {
	if s.DataURI != nil {
		v := *s.DataURI

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "dataURI", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EntryName != nil {
		v := *s.EntryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "entryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A summary of information about a data set.
type DatasetSummary struct {
	_ struct{} `type:"structure"`

	// A list of "DataActionSummary" objects.
	Actions []DatasetActionSummary `locationName:"actions" min:"1" type:"list"`

	// The time the data set was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The name of the data set.
	DatasetName *string `locationName:"datasetName" min:"1" type:"string"`

	// The last time the data set was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The status of the data set.
	Status DatasetStatus `locationName:"status" type:"string" enum:"true"`

	// A list of triggers. A trigger causes data set content to be populated at
	// a specified time interval or when another data set is populated. The list
	// of triggers can be empty or contain up to five DataSetTrigger objects
	Triggers []DatasetTrigger `locationName:"triggers" type:"list"`
}

// String returns the string representation
func (s DatasetSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatasetSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.Actions != nil {
		v := s.Actions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "actions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DatasetName != nil {
		v := *s.DatasetName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "datasetName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Triggers != nil {
		v := s.Triggers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "triggers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The "DatasetTrigger" that specifies when the data set is automatically updated.
type DatasetTrigger struct {
	_ struct{} `type:"structure"`

	// The data set whose content creation triggers the creation of this data set's
	// contents.
	Dataset *TriggeringDataset `locationName:"dataset" type:"structure"`

	// The "Schedule" when the trigger is initiated.
	Schedule *Schedule `locationName:"schedule" type:"structure"`
}

// String returns the string representation
func (s DatasetTrigger) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetTrigger) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DatasetTrigger"}
	if s.Dataset != nil {
		if err := s.Dataset.Validate(); err != nil {
			invalidParams.AddNested("Dataset", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatasetTrigger) MarshalFields(e protocol.FieldEncoder) error {
	if s.Dataset != nil {
		v := s.Dataset

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dataset", v, metadata)
	}
	if s.Schedule != nil {
		v := s.Schedule

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "schedule", v, metadata)
	}
	return nil
}

// Information about a data store.
type Datastore struct {
	_ struct{} `type:"structure"`

	// The ARN of the data store.
	Arn *string `locationName:"arn" type:"string"`

	// When the data store was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The last time the data store was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The name of the data store.
	Name *string `locationName:"name" min:"1" type:"string"`

	// How long, in days, message data is kept for the data store. When "customerManagedS3"
	// storage is selected, this parameter is ignored.
	RetentionPeriod *RetentionPeriod `locationName:"retentionPeriod" type:"structure"`

	// The status of a data store:
	//
	// CREATING
	//
	// The data store is being created.
	//
	// ACTIVE
	//
	// The data store has been created and can be used.
	//
	// DELETING
	//
	// The data store is being deleted.
	Status DatastoreStatus `locationName:"status" type:"string" enum:"true"`

	// Where data store data is stored. You may choose one of "serviceManagedS3"
	// or "customerManagedS3" storage. If not specified, the default is "serviceManagedS3".
	// This cannot be changed after the data store is created.
	Storage *DatastoreStorage `locationName:"storage" type:"structure"`
}

// String returns the string representation
func (s Datastore) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Datastore) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RetentionPeriod != nil {
		v := s.RetentionPeriod

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "retentionPeriod", v, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Storage != nil {
		v := s.Storage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "storage", v, metadata)
	}
	return nil
}

// The 'datastore' activity that specifies where to store the processed data.
type DatastoreActivity struct {
	_ struct{} `type:"structure"`

	// The name of the data store where processed messages are stored.
	//
	// DatastoreName is a required field
	DatastoreName *string `locationName:"datastoreName" min:"1" type:"string" required:"true"`

	// The name of the 'datastore' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DatastoreActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatastoreActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DatastoreActivity"}

	if s.DatastoreName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatastoreName"))
	}
	if s.DatastoreName != nil && len(*s.DatastoreName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatastoreName", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatastoreActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.DatastoreName != nil {
		v := *s.DatastoreName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "datastoreName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Statistical information about the data store.
type DatastoreStatistics struct {
	_ struct{} `type:"structure"`

	// The estimated size of the data store.
	Size *EstimatedResourceSize `locationName:"size" type:"structure"`
}

// String returns the string representation
func (s DatastoreStatistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatastoreStatistics) MarshalFields(e protocol.FieldEncoder) error {
	if s.Size != nil {
		v := s.Size

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "size", v, metadata)
	}
	return nil
}

// Where data store data is stored. You may choose one of "serviceManagedS3"
// or "customerManagedS3" storage. If not specified, the default is "serviceManagedS3".
// This cannot be changed after the data store is created.
type DatastoreStorage struct {
	_ struct{} `type:"structure"`

	// Use this to store data store data in an S3 bucket that you manage. When customer
	// managed storage is selected, the "retentionPeriod" parameter is ignored.
	// The choice of service-managed or customer-managed S3 storage cannot be changed
	// after creation of the data store.
	CustomerManagedS3 *CustomerManagedDatastoreS3Storage `locationName:"customerManagedS3" type:"structure"`

	// Use this to store data store data in an S3 bucket managed by the AWS IoT
	// Analytics service. The choice of service-managed or customer-managed S3 storage
	// cannot be changed after creation of the data store.
	ServiceManagedS3 *ServiceManagedDatastoreS3Storage `locationName:"serviceManagedS3" type:"structure"`
}

// String returns the string representation
func (s DatastoreStorage) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatastoreStorage) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DatastoreStorage"}
	if s.CustomerManagedS3 != nil {
		if err := s.CustomerManagedS3.Validate(); err != nil {
			invalidParams.AddNested("CustomerManagedS3", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatastoreStorage) MarshalFields(e protocol.FieldEncoder) error {
	if s.CustomerManagedS3 != nil {
		v := s.CustomerManagedS3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "customerManagedS3", v, metadata)
	}
	if s.ServiceManagedS3 != nil {
		v := s.ServiceManagedS3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "serviceManagedS3", v, metadata)
	}
	return nil
}

// Where data store data is stored.
type DatastoreStorageSummary struct {
	_ struct{} `type:"structure"`

	// Used to store data store data in an S3 bucket that you manage.
	CustomerManagedS3 *CustomerManagedDatastoreS3StorageSummary `locationName:"customerManagedS3" type:"structure"`

	// Used to store data store data in an S3 bucket managed by the AWS IoT Analytics
	// service.
	ServiceManagedS3 *ServiceManagedDatastoreS3StorageSummary `locationName:"serviceManagedS3" type:"structure"`
}

// String returns the string representation
func (s DatastoreStorageSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatastoreStorageSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CustomerManagedS3 != nil {
		v := s.CustomerManagedS3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "customerManagedS3", v, metadata)
	}
	if s.ServiceManagedS3 != nil {
		v := s.ServiceManagedS3

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "serviceManagedS3", v, metadata)
	}
	return nil
}

// A summary of information about a data store.
type DatastoreSummary struct {
	_ struct{} `type:"structure"`

	// When the data store was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The name of the data store.
	DatastoreName *string `locationName:"datastoreName" min:"1" type:"string"`

	// Where data store data is stored.
	DatastoreStorage *DatastoreStorageSummary `locationName:"datastoreStorage" type:"structure"`

	// The last time the data store was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The status of the data store.
	Status DatastoreStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s DatastoreSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DatastoreSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DatastoreName != nil {
		v := *s.DatastoreName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "datastoreName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DatastoreStorage != nil {
		v := s.DatastoreStorage

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "datastoreStorage", v, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Used to limit data to that which has arrived since the last execution of
// the action.
type DeltaTime struct {
	_ struct{} `type:"structure"`

	// The number of seconds of estimated "in flight" lag time of message data.
	// When you create data set contents using message data from a specified time
	// frame, some message data may still be "in flight" when processing begins,
	// and so will not arrive in time to be processed. Use this field to make allowances
	// for the "in flight" time of your message data, so that data not processed
	// from a previous time frame will be included with the next time frame. Without
	// this, missed message data would be excluded from processing during the next
	// time frame as well, because its timestamp places it within the previous time
	// frame.
	//
	// OffsetSeconds is a required field
	OffsetSeconds *int64 `locationName:"offsetSeconds" type:"integer" required:"true"`

	// An expression by which the time of the message data may be determined. This
	// may be the name of a timestamp field, or a SQL expression which is used to
	// derive the time the message data was generated.
	//
	// TimeExpression is a required field
	TimeExpression *string `locationName:"timeExpression" type:"string" required:"true"`
}

// String returns the string representation
func (s DeltaTime) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeltaTime) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeltaTime"}

	if s.OffsetSeconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("OffsetSeconds"))
	}

	if s.TimeExpression == nil {
		invalidParams.Add(aws.NewErrParamRequired("TimeExpression"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeltaTime) MarshalFields(e protocol.FieldEncoder) error {
	if s.OffsetSeconds != nil {
		v := *s.OffsetSeconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "offsetSeconds", protocol.Int64Value(v), metadata)
	}
	if s.TimeExpression != nil {
		v := *s.TimeExpression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timeExpression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An activity that adds data from the AWS IoT device registry to your message.
type DeviceRegistryEnrichActivity struct {
	_ struct{} `type:"structure"`

	// The name of the attribute that is added to the message.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" min:"1" type:"string" required:"true"`

	// The name of the 'deviceRegistryEnrich' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`

	// The ARN of the role that allows access to the device's registry information.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The name of the IoT device whose registry information is added to the message.
	//
	// ThingName is a required field
	ThingName *string `locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeviceRegistryEnrichActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeviceRegistryEnrichActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeviceRegistryEnrichActivity"}

	if s.Attribute == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attribute"))
	}
	if s.Attribute != nil && len(*s.Attribute) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Attribute", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Next", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if s.ThingName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeviceRegistryEnrichActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attribute != nil {
		v := *s.Attribute

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attribute", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Next != nil {
		v := *s.Next

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "next", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An activity that adds information from the AWS IoT Device Shadows service
// to a message.
type DeviceShadowEnrichActivity struct {
	_ struct{} `type:"structure"`

	// The name of the attribute that is added to the message.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" min:"1" type:"string" required:"true"`

	// The name of the 'deviceShadowEnrich' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`

	// The ARN of the role that allows access to the device's shadow.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The name of the IoT device whose shadow information is added to the message.
	//
	// ThingName is a required field
	ThingName *string `locationName:"thingName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeviceShadowEnrichActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeviceShadowEnrichActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeviceShadowEnrichActivity"}

	if s.Attribute == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attribute"))
	}
	if s.Attribute != nil && len(*s.Attribute) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Attribute", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Next", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if s.ThingName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ThingName"))
	}
	if s.ThingName != nil && len(*s.ThingName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ThingName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeviceShadowEnrichActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attribute != nil {
		v := *s.Attribute

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attribute", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Next != nil {
		v := *s.Next

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "next", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ThingName != nil {
		v := *s.ThingName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "thingName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The estimated size of the resource.
type EstimatedResourceSize struct {
	_ struct{} `type:"structure"`

	// The time when the estimate of the size of the resource was made.
	EstimatedOn *time.Time `locationName:"estimatedOn" type:"timestamp"`

	// The estimated size of the resource in bytes.
	EstimatedSizeInBytes *float64 `locationName:"estimatedSizeInBytes" type:"double"`
}

// String returns the string representation
func (s EstimatedResourceSize) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s EstimatedResourceSize) MarshalFields(e protocol.FieldEncoder) error {
	if s.EstimatedOn != nil {
		v := *s.EstimatedOn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "estimatedOn",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.EstimatedSizeInBytes != nil {
		v := *s.EstimatedSizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "estimatedSizeInBytes", protocol.Float64Value(v), metadata)
	}
	return nil
}

// An activity that filters a message based on its attributes.
type FilterActivity struct {
	_ struct{} `type:"structure"`

	// An expression that looks like a SQL WHERE clause that must return a Boolean
	// value.
	//
	// Filter is a required field
	Filter *string `locationName:"filter" min:"1" type:"string" required:"true"`

	// The name of the 'filter' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s FilterActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FilterActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FilterActivity"}

	if s.Filter == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filter"))
	}
	if s.Filter != nil && len(*s.Filter) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filter", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FilterActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Filter != nil {
		v := *s.Filter

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "filter", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Next != nil {
		v := *s.Next

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "next", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Configuration information for coordination with the AWS Glue ETL (extract,
// transform and load) service.
type GlueConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the database in your AWS Glue Data Catalog in which the table
	// is located. (An AWS Glue Data Catalog database contains Glue Data tables.)
	//
	// DatabaseName is a required field
	DatabaseName *string `locationName:"databaseName" min:"1" type:"string" required:"true"`

	// The name of the table in your AWS Glue Data Catalog which is used to perform
	// the ETL (extract, transform and load) operations. (An AWS Glue Data Catalog
	// table contains partitioned data and descriptions of data sources and targets.)
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GlueConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlueConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GlueConfiguration"}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GlueConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.DatabaseName != nil {
		v := *s.DatabaseName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "databaseName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.TableName != nil {
		v := *s.TableName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "tableName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Configuration information for delivery of data set contents to AWS IoT Events.
type IotEventsDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the AWS IoT Events input to which data set contents are delivered.
	//
	// InputName is a required field
	InputName *string `locationName:"inputName" min:"1" type:"string" required:"true"`

	// The ARN of the role which grants AWS IoT Analytics permission to deliver
	// data set contents to an AWS IoT Events input.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s IotEventsDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IotEventsDestinationConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IotEventsDestinationConfiguration"}

	if s.InputName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputName"))
	}
	if s.InputName != nil && len(*s.InputName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputName", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IotEventsDestinationConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.InputName != nil {
		v := *s.InputName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An activity that runs a Lambda function to modify the message.
type LambdaActivity struct {
	_ struct{} `type:"structure"`

	// The number of messages passed to the Lambda function for processing.
	//
	// The AWS Lambda function must be able to process all of these messages within
	// five minutes, which is the maximum timeout duration for Lambda functions.
	//
	// BatchSize is a required field
	BatchSize *int64 `locationName:"batchSize" min:"1" type:"integer" required:"true"`

	// The name of the Lambda function that is run on the message.
	//
	// LambdaName is a required field
	LambdaName *string `locationName:"lambdaName" min:"1" type:"string" required:"true"`

	// The name of the 'lambda' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s LambdaActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaActivity"}

	if s.BatchSize == nil {
		invalidParams.Add(aws.NewErrParamRequired("BatchSize"))
	}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("BatchSize", 1))
	}

	if s.LambdaName == nil {
		invalidParams.Add(aws.NewErrParamRequired("LambdaName"))
	}
	if s.LambdaName != nil && len(*s.LambdaName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LambdaName", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LambdaActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.BatchSize != nil {
		v := *s.BatchSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "batchSize", protocol.Int64Value(v), metadata)
	}
	if s.LambdaName != nil {
		v := *s.LambdaName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lambdaName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Next != nil {
		v := *s.Next

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "next", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about logging options.
type LoggingOptions struct {
	_ struct{} `type:"structure"`

	// If true, logging is enabled for AWS IoT Analytics.
	//
	// Enabled is a required field
	Enabled *bool `locationName:"enabled" type:"boolean" required:"true"`

	// The logging level. Currently, only "ERROR" is supported.
	//
	// Level is a required field
	Level LoggingLevel `locationName:"level" type:"string" required:"true" enum:"true"`

	// The ARN of the role that grants permission to AWS IoT Analytics to perform
	// logging.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingOptions) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingOptions) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LoggingOptions"}

	if s.Enabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("Enabled"))
	}
	if len(s.Level) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Level"))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LoggingOptions) MarshalFields(e protocol.FieldEncoder) error {
	if s.Enabled != nil {
		v := *s.Enabled

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "enabled", protocol.BoolValue(v), metadata)
	}
	if len(s.Level) > 0 {
		v := s.Level

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "level", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An activity that computes an arithmetic expression using the message's attributes.
type MathActivity struct {
	_ struct{} `type:"structure"`

	// The name of the attribute that contains the result of the math operation.
	//
	// Attribute is a required field
	Attribute *string `locationName:"attribute" min:"1" type:"string" required:"true"`

	// An expression that uses one or more existing attributes and must return an
	// integer value.
	//
	// Math is a required field
	Math *string `locationName:"math" min:"1" type:"string" required:"true"`

	// The name of the 'math' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s MathActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MathActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MathActivity"}

	if s.Attribute == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attribute"))
	}
	if s.Attribute != nil && len(*s.Attribute) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Attribute", 1))
	}

	if s.Math == nil {
		invalidParams.Add(aws.NewErrParamRequired("Math"))
	}
	if s.Math != nil && len(*s.Math) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Math", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MathActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attribute != nil {
		v := *s.Attribute

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attribute", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Math != nil {
		v := *s.Math

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "math", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Next != nil {
		v := *s.Next

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "next", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a message.
type Message struct {
	_ struct{} `type:"structure"`

	// The ID you wish to assign to the message. Each "messageId" must be unique
	// within each batch sent.
	//
	// MessageId is a required field
	MessageId *string `locationName:"messageId" min:"1" type:"string" required:"true"`

	// The payload of the message. This may be a JSON string or a Base64-encoded
	// string representing binary data (in which case you must decode it by means
	// of a pipeline activity).
	//
	// Payload is automatically base64 encoded/decoded by the SDK.
	//
	// Payload is a required field
	Payload []byte `locationName:"payload" type:"blob" required:"true"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Message"}

	if s.MessageId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MessageId", 1))
	}

	if s.Payload == nil {
		invalidParams.Add(aws.NewErrParamRequired("Payload"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Message) MarshalFields(e protocol.FieldEncoder) error {
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "messageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Payload != nil {
		v := s.Payload

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "payload", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	return nil
}

// The value of the variable as a structure that specifies an output file URI.
type OutputFileUriValue struct {
	_ struct{} `type:"structure"`

	// The URI of the location where data set contents are stored, usually the URI
	// of a file in an S3 bucket.
	//
	// FileName is a required field
	FileName *string `locationName:"fileName" type:"string" required:"true"`
}

// String returns the string representation
func (s OutputFileUriValue) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputFileUriValue) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputFileUriValue"}

	if s.FileName == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s OutputFileUriValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.FileName != nil {
		v := *s.FileName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "fileName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about a pipeline.
type Pipeline struct {
	_ struct{} `type:"structure"`

	// The activities that perform transformations on the messages.
	Activities []PipelineActivity `locationName:"activities" min:"1" type:"list"`

	// The ARN of the pipeline.
	Arn *string `locationName:"arn" type:"string"`

	// When the pipeline was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The last time the pipeline was updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The name of the pipeline.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A summary of information about the pipeline reprocessing.
	ReprocessingSummaries []ReprocessingSummary `locationName:"reprocessingSummaries" type:"list"`
}

// String returns the string representation
func (s Pipeline) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Pipeline) MarshalFields(e protocol.FieldEncoder) error {
	if s.Activities != nil {
		v := s.Activities

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "activities", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReprocessingSummaries != nil {
		v := s.ReprocessingSummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "reprocessingSummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// An activity that performs a transformation on a message.
type PipelineActivity struct {
	_ struct{} `type:"structure"`

	// Adds other attributes based on existing attributes in the message.
	AddAttributes *AddAttributesActivity `locationName:"addAttributes" type:"structure"`

	// Determines the source of the messages to be processed.
	Channel *ChannelActivity `locationName:"channel" type:"structure"`

	// Specifies where to store the processed message data.
	Datastore *DatastoreActivity `locationName:"datastore" type:"structure"`

	// Adds data from the AWS IoT device registry to your message.
	DeviceRegistryEnrich *DeviceRegistryEnrichActivity `locationName:"deviceRegistryEnrich" type:"structure"`

	// Adds information from the AWS IoT Device Shadows service to a message.
	DeviceShadowEnrich *DeviceShadowEnrichActivity `locationName:"deviceShadowEnrich" type:"structure"`

	// Filters a message based on its attributes.
	Filter *FilterActivity `locationName:"filter" type:"structure"`

	// Runs a Lambda function to modify the message.
	Lambda *LambdaActivity `locationName:"lambda" type:"structure"`

	// Computes an arithmetic expression using the message's attributes and adds
	// it to the message.
	Math *MathActivity `locationName:"math" type:"structure"`

	// Removes attributes from a message.
	RemoveAttributes *RemoveAttributesActivity `locationName:"removeAttributes" type:"structure"`

	// Creates a new message using only the specified attributes from the original
	// message.
	SelectAttributes *SelectAttributesActivity `locationName:"selectAttributes" type:"structure"`
}

// String returns the string representation
func (s PipelineActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipelineActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PipelineActivity"}
	if s.AddAttributes != nil {
		if err := s.AddAttributes.Validate(); err != nil {
			invalidParams.AddNested("AddAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.Channel != nil {
		if err := s.Channel.Validate(); err != nil {
			invalidParams.AddNested("Channel", err.(aws.ErrInvalidParams))
		}
	}
	if s.Datastore != nil {
		if err := s.Datastore.Validate(); err != nil {
			invalidParams.AddNested("Datastore", err.(aws.ErrInvalidParams))
		}
	}
	if s.DeviceRegistryEnrich != nil {
		if err := s.DeviceRegistryEnrich.Validate(); err != nil {
			invalidParams.AddNested("DeviceRegistryEnrich", err.(aws.ErrInvalidParams))
		}
	}
	if s.DeviceShadowEnrich != nil {
		if err := s.DeviceShadowEnrich.Validate(); err != nil {
			invalidParams.AddNested("DeviceShadowEnrich", err.(aws.ErrInvalidParams))
		}
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(aws.ErrInvalidParams))
		}
	}
	if s.Lambda != nil {
		if err := s.Lambda.Validate(); err != nil {
			invalidParams.AddNested("Lambda", err.(aws.ErrInvalidParams))
		}
	}
	if s.Math != nil {
		if err := s.Math.Validate(); err != nil {
			invalidParams.AddNested("Math", err.(aws.ErrInvalidParams))
		}
	}
	if s.RemoveAttributes != nil {
		if err := s.RemoveAttributes.Validate(); err != nil {
			invalidParams.AddNested("RemoveAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.SelectAttributes != nil {
		if err := s.SelectAttributes.Validate(); err != nil {
			invalidParams.AddNested("SelectAttributes", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PipelineActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.AddAttributes != nil {
		v := s.AddAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "addAttributes", v, metadata)
	}
	if s.Channel != nil {
		v := s.Channel

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "channel", v, metadata)
	}
	if s.Datastore != nil {
		v := s.Datastore

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "datastore", v, metadata)
	}
	if s.DeviceRegistryEnrich != nil {
		v := s.DeviceRegistryEnrich

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "deviceRegistryEnrich", v, metadata)
	}
	if s.DeviceShadowEnrich != nil {
		v := s.DeviceShadowEnrich

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "deviceShadowEnrich", v, metadata)
	}
	if s.Filter != nil {
		v := s.Filter

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "filter", v, metadata)
	}
	if s.Lambda != nil {
		v := s.Lambda

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "lambda", v, metadata)
	}
	if s.Math != nil {
		v := s.Math

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "math", v, metadata)
	}
	if s.RemoveAttributes != nil {
		v := s.RemoveAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "removeAttributes", v, metadata)
	}
	if s.SelectAttributes != nil {
		v := s.SelectAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "selectAttributes", v, metadata)
	}
	return nil
}

// A summary of information about a pipeline.
type PipelineSummary struct {
	_ struct{} `type:"structure"`

	// When the pipeline was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// When the pipeline was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The name of the pipeline.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`

	// A summary of information about the pipeline reprocessing.
	ReprocessingSummaries []ReprocessingSummary `locationName:"reprocessingSummaries" type:"list"`
}

// String returns the string representation
func (s PipelineSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PipelineSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.PipelineName != nil {
		v := *s.PipelineName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "pipelineName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ReprocessingSummaries != nil {
		v := s.ReprocessingSummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "reprocessingSummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Information which is used to filter message data, to segregate it according
// to the time frame in which it arrives.
type QueryFilter struct {
	_ struct{} `type:"structure"`

	// Used to limit data to that which has arrived since the last execution of
	// the action.
	DeltaTime *DeltaTime `locationName:"deltaTime" type:"structure"`
}

// String returns the string representation
func (s QueryFilter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryFilter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "QueryFilter"}
	if s.DeltaTime != nil {
		if err := s.DeltaTime.Validate(); err != nil {
			invalidParams.AddNested("DeltaTime", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s QueryFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeltaTime != nil {
		v := s.DeltaTime

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "deltaTime", v, metadata)
	}
	return nil
}

// An activity that removes attributes from a message.
type RemoveAttributesActivity struct {
	_ struct{} `type:"structure"`

	// A list of 1-50 attributes to remove from the message.
	//
	// Attributes is a required field
	Attributes []string `locationName:"attributes" min:"1" type:"list" required:"true"`

	// The name of the 'removeAttributes' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s RemoveAttributesActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveAttributesActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemoveAttributesActivity"}

	if s.Attributes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil && len(s.Attributes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Attributes", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemoveAttributesActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "attributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Next != nil {
		v := *s.Next

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "next", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about pipeline reprocessing.
type ReprocessingSummary struct {
	_ struct{} `type:"structure"`

	// The time the pipeline reprocessing was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The 'reprocessingId' returned by "StartPipelineReprocessing".
	Id *string `locationName:"id" type:"string"`

	// The status of the pipeline reprocessing.
	Status ReprocessingStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s ReprocessingSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ReprocessingSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The configuration of the resource used to execute the "containerAction".
type ResourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The type of the compute resource used to execute the "containerAction". Possible
	// values are: ACU_1 (vCPU=4, memory=16GiB) or ACU_2 (vCPU=8, memory=32GiB).
	//
	// ComputeType is a required field
	ComputeType ComputeType `locationName:"computeType" type:"string" required:"true" enum:"true"`

	// The size (in GB) of the persistent storage available to the resource instance
	// used to execute the "containerAction" (min: 1, max: 50).
	//
	// VolumeSizeInGB is a required field
	VolumeSizeInGB *int64 `locationName:"volumeSizeInGB" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s ResourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceConfiguration"}
	if len(s.ComputeType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ComputeType"))
	}

	if s.VolumeSizeInGB == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeSizeInGB"))
	}
	if s.VolumeSizeInGB != nil && *s.VolumeSizeInGB < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("VolumeSizeInGB", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ComputeType) > 0 {
		v := s.ComputeType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "computeType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.VolumeSizeInGB != nil {
		v := *s.VolumeSizeInGB

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "volumeSizeInGB", protocol.Int64Value(v), metadata)
	}
	return nil
}

// How long, in days, message data is kept.
type RetentionPeriod struct {
	_ struct{} `type:"structure"`

	// The number of days that message data is kept. The "unlimited" parameter must
	// be false.
	NumberOfDays *int64 `locationName:"numberOfDays" min:"1" type:"integer"`

	// If true, message data is kept indefinitely.
	Unlimited *bool `locationName:"unlimited" type:"boolean"`
}

// String returns the string representation
func (s RetentionPeriod) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetentionPeriod) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RetentionPeriod"}
	if s.NumberOfDays != nil && *s.NumberOfDays < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("NumberOfDays", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RetentionPeriod) MarshalFields(e protocol.FieldEncoder) error {
	if s.NumberOfDays != nil {
		v := *s.NumberOfDays

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "numberOfDays", protocol.Int64Value(v), metadata)
	}
	if s.Unlimited != nil {
		v := *s.Unlimited

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unlimited", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Configuration information for delivery of data set contents to Amazon S3.
type S3DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket to which data set contents are delivered.
	//
	// Bucket is a required field
	Bucket *string `locationName:"bucket" min:"3" type:"string" required:"true"`

	// Configuration information for coordination with the AWS Glue ETL (extract,
	// transform and load) service.
	GlueConfiguration *GlueConfiguration `locationName:"glueConfiguration" type:"structure"`

	// The key of the data set contents object. Each object in an Amazon S3 bucket
	// has a key that is its unique identifier within the bucket (each object in
	// a bucket has exactly one key). To produce a unique key, you can use "!{iotanalytics:scheduledTime}"
	// to insert the time of the scheduled SQL query run, or "!{iotanalytics:versioned}
	// to insert a unique hash identifying the data set, for example: "/DataSet/!{iotanalytics:scheduledTime}/!{iotanalytics:versioned}.csv".
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The ARN of the role which grants AWS IoT Analytics permission to interact
	// with your Amazon S3 and AWS Glue resources.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s S3DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DestinationConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3DestinationConfiguration"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 3))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 20))
	}
	if s.GlueConfiguration != nil {
		if err := s.GlueConfiguration.Validate(); err != nil {
			invalidParams.AddNested("GlueConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3DestinationConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "bucket", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlueConfiguration != nil {
		v := s.GlueConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "glueConfiguration", v, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RoleArn != nil {
		v := *s.RoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "roleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The schedule for when to trigger an update.
type Schedule struct {
	_ struct{} `type:"structure"`

	// The expression that defines when to trigger an update. For more information,
	// see Schedule Expressions for Rules (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html)
	// in the Amazon CloudWatch Events User Guide.
	Expression *string `locationName:"expression" type:"string"`
}

// String returns the string representation
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Schedule) MarshalFields(e protocol.FieldEncoder) error {
	if s.Expression != nil {
		v := *s.Expression

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "expression", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Creates a new message using only the specified attributes from the original
// message.
type SelectAttributesActivity struct {
	_ struct{} `type:"structure"`

	// A list of the attributes to select from the message.
	//
	// Attributes is a required field
	Attributes []string `locationName:"attributes" min:"1" type:"list" required:"true"`

	// The name of the 'selectAttributes' activity.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The next activity in the pipeline.
	Next *string `locationName:"next" min:"1" type:"string"`
}

// String returns the string representation
func (s SelectAttributesActivity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectAttributesActivity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SelectAttributesActivity"}

	if s.Attributes == nil {
		invalidParams.Add(aws.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil && len(s.Attributes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Attributes", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.Next != nil && len(*s.Next) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Next", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SelectAttributesActivity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Attributes != nil {
		v := s.Attributes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "attributes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Next != nil {
		v := *s.Next

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "next", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Use this to store channel data in an S3 bucket managed by the AWS IoT Analytics
// service. The choice of service-managed or customer-managed S3 storage cannot
// be changed after creation of the channel.
type ServiceManagedChannelS3Storage struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ServiceManagedChannelS3Storage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServiceManagedChannelS3Storage) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Used to store channel data in an S3 bucket managed by the AWS IoT Analytics
// service.
type ServiceManagedChannelS3StorageSummary struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ServiceManagedChannelS3StorageSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServiceManagedChannelS3StorageSummary) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Use this to store data store data in an S3 bucket managed by the AWS IoT
// Analytics service. The choice of service-managed or customer-managed S3 storage
// cannot be changed after creation of the data store.
type ServiceManagedDatastoreS3Storage struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ServiceManagedDatastoreS3Storage) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServiceManagedDatastoreS3Storage) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Used to store data store data in an S3 bucket managed by the AWS IoT Analytics
// service.
type ServiceManagedDatastoreS3StorageSummary struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ServiceManagedDatastoreS3StorageSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ServiceManagedDatastoreS3StorageSummary) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// The SQL query to modify the message.
type SqlQueryDatasetAction struct {
	_ struct{} `type:"structure"`

	// Pre-filters applied to message data.
	Filters []QueryFilter `locationName:"filters" type:"list"`

	// A SQL query string.
	//
	// SqlQuery is a required field
	SqlQuery *string `locationName:"sqlQuery" type:"string" required:"true"`
}

// String returns the string representation
func (s SqlQueryDatasetAction) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqlQueryDatasetAction) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SqlQueryDatasetAction"}

	if s.SqlQuery == nil {
		invalidParams.Add(aws.NewErrParamRequired("SqlQuery"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SqlQueryDatasetAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "filters", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SqlQuery != nil {
		v := *s.SqlQuery

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "sqlQuery", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A set of key/value pairs which are used to manage the resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag's key.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The tag's value.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the data set whose content generation triggers the new
// data set content generation.
type TriggeringDataset struct {
	_ struct{} `type:"structure"`

	// The name of the data set whose content generation triggers the new data set
	// content generation.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TriggeringDataset) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TriggeringDataset) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TriggeringDataset"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TriggeringDataset) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An instance of a variable to be passed to the "containerAction" execution.
// Each variable must have a name and a value given by one of "stringValue",
// "datasetContentVersionValue", or "outputFileUriValue".
type Variable struct {
	_ struct{} `type:"structure"`

	// The value of the variable as a structure that specifies a data set content
	// version.
	DatasetContentVersionValue *DatasetContentVersionValue `locationName:"datasetContentVersionValue" type:"structure"`

	// The value of the variable as a double (numeric).
	DoubleValue *float64 `locationName:"doubleValue" type:"double"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The value of the variable as a structure that specifies an output file URI.
	OutputFileUriValue *OutputFileUriValue `locationName:"outputFileUriValue" type:"structure"`

	// The value of the variable as a string.
	StringValue *string `locationName:"stringValue" type:"string"`
}

// String returns the string representation
func (s Variable) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Variable) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Variable"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.DatasetContentVersionValue != nil {
		if err := s.DatasetContentVersionValue.Validate(); err != nil {
			invalidParams.AddNested("DatasetContentVersionValue", err.(aws.ErrInvalidParams))
		}
	}
	if s.OutputFileUriValue != nil {
		if err := s.OutputFileUriValue.Validate(); err != nil {
			invalidParams.AddNested("OutputFileUriValue", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Variable) MarshalFields(e protocol.FieldEncoder) error {
	if s.DatasetContentVersionValue != nil {
		v := s.DatasetContentVersionValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "datasetContentVersionValue", v, metadata)
	}
	if s.DoubleValue != nil {
		v := *s.DoubleValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "doubleValue", protocol.Float64Value(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OutputFileUriValue != nil {
		v := s.OutputFileUriValue

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "outputFileUriValue", v, metadata)
	}
	if s.StringValue != nil {
		v := *s.StringValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stringValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the versioning of data set contents.
type VersioningConfiguration struct {
	_ struct{} `type:"structure"`

	// How many versions of data set contents will be kept. The "unlimited" parameter
	// must be false.
	MaxVersions *int64 `locationName:"maxVersions" min:"1" type:"integer"`

	// If true, unlimited versions of data set contents will be kept.
	Unlimited *bool `locationName:"unlimited" type:"boolean"`
}

// String returns the string representation
func (s VersioningConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VersioningConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VersioningConfiguration"}
	if s.MaxVersions != nil && *s.MaxVersions < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxVersions", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VersioningConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if s.MaxVersions != nil {
		v := *s.MaxVersions

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "maxVersions", protocol.Int64Value(v), metadata)
	}
	if s.Unlimited != nil {
		v := *s.Unlimited

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "unlimited", protocol.BoolValue(v), metadata)
	}
	return nil
}
