// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type DeregisterInstanceInput struct {
	_ struct{} `type:"structure"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterInstanceInput"}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeregisterInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterInstance = "DeregisterInstance"

// DeregisterInstanceRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Deregister a registered Amazon EC2 or on-premises instance. This action removes
// the instance from the stack and returns it to your control. This action cannot
// be used with instances that were created with AWS OpsWorks Stacks.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using DeregisterInstanceRequest.
//    req := client.DeregisterInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterInstance
func (c *Client) DeregisterInstanceRequest(input *DeregisterInstanceInput) DeregisterInstanceRequest {
	op := &aws.Operation{
		Name:       opDeregisterInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterInstanceInput{}
	}

	req := c.newRequest(op, input, &DeregisterInstanceOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeregisterInstanceRequest{Request: req, Input: input, Copy: c.DeregisterInstanceRequest}
}

// DeregisterInstanceRequest is the request type for the
// DeregisterInstance API operation.
type DeregisterInstanceRequest struct {
	*aws.Request
	Input *DeregisterInstanceInput
	Copy  func(*DeregisterInstanceInput) DeregisterInstanceRequest
}

// Send marshals and sends the DeregisterInstance API request.
func (r DeregisterInstanceRequest) Send(ctx context.Context) (*DeregisterInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterInstanceResponse{
		DeregisterInstanceOutput: r.Request.Data.(*DeregisterInstanceOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterInstanceResponse is the response type for the
// DeregisterInstance API operation.
type DeregisterInstanceResponse struct {
	*DeregisterInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterInstance request.
func (r *DeregisterInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
