// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package personalize

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListBatchInferenceJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of batch inference job results to return in each page.
	// The default value is 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The token to request the next page of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the solution version from which the batch
	// inference jobs were created.
	SolutionVersionArn *string `locationName:"solutionVersionArn" type:"string"`
}

// String returns the string representation
func (s ListBatchInferenceJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBatchInferenceJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListBatchInferenceJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListBatchInferenceJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing information on each job that is returned.
	BatchInferenceJobs []BatchInferenceJobSummary `locationName:"batchInferenceJobs" type:"list"`

	// The token to use to retreive the next page of results. The value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListBatchInferenceJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListBatchInferenceJobs = "ListBatchInferenceJobs"

// ListBatchInferenceJobsRequest returns a request value for making API operation for
// Amazon Personalize.
//
// Gets a list of the batch inference jobs that have been performed off of a
// solution version.
//
//    // Example sending a request using ListBatchInferenceJobsRequest.
//    req := client.ListBatchInferenceJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/personalize-2018-05-22/ListBatchInferenceJobs
func (c *Client) ListBatchInferenceJobsRequest(input *ListBatchInferenceJobsInput) ListBatchInferenceJobsRequest {
	op := &aws.Operation{
		Name:       opListBatchInferenceJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBatchInferenceJobsInput{}
	}

	req := c.newRequest(op, input, &ListBatchInferenceJobsOutput{})
	return ListBatchInferenceJobsRequest{Request: req, Input: input, Copy: c.ListBatchInferenceJobsRequest}
}

// ListBatchInferenceJobsRequest is the request type for the
// ListBatchInferenceJobs API operation.
type ListBatchInferenceJobsRequest struct {
	*aws.Request
	Input *ListBatchInferenceJobsInput
	Copy  func(*ListBatchInferenceJobsInput) ListBatchInferenceJobsRequest
}

// Send marshals and sends the ListBatchInferenceJobs API request.
func (r ListBatchInferenceJobsRequest) Send(ctx context.Context) (*ListBatchInferenceJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListBatchInferenceJobsResponse{
		ListBatchInferenceJobsOutput: r.Request.Data.(*ListBatchInferenceJobsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListBatchInferenceJobsRequestPaginator returns a paginator for ListBatchInferenceJobs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListBatchInferenceJobsRequest(input)
//   p := personalize.NewListBatchInferenceJobsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListBatchInferenceJobsPaginator(req ListBatchInferenceJobsRequest) ListBatchInferenceJobsPaginator {
	return ListBatchInferenceJobsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListBatchInferenceJobsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListBatchInferenceJobsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListBatchInferenceJobsPaginator struct {
	aws.Pager
}

func (p *ListBatchInferenceJobsPaginator) CurrentPage() *ListBatchInferenceJobsOutput {
	return p.Pager.CurrentPage().(*ListBatchInferenceJobsOutput)
}

// ListBatchInferenceJobsResponse is the response type for the
// ListBatchInferenceJobs API operation.
type ListBatchInferenceJobsResponse struct {
	*ListBatchInferenceJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListBatchInferenceJobs request.
func (r *ListBatchInferenceJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
