// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// This action deletes a health check.
type DeleteHealthCheckInput struct {
	_ struct{} `type:"structure"`

	// The ID of the health check that you want to delete.
	//
	// HealthCheckId is a required field
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteHealthCheckInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteHealthCheckInput"}

	if s.HealthCheckId == nil {
		invalidParams.Add(aws.NewErrParamRequired("HealthCheckId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteHealthCheckInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.HealthCheckId != nil {
		v := *s.HealthCheckId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "HealthCheckId", protocol.StringValue(v), metadata)
	}
	return nil
}

// An empty element.
type DeleteHealthCheckOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteHealthCheckOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteHealthCheck = "DeleteHealthCheck"

// DeleteHealthCheckRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Deletes a health check.
//
// Amazon Route 53 does not prevent you from deleting a health check even if
// the health check is associated with one or more resource record sets. If
// you delete a health check and you don't update the associated resource record
// sets, the future status of the health check can't be predicted and may change.
// This will affect the routing of DNS queries for your DNS failover configuration.
// For more information, see Replacing and Deleting Health Checks (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html#health-checks-deleting.html)
// in the Amazon Route 53 Developer Guide.
//
//    // Example sending a request using DeleteHealthCheckRequest.
//    req := client.DeleteHealthCheckRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/DeleteHealthCheck
func (c *Client) DeleteHealthCheckRequest(input *DeleteHealthCheckInput) DeleteHealthCheckRequest {
	op := &aws.Operation{
		Name:       opDeleteHealthCheck,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}",
	}

	if input == nil {
		input = &DeleteHealthCheckInput{}
	}

	req := c.newRequest(op, input, &DeleteHealthCheckOutput{})
	return DeleteHealthCheckRequest{Request: req, Input: input, Copy: c.DeleteHealthCheckRequest}
}

// DeleteHealthCheckRequest is the request type for the
// DeleteHealthCheck API operation.
type DeleteHealthCheckRequest struct {
	*aws.Request
	Input *DeleteHealthCheckInput
	Copy  func(*DeleteHealthCheckInput) DeleteHealthCheckRequest
}

// Send marshals and sends the DeleteHealthCheck API request.
func (r DeleteHealthCheckRequest) Send(ctx context.Context) (*DeleteHealthCheckResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteHealthCheckResponse{
		DeleteHealthCheckOutput: r.Request.Data.(*DeleteHealthCheckOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteHealthCheckResponse is the response type for the
// DeleteHealthCheck API operation.
type DeleteHealthCheckResponse struct {
	*DeleteHealthCheckOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteHealthCheck request.
func (r *DeleteHealthCheckResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
