// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListUserProfilesInput struct {
	_ struct{} `type:"structure"`

	// A parameter by which to filter the results.
	DomainIdEquals *string `type:"string"`

	// Returns a list up to a specified limit.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was truncated, you will receive this token. Use
	// it in your next request to receive the next set of results.
	NextToken *string `type:"string"`

	// The parameter by which to sort the results. The default is CreationTime.
	SortBy UserProfileSortKey `type:"string" enum:"true"`

	// The sort order for the results. The default is Ascending.
	SortOrder SortOrder `type:"string" enum:"true"`

	// A parameter by which to filter the results.
	UserProfileNameContains *string `type:"string"`
}

// String returns the string representation
func (s ListUserProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserProfilesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListUserProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListUserProfilesOutput struct {
	_ struct{} `type:"structure"`

	// If the previous response was truncated, you will receive this token. Use
	// it in your next request to receive the next set of results.
	NextToken *string `type:"string"`

	// The list of user profiles.
	UserProfiles []UserProfileDetails `type:"list"`
}

// String returns the string representation
func (s ListUserProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListUserProfiles = "ListUserProfiles"

// ListUserProfilesRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Lists user profiles.
//
//    // Example sending a request using ListUserProfilesRequest.
//    req := client.ListUserProfilesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListUserProfiles
func (c *Client) ListUserProfilesRequest(input *ListUserProfilesInput) ListUserProfilesRequest {
	op := &aws.Operation{
		Name:       opListUserProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUserProfilesInput{}
	}

	req := c.newRequest(op, input, &ListUserProfilesOutput{})
	return ListUserProfilesRequest{Request: req, Input: input, Copy: c.ListUserProfilesRequest}
}

// ListUserProfilesRequest is the request type for the
// ListUserProfiles API operation.
type ListUserProfilesRequest struct {
	*aws.Request
	Input *ListUserProfilesInput
	Copy  func(*ListUserProfilesInput) ListUserProfilesRequest
}

// Send marshals and sends the ListUserProfiles API request.
func (r ListUserProfilesRequest) Send(ctx context.Context) (*ListUserProfilesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListUserProfilesResponse{
		ListUserProfilesOutput: r.Request.Data.(*ListUserProfilesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListUserProfilesRequestPaginator returns a paginator for ListUserProfiles.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListUserProfilesRequest(input)
//   p := sagemaker.NewListUserProfilesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListUserProfilesPaginator(req ListUserProfilesRequest) ListUserProfilesPaginator {
	return ListUserProfilesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListUserProfilesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListUserProfilesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListUserProfilesPaginator struct {
	aws.Pager
}

func (p *ListUserProfilesPaginator) CurrentPage() *ListUserProfilesOutput {
	return p.Pager.CurrentPage().(*ListUserProfilesOutput)
}

// ListUserProfilesResponse is the response type for the
// ListUserProfiles API operation.
type ListUserProfilesResponse struct {
	*ListUserProfilesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListUserProfiles request.
func (r *ListUserProfilesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
