// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateAssociationStatusInput struct {
	_ struct{} `type:"structure"`

	// The association status.
	//
	// AssociationStatus is a required field
	AssociationStatus *AssociationStatus `type:"structure" required:"true"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The name of the Systems Manager document.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAssociationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssociationStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateAssociationStatusInput"}

	if s.AssociationStatus == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssociationStatus"))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.AssociationStatus != nil {
		if err := s.AssociationStatus.Validate(); err != nil {
			invalidParams.AddNested("AssociationStatus", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateAssociationStatusOutput struct {
	_ struct{} `type:"structure"`

	// Information about the association.
	AssociationDescription *AssociationDescription `type:"structure"`
}

// String returns the string representation
func (s UpdateAssociationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateAssociationStatus = "UpdateAssociationStatus"

// UpdateAssociationStatusRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Updates the status of the Systems Manager document associated with the specified
// instance.
//
//    // Example sending a request using UpdateAssociationStatusRequest.
//    req := client.UpdateAssociationStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociationStatus
func (c *Client) UpdateAssociationStatusRequest(input *UpdateAssociationStatusInput) UpdateAssociationStatusRequest {
	op := &aws.Operation{
		Name:       opUpdateAssociationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAssociationStatusInput{}
	}

	req := c.newRequest(op, input, &UpdateAssociationStatusOutput{})
	return UpdateAssociationStatusRequest{Request: req, Input: input, Copy: c.UpdateAssociationStatusRequest}
}

// UpdateAssociationStatusRequest is the request type for the
// UpdateAssociationStatus API operation.
type UpdateAssociationStatusRequest struct {
	*aws.Request
	Input *UpdateAssociationStatusInput
	Copy  func(*UpdateAssociationStatusInput) UpdateAssociationStatusRequest
}

// Send marshals and sends the UpdateAssociationStatus API request.
func (r UpdateAssociationStatusRequest) Send(ctx context.Context) (*UpdateAssociationStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateAssociationStatusResponse{
		UpdateAssociationStatusOutput: r.Request.Data.(*UpdateAssociationStatusOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateAssociationStatusResponse is the response type for the
// UpdateAssociationStatus API operation.
type UpdateAssociationStatusResponse struct {
	*UpdateAssociationStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateAssociationStatus request.
func (r *UpdateAssociationStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
