// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transfer

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateServerInput struct {
	_ struct{} `type:"structure"`

	// The virtual private cloud (VPC) endpoint settings that you want to configure
	// for your SFTP server. This parameter is required when you specify a value
	// for the EndpointType parameter.
	EndpointDetails *EndpointDetails `type:"structure"`

	// The type of VPC endpoint that you want your SFTP server to connect to. If
	// you connect to a VPC endpoint, your SFTP server isn't accessible over the
	// public internet.
	EndpointType EndpointType `type:"string" enum:"true"`

	// The RSA private key as generated by the ssh-keygen -N "" -f my-new-server-key
	// command.
	//
	// If you aren't planning to migrate existing users from an existing SFTP server
	// to a new AWS SFTP server, don't update the host key. Accidentally changing
	// a server's host key can be disruptive.
	//
	// For more information, see "https://alpha-docs-aws.amazon.com/transfer/latest/userguide/configuring-servers.html#change-host-key"
	// in the AWS SFTP User Guide.
	HostKey *string `type:"string" sensitive:"true"`

	// This parameter is required when the IdentityProviderType is set to API_GATEWAY.
	// Accepts an array containing all of the information required to call a customer-supplied
	// authentication API, including the API Gateway URL. This property is not required
	// when the IdentityProviderType is set to SERVICE_MANAGED.
	IdentityProviderDetails *IdentityProviderDetails `type:"structure"`

	// Specifies the mode of authentication for the SFTP server. The default value
	// is SERVICE_MANAGED, which allows you to store and access SFTP user credentials
	// within the AWS Transfer for SFTP service. Use the API_GATEWAY value to integrate
	// with an identity provider of your choosing. The API_GATEWAY setting requires
	// you to provide an API Gateway endpoint URL to call for authentication using
	// the IdentityProviderDetails parameter.
	IdentityProviderType IdentityProviderType `type:"string" enum:"true"`

	// A value that allows the service to write your SFTP users' activity to your
	// Amazon CloudWatch logs for monitoring and auditing purposes.
	LoggingRole *string `min:"20" type:"string"`

	// Key-value pairs that can be used to group and search for servers.
	Tags []Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateServerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateServerInput"}
	if s.LoggingRole != nil && len(*s.LoggingRole) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("LoggingRole", 20))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Tags", 1))
	}
	if s.EndpointDetails != nil {
		if err := s.EndpointDetails.Validate(); err != nil {
			invalidParams.AddNested("EndpointDetails", err.(aws.ErrInvalidParams))
		}
	}
	if s.IdentityProviderDetails != nil {
		if err := s.IdentityProviderDetails.Validate(); err != nil {
			invalidParams.AddNested("IdentityProviderDetails", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateServerOutput struct {
	_ struct{} `type:"structure"`

	// The service-assigned ID of the SFTP server that is created.
	//
	// ServerId is a required field
	ServerId *string `min:"19" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateServerOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateServer = "CreateServer"

// CreateServerRequest returns a request value for making API operation for
// AWS Transfer for SFTP.
//
// Instantiates an autoscaling virtual server based on Secure File Transfer
// Protocol (SFTP) in AWS. When you make updates to your server or when you
// work with users, use the service-generated ServerId property that is assigned
// to the newly created server.
//
//    // Example sending a request using CreateServerRequest.
//    req := client.CreateServerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transfer-2018-11-05/CreateServer
func (c *Client) CreateServerRequest(input *CreateServerInput) CreateServerRequest {
	op := &aws.Operation{
		Name:       opCreateServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServerInput{}
	}

	req := c.newRequest(op, input, &CreateServerOutput{})
	return CreateServerRequest{Request: req, Input: input, Copy: c.CreateServerRequest}
}

// CreateServerRequest is the request type for the
// CreateServer API operation.
type CreateServerRequest struct {
	*aws.Request
	Input *CreateServerInput
	Copy  func(*CreateServerInput) CreateServerRequest
}

// Send marshals and sends the CreateServer API request.
func (r CreateServerRequest) Send(ctx context.Context) (*CreateServerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateServerResponse{
		CreateServerOutput: r.Request.Data.(*CreateServerOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateServerResponse is the response type for the
// CreateServer API operation.
type CreateServerResponse struct {
	*CreateServerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateServer request.
func (r *CreateServerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
