// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/service/waf"
)

type CreateGeoMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the GeoMatchSet. You can't change Name
	// after you create the GeoMatchSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGeoMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGeoMatchSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateGeoMatchSetInput"}

	if s.ChangeToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeToken", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateGeoMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateGeoMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`

	// The GeoMatchSet returned in the CreateGeoMatchSet response. The GeoMatchSet
	// contains no GeoMatchConstraints.
	GeoMatchSet *waf.GeoMatchSet `type:"structure"`
}

// String returns the string representation
func (s CreateGeoMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateGeoMatchSet = "CreateGeoMatchSet"

// CreateGeoMatchSetRequest returns a request value for making API operation for
// AWS WAF Regional.
//
// Creates an GeoMatchSet, which you use to specify which web requests you want
// to allow or block based on the country that the requests originate from.
// For example, if you're receiving a lot of requests from one or more countries
// and you want to block the requests, you can create an GeoMatchSet that contains
// those countries and then configure AWS WAF to block the requests.
//
// To create and configure a GeoMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateGeoMatchSet request.
//
// Submit a CreateGeoMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateGeoMatchSet request.
//
// Submit an UpdateGeoMatchSetSet request to specify the countries that you
// want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
//    // Example sending a request using CreateGeoMatchSetRequest.
//    req := client.CreateGeoMatchSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/CreateGeoMatchSet
func (c *Client) CreateGeoMatchSetRequest(input *CreateGeoMatchSetInput) CreateGeoMatchSetRequest {
	op := &aws.Operation{
		Name:       opCreateGeoMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGeoMatchSetInput{}
	}

	req := c.newRequest(op, input, &CreateGeoMatchSetOutput{})
	return CreateGeoMatchSetRequest{Request: req, Input: input, Copy: c.CreateGeoMatchSetRequest}
}

// CreateGeoMatchSetRequest is the request type for the
// CreateGeoMatchSet API operation.
type CreateGeoMatchSetRequest struct {
	*aws.Request
	Input *CreateGeoMatchSetInput
	Copy  func(*CreateGeoMatchSetInput) CreateGeoMatchSetRequest
}

// Send marshals and sends the CreateGeoMatchSet API request.
func (r CreateGeoMatchSetRequest) Send(ctx context.Context) (*CreateGeoMatchSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateGeoMatchSetResponse{
		CreateGeoMatchSetOutput: r.Request.Data.(*CreateGeoMatchSetOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateGeoMatchSetResponse is the response type for the
// CreateGeoMatchSet API operation.
type CreateGeoMatchSetResponse struct {
	*CreateGeoMatchSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateGeoMatchSet request.
func (r *CreateGeoMatchSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
