// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workmail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateResourceInput struct {
	_ struct{} `type:"structure"`

	// The name of the new resource.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The identifier associated with the organization for which the resource is
	// created.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The type of the new resource. The available types are equipment and room.
	//
	// Type is a required field
	Type ResourceType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s CreateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateResourceInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.OrganizationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationId"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateResourceOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the new resource.
	ResourceId *string `type:"string"`
}

// String returns the string representation
func (s CreateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateResource = "CreateResource"

// CreateResourceRequest returns a request value for making API operation for
// Amazon WorkMail.
//
// Creates a new Amazon WorkMail resource.
//
//    // Example sending a request using CreateResourceRequest.
//    req := client.CreateResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateResource
func (c *Client) CreateResourceRequest(input *CreateResourceInput) CreateResourceRequest {
	op := &aws.Operation{
		Name:       opCreateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResourceInput{}
	}

	req := c.newRequest(op, input, &CreateResourceOutput{})
	return CreateResourceRequest{Request: req, Input: input, Copy: c.CreateResourceRequest}
}

// CreateResourceRequest is the request type for the
// CreateResource API operation.
type CreateResourceRequest struct {
	*aws.Request
	Input *CreateResourceInput
	Copy  func(*CreateResourceInput) CreateResourceRequest
}

// Send marshals and sends the CreateResource API request.
func (r CreateResourceRequest) Send(ctx context.Context) (*CreateResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateResourceResponse{
		CreateResourceOutput: r.Request.Data.(*CreateResourceOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateResourceResponse is the response type for the
// CreateResource API operation.
type CreateResourceResponse struct {
	*CreateResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateResource request.
func (r *CreateResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
