// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package binaryauthorization provides access to the Binary Authorization API.
//
// For product documentation, see: https://cloud.google.com/binary-authorization/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/binaryauthorization/v1"
//	...
//	ctx := context.Background()
//	binaryauthorizationService, err := binaryauthorization.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	binaryauthorizationService, err := binaryauthorization.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	binaryauthorizationService, err := binaryauthorization.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package binaryauthorization // import "google.golang.org/api/binaryauthorization/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "binaryauthorization:v1"
const apiName = "binaryauthorization"
const apiVersion = "v1"
const basePath = "https://binaryauthorization.googleapis.com/"
const basePathTemplate = "https://binaryauthorization.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://binaryauthorization.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	s.Systempolicy = NewSystempolicyService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService

	Systempolicy *SystempolicyService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Attestors = NewProjectsAttestorsService(s)
	rs.Platforms = NewProjectsPlatformsService(s)
	rs.Policy = NewProjectsPolicyService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Attestors *ProjectsAttestorsService

	Platforms *ProjectsPlatformsService

	Policy *ProjectsPolicyService
}

func NewProjectsAttestorsService(s *Service) *ProjectsAttestorsService {
	rs := &ProjectsAttestorsService{s: s}
	return rs
}

type ProjectsAttestorsService struct {
	s *Service
}

func NewProjectsPlatformsService(s *Service) *ProjectsPlatformsService {
	rs := &ProjectsPlatformsService{s: s}
	rs.Gke = NewProjectsPlatformsGkeService(s)
	rs.Policies = NewProjectsPlatformsPoliciesService(s)
	return rs
}

type ProjectsPlatformsService struct {
	s *Service

	Gke *ProjectsPlatformsGkeService

	Policies *ProjectsPlatformsPoliciesService
}

func NewProjectsPlatformsGkeService(s *Service) *ProjectsPlatformsGkeService {
	rs := &ProjectsPlatformsGkeService{s: s}
	rs.Policies = NewProjectsPlatformsGkePoliciesService(s)
	return rs
}

type ProjectsPlatformsGkeService struct {
	s *Service

	Policies *ProjectsPlatformsGkePoliciesService
}

func NewProjectsPlatformsGkePoliciesService(s *Service) *ProjectsPlatformsGkePoliciesService {
	rs := &ProjectsPlatformsGkePoliciesService{s: s}
	return rs
}

type ProjectsPlatformsGkePoliciesService struct {
	s *Service
}

func NewProjectsPlatformsPoliciesService(s *Service) *ProjectsPlatformsPoliciesService {
	rs := &ProjectsPlatformsPoliciesService{s: s}
	return rs
}

type ProjectsPlatformsPoliciesService struct {
	s *Service
}

func NewProjectsPolicyService(s *Service) *ProjectsPolicyService {
	rs := &ProjectsPolicyService{s: s}
	return rs
}

type ProjectsPolicyService struct {
	s *Service
}

func NewSystempolicyService(s *Service) *SystempolicyService {
	rs := &SystempolicyService{s: s}
	return rs
}

type SystempolicyService struct {
	s *Service
}

// AdmissionRule: An admission rule specifies either that all container images
// used in a pod creation request must be attested to by one or more attestors,
// that all pod creations will be allowed, or that all pod creations will be
// denied. Images matching an admission allowlist pattern are exempted from
// admission rules and will never block a pod creation.
type AdmissionRule struct {
	// EnforcementMode: Required. The action when a pod creation is denied by the
	// admission rule.
	//
	// Possible values:
	//   "ENFORCEMENT_MODE_UNSPECIFIED" - Do not use.
	//   "ENFORCED_BLOCK_AND_AUDIT_LOG" - Enforce the admission rule by blocking
	// the pod creation.
	//   "DRYRUN_AUDIT_LOG_ONLY" - Dryrun mode: Audit logging only. This will allow
	// the pod creation as if the admission request had specified break-glass.
	EnforcementMode string `json:"enforcementMode,omitempty"`
	// EvaluationMode: Required. How this admission rule will be evaluated.
	//
	// Possible values:
	//   "EVALUATION_MODE_UNSPECIFIED" - Do not use.
	//   "ALWAYS_ALLOW" - This rule allows all pod creations.
	//   "REQUIRE_ATTESTATION" - This rule allows a pod creation if all the
	// attestors listed in `require_attestations_by` have valid attestations for
	// all of the images in the pod spec.
	//   "ALWAYS_DENY" - This rule denies all pod creations.
	EvaluationMode string `json:"evaluationMode,omitempty"`
	// RequireAttestationsBy: Optional. The resource names of the attestors that
	// must attest to a container image, in the format `projects/*/attestors/*`.
	// Each attestor must exist before a policy can reference it. To add an
	// attestor to a policy the principal issuing the policy change request must be
	// able to read the attestor resource. Note: this field must be non-empty when
	// the `evaluation_mode` field specifies `REQUIRE_ATTESTATION`, otherwise it
	// must be empty.
	RequireAttestationsBy []string `json:"requireAttestationsBy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnforcementMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnforcementMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdmissionRule) MarshalJSON() ([]byte, error) {
	type NoMethod AdmissionRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdmissionWhitelistPattern: An admission allowlist pattern exempts images
// from checks by admission rules.
type AdmissionWhitelistPattern struct {
	// NamePattern: An image name pattern to allowlist, in the form
	// `registry/path/to/image`. This supports a trailing `*` wildcard, but this is
	// allowed only in text after the `registry/` part. This also supports a
	// trailing `**` wildcard which matches subdirectories of a given entry.
	NamePattern string `json:"namePattern,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NamePattern") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NamePattern") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdmissionWhitelistPattern) MarshalJSON() ([]byte, error) {
	type NoMethod AdmissionWhitelistPattern
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AllowlistResult: Result of evaluating an image name allowlist.
type AllowlistResult struct {
	// MatchedPattern: The allowlist pattern that the image matched.
	MatchedPattern string `json:"matchedPattern,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MatchedPattern") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MatchedPattern") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AllowlistResult) MarshalJSON() ([]byte, error) {
	type NoMethod AllowlistResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AttestationAuthenticator: An attestation authenticator that will be used to
// verify attestations. Typically this is just a set of public keys.
// Conceptually, an authenticator can be treated as always returning either
// "authenticated" or "not authenticated" when presented with a signed
// attestation (almost always assumed to be a DSSE
// (https://github.com/secure-systems-lab/dsse) attestation). The details of
// how an authenticator makes this decision are specific to the type of
// 'authenticator' that this message wraps.
type AttestationAuthenticator struct {
	// DisplayName: Optional. A user-provided name for this
	// `AttestationAuthenticator`. This field has no effect on the policy
	// evaluation behavior except to improve readability of messages in evaluation
	// results.
	DisplayName string `json:"displayName,omitempty"`
	// PkixPublicKeySet: Optional. A set of raw PKIX SubjectPublicKeyInfo format
	// public keys. If any public key in the set validates the attestation
	// signature, then the signature is considered authenticated (i.e. any one key
	// is sufficient to authenticate).
	PkixPublicKeySet *PkixPublicKeySet `json:"pkixPublicKeySet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AttestationAuthenticator) MarshalJSON() ([]byte, error) {
	type NoMethod AttestationAuthenticator
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AttestationOccurrence: Occurrence that represents a single "attestation".
// The authenticity of an attestation can be verified using the attached
// signature. If the verifier trusts the public key of the signer, then
// verifying the signature is sufficient to establish trust. In this
// circumstance, the authority to which this attestation is attached is
// primarily useful for lookup (how to find this attestation if you already
// know the authority and artifact to be verified) and intent (for which
// authority this attestation was intended to sign.
type AttestationOccurrence struct {
	// Jwts: One or more JWTs encoding a self-contained attestation. Each JWT
	// encodes the payload that it verifies within the JWT itself. Verifier
	// implementation SHOULD ignore the `serialized_payload` field when verifying
	// these JWTs. If only JWTs are present on this AttestationOccurrence, then the
	// `serialized_payload` SHOULD be left empty. Each JWT SHOULD encode a claim
	// specific to the `resource_uri` of this Occurrence, but this is not validated
	// by Grafeas metadata API implementations. The JWT itself is opaque to
	// Grafeas.
	Jwts []*Jwt `json:"jwts,omitempty"`
	// SerializedPayload: Required. The serialized payload that is verified by one
	// or more `signatures`.
	SerializedPayload string `json:"serializedPayload,omitempty"`
	// Signatures: One or more signatures over `serialized_payload`. Verifier
	// implementations should consider this attestation message verified if at
	// least one `signature` verifies `serialized_payload`. See `Signature` in
	// common.proto for more details on signature structure and verification.
	Signatures []*Signature `json:"signatures,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Jwts") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Jwts") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AttestationOccurrence) MarshalJSON() ([]byte, error) {
	type NoMethod AttestationOccurrence
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AttestationSource: Specifies the locations for fetching the provenance
// attestations.
type AttestationSource struct {
	// ContainerAnalysisAttestationProjects: The IDs of the Google Cloud projects
	// that store the SLSA attestations as Container Analysis Occurrences, in the
	// format `projects/[PROJECT_ID]`. Maximum number of
	// `container_analysis_attestation_projects` allowed in each
	// `AttestationSource` is 10.
	ContainerAnalysisAttestationProjects []string `json:"containerAnalysisAttestationProjects,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ContainerAnalysisAttestationProjects") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "ContainerAnalysisAttestationProjects") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s AttestationSource) MarshalJSON() ([]byte, error) {
	type NoMethod AttestationSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Attestor: An attestor that attests to container image artifacts. An existing
// attestor cannot be modified except where indicated.
type Attestor struct {
	// Description: Optional. A descriptive comment. This field may be updated. The
	// field may be displayed in chooser dialogs.
	Description string `json:"description,omitempty"`
	// Etag: Optional. A checksum, returned by the server, that can be sent on
	// update requests to ensure the attestor has an up-to-date value before
	// attempting to update it. See https://google.aip.dev/154.
	Etag string `json:"etag,omitempty"`
	// Name: Required. The resource name, in the format: `projects/*/attestors/*`.
	// This field may not be updated.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Time when the attestor was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// UserOwnedGrafeasNote: This specifies how an attestation will be read, and
	// how it will be used during policy enforcement.
	UserOwnedGrafeasNote *UserOwnedGrafeasNote `json:"userOwnedGrafeasNote,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Attestor) MarshalJSON() ([]byte, error) {
	type NoMethod Attestor
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AttestorPublicKey: An attestor public key that will be used to verify
// attestations signed by this attestor.
type AttestorPublicKey struct {
	// AsciiArmoredPgpPublicKey: ASCII-armored representation of a PGP public key,
	// as the entire output by the command `gpg --export --armor foo@example.com`
	// (either LF or CRLF line endings). When using this field, `id` should be left
	// blank. The Binary Authorization API handlers will calculate the ID and fill
	// it in automatically. Binary Authorization computes this ID as the OpenPGP
	// RFC4880 V4 fingerprint, represented as upper-case hex. If `id` is provided
	// by the caller, it will be overwritten by the API-calculated ID.
	AsciiArmoredPgpPublicKey string `json:"asciiArmoredPgpPublicKey,omitempty"`
	// Comment: Optional. A descriptive comment. This field may be updated.
	Comment string `json:"comment,omitempty"`
	// Id: The ID of this public key. Signatures verified by Binary Authorization
	// must include the ID of the public key that can be used to verify them, and
	// that ID must match the contents of this field exactly. Additional
	// restrictions on this field can be imposed based on which public key type is
	// encapsulated. See the documentation on `public_key` cases below for details.
	Id string `json:"id,omitempty"`
	// PkixPublicKey: A raw PKIX SubjectPublicKeyInfo format public key. NOTE: `id`
	// may be explicitly provided by the caller when using this type of public key,
	// but it MUST be a valid RFC3986 URI. If `id` is left blank, a default one
	// will be computed based on the digest of the DER encoding of the public key.
	PkixPublicKey *PkixPublicKey `json:"pkixPublicKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AsciiArmoredPgpPublicKey")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AsciiArmoredPgpPublicKey") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AttestorPublicKey) MarshalJSON() ([]byte, error) {
	type NoMethod AttestorPublicKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Check: A single check to perform against a Pod. Checks are grouped into
// `CheckSet` objects, which are defined by the top-level policy.
type Check struct {
	// AlwaysDeny: Optional. A special-case check that always denies. Note that
	// this still only applies when the scope of the `CheckSet` applies and the
	// image isn't exempted by an image allowlist. This check is primarily useful
	// for testing, or to set the default behavior for all unmatched scopes to
	// "deny".
	AlwaysDeny bool `json:"alwaysDeny,omitempty"`
	// DisplayName: Optional. A user-provided name for this check. This field has
	// no effect on the policy evaluation behavior except to improve readability of
	// messages in evaluation results.
	DisplayName string `json:"displayName,omitempty"`
	// ImageAllowlist: Optional. Images exempted from this check. If any of the
	// patterns match the image url, the check will not be evaluated.
	ImageAllowlist *ImageAllowlist `json:"imageAllowlist,omitempty"`
	// ImageFreshnessCheck: Optional. Require that an image is no older than a
	// configured expiration time. Image age is determined by its upload time.
	ImageFreshnessCheck *ImageFreshnessCheck `json:"imageFreshnessCheck,omitempty"`
	// SigstoreSignatureCheck: Optional. Require that an image was signed by Cosign
	// with a trusted key. This check requires that both the image and signature
	// are stored in Artifact Registry.
	SigstoreSignatureCheck *SigstoreSignatureCheck `json:"sigstoreSignatureCheck,omitempty"`
	// SimpleSigningAttestationCheck: Optional. Require a SimpleSigning-type
	// attestation for every image in the deployment.
	SimpleSigningAttestationCheck *SimpleSigningAttestationCheck `json:"simpleSigningAttestationCheck,omitempty"`
	// SlsaCheck: Optional. Require that an image was built by a trusted builder
	// (such as Google Cloud Build), meets requirements for Supply chain Levels for
	// Software Artifacts (SLSA), and was built from a trusted source code
	// repostitory.
	SlsaCheck *SlsaCheck `json:"slsaCheck,omitempty"`
	// TrustedDirectoryCheck: Optional. Require that an image lives in a trusted
	// directory.
	TrustedDirectoryCheck *TrustedDirectoryCheck `json:"trustedDirectoryCheck,omitempty"`
	// VulnerabilityCheck: Optional. Require that an image does not contain
	// vulnerabilities that violate the configured rules, such as based on severity
	// levels.
	VulnerabilityCheck *VulnerabilityCheck `json:"vulnerabilityCheck,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AlwaysDeny") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AlwaysDeny") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Check) MarshalJSON() ([]byte, error) {
	type NoMethod Check
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CheckResult: Result of evaluating one check.
type CheckResult struct {
	// AllowlistResult: If the image was exempted by an allow_pattern in the check,
	// contains the pattern that the image name matched.
	AllowlistResult *AllowlistResult `json:"allowlistResult,omitempty"`
	// DisplayName: The name of the check.
	DisplayName string `json:"displayName,omitempty"`
	// EvaluationResult: If a check was evaluated, contains the result of the
	// check.
	EvaluationResult *EvaluationResult `json:"evaluationResult,omitempty"`
	// Explanation: Explanation of this check result.
	Explanation string `json:"explanation,omitempty"`
	// Index: The index of the check.
	Index int64 `json:"index,omitempty,string"`
	// Type: The type of the check.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowlistResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowlistResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckResult) MarshalJSON() ([]byte, error) {
	type NoMethod CheckResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CheckResults: Result of evaluating one or more checks.
type CheckResults struct {
	// Results: Per-check details.
	Results []*CheckResult `json:"results,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Results") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Results") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckResults) MarshalJSON() ([]byte, error) {
	type NoMethod CheckResults
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CheckSet: A conjunction of policy checks, scoped to a particular namespace
// or Kubernetes service account. In order for evaluation of a `CheckSet` to
// return "allowed" for a given image in a given Pod, one of the following
// conditions must be satisfied: * The image is explicitly exempted by an entry
// in `image_allowlist`, OR * ALL of the `checks` evaluate to "allowed".
type CheckSet struct {
	// Checks: Optional. The checks to apply. The ultimate result of evaluating the
	// check set will be "allow" if and only if every check in `checks` evaluates
	// to "allow". If `checks` is empty, the default behavior is "always allow".
	Checks []*Check `json:"checks,omitempty"`
	// DisplayName: Optional. A user-provided name for this `CheckSet`. This field
	// has no effect on the policy evaluation behavior except to improve
	// readability of messages in evaluation results.
	DisplayName string `json:"displayName,omitempty"`
	// ImageAllowlist: Optional. Images exempted from this `CheckSet`. If any of
	// the patterns match the image being evaluated, no checks in the `CheckSet`
	// will be evaluated.
	ImageAllowlist *ImageAllowlist `json:"imageAllowlist,omitempty"`
	// Scope: Optional. The scope to which this `CheckSet` applies. If unset or an
	// empty string (the default), applies to all namespaces and service accounts.
	// See the `Scope` message documentation for details on scoping rules.
	Scope *Scope `json:"scope,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Checks") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Checks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckSet) MarshalJSON() ([]byte, error) {
	type NoMethod CheckSet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CheckSetResult: Result of evaluating one check set.
type CheckSetResult struct {
	// AllowlistResult: If the image was exempted by an allow_pattern in the check
	// set, contains the pattern that the image name matched.
	AllowlistResult *AllowlistResult `json:"allowlistResult,omitempty"`
	// CheckResults: If checks were evaluated, contains the results of evaluating
	// each check.
	CheckResults *CheckResults `json:"checkResults,omitempty"`
	// DisplayName: The name of the check set.
	DisplayName string `json:"displayName,omitempty"`
	// Explanation: Explanation of this check set result. Only populated if no
	// checks were evaluated.
	Explanation string `json:"explanation,omitempty"`
	// Index: The index of the check set.
	Index int64 `json:"index,omitempty,string"`
	// Scope: The scope of the check set.
	Scope *Scope `json:"scope,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowlistResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowlistResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckSetResult) MarshalJSON() ([]byte, error) {
	type NoMethod CheckSetResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EvaluateGkePolicyRequest: Request message for
// PlatformPolicyEvaluationService.EvaluateGkePolicy.
type EvaluateGkePolicyRequest struct {
	// Resource: Required. JSON or YAML blob representing a Kubernetes resource.
	Resource googleapi.RawMessage `json:"resource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resource") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EvaluateGkePolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EvaluateGkePolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EvaluateGkePolicyResponse: Response message for
// PlatformPolicyEvaluationService.EvaluateGkePolicy.
type EvaluateGkePolicyResponse struct {
	// Results: Evaluation result for each Pod contained in the request.
	Results []*PodResult `json:"results,omitempty"`
	// Verdict: The result of evaluating all Pods in the request.
	//
	// Possible values:
	//   "VERDICT_UNSPECIFIED" - Not specified. This should never be used.
	//   "CONFORMANT" - All Pods in the request conform to the policy.
	//   "NON_CONFORMANT" - At least one Pod does not conform to the policy.
	//   "ERROR" - Encountered at least one error evaluating a Pod and all other
	// Pods conform to the policy. Non-conformance has precedence over errors.
	Verdict string `json:"verdict,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Results") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Results") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EvaluateGkePolicyResponse) MarshalJSON() ([]byte, error) {
	type NoMethod EvaluateGkePolicyResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EvaluationResult: Result of evaluating one check.
type EvaluationResult struct {
	// Verdict: The result of evaluating this check.
	//
	// Possible values:
	//   "CHECK_VERDICT_UNSPECIFIED" - Not specified. This should never be used.
	//   "CONFORMANT" - The check was successfully evaluated and the image
	// satisfied the check.
	//   "NON_CONFORMANT" - The check was successfully evaluated and the image did
	// not satisfy the check.
	//   "ERROR" - The check was not successfully evaluated.
	Verdict string `json:"verdict,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Verdict") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Verdict") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EvaluationResult) MarshalJSON() ([]byte, error) {
	type NoMethod EvaluationResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GkePolicy: A Binary Authorization policy for a GKE cluster. This is one type
// of policy that can occur as a `PlatformPolicy`.
type GkePolicy struct {
	// CheckSets: Optional. The `CheckSet` objects to apply, scoped by namespace or
	// namespace and service account. Exactly one `CheckSet` will be evaluated for
	// a given Pod (unless the list is empty, in which case the behavior is "always
	// allow"). If multiple `CheckSet` objects have scopes that match the namespace
	// and service account of the Pod being evaluated, only the `CheckSet` with the
	// MOST SPECIFIC scope will match. `CheckSet` objects must be listed in order
	// of decreasing specificity, i.e. if a scope matches a given service account
	// (which must include the namespace), it must come before a `CheckSet` with a
	// scope matching just that namespace. This property is enforced by server-side
	// validation. The purpose of this restriction is to ensure that if more than
	// one `CheckSet` matches a given Pod, the `CheckSet` that will be evaluated
	// will always be the first in the list to match (because if any other matches,
	// it must be less specific). If `check_sets` is empty, the default behavior is
	// to allow all images. If `check_sets` is non-empty, the last `check_sets`
	// entry must always be a `CheckSet` with no scope set, i.e. a catchall to
	// handle any situation not caught by the preceding `CheckSet` objects.
	CheckSets []*CheckSet `json:"checkSets,omitempty"`
	// ImageAllowlist: Optional. Images exempted from this policy. If any of the
	// patterns match the image being evaluated, the rest of the policy will not be
	// evaluated.
	ImageAllowlist *ImageAllowlist `json:"imageAllowlist,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CheckSets") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CheckSets") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GkePolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GkePolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IamPolicy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources. A `Policy` is a collection of
// `bindings`. A `binding` binds one or more `members`, or principals, to a
// single `role`. Principals can be user accounts, service accounts, Google
// groups, and domains (such as G Suite). A `role` is a named list of
// permissions; each `role` can be an IAM predefined role or a user-created
// custom role. For some types of Google Cloud resources, a `binding` can also
// specify a `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or both. To
// learn which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type IamPolicy struct {
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Bindings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bindings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IamPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod IamPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImageAllowlist: Images that are exempted from normal checks based on name
// pattern only.
type ImageAllowlist struct {
	// AllowPattern: Required. A disjunction of image patterns to allow. If any of
	// these patterns match, then the image is considered exempted by this
	// allowlist.
	AllowPattern []string `json:"allowPattern,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowPattern") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowPattern") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImageAllowlist) MarshalJSON() ([]byte, error) {
	type NoMethod ImageAllowlist
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImageFreshnessCheck: An image freshness check, which rejects images that
// were uploaded before the set number of days ago to the supported
// repositories.
type ImageFreshnessCheck struct {
	// MaxUploadAgeDays: Required. The max number of days that is allowed since the
	// image was uploaded. Must be greater than zero.
	MaxUploadAgeDays int64 `json:"maxUploadAgeDays,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxUploadAgeDays") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxUploadAgeDays") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImageFreshnessCheck) MarshalJSON() ([]byte, error) {
	type NoMethod ImageFreshnessCheck
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImageResult: Result of evaluating one image.
type ImageResult struct {
	// AllowlistResult: If the image was exempted by a top-level allow_pattern,
	// contains the allowlist pattern that the image name matched.
	AllowlistResult *AllowlistResult `json:"allowlistResult,omitempty"`
	// CheckSetResult: If a check set was evaluated, contains the result of the
	// check set. Empty if there were no check sets.
	CheckSetResult *CheckSetResult `json:"checkSetResult,omitempty"`
	// Explanation: Explanation of this image result. Only populated if no check
	// sets were evaluated.
	Explanation string `json:"explanation,omitempty"`
	// ImageUri: Image URI from the request.
	ImageUri string `json:"imageUri,omitempty"`
	// Verdict: The result of evaluating this image.
	//
	// Possible values:
	//   "IMAGE_VERDICT_UNSPECIFIED" - Not specified. This should never be used.
	//   "CONFORMANT" - Image conforms to the policy.
	//   "NON_CONFORMANT" - Image does not conform to the policy.
	//   "ERROR" - Error evaluating the image. Non-conformance has precedence over
	// errors.
	Verdict string `json:"verdict,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowlistResult") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowlistResult") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImageResult) MarshalJSON() ([]byte, error) {
	type NoMethod ImageResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Jwt struct {
	// CompactJwt: The compact encoding of a JWS, which is always three base64
	// encoded strings joined by periods. For details, see:
	// https://tools.ietf.org/html/rfc7515.html#section-3.1
	CompactJwt string `json:"compactJwt,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompactJwt") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompactJwt") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Jwt) MarshalJSON() ([]byte, error) {
	type NoMethod Jwt
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAttestorsResponse: Response message for
// BinauthzManagementServiceV1.ListAttestors.
type ListAttestorsResponse struct {
	// Attestors: The list of attestors.
	Attestors []*Attestor `json:"attestors,omitempty"`
	// NextPageToken: A token to retrieve the next page of results. Pass this value
	// in the ListAttestorsRequest.page_token field in the subsequent call to the
	// `ListAttestors` method to retrieve the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Attestors") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attestors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAttestorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAttestorsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListPlatformPoliciesResponse: Response message for
// PlatformPolicyManagementService.ListPlatformPolicies.
type ListPlatformPoliciesResponse struct {
	// NextPageToken: A token to retrieve the next page of results. Pass this value
	// in the ListPlatformPoliciesRequest.page_token field in the subsequent call
	// to the `ListPlatformPolicies` method to retrieve the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// PlatformPolicies: The list of platform policies.
	PlatformPolicies []*PlatformPolicy `json:"platformPolicies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListPlatformPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListPlatformPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PkixPublicKey: A public key in the PkixPublicKey format
// (https://tools.ietf.org/html/rfc5280#section-4.1.2.7). Public keys of this
// type are typically textually encoded using the PEM format.
type PkixPublicKey struct {
	// KeyId: Optional. The ID of this public key. Signatures verified by Binary
	// Authorization must include the ID of the public key that can be used to
	// verify them. The ID must match exactly contents of the `key_id` field
	// exactly. The ID may be explicitly provided by the caller, but it MUST be a
	// valid RFC3986 URI. If `key_id` is left blank and this `PkixPublicKey` is not
	// used in the context of a wrapper (see next paragraph), a default key ID will
	// be computed based on the digest of the DER encoding of the public key. If
	// this `PkixPublicKey` is used in the context of a wrapper that has its own
	// notion of key ID (e.g. `AttestorPublicKey`), then this field can either
	// match that value exactly, or be left blank, in which case it behaves exactly
	// as though it is equal to that wrapper value.
	KeyId string `json:"keyId,omitempty"`
	// PublicKeyPem: A PEM-encoded public key, as described in
	// https://tools.ietf.org/html/rfc7468#section-13
	PublicKeyPem string `json:"publicKeyPem,omitempty"`
	// SignatureAlgorithm: The signature algorithm used to verify a message against
	// a signature using this key. These signature algorithm must match the
	// structure and any object identifiers encoded in `public_key_pem` (i.e. this
	// algorithm must match that of the public key).
	//
	// Possible values:
	//   "SIGNATURE_ALGORITHM_UNSPECIFIED" - Not specified.
	//   "RSA_PSS_2048_SHA256" - RSASSA-PSS 2048 bit key with a SHA256 digest.
	//   "RSA_SIGN_PSS_2048_SHA256" - RSASSA-PSS 2048 bit key with a SHA256 digest.
	//   "RSA_PSS_3072_SHA256" - RSASSA-PSS 3072 bit key with a SHA256 digest.
	//   "RSA_SIGN_PSS_3072_SHA256" - RSASSA-PSS 3072 bit key with a SHA256 digest.
	//   "RSA_PSS_4096_SHA256" - RSASSA-PSS 4096 bit key with a SHA256 digest.
	//   "RSA_SIGN_PSS_4096_SHA256" - RSASSA-PSS 4096 bit key with a SHA256 digest.
	//   "RSA_PSS_4096_SHA512" - RSASSA-PSS 4096 bit key with a SHA512 digest.
	//   "RSA_SIGN_PSS_4096_SHA512" - RSASSA-PSS 4096 bit key with a SHA512 digest.
	//   "RSA_SIGN_PKCS1_2048_SHA256" - RSASSA-PKCS1-v1_5 with a 2048 bit key and a
	// SHA256 digest.
	//   "RSA_SIGN_PKCS1_3072_SHA256" - RSASSA-PKCS1-v1_5 with a 3072 bit key and a
	// SHA256 digest.
	//   "RSA_SIGN_PKCS1_4096_SHA256" - RSASSA-PKCS1-v1_5 with a 4096 bit key and a
	// SHA256 digest.
	//   "RSA_SIGN_PKCS1_4096_SHA512" - RSASSA-PKCS1-v1_5 with a 4096 bit key and a
	// SHA512 digest.
	//   "ECDSA_P256_SHA256" - ECDSA on the NIST P-256 curve with a SHA256 digest.
	//   "EC_SIGN_P256_SHA256" - ECDSA on the NIST P-256 curve with a SHA256
	// digest.
	//   "ECDSA_P384_SHA384" - ECDSA on the NIST P-384 curve with a SHA384 digest.
	//   "EC_SIGN_P384_SHA384" - ECDSA on the NIST P-384 curve with a SHA384
	// digest.
	//   "ECDSA_P521_SHA512" - ECDSA on the NIST P-521 curve with a SHA512 digest.
	//   "EC_SIGN_P521_SHA512" - ECDSA on the NIST P-521 curve with a SHA512
	// digest.
	SignatureAlgorithm string `json:"signatureAlgorithm,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KeyId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KeyId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PkixPublicKey) MarshalJSON() ([]byte, error) {
	type NoMethod PkixPublicKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PkixPublicKeySet: A bundle of PKIX public keys, used to authenticate
// attestation signatures. Generally, a signature is considered to be
// authenticated by a `PkixPublicKeySet` if any of the public keys verify it
// (i.e. it is an "OR" of the keys).
type PkixPublicKeySet struct {
	// PkixPublicKeys: Required. `pkix_public_keys` must have at least one entry.
	PkixPublicKeys []*PkixPublicKey `json:"pkixPublicKeys,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PkixPublicKeys") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PkixPublicKeys") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PkixPublicKeySet) MarshalJSON() ([]byte, error) {
	type NoMethod PkixPublicKeySet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PlatformPolicy: A Binary Authorization platform policy for deployments on
// various platforms.
type PlatformPolicy struct {
	// Description: Optional. A description comment about the policy.
	Description string `json:"description,omitempty"`
	// Etag: Optional. Used to prevent updating the policy when another request has
	// updated it since it was retrieved.
	Etag string `json:"etag,omitempty"`
	// GkePolicy: Optional. GKE platform-specific policy.
	GkePolicy *GkePolicy `json:"gkePolicy,omitempty"`
	// Name: Output only. The relative resource name of the Binary Authorization
	// platform policy, in the form of `projects/*/platforms/*/policies/*`.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Time when the policy was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PlatformPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod PlatformPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PodResult: Result of evaluating the whole GKE policy for one Pod.
type PodResult struct {
	// ImageResults: Per-image details.
	ImageResults []*ImageResult `json:"imageResults,omitempty"`
	// KubernetesNamespace: The Kubernetes namespace of the Pod.
	KubernetesNamespace string `json:"kubernetesNamespace,omitempty"`
	// KubernetesServiceAccount: The Kubernetes service account of the Pod.
	KubernetesServiceAccount string `json:"kubernetesServiceAccount,omitempty"`
	// PodName: The name of the Pod.
	PodName string `json:"podName,omitempty"`
	// Verdict: The result of evaluating this Pod.
	//
	// Possible values:
	//   "POD_VERDICT_UNSPECIFIED" - Not specified. This should never be used.
	//   "CONFORMANT" - All images conform to the policy.
	//   "NON_CONFORMANT" - At least one image does not conform to the policy.
	//   "ERROR" - Encountered at least one error evaluating an image and all other
	// images with non-error verdicts conform to the policy. Non-conformance has
	// precedence over errors.
	Verdict string `json:"verdict,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageResults") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageResults") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PodResult) MarshalJSON() ([]byte, error) {
	type NoMethod PodResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: A policy for container image binary authorization.
type Policy struct {
	// AdmissionWhitelistPatterns: Optional. Admission policy allowlisting. A
	// matching admission request will always be permitted. This feature is
	// typically used to exclude Google or third-party infrastructure images from
	// Binary Authorization policies.
	AdmissionWhitelistPatterns []*AdmissionWhitelistPattern `json:"admissionWhitelistPatterns,omitempty"`
	// ClusterAdmissionRules: Optional. A valid policy has only one of the
	// following rule maps non-empty, i.e. only one of `cluster_admission_rules`,
	// `kubernetes_namespace_admission_rules`,
	// `kubernetes_service_account_admission_rules`, or
	// `istio_service_identity_admission_rules` can be non-empty. Per-cluster
	// admission rules. Cluster spec format: `location.clusterId`. There can be at
	// most one admission rule per cluster spec. A `location` is either a compute
	// zone (e.g. us-central1-a) or a region (e.g. us-central1). For `clusterId`
	// syntax restrictions see
	// https://cloud.google.com/container-engine/reference/rest/v1/projects.zones.clusters.
	ClusterAdmissionRules map[string]AdmissionRule `json:"clusterAdmissionRules,omitempty"`
	// DefaultAdmissionRule: Required. Default admission rule for a cluster without
	// a per-cluster, per- kubernetes-service-account, or
	// per-istio-service-identity admission rule.
	DefaultAdmissionRule *AdmissionRule `json:"defaultAdmissionRule,omitempty"`
	// Description: Optional. A descriptive comment.
	Description string `json:"description,omitempty"`
	// Etag: Optional. A checksum, returned by the server, that can be sent on
	// update requests to ensure the policy has an up-to-date value before
	// attempting to update it. See https://google.aip.dev/154.
	Etag string `json:"etag,omitempty"`
	// GlobalPolicyEvaluationMode: Optional. Controls the evaluation of a
	// Google-maintained global admission policy for common system-level images.
	// Images not covered by the global policy will be subject to the project
	// admission policy. This setting has no effect when specified inside a global
	// admission policy.
	//
	// Possible values:
	//   "GLOBAL_POLICY_EVALUATION_MODE_UNSPECIFIED" - Not specified: `DISABLE` is
	// assumed.
	//   "ENABLE" - Enables system policy evaluation.
	//   "DISABLE" - Disables system policy evaluation.
	GlobalPolicyEvaluationMode string `json:"globalPolicyEvaluationMode,omitempty"`
	// IstioServiceIdentityAdmissionRules: Optional. Per-istio-service-identity
	// admission rules. Istio service identity spec format: `spiffe:///ns//sa/` or
	// `/ns//sa/` e.g. `spiffe://example.com/ns/test-ns/sa/default`
	IstioServiceIdentityAdmissionRules map[string]AdmissionRule `json:"istioServiceIdentityAdmissionRules,omitempty"`
	// KubernetesNamespaceAdmissionRules: Optional. Per-kubernetes-namespace
	// admission rules. K8s namespace spec format: `[a-z.-]+`, e.g.
	// `some-namespace`
	KubernetesNamespaceAdmissionRules map[string]AdmissionRule `json:"kubernetesNamespaceAdmissionRules,omitempty"`
	// KubernetesServiceAccountAdmissionRules: Optional.
	// Per-kubernetes-service-account admission rules. Service account spec format:
	// `namespace:serviceaccount`. e.g. `test-ns:default`
	KubernetesServiceAccountAdmissionRules map[string]AdmissionRule `json:"kubernetesServiceAccountAdmissionRules,omitempty"`
	// Name: Output only. The resource name, in the format `projects/*/policy`.
	// There is at most one policy per project.
	Name string `json:"name,omitempty"`
	// UpdateTime: Output only. Time when the policy was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AdmissionWhitelistPatterns")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdmissionWhitelistPatterns") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Scope: A scope specifier for `CheckSet` objects.
type Scope struct {
	// KubernetesNamespace: Optional. Matches all Kubernetes service accounts in
	// the provided namespace, unless a more specific `kubernetes_service_account`
	// scope already matched.
	KubernetesNamespace string `json:"kubernetesNamespace,omitempty"`
	// KubernetesServiceAccount: Optional. Matches a single Kubernetes service
	// account, e.g. `my-namespace:my-service-account`.
	// `kubernetes_service_account` scope is always more specific than
	// `kubernetes_namespace` scope for the same namespace.
	KubernetesServiceAccount string `json:"kubernetesServiceAccount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KubernetesNamespace") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KubernetesNamespace") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Scope) MarshalJSON() ([]byte, error) {
	type NoMethod Scope
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *IamPolicy `json:"policy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Signature: Verifiers (e.g. Kritis implementations) MUST verify signatures
// with respect to the trust anchors defined in policy (e.g. a Kritis policy).
// Typically this means that the verifier has been configured with a map from
// `public_key_id` to public key material (and any required parameters, e.g.
// signing algorithm). In particular, verification implementations MUST NOT
// treat the signature `public_key_id` as anything more than a key lookup hint.
// The `public_key_id` DOES NOT validate or authenticate a public key; it only
// provides a mechanism for quickly selecting a public key ALREADY CONFIGURED
// on the verifier through a trusted channel. Verification implementations MUST
// reject signatures in any of the following circumstances: * The
// `public_key_id` is not recognized by the verifier. * The public key that
// `public_key_id` refers to does not verify the signature with respect to the
// payload. The `signature` contents SHOULD NOT be "attached" (where the
// payload is included with the serialized `signature` bytes). Verifiers MUST
// ignore any "attached" payload and only verify signatures with respect to
// explicitly provided payload (e.g. a `payload` field on the proto message
// that holds this Signature, or the canonical serialization of the proto
// message that holds this signature).
type Signature struct {
	// PublicKeyId: The identifier for the public key that verifies this signature.
	// * The `public_key_id` is required. * The `public_key_id` SHOULD be an
	// RFC3986 conformant URI. * When possible, the `public_key_id` SHOULD be an
	// immutable reference, such as a cryptographic digest. Examples of valid
	// `public_key_id`s: OpenPGP V4 public key fingerprint: *
	// "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA" See
	// https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more
	// details on this scheme. RFC6920 digest-named SubjectPublicKeyInfo (digest of
	// the DER serialization): *
	// "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU" *
	// "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a127158
	// 9a5"
	PublicKeyId string `json:"publicKeyId,omitempty"`
	// Signature: The content of the signature, an opaque bytestring. The payload
	// that this signature verifies MUST be unambiguously provided with the
	// Signature during verification. A wrapper message might provide the payload
	// explicitly. Alternatively, a message might have a canonical serialization
	// that can always be unambiguously computed to derive the payload.
	Signature string `json:"signature,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PublicKeyId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PublicKeyId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Signature) MarshalJSON() ([]byte, error) {
	type NoMethod Signature
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SigstoreAuthority: A Sigstore authority, used to verify signatures that are
// created by Sigstore. An authority is analogous to an attestation
// authenticator, verifying that a signature is valid or invalid.
type SigstoreAuthority struct {
	// DisplayName: Optional. A user-provided name for this `SigstoreAuthority`.
	// This field has no effect on the policy evaluation behavior except to improve
	// readability of messages in evaluation results.
	DisplayName string `json:"displayName,omitempty"`
	// PublicKeySet: Required. A simple set of public keys. A signature is
	// considered valid if any keys in the set validate the signature.
	PublicKeySet *SigstorePublicKeySet `json:"publicKeySet,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SigstoreAuthority) MarshalJSON() ([]byte, error) {
	type NoMethod SigstoreAuthority
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SigstorePublicKey: A Sigstore public key. `SigstorePublicKey` is the public
// key material used to authenticate Sigstore signatures.
type SigstorePublicKey struct {
	// PublicKeyPem: The public key material in PEM format.
	PublicKeyPem string `json:"publicKeyPem,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PublicKeyPem") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PublicKeyPem") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SigstorePublicKey) MarshalJSON() ([]byte, error) {
	type NoMethod SigstorePublicKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SigstorePublicKeySet: A bundle of Sigstore public keys, used to verify
// Sigstore signatures. A signature is authenticated by a
// `SigstorePublicKeySet` if any of the keys verify it.
type SigstorePublicKeySet struct {
	// PublicKeys: Required. `public_keys` must have at least one entry.
	PublicKeys []*SigstorePublicKey `json:"publicKeys,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PublicKeys") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PublicKeys") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SigstorePublicKeySet) MarshalJSON() ([]byte, error) {
	type NoMethod SigstorePublicKeySet
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SigstoreSignatureCheck: A Sigstore signature check, which verifies the
// Sigstore signature associated with an image.
type SigstoreSignatureCheck struct {
	// SigstoreAuthorities: Required. The authorities required by this check to
	// verify the signature. A signature only needs to be verified by one authority
	// to pass the check.
	SigstoreAuthorities []*SigstoreAuthority `json:"sigstoreAuthorities,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SigstoreAuthorities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SigstoreAuthorities") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SigstoreSignatureCheck) MarshalJSON() ([]byte, error) {
	type NoMethod SigstoreSignatureCheck
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SimpleSigningAttestationCheck: Require a signed DSSE
// (https://github.com/secure-systems-lab/dsse) attestation with type
// SimpleSigning.
type SimpleSigningAttestationCheck struct {
	// AttestationAuthenticators: Required. The authenticators required by this
	// check to verify an attestation. Typically this is one or more PKIX public
	// keys for signature verification. Only one authenticator needs to consider an
	// attestation verified in order for an attestation to be considered fully
	// authenticated. In otherwords, this list of authenticators is an "OR" of the
	// authenticator results. At least one authenticator is required.
	AttestationAuthenticators []*AttestationAuthenticator `json:"attestationAuthenticators,omitempty"`
	// ContainerAnalysisAttestationProjects: Optional. The projects where
	// attestations are stored as Container Analysis Occurrences, in the format
	// `projects/[PROJECT_ID]`. Only one attestation needs to successfully verify
	// an image for this check to pass, so a single verified attestation found in
	// any of `container_analysis_attestation_projects` is sufficient for the check
	// to pass. A project ID must be used, not a project number. When fetching
	// Occurrences from Container Analysis, only `AttestationOccurrence` kinds are
	// considered. In the future, additional Occurrence kinds may be added to the
	// query. Maximum number of `container_analysis_attestation_projects` allowed
	// in each `SimpleSigningAttestationCheck` is 10.
	ContainerAnalysisAttestationProjects []string `json:"containerAnalysisAttestationProjects,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttestationAuthenticators")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttestationAuthenticators") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SimpleSigningAttestationCheck) MarshalJSON() ([]byte, error) {
	type NoMethod SimpleSigningAttestationCheck
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SlsaCheck: A SLSA provenance attestation check, which ensures that images
// are built by a trusted builder using source code from its trusted
// repositories only.
type SlsaCheck struct {
	// Rules: Specifies a list of verification rules for the SLSA attestations. An
	// image is considered compliant with the SlsaCheck if any of the rules are
	// satisfied.
	Rules []*VerificationRule `json:"rules,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Rules") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Rules") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SlsaCheck) MarshalJSON() ([]byte, error) {
	type NoMethod SlsaCheck
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions` method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TrustedDirectoryCheck: A trusted directory check, which rejects images that
// do not come from the set of user-configured trusted directories.
type TrustedDirectoryCheck struct {
	// TrustedDirPatterns: Required. List of trusted directory patterns. A pattern
	// is in the form "registry/path/to/directory". The registry domain part is
	// defined as two or more dot-separated words, e.g., `us.pkg.dev`, or `gcr.io`.
	// Additionally, `*` can be used in three ways as wildcards: 1. leading `*` to
	// match varying prefixes in registry subdomain (useful for location prefixes);
	// 2. trailing `*` after registry/ to match varying endings; 3. trailing `**`
	// after registry/ to match "/" as well. For example: --
	// `gcr.io/my-project/my-repo` is valid to match a single directory --
	// `*-docker.pkg.dev/my-project/my-repo` or `*.gcr.io/my-project` are valid to
	// match varying prefixes -- `gcr.io/my-project/*` will match all direct
	// directories in `my-project` -- `gcr.io/my-project/**` would match all
	// directories in `my-project` -- `gcr.i*` is not allowed since the registry is
	// not completely specified -- `sub*domain.gcr.io/nginx` is not valid because
	// only leading `*` or trailing `*` are allowed. --
	// `*pkg.dev/my-project/my-repo` is not valid because leading `*` can only
	// match subdomain -- `**-docker.pkg.dev` is not valid because one leading `*`
	// is allowed, and that it cannot match `/`
	TrustedDirPatterns []string `json:"trustedDirPatterns,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TrustedDirPatterns") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TrustedDirPatterns") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TrustedDirectoryCheck) MarshalJSON() ([]byte, error) {
	type NoMethod TrustedDirectoryCheck
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserOwnedGrafeasNote: An user owned Grafeas note references a Grafeas
// Attestation.Authority Note created by the user.
type UserOwnedGrafeasNote struct {
	// DelegationServiceAccountEmail: Output only. This field will contain the
	// service account email address that this attestor will use as the principal
	// when querying Container Analysis. Attestor administrators must grant this
	// service account the IAM role needed to read attestations from the
	// note_reference in Container Analysis
	// (`containeranalysis.notes.occurrences.viewer`). This email address is fixed
	// for the lifetime of the attestor, but callers should not make any other
	// assumptions about the service account email; future versions may use an
	// email based on a different naming pattern.
	DelegationServiceAccountEmail string `json:"delegationServiceAccountEmail,omitempty"`
	// NoteReference: Required. The Grafeas resource name of a
	// Attestation.Authority Note, created by the user, in the format:
	// `projects/[PROJECT_ID]/notes/*`. This field may not be updated. A project ID
	// must be used, not a project number. An attestation by this attestor is
	// stored as a Grafeas Attestation.Authority Occurrence that names a container
	// image and that links to this Note. Grafeas is an external dependency.
	NoteReference string `json:"noteReference,omitempty"`
	// PublicKeys: Optional. Public keys that verify attestations signed by this
	// attestor. This field may be updated. If this field is non-empty, one of the
	// specified public keys must verify that an attestation was signed by this
	// attestor for the image specified in the admission request. If this field is
	// empty, this attestor always returns that no valid attestations exist.
	PublicKeys []*AttestorPublicKey `json:"publicKeys,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "DelegationServiceAccountEmail") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DelegationServiceAccountEmail")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserOwnedGrafeasNote) MarshalJSON() ([]byte, error) {
	type NoMethod UserOwnedGrafeasNote
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValidateAttestationOccurrenceRequest: Request message for
// ValidationHelperV1.ValidateAttestationOccurrence.
type ValidateAttestationOccurrenceRequest struct {
	// Attestation: Required. An AttestationOccurrence to be checked that it can be
	// verified by the `Attestor`. It does not have to be an existing entity in
	// Container Analysis. It must otherwise be a valid `AttestationOccurrence`.
	Attestation *AttestationOccurrence `json:"attestation,omitempty"`
	// OccurrenceNote: Required. The resource name of the Note to which the
	// containing Occurrence is associated.
	OccurrenceNote string `json:"occurrenceNote,omitempty"`
	// OccurrenceResourceUri: Required. The URI of the artifact (e.g. container
	// image) that is the subject of the containing Occurrence.
	OccurrenceResourceUri string `json:"occurrenceResourceUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Attestation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Attestation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValidateAttestationOccurrenceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ValidateAttestationOccurrenceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValidateAttestationOccurrenceResponse: Response message for
// ValidationHelperV1.ValidateAttestationOccurrence.
type ValidateAttestationOccurrenceResponse struct {
	// DenialReason: The reason for denial if the Attestation couldn't be
	// validated.
	DenialReason string `json:"denialReason,omitempty"`
	// Result: The result of the Attestation validation.
	//
	// Possible values:
	//   "RESULT_UNSPECIFIED" - Unspecified.
	//   "VERIFIED" - The Attestation was able to verified by the Attestor.
	//   "ATTESTATION_NOT_VERIFIABLE" - The Attestation was not able to verified by
	// the Attestor.
	Result string `json:"result,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DenialReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DenialReason") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValidateAttestationOccurrenceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ValidateAttestationOccurrenceResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VerificationRule: Specifies verification rules for evaluating the SLSA
// attestations including: which builders to trust, where to fetch the SLSA
// attestations generated by those builders, and other builder-specific
// evaluation rules such as which source repositories are trusted. An image is
// considered verified by the rule if any of the fetched SLSA attestations is
// verified.
type VerificationRule struct {
	// AttestationSource: Specifies where to fetch the provenances attestations
	// generated by the builder (group).
	AttestationSource *AttestationSource `json:"attestationSource,omitempty"`
	// ConfigBasedBuildRequired: If true, require the image to be built from a
	// top-level configuration. `trusted_source_repo_patterns` specifies the
	// repositories containing this configuration.
	ConfigBasedBuildRequired bool `json:"configBasedBuildRequired,omitempty"`
	// CustomConstraints: Optional. A CEL expression for specifying custom
	// constraints on the provenance payload. This can be used when users want to
	// specify expectations on provenance fields that are not covered by the
	// general check. For example, users can use this field to require that certain
	// parameters should never be used during the build process.
	CustomConstraints string `json:"customConstraints,omitempty"`
	// TrustedBuilder: Each verification rule is used for evaluation against
	// provenances generated by a specific builder (group). For some of the
	// builders, such as the Google Cloud Build, users don't need to explicitly
	// specify their roots of trust in the policy since the evaluation service can
	// automatically fetch them based on the builder (group).
	//
	// Possible values:
	//   "BUILDER_UNSPECIFIED" - Should never happen.
	//   "GOOGLE_CLOUD_BUILD" - The whole Google Cloud Build (GCB) builder group,
	// including all GCB builder types.
	TrustedBuilder string `json:"trustedBuilder,omitempty"`
	// TrustedSourceRepoPatterns: List of trusted source code repository URL
	// patterns. These patterns match the full repository URL without its scheme
	// (e.g. `https://`). The patterns must not include schemes. For example, the
	// pattern `source.cloud.google.com/my-project/my-repo-name` matches the
	// following URLs: - `source.cloud.google.com/my-project/my-repo-name` -
	// `git+ssh://source.cloud.google.com/my-project/my-repo-name` -
	// `https://source.cloud.google.com/my-project/my-repo-name` A pattern matches
	// a URL either exactly or with `*` wildcards. `*` can be used in only two
	// ways: 1. trailing `*` after hosturi/ to match varying endings; 2. trailing
	// `**` after hosturi/ to match `/` as well. `*` and `**` can only be used as
	// wildcards and can only occur at the end of the pattern after a `/`. (So it's
	// not possible to match a URL that contains literal `*`.) For example: -
	// `github.com/my-project/my-repo` is valid to match a single repo -
	// `github.com/my-project/*` will match all direct repos in `my-project` -
	// `github.com/**` matches all repos in GitHub
	TrustedSourceRepoPatterns []string `json:"trustedSourceRepoPatterns,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AttestationSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AttestationSource") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VerificationRule) MarshalJSON() ([]byte, error) {
	type NoMethod VerificationRule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VulnerabilityCheck: An image vulnerability check, which rejects images that
// violate the configured vulnerability rules.
type VulnerabilityCheck struct {
	// AllowedCves: Optional. A list of specific CVEs to ignore even if the
	// vulnerability level violates `maximumUnfixableSeverity` or
	// `maximumFixableSeverity`. CVEs are listed in the format of Container
	// Analysis note id. For example: - CVE-2021-20305 - CVE-2020-10543 The CVEs
	// are applicable regardless of note provider project, e.g., an entry of
	// `CVE-2021-20305` will allow vulnerabilities with a note name of either
	// `projects/goog-vulnz/notes/CVE-2021-20305` or
	// `projects/CUSTOM-PROJECT/notes/CVE-2021-20305`.
	AllowedCves []string `json:"allowedCves,omitempty"`
	// BlockedCves: Optional. A list of specific CVEs to always raise warnings
	// about even if the vulnerability level meets `maximumUnfixableSeverity` or
	// `maximumFixableSeverity`. CVEs are listed in the format of Container
	// Analysis note id. For example: - CVE-2021-20305 - CVE-2020-10543 The CVEs
	// are applicable regardless of note provider project, e.g., an entry of
	// `CVE-2021-20305` will block vulnerabilities with a note name of either
	// `projects/goog-vulnz/notes/CVE-2021-20305` or
	// `projects/CUSTOM-PROJECT/notes/CVE-2021-20305`.
	BlockedCves []string `json:"blockedCves,omitempty"`
	// ContainerAnalysisVulnerabilityProjects: Optional. The projects where
	// vulnerabilities are stored as Container Analysis Occurrences. Each project
	// is expressed in the resource format of `projects/[PROJECT_ID]`, e.g.,
	// `projects/my-gcp-project`. An attempt will be made for each project to fetch
	// vulnerabilities, and all valid vulnerabilities will be used to check against
	// the vulnerability policy. If no valid scan is found in all projects
	// configured here, an error will be returned for the check. Maximum number of
	// `container_analysis_vulnerability_projects` allowed in each
	// `VulnerabilityCheck` is 10.
	ContainerAnalysisVulnerabilityProjects []string `json:"containerAnalysisVulnerabilityProjects,omitempty"`
	// MaximumFixableSeverity: Required. The threshold for severity for which a fix
	// is currently available. This field is required and must be set.
	//
	// Possible values:
	//   "MAXIMUM_ALLOWED_SEVERITY_UNSPECIFIED" - Not specified.
	//   "BLOCK_ALL" - Block any vulnerability.
	//   "MINIMAL" - Allow only minimal severity.
	//   "LOW" - Allow only low severity and lower.
	//   "MEDIUM" - Allow medium severity and lower.
	//   "HIGH" - Allow high severity and lower.
	//   "CRITICAL" - Allow critical severity and lower.
	//   "ALLOW_ALL" - Allow all severity, even vulnerability with unspecified
	// severity.
	MaximumFixableSeverity string `json:"maximumFixableSeverity,omitempty"`
	// MaximumUnfixableSeverity: Required. The threshold for severity for which a
	// fix isn't currently available. This field is required and must be set.
	//
	// Possible values:
	//   "MAXIMUM_ALLOWED_SEVERITY_UNSPECIFIED" - Not specified.
	//   "BLOCK_ALL" - Block any vulnerability.
	//   "MINIMAL" - Allow only minimal severity.
	//   "LOW" - Allow only low severity and lower.
	//   "MEDIUM" - Allow medium severity and lower.
	//   "HIGH" - Allow high severity and lower.
	//   "CRITICAL" - Allow critical severity and lower.
	//   "ALLOW_ALL" - Allow all severity, even vulnerability with unspecified
	// severity.
	MaximumUnfixableSeverity string `json:"maximumUnfixableSeverity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedCves") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedCves") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VulnerabilityCheck) MarshalJSON() ([]byte, error) {
	type NoMethod VulnerabilityCheck
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsGetPolicyCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetPolicy: A policy specifies the attestors that must attest to a container
// image, before the project is allowed to deploy that image. There is at most
// one policy per project. All image admission requests are permitted if a
// project has no policy. Gets the policy for this project. Returns a default
// policy if the project does not have one.
//
//   - name: The resource name of the policy to retrieve, in the format
//     `projects/*/policy`.
func (r *ProjectsService) GetPolicy(name string) *ProjectsGetPolicyCall {
	c := &ProjectsGetPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsGetPolicyCall) Fields(s ...googleapi.Field) *ProjectsGetPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsGetPolicyCall) IfNoneMatch(entityTag string) *ProjectsGetPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsGetPolicyCall) Context(ctx context.Context) *ProjectsGetPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsGetPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsGetPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.getPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.getPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsGetPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.getPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsUpdatePolicyCall struct {
	s          *Service
	name       string
	policy     *Policy
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdatePolicy: Creates or updates a project's policy, and returns a copy of
// the new policy. A policy is always updated as a whole, to avoid race
// conditions with concurrent policy enforcement (or management!) requests.
// Returns `NOT_FOUND` if the project does not exist, `INVALID_ARGUMENT` if the
// request is malformed.
//
//   - name: Output only. The resource name, in the format `projects/*/policy`.
//     There is at most one policy per project.
func (r *ProjectsService) UpdatePolicy(name string, policy *Policy) *ProjectsUpdatePolicyCall {
	c := &ProjectsUpdatePolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.policy = policy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsUpdatePolicyCall) Fields(s ...googleapi.Field) *ProjectsUpdatePolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsUpdatePolicyCall) Context(ctx context.Context) *ProjectsUpdatePolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsUpdatePolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsUpdatePolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.policy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.updatePolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.updatePolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsUpdatePolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.updatePolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAttestorsCreateCall struct {
	s          *Service
	parent     string
	attestor   *Attestor
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates an attestor, and returns a copy of the new attestor. Returns
// `NOT_FOUND` if the project does not exist, `INVALID_ARGUMENT` if the request
// is malformed, `ALREADY_EXISTS` if the attestor already exists.
//
// - parent: The parent of this attestor.
func (r *ProjectsAttestorsService) Create(parent string, attestor *Attestor) *ProjectsAttestorsCreateCall {
	c := &ProjectsAttestorsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.attestor = attestor
	return c
}

// AttestorId sets the optional parameter "attestorId": Required. The attestors
// ID.
func (c *ProjectsAttestorsCreateCall) AttestorId(attestorId string) *ProjectsAttestorsCreateCall {
	c.urlParams_.Set("attestorId", attestorId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAttestorsCreateCall) Fields(s ...googleapi.Field) *ProjectsAttestorsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAttestorsCreateCall) Context(ctx context.Context) *ProjectsAttestorsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAttestorsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAttestorsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.attestor)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/attestors")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.attestors.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Attestor.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAttestorsCreateCall) Do(opts ...googleapi.CallOption) (*Attestor, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Attestor{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAttestorsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an attestor. Returns `NOT_FOUND` if the attestor does not
// exist.
//
//   - name: The name of the attestors to delete, in the format
//     `projects/*/attestors/*`.
func (r *ProjectsAttestorsService) Delete(name string) *ProjectsAttestorsDeleteCall {
	c := &ProjectsAttestorsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAttestorsDeleteCall) Fields(s ...googleapi.Field) *ProjectsAttestorsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAttestorsDeleteCall) Context(ctx context.Context) *ProjectsAttestorsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAttestorsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAttestorsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.attestors.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAttestorsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAttestorsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an attestor. Returns `NOT_FOUND` if the attestor does not exist.
//
//   - name: The name of the attestor to retrieve, in the format
//     `projects/*/attestors/*`.
func (r *ProjectsAttestorsService) Get(name string) *ProjectsAttestorsGetCall {
	c := &ProjectsAttestorsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAttestorsGetCall) Fields(s ...googleapi.Field) *ProjectsAttestorsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAttestorsGetCall) IfNoneMatch(entityTag string) *ProjectsAttestorsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAttestorsGetCall) Context(ctx context.Context) *ProjectsAttestorsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAttestorsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAttestorsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.attestors.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Attestor.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAttestorsGetCall) Do(opts ...googleapi.CallOption) (*Attestor, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Attestor{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAttestorsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsAttestorsService) GetIamPolicy(resource string) *ProjectsAttestorsGetIamPolicyCall {
	c := &ProjectsAttestorsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsAttestorsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsAttestorsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAttestorsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsAttestorsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAttestorsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsAttestorsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAttestorsGetIamPolicyCall) Context(ctx context.Context) *ProjectsAttestorsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAttestorsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAttestorsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.attestors.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *IamPolicy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAttestorsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*IamPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &IamPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAttestorsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists attestors. Returns `INVALID_ARGUMENT` if the project does not
// exist.
//
//   - parent: The resource name of the project associated with the attestors, in
//     the format `projects/*`.
func (r *ProjectsAttestorsService) List(parent string) *ProjectsAttestorsListCall {
	c := &ProjectsAttestorsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer results than requested. If unspecified, the server
// will pick an appropriate default.
func (c *ProjectsAttestorsListCall) PageSize(pageSize int64) *ProjectsAttestorsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. Typically, this is the value of
// ListAttestorsResponse.next_page_token returned from the previous call to the
// `ListAttestors` method.
func (c *ProjectsAttestorsListCall) PageToken(pageToken string) *ProjectsAttestorsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAttestorsListCall) Fields(s ...googleapi.Field) *ProjectsAttestorsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAttestorsListCall) IfNoneMatch(entityTag string) *ProjectsAttestorsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAttestorsListCall) Context(ctx context.Context) *ProjectsAttestorsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAttestorsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAttestorsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/attestors")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.attestors.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAttestorsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsAttestorsListCall) Do(opts ...googleapi.CallOption) (*ListAttestorsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAttestorsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAttestorsListCall) Pages(ctx context.Context, f func(*ListAttestorsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsAttestorsSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsAttestorsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsAttestorsSetIamPolicyCall {
	c := &ProjectsAttestorsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAttestorsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsAttestorsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAttestorsSetIamPolicyCall) Context(ctx context.Context) *ProjectsAttestorsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAttestorsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAttestorsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.attestors.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *IamPolicy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAttestorsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*IamPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &IamPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAttestorsTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsAttestorsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsAttestorsTestIamPermissionsCall {
	c := &ProjectsAttestorsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAttestorsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsAttestorsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAttestorsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsAttestorsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAttestorsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAttestorsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.attestors.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAttestorsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAttestorsUpdateCall struct {
	s          *Service
	name       string
	attestor   *Attestor
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates an attestor. Returns `NOT_FOUND` if the attestor does not
// exist.
//
//   - name: The resource name, in the format: `projects/*/attestors/*`. This
//     field may not be updated.
func (r *ProjectsAttestorsService) Update(name string, attestor *Attestor) *ProjectsAttestorsUpdateCall {
	c := &ProjectsAttestorsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.attestor = attestor
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAttestorsUpdateCall) Fields(s ...googleapi.Field) *ProjectsAttestorsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAttestorsUpdateCall) Context(ctx context.Context) *ProjectsAttestorsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAttestorsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAttestorsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.attestor)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.attestors.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Attestor.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsAttestorsUpdateCall) Do(opts ...googleapi.CallOption) (*Attestor, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Attestor{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAttestorsValidateAttestationOccurrenceCall struct {
	s                                    *Service
	attestor                             string
	validateattestationoccurrencerequest *ValidateAttestationOccurrenceRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// ValidateAttestationOccurrence: Returns whether the given `Attestation` for
// the given image URI was signed by the given `Attestor`
//
//   - attestor: The resource name of the Attestor of the occurrence, in the
//     format `projects/*/attestors/*`.
func (r *ProjectsAttestorsService) ValidateAttestationOccurrence(attestor string, validateattestationoccurrencerequest *ValidateAttestationOccurrenceRequest) *ProjectsAttestorsValidateAttestationOccurrenceCall {
	c := &ProjectsAttestorsValidateAttestationOccurrenceCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.attestor = attestor
	c.validateattestationoccurrencerequest = validateattestationoccurrencerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAttestorsValidateAttestationOccurrenceCall) Fields(s ...googleapi.Field) *ProjectsAttestorsValidateAttestationOccurrenceCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAttestorsValidateAttestationOccurrenceCall) Context(ctx context.Context) *ProjectsAttestorsValidateAttestationOccurrenceCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAttestorsValidateAttestationOccurrenceCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAttestorsValidateAttestationOccurrenceCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.validateattestationoccurrencerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+attestor}:validateAttestationOccurrence")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"attestor": c.attestor,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.validateAttestationOccurrence", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.attestors.validateAttestationOccurrence" call.
// Any non-2xx status code is an error. Response headers are in either
// *ValidateAttestationOccurrenceResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAttestorsValidateAttestationOccurrenceCall) Do(opts ...googleapi.CallOption) (*ValidateAttestationOccurrenceResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ValidateAttestationOccurrenceResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.attestors.validateAttestationOccurrence", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPlatformsGkePoliciesEvaluateCall struct {
	s                        *Service
	name                     string
	evaluategkepolicyrequest *EvaluateGkePolicyRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Evaluate: Evaluates a Kubernetes object versus a GKE platform policy.
// Returns `NOT_FOUND` if the policy doesn't exist, `INVALID_ARGUMENT` if the
// policy or request is malformed and `PERMISSION_DENIED` if the client does
// not have sufficient permissions.
//
//   - name: The name of the platform policy to evaluate in the format
//     `projects/*/platforms/*/policies/*`.
func (r *ProjectsPlatformsGkePoliciesService) Evaluate(name string, evaluategkepolicyrequest *EvaluateGkePolicyRequest) *ProjectsPlatformsGkePoliciesEvaluateCall {
	c := &ProjectsPlatformsGkePoliciesEvaluateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.evaluategkepolicyrequest = evaluategkepolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPlatformsGkePoliciesEvaluateCall) Fields(s ...googleapi.Field) *ProjectsPlatformsGkePoliciesEvaluateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPlatformsGkePoliciesEvaluateCall) Context(ctx context.Context) *ProjectsPlatformsGkePoliciesEvaluateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPlatformsGkePoliciesEvaluateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPlatformsGkePoliciesEvaluateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.evaluategkepolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:evaluate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.platforms.gke.policies.evaluate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.platforms.gke.policies.evaluate" call.
// Any non-2xx status code is an error. Response headers are in either
// *EvaluateGkePolicyResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsPlatformsGkePoliciesEvaluateCall) Do(opts ...googleapi.CallOption) (*EvaluateGkePolicyResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EvaluateGkePolicyResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.platforms.gke.policies.evaluate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPlatformsPoliciesCreateCall struct {
	s              *Service
	parent         string
	platformpolicy *PlatformPolicy
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// Create: Creates a platform policy, and returns a copy of it. Returns
// `NOT_FOUND` if the project or platform doesn't exist, `INVALID_ARGUMENT` if
// the request is malformed, `ALREADY_EXISTS` if the policy already exists, and
// `INVALID_ARGUMENT` if the policy contains a platform-specific policy that
// does not match the platform value specified in the URL.
//
// - parent: The parent of this platform policy.
func (r *ProjectsPlatformsPoliciesService) Create(parent string, platformpolicy *PlatformPolicy) *ProjectsPlatformsPoliciesCreateCall {
	c := &ProjectsPlatformsPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.platformpolicy = platformpolicy
	return c
}

// PolicyId sets the optional parameter "policyId": Required. The platform
// policy ID.
func (c *ProjectsPlatformsPoliciesCreateCall) PolicyId(policyId string) *ProjectsPlatformsPoliciesCreateCall {
	c.urlParams_.Set("policyId", policyId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPlatformsPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsPlatformsPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPlatformsPoliciesCreateCall) Context(ctx context.Context) *ProjectsPlatformsPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPlatformsPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPlatformsPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.platformpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/policies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.platforms.policies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.platforms.policies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *PlatformPolicy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsPlatformsPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*PlatformPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PlatformPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.platforms.policies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPlatformsPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a platform policy. Returns `NOT_FOUND` if the policy doesn't
// exist.
//
//   - name: The name of the platform policy to delete, in the format
//     `projects/*/platforms/*/policies/*`.
func (r *ProjectsPlatformsPoliciesService) Delete(name string) *ProjectsPlatformsPoliciesDeleteCall {
	c := &ProjectsPlatformsPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": Used to prevent deleting the policy
// when another request has updated it since it was retrieved.
func (c *ProjectsPlatformsPoliciesDeleteCall) Etag(etag string) *ProjectsPlatformsPoliciesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPlatformsPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsPlatformsPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPlatformsPoliciesDeleteCall) Context(ctx context.Context) *ProjectsPlatformsPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPlatformsPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPlatformsPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.platforms.policies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.platforms.policies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsPlatformsPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.platforms.policies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPlatformsPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a platform policy. Returns `NOT_FOUND` if the policy doesn't
// exist.
//
//   - name: The name of the platform policy to retrieve in the format
//     `projects/*/platforms/*/policies/*`.
func (r *ProjectsPlatformsPoliciesService) Get(name string) *ProjectsPlatformsPoliciesGetCall {
	c := &ProjectsPlatformsPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPlatformsPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsPlatformsPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsPlatformsPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsPlatformsPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPlatformsPoliciesGetCall) Context(ctx context.Context) *ProjectsPlatformsPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPlatformsPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPlatformsPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.platforms.policies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.platforms.policies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *PlatformPolicy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsPlatformsPoliciesGetCall) Do(opts ...googleapi.CallOption) (*PlatformPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PlatformPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.platforms.policies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPlatformsPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists platform policies owned by a project in the specified platform.
// Returns `INVALID_ARGUMENT` if the project or the platform doesn't exist.
//
//   - parent: The resource name of the platform associated with the platform
//     policies using the format `projects/*/platforms/*`.
func (r *ProjectsPlatformsPoliciesService) List(parent string) *ProjectsPlatformsPoliciesListCall {
	c := &ProjectsPlatformsPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Requested page size. The
// server may return fewer results than requested. If unspecified, the server
// picks an appropriate default.
func (c *ProjectsPlatformsPoliciesListCall) PageSize(pageSize int64) *ProjectsPlatformsPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token identifying a
// page of results the server should return. Typically, this is the value of
// ListPlatformPoliciesResponse.next_page_token returned from the previous call
// to the `ListPlatformPolicies` method.
func (c *ProjectsPlatformsPoliciesListCall) PageToken(pageToken string) *ProjectsPlatformsPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPlatformsPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsPlatformsPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsPlatformsPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsPlatformsPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPlatformsPoliciesListCall) Context(ctx context.Context) *ProjectsPlatformsPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPlatformsPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPlatformsPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/policies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.platforms.policies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.platforms.policies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListPlatformPoliciesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsPlatformsPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListPlatformPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListPlatformPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.platforms.policies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsPlatformsPoliciesListCall) Pages(ctx context.Context, f func(*ListPlatformPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsPlatformsPoliciesReplacePlatformPolicyCall struct {
	s              *Service
	name           string
	platformpolicy *PlatformPolicy
	urlParams_     gensupport.URLParams
	ctx_           context.Context
	header_        http.Header
}

// ReplacePlatformPolicy: Replaces a platform policy. Returns `NOT_FOUND` if
// the policy doesn't exist.
//
//   - name: Output only. The relative resource name of the Binary Authorization
//     platform policy, in the form of `projects/*/platforms/*/policies/*`.
func (r *ProjectsPlatformsPoliciesService) ReplacePlatformPolicy(name string, platformpolicy *PlatformPolicy) *ProjectsPlatformsPoliciesReplacePlatformPolicyCall {
	c := &ProjectsPlatformsPoliciesReplacePlatformPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.platformpolicy = platformpolicy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPlatformsPoliciesReplacePlatformPolicyCall) Fields(s ...googleapi.Field) *ProjectsPlatformsPoliciesReplacePlatformPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPlatformsPoliciesReplacePlatformPolicyCall) Context(ctx context.Context) *ProjectsPlatformsPoliciesReplacePlatformPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPlatformsPoliciesReplacePlatformPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPlatformsPoliciesReplacePlatformPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.platformpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.platforms.policies.replacePlatformPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.platforms.policies.replacePlatformPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *PlatformPolicy.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsPlatformsPoliciesReplacePlatformPolicyCall) Do(opts ...googleapi.CallOption) (*PlatformPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &PlatformPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.platforms.policies.replacePlatformPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPolicyGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsPolicyService) GetIamPolicy(resource string) *ProjectsPolicyGetIamPolicyCall {
	c := &ProjectsPolicyGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsPolicyGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsPolicyGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPolicyGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsPolicyGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsPolicyGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsPolicyGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPolicyGetIamPolicyCall) Context(ctx context.Context) *ProjectsPolicyGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPolicyGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPolicyGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.policy.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.policy.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *IamPolicy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsPolicyGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*IamPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &IamPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.policy.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPolicySetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`,
// and `PERMISSION_DENIED` errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsPolicyService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsPolicySetIamPolicyCall {
	c := &ProjectsPolicySetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPolicySetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsPolicySetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPolicySetIamPolicyCall) Context(ctx context.Context) *ProjectsPolicySetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPolicySetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPolicySetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.policy.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.policy.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *IamPolicy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsPolicySetIamPolicyCall) Do(opts ...googleapi.CallOption) (*IamPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &IamPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.policy.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsPolicyTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a `NOT_FOUND` error. Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsPolicyService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsPolicyTestIamPermissionsCall {
	c := &ProjectsPolicyTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsPolicyTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsPolicyTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsPolicyTestIamPermissionsCall) Context(ctx context.Context) *ProjectsPolicyTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsPolicyTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsPolicyTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.projects.policy.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.projects.policy.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsPolicyTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.projects.policy.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type SystempolicyGetPolicyCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetPolicy: Gets the current system policy in the specified location.
//
//   - name: The resource name, in the format `locations/*/policy`. Note that the
//     system policy is not associated with a project.
func (r *SystempolicyService) GetPolicy(name string) *SystempolicyGetPolicyCall {
	c := &SystempolicyGetPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SystempolicyGetPolicyCall) Fields(s ...googleapi.Field) *SystempolicyGetPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *SystempolicyGetPolicyCall) IfNoneMatch(entityTag string) *SystempolicyGetPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SystempolicyGetPolicyCall) Context(ctx context.Context) *SystempolicyGetPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SystempolicyGetPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SystempolicyGetPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "binaryauthorization.systempolicy.getPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "binaryauthorization.systempolicy.getPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *SystempolicyGetPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "binaryauthorization.systempolicy.getPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
