// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.3
// source: google/cloud/dataqna/v1alpha/auto_suggestion_service.proto

package dataqnapb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AutoSuggestionService_SuggestQueries_FullMethodName = "/google.cloud.dataqna.v1alpha.AutoSuggestionService/SuggestQueries"
)

// AutoSuggestionServiceClient is the client API for AutoSuggestionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AutoSuggestionServiceClient interface {
	// Gets a list of suggestions based on a prefix string.
	// AutoSuggestion tolerance should be less than 1 second.
	SuggestQueries(ctx context.Context, in *SuggestQueriesRequest, opts ...grpc.CallOption) (*SuggestQueriesResponse, error)
}

type autoSuggestionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAutoSuggestionServiceClient(cc grpc.ClientConnInterface) AutoSuggestionServiceClient {
	return &autoSuggestionServiceClient{cc}
}

func (c *autoSuggestionServiceClient) SuggestQueries(ctx context.Context, in *SuggestQueriesRequest, opts ...grpc.CallOption) (*SuggestQueriesResponse, error) {
	out := new(SuggestQueriesResponse)
	err := c.cc.Invoke(ctx, AutoSuggestionService_SuggestQueries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutoSuggestionServiceServer is the server API for AutoSuggestionService service.
// All implementations should embed UnimplementedAutoSuggestionServiceServer
// for forward compatibility
type AutoSuggestionServiceServer interface {
	// Gets a list of suggestions based on a prefix string.
	// AutoSuggestion tolerance should be less than 1 second.
	SuggestQueries(context.Context, *SuggestQueriesRequest) (*SuggestQueriesResponse, error)
}

// UnimplementedAutoSuggestionServiceServer should be embedded to have forward compatible implementations.
type UnimplementedAutoSuggestionServiceServer struct {
}

func (UnimplementedAutoSuggestionServiceServer) SuggestQueries(context.Context, *SuggestQueriesRequest) (*SuggestQueriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SuggestQueries not implemented")
}

// UnsafeAutoSuggestionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AutoSuggestionServiceServer will
// result in compilation errors.
type UnsafeAutoSuggestionServiceServer interface {
	mustEmbedUnimplementedAutoSuggestionServiceServer()
}

func RegisterAutoSuggestionServiceServer(s grpc.ServiceRegistrar, srv AutoSuggestionServiceServer) {
	s.RegisterService(&AutoSuggestionService_ServiceDesc, srv)
}

func _AutoSuggestionService_SuggestQueries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuggestQueriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoSuggestionServiceServer).SuggestQueries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoSuggestionService_SuggestQueries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoSuggestionServiceServer).SuggestQueries(ctx, req.(*SuggestQueriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AutoSuggestionService_ServiceDesc is the grpc.ServiceDesc for AutoSuggestionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AutoSuggestionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataqna.v1alpha.AutoSuggestionService",
	HandlerType: (*AutoSuggestionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SuggestQueries",
			Handler:    _AutoSuggestionService_SuggestQueries_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataqna/v1alpha/auto_suggestion_service.proto",
}
