// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/cloud/beyondcorp/appconnections/v1/app_connections_service.proto

package appconnectionspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum containing list of all possible network connectivity options
// supported by BeyondCorp AppConnection.
type AppConnection_Type int32

const (
	// Default value. This value is unused.
	AppConnection_TYPE_UNSPECIFIED AppConnection_Type = 0
	// TCP Proxy based BeyondCorp AppConnection. API will default to this if
	// unset.
	AppConnection_TCP_PROXY AppConnection_Type = 1
)

// Enum value maps for AppConnection_Type.
var (
	AppConnection_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "TCP_PROXY",
	}
	AppConnection_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"TCP_PROXY":        1,
	}
)

func (x AppConnection_Type) Enum() *AppConnection_Type {
	p := new(AppConnection_Type)
	*p = x
	return p
}

func (x AppConnection_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AppConnection_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_enumTypes[0].Descriptor()
}

func (AppConnection_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_enumTypes[0]
}

func (x AppConnection_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AppConnection_Type.Descriptor instead.
func (AppConnection_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{8, 0}
}

// Represents the different states of a AppConnection.
type AppConnection_State int32

const (
	// Default value. This value is unused.
	AppConnection_STATE_UNSPECIFIED AppConnection_State = 0
	// AppConnection is being created.
	AppConnection_CREATING AppConnection_State = 1
	// AppConnection has been created.
	AppConnection_CREATED AppConnection_State = 2
	// AppConnection's configuration is being updated.
	AppConnection_UPDATING AppConnection_State = 3
	// AppConnection is being deleted.
	AppConnection_DELETING AppConnection_State = 4
	// AppConnection is down and may be restored in the future.
	// This happens when CCFE sends ProjectState = OFF.
	AppConnection_DOWN AppConnection_State = 5
)

// Enum value maps for AppConnection_State.
var (
	AppConnection_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "CREATED",
		3: "UPDATING",
		4: "DELETING",
		5: "DOWN",
	}
	AppConnection_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"CREATED":           2,
		"UPDATING":          3,
		"DELETING":          4,
		"DOWN":              5,
	}
)

func (x AppConnection_State) Enum() *AppConnection_State {
	p := new(AppConnection_State)
	*p = x
	return p
}

func (x AppConnection_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AppConnection_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_enumTypes[1].Descriptor()
}

func (AppConnection_State) Type() protoreflect.EnumType {
	return &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_enumTypes[1]
}

func (x AppConnection_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AppConnection_State.Descriptor instead.
func (AppConnection_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{8, 1}
}

// Enum listing possible gateway hosting options.
type AppConnection_Gateway_Type int32

const (
	// Default value. This value is unused.
	AppConnection_Gateway_TYPE_UNSPECIFIED AppConnection_Gateway_Type = 0
	// Gateway hosted in a GCP regional managed instance group.
	AppConnection_Gateway_GCP_REGIONAL_MIG AppConnection_Gateway_Type = 1
)

// Enum value maps for AppConnection_Gateway_Type.
var (
	AppConnection_Gateway_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "GCP_REGIONAL_MIG",
	}
	AppConnection_Gateway_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"GCP_REGIONAL_MIG": 1,
	}
)

func (x AppConnection_Gateway_Type) Enum() *AppConnection_Gateway_Type {
	p := new(AppConnection_Gateway_Type)
	*p = x
	return p
}

func (x AppConnection_Gateway_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AppConnection_Gateway_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_enumTypes[2].Descriptor()
}

func (AppConnection_Gateway_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_enumTypes[2]
}

func (x AppConnection_Gateway_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AppConnection_Gateway_Type.Descriptor instead.
func (AppConnection_Gateway_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{8, 1, 0}
}

// Request message for BeyondCorp.ListAppConnections.
type ListAppConnectionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the AppConnection location using the form:
	// `projects/{project_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	// If not specified, a default value of 50 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [next_page_token][BeyondCorp.ListAppConnectionsResponse.next_page_token] to
	// determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous
	// ListAppConnectionsRequest, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter specifying constraints of a list operation.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specifies the ordering of results. See
	// [Sorting
	// order](https://cloud.google.com/apis/design/design_patterns#sorting_order)
	// for more information.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListAppConnectionsRequest) Reset() {
	*x = ListAppConnectionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAppConnectionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAppConnectionsRequest) ProtoMessage() {}

func (x *ListAppConnectionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAppConnectionsRequest.ProtoReflect.Descriptor instead.
func (*ListAppConnectionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{0}
}

func (x *ListAppConnectionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAppConnectionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAppConnectionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAppConnectionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAppConnectionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for BeyondCorp.ListAppConnections.
type ListAppConnectionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of BeyondCorp AppConnections in the project.
	AppConnections []*AppConnection `protobuf:"bytes,1,rep,name=app_connections,json=appConnections,proto3" json:"app_connections,omitempty"`
	// A token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// A list of locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListAppConnectionsResponse) Reset() {
	*x = ListAppConnectionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAppConnectionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAppConnectionsResponse) ProtoMessage() {}

func (x *ListAppConnectionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAppConnectionsResponse.ProtoReflect.Descriptor instead.
func (*ListAppConnectionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListAppConnectionsResponse) GetAppConnections() []*AppConnection {
	if x != nil {
		return x.AppConnections
	}
	return nil
}

func (x *ListAppConnectionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListAppConnectionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for BeyondCorp.GetAppConnection.
type GetAppConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. BeyondCorp AppConnection name using the form:
	// `projects/{project_id}/locations/{location_id}/appConnections/{app_connection_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAppConnectionRequest) Reset() {
	*x = GetAppConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAppConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAppConnectionRequest) ProtoMessage() {}

func (x *GetAppConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAppConnectionRequest.ProtoReflect.Descriptor instead.
func (*GetAppConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{2}
}

func (x *GetAppConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for BeyondCorp.CreateAppConnection.
type CreateAppConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource project name of the AppConnection location using the
	// form: `projects/{project_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. User-settable AppConnection resource ID.
	//   - Must start with a letter.
	//   - Must contain between 4-63 characters from `/[a-z][0-9]-/`.
	//   - Must end with a number or a letter.
	AppConnectionId string `protobuf:"bytes,2,opt,name=app_connection_id,json=appConnectionId,proto3" json:"app_connection_id,omitempty"`
	// Required. A BeyondCorp AppConnection resource.
	AppConnection *AppConnection `protobuf:"bytes,3,opt,name=app_connection,json=appConnection,proto3" json:"app_connection,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set, validates request by executing a dry-run which would not
	// alter the resource in any way.
	ValidateOnly bool `protobuf:"varint,5,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAppConnectionRequest) Reset() {
	*x = CreateAppConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateAppConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAppConnectionRequest) ProtoMessage() {}

func (x *CreateAppConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAppConnectionRequest.ProtoReflect.Descriptor instead.
func (*CreateAppConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateAppConnectionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAppConnectionRequest) GetAppConnectionId() string {
	if x != nil {
		return x.AppConnectionId
	}
	return ""
}

func (x *CreateAppConnectionRequest) GetAppConnection() *AppConnection {
	if x != nil {
		return x.AppConnection
	}
	return nil
}

func (x *CreateAppConnectionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *CreateAppConnectionRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for BeyondCorp.UpdateAppConnection.
type UpdateAppConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. The elements of the repeated paths field may only include these
	// fields from [BeyondCorp.AppConnection]:
	// * `labels`
	// * `display_name`
	// * `application_endpoint`
	// * `connectors`
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. AppConnection message with updated fields. Only supported fields
	// specified in update_mask are updated.
	AppConnection *AppConnection `protobuf:"bytes,2,opt,name=app_connection,json=appConnection,proto3" json:"app_connection,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set, validates request by executing a dry-run which would not
	// alter the resource in any way.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. If set as true, will create the resource if it is not found.
	AllowMissing bool `protobuf:"varint,5,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
}

func (x *UpdateAppConnectionRequest) Reset() {
	*x = UpdateAppConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAppConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAppConnectionRequest) ProtoMessage() {}

func (x *UpdateAppConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAppConnectionRequest.ProtoReflect.Descriptor instead.
func (*UpdateAppConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateAppConnectionRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateAppConnectionRequest) GetAppConnection() *AppConnection {
	if x != nil {
		return x.AppConnection
	}
	return nil
}

func (x *UpdateAppConnectionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *UpdateAppConnectionRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdateAppConnectionRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

// Request message for BeyondCorp.DeleteAppConnection.
type DeleteAppConnectionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. BeyondCorp Connector name using the form:
	// `projects/{project_id}/locations/{location_id}/appConnections/{app_connection_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set, validates request by executing a dry-run which would not
	// alter the resource in any way.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *DeleteAppConnectionRequest) Reset() {
	*x = DeleteAppConnectionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteAppConnectionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAppConnectionRequest) ProtoMessage() {}

func (x *DeleteAppConnectionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAppConnectionRequest.ProtoReflect.Descriptor instead.
func (*DeleteAppConnectionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteAppConnectionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAppConnectionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteAppConnectionRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for BeyondCorp.ResolveAppConnections.
type ResolveAppConnectionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the AppConnection location using the form:
	// `projects/{project_id}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. BeyondCorp Connector name of the connector associated with those
	// AppConnections using the form:
	// `projects/{project_id}/locations/{location_id}/appConnectors/{app_connector_id}`
	AppConnectorId string `protobuf:"bytes,2,opt,name=app_connector_id,json=appConnectorId,proto3" json:"app_connector_id,omitempty"`
	// Optional. The maximum number of items to return.
	// If not specified, a default value of 50 will be used by the service.
	// Regardless of the page_size value, the response may include a partial list
	// and a caller should only rely on response's
	// [next_page_token][BeyondCorp.ResolveAppConnectionsResponse.next_page_token]
	// to determine if there are more instances left to be queried.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous
	// ResolveAppConnectionsResponse, if any.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ResolveAppConnectionsRequest) Reset() {
	*x = ResolveAppConnectionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveAppConnectionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveAppConnectionsRequest) ProtoMessage() {}

func (x *ResolveAppConnectionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveAppConnectionsRequest.ProtoReflect.Descriptor instead.
func (*ResolveAppConnectionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{6}
}

func (x *ResolveAppConnectionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ResolveAppConnectionsRequest) GetAppConnectorId() string {
	if x != nil {
		return x.AppConnectorId
	}
	return ""
}

func (x *ResolveAppConnectionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ResolveAppConnectionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for BeyondCorp.ResolveAppConnections.
type ResolveAppConnectionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of BeyondCorp AppConnections with details in the project.
	AppConnectionDetails []*ResolveAppConnectionsResponse_AppConnectionDetails `protobuf:"bytes,1,rep,name=app_connection_details,json=appConnectionDetails,proto3" json:"app_connection_details,omitempty"`
	// A token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// A list of locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ResolveAppConnectionsResponse) Reset() {
	*x = ResolveAppConnectionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveAppConnectionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveAppConnectionsResponse) ProtoMessage() {}

func (x *ResolveAppConnectionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveAppConnectionsResponse.ProtoReflect.Descriptor instead.
func (*ResolveAppConnectionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{7}
}

func (x *ResolveAppConnectionsResponse) GetAppConnectionDetails() []*ResolveAppConnectionsResponse_AppConnectionDetails {
	if x != nil {
		return x.AppConnectionDetails
	}
	return nil
}

func (x *ResolveAppConnectionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ResolveAppConnectionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// A BeyondCorp AppConnection resource represents a BeyondCorp protected
// AppConnection to a remote application. It creates all the necessary GCP
// components needed for creating a BeyondCorp protected AppConnection. Multiple
// connectors can be authorised for a single AppConnection.
type AppConnection struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Unique resource name of the AppConnection.
	// The name is ignored when creating a AppConnection.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Timestamp when the resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when the resource was last modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Resource labels to represent user provided metadata.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. An arbitrary user-provided name for the AppConnection. Cannot
	// exceed 64 characters.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. A unique identifier for the instance generated by the
	// system.
	Uid string `protobuf:"bytes,6,opt,name=uid,proto3" json:"uid,omitempty"`
	// Required. The type of network connectivity used by the AppConnection.
	Type AppConnection_Type `protobuf:"varint,7,opt,name=type,proto3,enum=google.cloud.beyondcorp.appconnections.v1.AppConnection_Type" json:"type,omitempty"`
	// Required. Address of the remote application endpoint for the BeyondCorp
	// AppConnection.
	ApplicationEndpoint *AppConnection_ApplicationEndpoint `protobuf:"bytes,8,opt,name=application_endpoint,json=applicationEndpoint,proto3" json:"application_endpoint,omitempty"`
	// Optional. List of [google.cloud.beyondcorp.v1main.Connector.name] that are
	// authorised to be associated with this AppConnection.
	Connectors []string `protobuf:"bytes,9,rep,name=connectors,proto3" json:"connectors,omitempty"`
	// Output only. The current state of the AppConnection.
	State AppConnection_State `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.beyondcorp.appconnections.v1.AppConnection_State" json:"state,omitempty"`
	// Optional. Gateway used by the AppConnection.
	Gateway *AppConnection_Gateway `protobuf:"bytes,11,opt,name=gateway,proto3" json:"gateway,omitempty"`
}

func (x *AppConnection) Reset() {
	*x = AppConnection{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppConnection) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppConnection) ProtoMessage() {}

func (x *AppConnection) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppConnection.ProtoReflect.Descriptor instead.
func (*AppConnection) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{8}
}

func (x *AppConnection) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AppConnection) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AppConnection) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AppConnection) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AppConnection) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AppConnection) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *AppConnection) GetType() AppConnection_Type {
	if x != nil {
		return x.Type
	}
	return AppConnection_TYPE_UNSPECIFIED
}

func (x *AppConnection) GetApplicationEndpoint() *AppConnection_ApplicationEndpoint {
	if x != nil {
		return x.ApplicationEndpoint
	}
	return nil
}

func (x *AppConnection) GetConnectors() []string {
	if x != nil {
		return x.Connectors
	}
	return nil
}

func (x *AppConnection) GetState() AppConnection_State {
	if x != nil {
		return x.State
	}
	return AppConnection_STATE_UNSPECIFIED
}

func (x *AppConnection) GetGateway() *AppConnection_Gateway {
	if x != nil {
		return x.Gateway
	}
	return nil
}

// Represents the metadata of the long-running operation.
type AppConnectionOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *AppConnectionOperationMetadata) Reset() {
	*x = AppConnectionOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppConnectionOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppConnectionOperationMetadata) ProtoMessage() {}

func (x *AppConnectionOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppConnectionOperationMetadata.ProtoReflect.Descriptor instead.
func (*AppConnectionOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{9}
}

func (x *AppConnectionOperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AppConnectionOperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *AppConnectionOperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *AppConnectionOperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *AppConnectionOperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *AppConnectionOperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *AppConnectionOperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Details of the AppConnection.
type ResolveAppConnectionsResponse_AppConnectionDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A BeyondCorp AppConnection in the project.
	AppConnection *AppConnection `protobuf:"bytes,1,opt,name=app_connection,json=appConnection,proto3" json:"app_connection,omitempty"`
	// If type=GCP_REGIONAL_MIG, contains most recent VM instances, like
	// `https://www.googleapis.com/compute/v1/projects/{project_id}/zones/{zone_id}/instances/{instance_id}`.
	RecentMigVms []string `protobuf:"bytes,2,rep,name=recent_mig_vms,json=recentMigVms,proto3" json:"recent_mig_vms,omitempty"`
}

func (x *ResolveAppConnectionsResponse_AppConnectionDetails) Reset() {
	*x = ResolveAppConnectionsResponse_AppConnectionDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResolveAppConnectionsResponse_AppConnectionDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResolveAppConnectionsResponse_AppConnectionDetails) ProtoMessage() {}

func (x *ResolveAppConnectionsResponse_AppConnectionDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResolveAppConnectionsResponse_AppConnectionDetails.ProtoReflect.Descriptor instead.
func (*ResolveAppConnectionsResponse_AppConnectionDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{7, 0}
}

func (x *ResolveAppConnectionsResponse_AppConnectionDetails) GetAppConnection() *AppConnection {
	if x != nil {
		return x.AppConnection
	}
	return nil
}

func (x *ResolveAppConnectionsResponse_AppConnectionDetails) GetRecentMigVms() []string {
	if x != nil {
		return x.RecentMigVms
	}
	return nil
}

// ApplicationEndpoint represents a remote application endpoint.
type AppConnection_ApplicationEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Hostname or IP address of the remote application endpoint.
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// Required. Port of the remote application endpoint.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
}

func (x *AppConnection_ApplicationEndpoint) Reset() {
	*x = AppConnection_ApplicationEndpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppConnection_ApplicationEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppConnection_ApplicationEndpoint) ProtoMessage() {}

func (x *AppConnection_ApplicationEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppConnection_ApplicationEndpoint.ProtoReflect.Descriptor instead.
func (*AppConnection_ApplicationEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{8, 0}
}

func (x *AppConnection_ApplicationEndpoint) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *AppConnection_ApplicationEndpoint) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

// Gateway represents a user facing component that serves as an entrance to
// enable connectivity.
type AppConnection_Gateway struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of hosting used by the gateway.
	Type AppConnection_Gateway_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.beyondcorp.appconnections.v1.AppConnection_Gateway_Type" json:"type,omitempty"`
	// Output only. Server-defined URI for this resource.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	// Output only. Ingress port reserved on the gateways for this
	// AppConnection, if not specified or zero, the default port is 19443.
	IngressPort int32 `protobuf:"varint,4,opt,name=ingress_port,json=ingressPort,proto3" json:"ingress_port,omitempty"`
	// Required. AppGateway name in following format:
	// `projects/{project_id}/locations/{location_id}/appgateways/{gateway_id}`
	AppGateway string `protobuf:"bytes,5,opt,name=app_gateway,json=appGateway,proto3" json:"app_gateway,omitempty"`
}

func (x *AppConnection_Gateway) Reset() {
	*x = AppConnection_Gateway{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppConnection_Gateway) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppConnection_Gateway) ProtoMessage() {}

func (x *AppConnection_Gateway) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppConnection_Gateway.ProtoReflect.Descriptor instead.
func (*AppConnection_Gateway) Descriptor() ([]byte, []int) {
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP(), []int{8, 1}
}

func (x *AppConnection_Gateway) GetType() AppConnection_Gateway_Type {
	if x != nil {
		return x.Type
	}
	return AppConnection_Gateway_TYPE_UNSPECIFIED
}

func (x *AppConnection_Gateway) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *AppConnection_Gateway) GetIngressPort() int32 {
	if x != nil {
		return x.IngressPort
	}
	return 0
}

func (x *AppConnection_Gateway) GetAppGateway() string {
	if x != nil {
		return x.AppGateway
	}
	return ""
}

var File_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto protoreflect.FileDescriptor

var file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDesc = []byte{
	0x0a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x70, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xe7, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc9, 0x01, 0x0a, 0x1a, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x61, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70,
	0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x61, 0x70, 0x70,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x5e, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x41, 0x70, 0x70, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xca, 0x02, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x62, 0x65,
	0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a,
	0x11, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x61,
	0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x64,
	0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70,
	0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e,
	0x6c, 0x79, 0x22, 0xbc, 0x02, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x64, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e,
	0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e,
	0x67, 0x22, 0xaf, 0x01, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x70, 0x70, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f,
	0x6e, 0x6c, 0x79, 0x22, 0x87, 0x02, 0x0a, 0x1c, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x41,
	0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x62, 0x65,
	0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x58, 0x0a,
	0x10, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a,
	0x26, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x9f, 0x03,
	0x0a, 0x1d, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x93, 0x01, 0x0a, 0x16, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x6c, 0x76, 0x65, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52,
	0x14, 0x61, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x1a,
	0x9d, 0x01, 0x0a, 0x14, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x5f, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0e, 0x72, 0x65, 0x63,
	0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x69, 0x67, 0x5f, 0x76, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0c, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x4d, 0x69, 0x67, 0x56, 0x6d, 0x73, 0x22,
	0xc5, 0x0b, 0x0a, 0x0d, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x61,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65,
	0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64,
	0x12, 0x56, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65,
	0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x84, 0x01, 0x0a, 0x14, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12,
	0x23, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x09, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x12, 0x59, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70,
	0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x5f, 0x0a, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x1a, 0x47, 0x0a, 0x13, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74,
	0x12, 0x17, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0xab, 0x02, 0x0a, 0x07, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x5e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70,
	0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x26, 0x0a, 0x0c,
	0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x50, 0x6f, 0x72, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x61, 0x70, 0x70, 0x5f, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x26, 0x0a, 0x24, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x0a, 0x61, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x22, 0x32, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x43, 0x50, 0x5f, 0x52, 0x45, 0x47, 0x49, 0x4f, 0x4e, 0x41,
	0x4c, 0x5f, 0x4d, 0x49, 0x47, 0x10, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x2b, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x54, 0x43, 0x50, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x10, 0x01, 0x22,
	0x5f, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a,
	0x07, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50,
	0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x05,
	0x3a, 0x75, 0xea, 0x41, 0x72, 0x0a, 0x27, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xe2, 0x02, 0x0a, 0x1e, 0x41, 0x70, 0x70, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a,
	0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x32, 0xea, 0x0c, 0x0a,
	0x15, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xe6, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x44, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79,
	0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x70,
	0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70,
	0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x61, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0xd3, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61,
	0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f,
	0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa4, 0x02, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79,
	0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xa6, 0x01, 0xca, 0x41, 0x2f, 0x0a, 0x0d, 0x41, 0x70, 0x70, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x27, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2c, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x70,
	0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xa6, 0x02, 0x0a,
	0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61,
	0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa8, 0x01, 0xca, 0x41, 0x2f,
	0x0a, 0x0d, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1e, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x1a, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x53, 0x3a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x32, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf8, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79,
	0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x7b, 0xca, 0x41, 0x37, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12,
	0x1e, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61,
	0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xf7, 0x01, 0x0a, 0x15, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x41, 0x70, 0x70, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64,
	0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x41, 0x70,
	0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70,
	0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x62,
	0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x8a, 0x04, 0xea, 0x41, 0x6f, 0x0a,
	0x26, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x45, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x61, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x7b,
	0x61, 0x70, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x7d, 0xea, 0x41,
	0x69, 0x0a, 0x24, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x70, 0x70,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x61, 0x70, 0x70, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x73, 0x2f, 0x7b, 0x61, 0x70,
	0x70, 0x5f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x7d, 0x0a, 0x2d, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x65, 0x79,
	0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2e, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x1a, 0x41, 0x70, 0x70, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x55, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x65, 0x79,
	0x6f, 0x6e, 0x64, 0x63, 0x6f, 0x72, 0x70, 0x2f, 0x61, 0x70, 0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x70, 0x70,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x62, 0x3b, 0x61, 0x70,
	0x70, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x62, 0xaa, 0x02,
	0x29, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x65,
	0x79, 0x6f, 0x6e, 0x64, 0x43, 0x6f, 0x72, 0x70, 0x2e, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x29, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x65, 0x79, 0x6f, 0x6e, 0x64,
	0x43, 0x6f, 0x72, 0x70, 0x5c, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x2d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x42, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x43, 0x6f,
	0x72, 0x70, 0x3a, 0x3a, 0x41, 0x70, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescOnce sync.Once
	file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescData = file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDesc
)

func file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescGZIP() []byte {
	file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescData)
	})
	return file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDescData
}

var file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_goTypes = []interface{}{
	(AppConnection_Type)(0),                                    // 0: google.cloud.beyondcorp.appconnections.v1.AppConnection.Type
	(AppConnection_State)(0),                                   // 1: google.cloud.beyondcorp.appconnections.v1.AppConnection.State
	(AppConnection_Gateway_Type)(0),                            // 2: google.cloud.beyondcorp.appconnections.v1.AppConnection.Gateway.Type
	(*ListAppConnectionsRequest)(nil),                          // 3: google.cloud.beyondcorp.appconnections.v1.ListAppConnectionsRequest
	(*ListAppConnectionsResponse)(nil),                         // 4: google.cloud.beyondcorp.appconnections.v1.ListAppConnectionsResponse
	(*GetAppConnectionRequest)(nil),                            // 5: google.cloud.beyondcorp.appconnections.v1.GetAppConnectionRequest
	(*CreateAppConnectionRequest)(nil),                         // 6: google.cloud.beyondcorp.appconnections.v1.CreateAppConnectionRequest
	(*UpdateAppConnectionRequest)(nil),                         // 7: google.cloud.beyondcorp.appconnections.v1.UpdateAppConnectionRequest
	(*DeleteAppConnectionRequest)(nil),                         // 8: google.cloud.beyondcorp.appconnections.v1.DeleteAppConnectionRequest
	(*ResolveAppConnectionsRequest)(nil),                       // 9: google.cloud.beyondcorp.appconnections.v1.ResolveAppConnectionsRequest
	(*ResolveAppConnectionsResponse)(nil),                      // 10: google.cloud.beyondcorp.appconnections.v1.ResolveAppConnectionsResponse
	(*AppConnection)(nil),                                      // 11: google.cloud.beyondcorp.appconnections.v1.AppConnection
	(*AppConnectionOperationMetadata)(nil),                     // 12: google.cloud.beyondcorp.appconnections.v1.AppConnectionOperationMetadata
	(*ResolveAppConnectionsResponse_AppConnectionDetails)(nil), // 13: google.cloud.beyondcorp.appconnections.v1.ResolveAppConnectionsResponse.AppConnectionDetails
	(*AppConnection_ApplicationEndpoint)(nil),                  // 14: google.cloud.beyondcorp.appconnections.v1.AppConnection.ApplicationEndpoint
	(*AppConnection_Gateway)(nil),                              // 15: google.cloud.beyondcorp.appconnections.v1.AppConnection.Gateway
	nil,                                                        // 16: google.cloud.beyondcorp.appconnections.v1.AppConnection.LabelsEntry
	(*fieldmaskpb.FieldMask)(nil),                              // 17: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                              // 18: google.protobuf.Timestamp
	(*longrunningpb.Operation)(nil),                            // 19: google.longrunning.Operation
}
var file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_depIdxs = []int32{
	11, // 0: google.cloud.beyondcorp.appconnections.v1.ListAppConnectionsResponse.app_connections:type_name -> google.cloud.beyondcorp.appconnections.v1.AppConnection
	11, // 1: google.cloud.beyondcorp.appconnections.v1.CreateAppConnectionRequest.app_connection:type_name -> google.cloud.beyondcorp.appconnections.v1.AppConnection
	17, // 2: google.cloud.beyondcorp.appconnections.v1.UpdateAppConnectionRequest.update_mask:type_name -> google.protobuf.FieldMask
	11, // 3: google.cloud.beyondcorp.appconnections.v1.UpdateAppConnectionRequest.app_connection:type_name -> google.cloud.beyondcorp.appconnections.v1.AppConnection
	13, // 4: google.cloud.beyondcorp.appconnections.v1.ResolveAppConnectionsResponse.app_connection_details:type_name -> google.cloud.beyondcorp.appconnections.v1.ResolveAppConnectionsResponse.AppConnectionDetails
	18, // 5: google.cloud.beyondcorp.appconnections.v1.AppConnection.create_time:type_name -> google.protobuf.Timestamp
	18, // 6: google.cloud.beyondcorp.appconnections.v1.AppConnection.update_time:type_name -> google.protobuf.Timestamp
	16, // 7: google.cloud.beyondcorp.appconnections.v1.AppConnection.labels:type_name -> google.cloud.beyondcorp.appconnections.v1.AppConnection.LabelsEntry
	0,  // 8: google.cloud.beyondcorp.appconnections.v1.AppConnection.type:type_name -> google.cloud.beyondcorp.appconnections.v1.AppConnection.Type
	14, // 9: google.cloud.beyondcorp.appconnections.v1.AppConnection.application_endpoint:type_name -> google.cloud.beyondcorp.appconnections.v1.AppConnection.ApplicationEndpoint
	1,  // 10: google.cloud.beyondcorp.appconnections.v1.AppConnection.state:type_name -> google.cloud.beyondcorp.appconnections.v1.AppConnection.State
	15, // 11: google.cloud.beyondcorp.appconnections.v1.AppConnection.gateway:type_name -> google.cloud.beyondcorp.appconnections.v1.AppConnection.Gateway
	18, // 12: google.cloud.beyondcorp.appconnections.v1.AppConnectionOperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	18, // 13: google.cloud.beyondcorp.appconnections.v1.AppConnectionOperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	11, // 14: google.cloud.beyondcorp.appconnections.v1.ResolveAppConnectionsResponse.AppConnectionDetails.app_connection:type_name -> google.cloud.beyondcorp.appconnections.v1.AppConnection
	2,  // 15: google.cloud.beyondcorp.appconnections.v1.AppConnection.Gateway.type:type_name -> google.cloud.beyondcorp.appconnections.v1.AppConnection.Gateway.Type
	3,  // 16: google.cloud.beyondcorp.appconnections.v1.AppConnectionsService.ListAppConnections:input_type -> google.cloud.beyondcorp.appconnections.v1.ListAppConnectionsRequest
	5,  // 17: google.cloud.beyondcorp.appconnections.v1.AppConnectionsService.GetAppConnection:input_type -> google.cloud.beyondcorp.appconnections.v1.GetAppConnectionRequest
	6,  // 18: google.cloud.beyondcorp.appconnections.v1.AppConnectionsService.CreateAppConnection:input_type -> google.cloud.beyondcorp.appconnections.v1.CreateAppConnectionRequest
	7,  // 19: google.cloud.beyondcorp.appconnections.v1.AppConnectionsService.UpdateAppConnection:input_type -> google.cloud.beyondcorp.appconnections.v1.UpdateAppConnectionRequest
	8,  // 20: google.cloud.beyondcorp.appconnections.v1.AppConnectionsService.DeleteAppConnection:input_type -> google.cloud.beyondcorp.appconnections.v1.DeleteAppConnectionRequest
	9,  // 21: google.cloud.beyondcorp.appconnections.v1.AppConnectionsService.ResolveAppConnections:input_type -> google.cloud.beyondcorp.appconnections.v1.ResolveAppConnectionsRequest
	4,  // 22: google.cloud.beyondcorp.appconnections.v1.AppConnectionsService.ListAppConnections:output_type -> google.cloud.beyondcorp.appconnections.v1.ListAppConnectionsResponse
	11, // 23: google.cloud.beyondcorp.appconnections.v1.AppConnectionsService.GetAppConnection:output_type -> google.cloud.beyondcorp.appconnections.v1.AppConnection
	19, // 24: google.cloud.beyondcorp.appconnections.v1.AppConnectionsService.CreateAppConnection:output_type -> google.longrunning.Operation
	19, // 25: google.cloud.beyondcorp.appconnections.v1.AppConnectionsService.UpdateAppConnection:output_type -> google.longrunning.Operation
	19, // 26: google.cloud.beyondcorp.appconnections.v1.AppConnectionsService.DeleteAppConnection:output_type -> google.longrunning.Operation
	10, // 27: google.cloud.beyondcorp.appconnections.v1.AppConnectionsService.ResolveAppConnections:output_type -> google.cloud.beyondcorp.appconnections.v1.ResolveAppConnectionsResponse
	22, // [22:28] is the sub-list for method output_type
	16, // [16:22] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_init() }
func file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_init() {
	if File_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAppConnectionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAppConnectionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAppConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateAppConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAppConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteAppConnectionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveAppConnectionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveAppConnectionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppConnection); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppConnectionOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResolveAppConnectionsResponse_AppConnectionDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppConnection_ApplicationEndpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppConnection_Gateway); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_msgTypes,
	}.Build()
	File_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto = out.File
	file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_rawDesc = nil
	file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_goTypes = nil
	file_google_cloud_beyondcorp_appconnections_v1_app_connections_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AppConnectionsServiceClient is the client API for AppConnectionsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AppConnectionsServiceClient interface {
	// Lists AppConnections in a given project and location.
	ListAppConnections(ctx context.Context, in *ListAppConnectionsRequest, opts ...grpc.CallOption) (*ListAppConnectionsResponse, error)
	// Gets details of a single AppConnection.
	GetAppConnection(ctx context.Context, in *GetAppConnectionRequest, opts ...grpc.CallOption) (*AppConnection, error)
	// Creates a new AppConnection in a given project and location.
	CreateAppConnection(ctx context.Context, in *CreateAppConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single AppConnection.
	UpdateAppConnection(ctx context.Context, in *UpdateAppConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single AppConnection.
	DeleteAppConnection(ctx context.Context, in *DeleteAppConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resolves AppConnections details for a given AppConnector.
	// An internal method called by a connector to find AppConnections to connect
	// to.
	ResolveAppConnections(ctx context.Context, in *ResolveAppConnectionsRequest, opts ...grpc.CallOption) (*ResolveAppConnectionsResponse, error)
}

type appConnectionsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAppConnectionsServiceClient(cc grpc.ClientConnInterface) AppConnectionsServiceClient {
	return &appConnectionsServiceClient{cc}
}

func (c *appConnectionsServiceClient) ListAppConnections(ctx context.Context, in *ListAppConnectionsRequest, opts ...grpc.CallOption) (*ListAppConnectionsResponse, error) {
	out := new(ListAppConnectionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/ListAppConnections", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectionsServiceClient) GetAppConnection(ctx context.Context, in *GetAppConnectionRequest, opts ...grpc.CallOption) (*AppConnection, error) {
	out := new(AppConnection)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/GetAppConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectionsServiceClient) CreateAppConnection(ctx context.Context, in *CreateAppConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/CreateAppConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectionsServiceClient) UpdateAppConnection(ctx context.Context, in *UpdateAppConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/UpdateAppConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectionsServiceClient) DeleteAppConnection(ctx context.Context, in *DeleteAppConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/DeleteAppConnection", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *appConnectionsServiceClient) ResolveAppConnections(ctx context.Context, in *ResolveAppConnectionsRequest, opts ...grpc.CallOption) (*ResolveAppConnectionsResponse, error) {
	out := new(ResolveAppConnectionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/ResolveAppConnections", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AppConnectionsServiceServer is the server API for AppConnectionsService service.
type AppConnectionsServiceServer interface {
	// Lists AppConnections in a given project and location.
	ListAppConnections(context.Context, *ListAppConnectionsRequest) (*ListAppConnectionsResponse, error)
	// Gets details of a single AppConnection.
	GetAppConnection(context.Context, *GetAppConnectionRequest) (*AppConnection, error)
	// Creates a new AppConnection in a given project and location.
	CreateAppConnection(context.Context, *CreateAppConnectionRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single AppConnection.
	UpdateAppConnection(context.Context, *UpdateAppConnectionRequest) (*longrunningpb.Operation, error)
	// Deletes a single AppConnection.
	DeleteAppConnection(context.Context, *DeleteAppConnectionRequest) (*longrunningpb.Operation, error)
	// Resolves AppConnections details for a given AppConnector.
	// An internal method called by a connector to find AppConnections to connect
	// to.
	ResolveAppConnections(context.Context, *ResolveAppConnectionsRequest) (*ResolveAppConnectionsResponse, error)
}

// UnimplementedAppConnectionsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAppConnectionsServiceServer struct {
}

func (*UnimplementedAppConnectionsServiceServer) ListAppConnections(context.Context, *ListAppConnectionsRequest) (*ListAppConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAppConnections not implemented")
}
func (*UnimplementedAppConnectionsServiceServer) GetAppConnection(context.Context, *GetAppConnectionRequest) (*AppConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAppConnection not implemented")
}
func (*UnimplementedAppConnectionsServiceServer) CreateAppConnection(context.Context, *CreateAppConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAppConnection not implemented")
}
func (*UnimplementedAppConnectionsServiceServer) UpdateAppConnection(context.Context, *UpdateAppConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAppConnection not implemented")
}
func (*UnimplementedAppConnectionsServiceServer) DeleteAppConnection(context.Context, *DeleteAppConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAppConnection not implemented")
}
func (*UnimplementedAppConnectionsServiceServer) ResolveAppConnections(context.Context, *ResolveAppConnectionsRequest) (*ResolveAppConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResolveAppConnections not implemented")
}

func RegisterAppConnectionsServiceServer(s *grpc.Server, srv AppConnectionsServiceServer) {
	s.RegisterService(&_AppConnectionsService_serviceDesc, srv)
}

func _AppConnectionsService_ListAppConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAppConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectionsServiceServer).ListAppConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/ListAppConnections",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectionsServiceServer).ListAppConnections(ctx, req.(*ListAppConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectionsService_GetAppConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAppConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectionsServiceServer).GetAppConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/GetAppConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectionsServiceServer).GetAppConnection(ctx, req.(*GetAppConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectionsService_CreateAppConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAppConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectionsServiceServer).CreateAppConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/CreateAppConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectionsServiceServer).CreateAppConnection(ctx, req.(*CreateAppConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectionsService_UpdateAppConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAppConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectionsServiceServer).UpdateAppConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/UpdateAppConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectionsServiceServer).UpdateAppConnection(ctx, req.(*UpdateAppConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectionsService_DeleteAppConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAppConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectionsServiceServer).DeleteAppConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/DeleteAppConnection",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectionsServiceServer).DeleteAppConnection(ctx, req.(*DeleteAppConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AppConnectionsService_ResolveAppConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResolveAppConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AppConnectionsServiceServer).ResolveAppConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.beyondcorp.appconnections.v1.AppConnectionsService/ResolveAppConnections",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AppConnectionsServiceServer).ResolveAppConnections(ctx, req.(*ResolveAppConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AppConnectionsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.beyondcorp.appconnections.v1.AppConnectionsService",
	HandlerType: (*AppConnectionsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListAppConnections",
			Handler:    _AppConnectionsService_ListAppConnections_Handler,
		},
		{
			MethodName: "GetAppConnection",
			Handler:    _AppConnectionsService_GetAppConnection_Handler,
		},
		{
			MethodName: "CreateAppConnection",
			Handler:    _AppConnectionsService_CreateAppConnection_Handler,
		},
		{
			MethodName: "UpdateAppConnection",
			Handler:    _AppConnectionsService_UpdateAppConnection_Handler,
		},
		{
			MethodName: "DeleteAppConnection",
			Handler:    _AppConnectionsService_DeleteAppConnection_Handler,
		},
		{
			MethodName: "ResolveAppConnections",
			Handler:    _AppConnectionsService_ResolveAppConnections_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/beyondcorp/appconnections/v1/app_connections_service.proto",
}
