// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ivsrealtime

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateParticipantToken = "CreateParticipantToken"

// CreateParticipantTokenRequest generates a "aws/request.Request" representing the
// client's request for the CreateParticipantToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateParticipantToken for more information on using the CreateParticipantToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateParticipantTokenRequest method.
//	req, resp := client.CreateParticipantTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateParticipantToken
func (c *IVSRealTime) CreateParticipantTokenRequest(input *CreateParticipantTokenInput) (req *request.Request, output *CreateParticipantTokenOutput) {
	op := &request.Operation{
		Name:       opCreateParticipantToken,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateParticipantToken",
	}

	if input == nil {
		input = &CreateParticipantTokenInput{}
	}

	output = &CreateParticipantTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateParticipantToken API operation for Amazon Interactive Video Service RealTime.
//
// Creates an additional token for a specified stage. This can be done after
// stage creation or when tokens expire. Tokens always are scoped to the stage
// for which they are created.
//
// Encryption keys are owned by Amazon IVS and never used directly by your application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation CreateParticipantToken for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ServiceQuotaExceededException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateParticipantToken
func (c *IVSRealTime) CreateParticipantToken(input *CreateParticipantTokenInput) (*CreateParticipantTokenOutput, error) {
	req, out := c.CreateParticipantTokenRequest(input)
	return out, req.Send()
}

// CreateParticipantTokenWithContext is the same as CreateParticipantToken with the addition of
// the ability to pass a context and additional request options.
//
// See CreateParticipantToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) CreateParticipantTokenWithContext(ctx aws.Context, input *CreateParticipantTokenInput, opts ...request.Option) (*CreateParticipantTokenOutput, error) {
	req, out := c.CreateParticipantTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStage = "CreateStage"

// CreateStageRequest generates a "aws/request.Request" representing the
// client's request for the CreateStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStage for more information on using the CreateStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStageRequest method.
//	req, resp := client.CreateStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateStage
func (c *IVSRealTime) CreateStageRequest(input *CreateStageInput) (req *request.Request, output *CreateStageOutput) {
	op := &request.Operation{
		Name:       opCreateStage,
		HTTPMethod: "POST",
		HTTPPath:   "/CreateStage",
	}

	if input == nil {
		input = &CreateStageInput{}
	}

	output = &CreateStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStage API operation for Amazon Interactive Video Service RealTime.
//
// Creates a new stage (and optionally participant tokens).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation CreateStage for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ServiceQuotaExceededException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/CreateStage
func (c *IVSRealTime) CreateStage(input *CreateStageInput) (*CreateStageOutput, error) {
	req, out := c.CreateStageRequest(input)
	return out, req.Send()
}

// CreateStageWithContext is the same as CreateStage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) CreateStageWithContext(ctx aws.Context, input *CreateStageInput, opts ...request.Option) (*CreateStageOutput, error) {
	req, out := c.CreateStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStage = "DeleteStage"

// DeleteStageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStage for more information on using the DeleteStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStageRequest method.
//	req, resp := client.DeleteStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteStage
func (c *IVSRealTime) DeleteStageRequest(input *DeleteStageInput) (req *request.Request, output *DeleteStageOutput) {
	op := &request.Operation{
		Name:       opDeleteStage,
		HTTPMethod: "POST",
		HTTPPath:   "/DeleteStage",
	}

	if input == nil {
		input = &DeleteStageInput{}
	}

	output = &DeleteStageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStage API operation for Amazon Interactive Video Service RealTime.
//
// Shuts down and deletes the specified stage (disconnecting all participants).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation DeleteStage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ConflictException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DeleteStage
func (c *IVSRealTime) DeleteStage(input *DeleteStageInput) (*DeleteStageOutput, error) {
	req, out := c.DeleteStageRequest(input)
	return out, req.Send()
}

// DeleteStageWithContext is the same as DeleteStage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) DeleteStageWithContext(ctx aws.Context, input *DeleteStageInput, opts ...request.Option) (*DeleteStageOutput, error) {
	req, out := c.DeleteStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisconnectParticipant = "DisconnectParticipant"

// DisconnectParticipantRequest generates a "aws/request.Request" representing the
// client's request for the DisconnectParticipant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisconnectParticipant for more information on using the DisconnectParticipant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisconnectParticipantRequest method.
//	req, resp := client.DisconnectParticipantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DisconnectParticipant
func (c *IVSRealTime) DisconnectParticipantRequest(input *DisconnectParticipantInput) (req *request.Request, output *DisconnectParticipantOutput) {
	op := &request.Operation{
		Name:       opDisconnectParticipant,
		HTTPMethod: "POST",
		HTTPPath:   "/DisconnectParticipant",
	}

	if input == nil {
		input = &DisconnectParticipantInput{}
	}

	output = &DisconnectParticipantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisconnectParticipant API operation for Amazon Interactive Video Service RealTime.
//
// Disconnects a specified participant and revokes the participant permanently
// from a specified stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation DisconnectParticipant for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/DisconnectParticipant
func (c *IVSRealTime) DisconnectParticipant(input *DisconnectParticipantInput) (*DisconnectParticipantOutput, error) {
	req, out := c.DisconnectParticipantRequest(input)
	return out, req.Send()
}

// DisconnectParticipantWithContext is the same as DisconnectParticipant with the addition of
// the ability to pass a context and additional request options.
//
// See DisconnectParticipant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) DisconnectParticipantWithContext(ctx aws.Context, input *DisconnectParticipantInput, opts ...request.Option) (*DisconnectParticipantOutput, error) {
	req, out := c.DisconnectParticipantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStage = "GetStage"

// GetStageRequest generates a "aws/request.Request" representing the
// client's request for the GetStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStage for more information on using the GetStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStageRequest method.
//	req, resp := client.GetStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStage
func (c *IVSRealTime) GetStageRequest(input *GetStageInput) (req *request.Request, output *GetStageOutput) {
	op := &request.Operation{
		Name:       opGetStage,
		HTTPMethod: "POST",
		HTTPPath:   "/GetStage",
	}

	if input == nil {
		input = &GetStageInput{}
	}

	output = &GetStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStage API operation for Amazon Interactive Video Service RealTime.
//
// Gets information for the specified stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation GetStage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/GetStage
func (c *IVSRealTime) GetStage(input *GetStageInput) (*GetStageOutput, error) {
	req, out := c.GetStageRequest(input)
	return out, req.Send()
}

// GetStageWithContext is the same as GetStage with the addition of
// the ability to pass a context and additional request options.
//
// See GetStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) GetStageWithContext(ctx aws.Context, input *GetStageInput, opts ...request.Option) (*GetStageOutput, error) {
	req, out := c.GetStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListStages = "ListStages"

// ListStagesRequest generates a "aws/request.Request" representing the
// client's request for the ListStages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStages for more information on using the ListStages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStagesRequest method.
//	req, resp := client.ListStagesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStages
func (c *IVSRealTime) ListStagesRequest(input *ListStagesInput) (req *request.Request, output *ListStagesOutput) {
	op := &request.Operation{
		Name:       opListStages,
		HTTPMethod: "POST",
		HTTPPath:   "/ListStages",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStagesInput{}
	}

	output = &ListStagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListStages API operation for Amazon Interactive Video Service RealTime.
//
// Gets summary information about all stages in your account, in the AWS region
// where the API request is processed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListStages for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ConflictException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListStages
func (c *IVSRealTime) ListStages(input *ListStagesInput) (*ListStagesOutput, error) {
	req, out := c.ListStagesRequest(input)
	return out, req.Send()
}

// ListStagesWithContext is the same as ListStages with the addition of
// the ability to pass a context and additional request options.
//
// See ListStages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListStagesWithContext(ctx aws.Context, input *ListStagesInput, opts ...request.Option) (*ListStagesOutput, error) {
	req, out := c.ListStagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStagesPages iterates over the pages of a ListStages operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStages method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStages operation.
//	pageNum := 0
//	err := client.ListStagesPages(params,
//	    func(page *ivsrealtime.ListStagesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *IVSRealTime) ListStagesPages(input *ListStagesInput, fn func(*ListStagesOutput, bool) bool) error {
	return c.ListStagesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStagesPagesWithContext same as ListStagesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListStagesPagesWithContext(ctx aws.Context, input *ListStagesInput, fn func(*ListStagesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStagesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStagesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStagesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListTagsForResource
func (c *IVSRealTime) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Interactive Video Service RealTime.
//
// Gets information about AWS tags for the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/ListTagsForResource
func (c *IVSRealTime) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/TagResource
func (c *IVSRealTime) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Interactive Video Service RealTime.
//
// Adds or updates tags for the AWS resource with the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/TagResource
func (c *IVSRealTime) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UntagResource
func (c *IVSRealTime) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Interactive Video Service RealTime.
//
// Removes tags from the resource with the specified ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - InternalServerException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UntagResource
func (c *IVSRealTime) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStage = "UpdateStage"

// UpdateStageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStage for more information on using the UpdateStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStageRequest method.
//	req, resp := client.UpdateStageRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UpdateStage
func (c *IVSRealTime) UpdateStageRequest(input *UpdateStageInput) (req *request.Request, output *UpdateStageOutput) {
	op := &request.Operation{
		Name:       opUpdateStage,
		HTTPMethod: "POST",
		HTTPPath:   "/UpdateStage",
	}

	if input == nil {
		input = &UpdateStageInput{}
	}

	output = &UpdateStageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStage API operation for Amazon Interactive Video Service RealTime.
//
// Updates a stage’s configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Interactive Video Service RealTime's
// API operation UpdateStage for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//
//   - ValidationException
//
//   - AccessDeniedException
//
//   - ServiceQuotaExceededException
//
//   - PendingVerification
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/ivs-realtime-2020-07-14/UpdateStage
func (c *IVSRealTime) UpdateStage(input *UpdateStageInput) (*UpdateStageOutput, error) {
	req, out := c.UpdateStageRequest(input)
	return out, req.Send()
}

// UpdateStageWithContext is the same as UpdateStage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IVSRealTime) UpdateStageWithContext(ctx aws.Context, input *UpdateStageInput, opts ...request.Option) (*UpdateStageOutput, error) {
	req, out := c.UpdateStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// User does not have sufficient access to perform this action.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Updating or deleting a resource can cause an inconsistent state.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateParticipantTokenInput struct {
	_ struct{} `type:"structure"`

	// Application-provided attributes to encode into the token and attach to a
	// stage. Map keys and values can contain UTF-8 encoded text. The maximum length
	// of this field is 1 KB total. This field is exposed to all stage participants
	// and should not be used for personally identifying, confidential, or sensitive
	// information.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Set of capabilities that the user is allowed to perform in the stage. Default:
	// PUBLISH, SUBSCRIBE.
	Capabilities []*string `locationName:"capabilities" type:"list" enum:"ParticipantTokenCapability"`

	// Duration (in minutes), after which the token expires. Default: 60 (1 hour).
	Duration *int64 `locationName:"duration" min:"1" type:"integer"`

	// ARN of the stage to which this token is scoped.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`

	// Name that can be specified to help identify the token. This can be any UTF-8
	// encoded text. This field is exposed to all stage participants and should
	// not be used for personally identifying, confidential, or sensitive information.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantTokenInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateParticipantTokenInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateParticipantTokenInput"}
	if s.Duration != nil && *s.Duration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Duration", 1))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *CreateParticipantTokenInput) SetAttributes(v map[string]*string) *CreateParticipantTokenInput {
	s.Attributes = v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *CreateParticipantTokenInput) SetCapabilities(v []*string) *CreateParticipantTokenInput {
	s.Capabilities = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *CreateParticipantTokenInput) SetDuration(v int64) *CreateParticipantTokenInput {
	s.Duration = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *CreateParticipantTokenInput) SetStageArn(v string) *CreateParticipantTokenInput {
	s.StageArn = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateParticipantTokenInput) SetUserId(v string) *CreateParticipantTokenInput {
	s.UserId = &v
	return s
}

type CreateParticipantTokenOutput struct {
	_ struct{} `type:"structure"`

	// The participant token that was created.
	ParticipantToken *ParticipantToken `locationName:"participantToken" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantTokenOutput) GoString() string {
	return s.String()
}

// SetParticipantToken sets the ParticipantToken field's value.
func (s *CreateParticipantTokenOutput) SetParticipantToken(v *ParticipantToken) *CreateParticipantTokenOutput {
	s.ParticipantToken = v
	return s
}

type CreateStageInput struct {
	_ struct{} `type:"structure"`

	// Optional name that can be specified for the stage being created.
	Name *string `locationName:"name" type:"string"`

	// Array of participant token configuration objects to attach to the new stage.
	ParticipantTokenConfigurations []*ParticipantTokenConfiguration `locationName:"participantTokenConfigurations" type:"list"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStageInput"}
	if s.ParticipantTokenConfigurations != nil {
		for i, v := range s.ParticipantTokenConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParticipantTokenConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateStageInput) SetName(v string) *CreateStageInput {
	s.Name = &v
	return s
}

// SetParticipantTokenConfigurations sets the ParticipantTokenConfigurations field's value.
func (s *CreateStageInput) SetParticipantTokenConfigurations(v []*ParticipantTokenConfiguration) *CreateStageInput {
	s.ParticipantTokenConfigurations = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStageInput) SetTags(v map[string]*string) *CreateStageInput {
	s.Tags = v
	return s
}

type CreateStageOutput struct {
	_ struct{} `type:"structure"`

	// Participant tokens attached to the stage. These correspond to the participants
	// in the request.
	ParticipantTokens []*ParticipantToken `locationName:"participantTokens" type:"list"`

	// The stage that was created.
	Stage *Stage `locationName:"stage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageOutput) GoString() string {
	return s.String()
}

// SetParticipantTokens sets the ParticipantTokens field's value.
func (s *CreateStageOutput) SetParticipantTokens(v []*ParticipantToken) *CreateStageOutput {
	s.ParticipantTokens = v
	return s
}

// SetStage sets the Stage field's value.
func (s *CreateStageOutput) SetStage(v *Stage) *CreateStageOutput {
	s.Stage = v
	return s
}

type DeleteStageInput struct {
	_ struct{} `type:"structure"`

	// ARN of the stage to be deleted.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStageInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeleteStageInput) SetArn(v string) *DeleteStageInput {
	s.Arn = &v
	return s
}

type DeleteStageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageOutput) GoString() string {
	return s.String()
}

type DisconnectParticipantInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the participant to be disconnected. This is returned by CreateParticipantToken.
	//
	// ParticipantId is a required field
	ParticipantId *string `locationName:"participantId" type:"string" required:"true"`

	// Description of why this participant is being disconnected.
	Reason *string `locationName:"reason" type:"string"`

	// ARN of the stage to which the participant is attached.
	//
	// StageArn is a required field
	StageArn *string `locationName:"stageArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectParticipantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisconnectParticipantInput"}
	if s.ParticipantId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParticipantId"))
	}
	if s.StageArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StageArn"))
	}
	if s.StageArn != nil && len(*s.StageArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParticipantId sets the ParticipantId field's value.
func (s *DisconnectParticipantInput) SetParticipantId(v string) *DisconnectParticipantInput {
	s.ParticipantId = &v
	return s
}

// SetReason sets the Reason field's value.
func (s *DisconnectParticipantInput) SetReason(v string) *DisconnectParticipantInput {
	s.Reason = &v
	return s
}

// SetStageArn sets the StageArn field's value.
func (s *DisconnectParticipantInput) SetStageArn(v string) *DisconnectParticipantInput {
	s.StageArn = &v
	return s
}

type DisconnectParticipantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisconnectParticipantOutput) GoString() string {
	return s.String()
}

type GetStageInput struct {
	_ struct{} `type:"structure"`

	// ARN of the stage for which the information is to be retrieved.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStageInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *GetStageInput) SetArn(v string) *GetStageInput {
	s.Arn = &v
	return s
}

type GetStageOutput struct {
	_ struct{} `type:"structure"`

	// Object specifying a stage.
	Stage *Stage `locationName:"stage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageOutput) GoString() string {
	return s.String()
}

// SetStage sets the Stage field's value.
func (s *GetStageOutput) SetStage(v *Stage) *GetStageOutput {
	s.Stage = v
	return s
}

type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Unexpected error during processing of request.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListStagesInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Default: 50.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The first stage to retrieve. This is used for pagination; see the nextToken
	// response field.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStagesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStagesInput) SetMaxResults(v int64) *ListStagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStagesInput) SetNextToken(v string) *ListStagesInput {
	s.NextToken = &v
	return s
}

type ListStagesOutput struct {
	_ struct{} `type:"structure"`

	// If there are more rooms than maxResults, use nextToken in the request to
	// get the next set.
	NextToken *string `locationName:"nextToken" type:"string"`

	// List of the matching stages (summary information only).
	//
	// Stages is a required field
	Stages []*StageSummary `locationName:"stages" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStagesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStagesOutput) SetNextToken(v string) *ListStagesOutput {
	s.NextToken = &v
	return s
}

// SetStages sets the Stages field's value.
func (s *ListStagesOutput) SetStages(v []*StageSummary) *ListStagesOutput {
	s.Stages = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource to be retrieved. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value).
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Object specifying a participant token in a stage.
type ParticipantToken struct {
	_ struct{} `type:"structure"`

	// Application-provided attributes to encode into the token and attach to a
	// stage. This field is exposed to all stage participants and should not be
	// used for personally identifying, confidential, or sensitive information.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Set of capabilities that the user is allowed to perform in the stage.
	Capabilities []*string `locationName:"capabilities" type:"list" enum:"ParticipantTokenCapability"`

	// Duration (in minutes), after which the participant token expires. Default:
	// 60 (1 hour).
	Duration *int64 `locationName:"duration" min:"1" type:"integer"`

	// ISO 8601 timestamp (returned as a string) for when this token expires.
	ExpirationTime *time.Time `locationName:"expirationTime" type:"timestamp" timestampFormat:"iso8601"`

	// Unique identifier for this participant token, assigned by IVS.
	ParticipantId *string `locationName:"participantId" type:"string"`

	// The issued client token, encrypted.
	//
	// Token is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ParticipantToken's
	// String and GoString methods.
	Token *string `locationName:"token" type:"string" sensitive:"true"`

	// Name to help identify the token. This can be any UTF-8 encoded text. This
	// field is exposed to all stage participants and should not be used for personally
	// identifying, confidential, or sensitive information.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantToken) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantToken) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *ParticipantToken) SetAttributes(v map[string]*string) *ParticipantToken {
	s.Attributes = v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *ParticipantToken) SetCapabilities(v []*string) *ParticipantToken {
	s.Capabilities = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ParticipantToken) SetDuration(v int64) *ParticipantToken {
	s.Duration = &v
	return s
}

// SetExpirationTime sets the ExpirationTime field's value.
func (s *ParticipantToken) SetExpirationTime(v time.Time) *ParticipantToken {
	s.ExpirationTime = &v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *ParticipantToken) SetParticipantId(v string) *ParticipantToken {
	s.ParticipantId = &v
	return s
}

// SetToken sets the Token field's value.
func (s *ParticipantToken) SetToken(v string) *ParticipantToken {
	s.Token = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ParticipantToken) SetUserId(v string) *ParticipantToken {
	s.UserId = &v
	return s
}

// Object specifying a participant token configuration in a stage.
type ParticipantTokenConfiguration struct {
	_ struct{} `type:"structure"`

	// Application-provided attributes to encode into the corresponding participant
	// token and attach to a stage. Map keys and values can contain UTF-8 encoded
	// text. The maximum length of this field is 1 KB total. This field is exposed
	// to all stage participants and should not be used for personally identifying,
	// confidential, or sensitive information.
	Attributes map[string]*string `locationName:"attributes" type:"map"`

	// Set of capabilities that the user is allowed to perform in the stage.
	Capabilities []*string `locationName:"capabilities" type:"list" enum:"ParticipantTokenCapability"`

	// Duration (in minutes), after which the corresponding participant token expires.
	// Default: 60 (1 hour).
	Duration *int64 `locationName:"duration" min:"1" type:"integer"`

	// Name that can be specified to help identify the corresponding participant
	// token. This can be any UTF-8 encoded text. This field is exposed to all stage
	// participants and should not be used for personally identifying, confidential,
	// or sensitive information.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantTokenConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParticipantTokenConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParticipantTokenConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParticipantTokenConfiguration"}
	if s.Duration != nil && *s.Duration < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Duration", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *ParticipantTokenConfiguration) SetAttributes(v map[string]*string) *ParticipantTokenConfiguration {
	s.Attributes = v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *ParticipantTokenConfiguration) SetCapabilities(v []*string) *ParticipantTokenConfiguration {
	s.Capabilities = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *ParticipantTokenConfiguration) SetDuration(v int64) *ParticipantTokenConfiguration {
	s.Duration = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *ParticipantTokenConfiguration) SetUserId(v string) *ParticipantTokenConfiguration {
	s.UserId = &v
	return s
}

type PendingVerification struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Your account is pending verification.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingVerification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PendingVerification) GoString() string {
	return s.String()
}

func newErrorPendingVerification(v protocol.ResponseMetadata) error {
	return &PendingVerification{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PendingVerification) Code() string {
	return "PendingVerification"
}

// Message returns the exception's message.
func (s *PendingVerification) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PendingVerification) OrigErr() error {
	return nil
}

func (s *PendingVerification) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PendingVerification) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PendingVerification) RequestID() string {
	return s.RespMetadata.RequestID
}

type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Request references a resource which does not exist.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Request would cause a service quota to be exceeded.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Object specifying a stage.
type Stage struct {
	_ struct{} `type:"structure"`

	// ID of the active session within the stage.
	ActiveSessionId *string `locationName:"activeSessionId" min:"16" type:"string"`

	// Stage ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Stage name.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stage) GoString() string {
	return s.String()
}

// SetActiveSessionId sets the ActiveSessionId field's value.
func (s *Stage) SetActiveSessionId(v string) *Stage {
	s.ActiveSessionId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Stage) SetArn(v string) *Stage {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Stage) SetName(v string) *Stage {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Stage) SetTags(v map[string]*string) *Stage {
	s.Tags = v
	return s
}

// Summary information about a stage.
type StageSummary struct {
	_ struct{} `type:"structure"`

	// ID of the active session within the stage.
	ActiveSessionId *string `locationName:"activeSessionId" min:"16" type:"string"`

	// Stage ARN.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Stage name.
	Name *string `locationName:"name" type:"string"`

	// Tags attached to the resource. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints on tags beyond what is documented
	// there.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageSummary) GoString() string {
	return s.String()
}

// SetActiveSessionId sets the ActiveSessionId field's value.
func (s *StageSummary) SetActiveSessionId(v string) *StageSummary {
	s.ActiveSessionId = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *StageSummary) SetArn(v string) *StageSummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *StageSummary) SetName(v string) *StageSummary {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StageSummary) SetTags(v map[string]*string) *StageSummary {
	s.Tags = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource to be tagged. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Array of tags to be added or updated. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints beyond what is documented
	// there.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the resource to be untagged. The ARN must be URL-encoded.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// Array of tags to be removed. Array of maps, each of the form string:string
	// (key:value). See Tagging AWS Resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// for details, including restrictions that apply to tags and "Tag naming limits
	// and requirements"; Amazon IVS has no constraints beyond what is documented
	// there.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateStageInput struct {
	_ struct{} `type:"structure"`

	// ARN of the stage to be updated.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// Name of the stage to be updated.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStageInput"}
	if s.Arn == nil {
		invalidParams.Add(request.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *UpdateStageInput) SetArn(v string) *UpdateStageInput {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateStageInput) SetName(v string) *UpdateStageInput {
	s.Name = &v
	return s
}

type UpdateStageOutput struct {
	_ struct{} `type:"structure"`

	// The updated stage.
	Stage *Stage `locationName:"stage" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageOutput) GoString() string {
	return s.String()
}

// SetStage sets the Stage field's value.
func (s *UpdateStageOutput) SetStage(v *Stage) *UpdateStageOutput {
	s.Stage = v
	return s
}

type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The input fails to satisfy the constraints specified by an Amazon Web Services
	// service.
	ExceptionMessage *string `locationName:"exceptionMessage" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ParticipantTokenCapabilityPublish is a ParticipantTokenCapability enum value
	ParticipantTokenCapabilityPublish = "PUBLISH"

	// ParticipantTokenCapabilitySubscribe is a ParticipantTokenCapability enum value
	ParticipantTokenCapabilitySubscribe = "SUBSCRIBE"
)

// ParticipantTokenCapability_Values returns all elements of the ParticipantTokenCapability enum
func ParticipantTokenCapability_Values() []string {
	return []string{
		ParticipantTokenCapabilityPublish,
		ParticipantTokenCapabilitySubscribe,
	}
}
