/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import redis.clients.jedis.Endpoint;
import redis.clients.jedis.mcf.HealthCheck;
import redis.clients.jedis.mcf.HealthCheckCollection;
import redis.clients.jedis.mcf.HealthCheckImpl;
import redis.clients.jedis.mcf.HealthCheckStrategy;
import redis.clients.jedis.mcf.HealthStatus;
import redis.clients.jedis.mcf.HealthStatusChangeEvent;
import redis.clients.jedis.mcf.HealthStatusListener;

public class HealthStatusManager {
    private final HealthCheckCollection healthChecks = new HealthCheckCollection();
    private final List<HealthStatusListener> listeners = new CopyOnWriteArrayList<HealthStatusListener>();
    private final Map<Endpoint, List<HealthStatusListener>> endpointListeners = new ConcurrentHashMap<Endpoint, List<HealthStatusListener>>();

    public void registerListener(HealthStatusListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(HealthStatusListener listener) {
        this.listeners.remove(listener);
    }

    public void registerListener(Endpoint endpoint, HealthStatusListener listener) {
        this.endpointListeners.computeIfAbsent(endpoint, k -> new CopyOnWriteArrayList()).add(listener);
    }

    public void unregisterListener(Endpoint endpoint, HealthStatusListener listener) {
        this.endpointListeners.computeIfPresent(endpoint, (k, v) -> {
            v.remove(listener);
            return v;
        });
    }

    public void notifyListeners(HealthStatusChangeEvent eventArgs) {
        this.endpointListeners.computeIfPresent(eventArgs.getEndpoint(), (k, v) -> {
            for (HealthStatusListener listener : v) {
                listener.onStatusChange(eventArgs);
            }
            return v;
        });
        for (HealthStatusListener listener : this.listeners) {
            listener.onStatusChange(eventArgs);
        }
    }

    public HealthCheck add(Endpoint endpoint, HealthCheckStrategy strategy) {
        HealthCheckImpl hc = new HealthCheckImpl(endpoint, strategy, this::notifyListeners);
        HealthCheck old = this.healthChecks.add(hc);
        hc.start();
        if (old != null) {
            old.stop();
        }
        return hc;
    }

    public void addAll(Endpoint[] endpoints, HealthCheckStrategy strategy) {
        for (Endpoint endpoint : endpoints) {
            this.add(endpoint, strategy);
        }
    }

    public void remove(Endpoint endpoint) {
        HealthCheck old = this.healthChecks.remove(endpoint);
        if (old != null) {
            old.stop();
        }
    }

    public void removeAll(Endpoint[] endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.remove(endpoint);
        }
    }

    public HealthStatus getHealthStatus(Endpoint endpoint) {
        HealthCheck healthCheck = this.healthChecks.get(endpoint);
        return healthCheck != null ? healthCheck.getStatus() : HealthStatus.UNKNOWN;
    }

    public boolean hasHealthCheck(Endpoint endpoint) {
        return this.healthChecks.get(endpoint) != null;
    }

    public long getMaxWaitFor(Endpoint endpoint) {
        HealthCheck healthCheck = this.healthChecks.get(endpoint);
        return healthCheck != null ? healthCheck.getMaxWaitFor() : 0L;
    }

    public void close() {
        this.healthChecks.close();
    }
}

