/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal.util;

import com.ethlo.time.Duration;

public class DurationFormatter {
    private static final long SECONDS_IN_MINUTE = 60L;
    private static final long SECONDS_IN_HOUR = 3600L;
    private static final long SECONDS_IN_DAY = 86400L;
    private static final long SECONDS_IN_WEEK = 604800L;

    public static String normalizeDuration(Duration duration) {
        long minutes;
        long hours;
        long days;
        boolean negative;
        long seconds = duration.getSeconds();
        int nanos = duration.getNanos();
        if (seconds == 0L && nanos == 0) {
            return "PT0S";
        }
        StringBuilder s = new StringBuilder();
        boolean bl = negative = seconds < 0L;
        if (negative) {
            s.append('-');
            seconds = nanos > 0 ? seconds * -1L - 1L : seconds * -1L;
        }
        s.append('P');
        long weeks = seconds / 604800L;
        if (weeks > 0L) {
            s.append(weeks).append("W");
            seconds %= 604800L;
        }
        if ((days = seconds / 86400L) > 0L) {
            s.append(days).append("D");
            seconds %= 86400L;
        }
        if (seconds > 0L || nanos > 0) {
            s.append("T");
        }
        if ((hours = seconds / 3600L) > 0L) {
            s.append(hours).append("H");
            seconds %= 3600L;
        }
        if ((minutes = seconds / 60L) > 0L) {
            s.append(minutes).append("M");
            seconds %= 60L;
        }
        if (seconds > 0L || nanos > 0) {
            s.append(seconds);
            if (nanos > 0) {
                int endIndex;
                String fractionalPart = String.format("%09d", negative ? 1000000000 - nanos : nanos);
                for (endIndex = fractionalPart.length(); endIndex > 0 && fractionalPart.charAt(endIndex - 1) == '0'; --endIndex) {
                }
                if (endIndex > 0) {
                    s.append(".").append(fractionalPart, 0, endIndex);
                }
            }
            s.append("S");
        }
        return s.toString();
    }
}

