/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdBitBlt
extends MfCmd {
    private static final int POS_ROP = 0;
    private static final int POS_Y_SOURCE_ORIGIN = 1;
    private static final int POS_X_SOURCE_ORIGIN = 2;
    private static final int POS_DESTINATION_Y_EXT = 3;
    private static final int POS_DESTINATION_X_EXT = 4;
    private static final int POS_Y_DESTINATION_ORIGIN = 5;
    private static final int POS_X_DESTINATION_ORIGIN = 6;
    private static final int POS_BITMAP_WIDTH = 7;
    private static final int POS_BITMAP_HEIGHT = 8;
    private static final int POS_BYTES_PER_RASTER_LINE = 9;
    private static final int POS_COLOR_PLANES_BITMAP = 10;
    private static final int POS_ADJACENT_COLOR_BITS = 11;
    private static final int POS_DEVICE_DEPENDENT_BITMAP_BITS = 12;
    private int rop;
    private int sourceY;
    private int sourceX;
    private int destXExt;
    private int destYExt;
    private int destXOrigin;
    private int destYOrigin;
    private int bitmapWidth;
    private int bitmapHeight;
    private int bytesPerRasterLine;
    private int colorPlanesBitmap;
    private int adjacentColorBits;
    private byte[] deviceDependentBitmap;

    public void replay(WmfFile file) {
    }

    public MfCmd getInstance() {
        return new MfCmdBitBlt();
    }

    public void setRecord(MfRecord record) {
        this.setRop(record.getParam(0));
        this.setSourceX(record.getParam(1));
        this.setSourceY(record.getParam(2));
        this.setDestXExt(record.getParam(4));
        this.setDestYExt(record.getParam(3));
        this.setDestXOrigin(record.getParam(6));
        this.setDestYOrigin(record.getParam(5));
        this.setBitmapWidth(record.getParam(7));
        this.setBitmapHeight(record.getParam(8));
        this.setBytesPerRasterLine(record.getParam(9));
        this.setColorPlanesBitmap(record.getParam(10));
        this.setAdjacentColorBits(record.getParam(11));
    }

    public String toString() {
        StringBuffer b = new StringBuffer(100);
        b.append("[OLD_BIT_BLT]");
        return b.toString();
    }

    public int getFunction() {
        return 2338;
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(12 + this.deviceDependentBitmap.length / 4);
        record.setParam(0, this.getRop());
        record.setParam(1, this.getSourceX());
        record.setParam(2, this.getSourceY());
        record.setParam(4, this.getDestXExt());
        record.setParam(3, this.getDestYExt());
        record.setParam(6, this.getDestXOrigin());
        record.setParam(5, this.getDestYOrigin());
        record.setParam(7, this.getBitmapWidth());
        record.setParam(8, this.getBitmapHeight());
        record.setParam(9, this.getBytesPerRasterLine());
        record.setParam(10, this.getColorPlanesBitmap());
        record.setParam(11, this.getAdjacentColorBits());
        return record;
    }

    public int getAdjacentColorBits() {
        return this.adjacentColorBits;
    }

    public void setAdjacentColorBits(int adjacentColorBits) {
        this.adjacentColorBits = adjacentColorBits;
    }

    public int getBitmapHeight() {
        return this.bitmapHeight;
    }

    public void setBitmapHeight(int bitmapHeight) {
        this.bitmapHeight = bitmapHeight;
    }

    public int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public void setBitmapWidth(int bitmapWidth) {
        this.bitmapWidth = bitmapWidth;
    }

    public int getBytesPerRasterLine() {
        return this.bytesPerRasterLine;
    }

    public void setBytesPerRasterLine(int bytesPerRasterLine) {
        this.bytesPerRasterLine = bytesPerRasterLine;
    }

    public int getColorPlanesBitmap() {
        return this.colorPlanesBitmap;
    }

    public void setColorPlanesBitmap(int colorPlanesBitmap) {
        this.colorPlanesBitmap = colorPlanesBitmap;
    }

    public int getDestXExt() {
        return this.destXExt;
    }

    public void setDestXExt(int destXExt) {
        this.destXExt = destXExt;
    }

    public int getDestXOrigin() {
        return this.destXOrigin;
    }

    public void setDestXOrigin(int destXOrigin) {
        this.destXOrigin = destXOrigin;
    }

    public int getDestYExt() {
        return this.destYExt;
    }

    public void setDestYExt(int destYExt) {
        this.destYExt = destYExt;
    }

    public int getDestYOrigin() {
        return this.destYOrigin;
    }

    public void setDestYOrigin(int destYOrigin) {
        this.destYOrigin = destYOrigin;
    }

    public byte[] getDeviceDependentBitmap() {
        return this.deviceDependentBitmap;
    }

    public void setDeviceDependentBitmap(byte[] deviceDependentBitmap) {
        this.deviceDependentBitmap = deviceDependentBitmap;
    }

    public int getRop() {
        return this.rop;
    }

    public void setRop(int rop) {
        this.rop = rop;
    }

    public int getSourceX() {
        return this.sourceX;
    }

    public void setSourceX(int sourceX) {
        this.sourceX = sourceX;
    }

    public int getSourceY() {
        return this.sourceY;
    }

    public void setSourceY(int sourceY) {
        this.sourceY = sourceY;
    }
}

