// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolExponentialHistogramDataPoint_Buckets = sync.Pool{
		New: func() any {
			return &otlpmetrics.ExponentialHistogramDataPoint_Buckets{}
		},
	}
)

func NewOrigExponentialHistogramDataPoint_Buckets() *otlpmetrics.ExponentialHistogramDataPoint_Buckets {
	if !UseProtoPooling.IsEnabled() {
		return &otlpmetrics.ExponentialHistogramDataPoint_Buckets{}
	}
	return protoPoolExponentialHistogramDataPoint_Buckets.Get().(*otlpmetrics.ExponentialHistogramDataPoint_Buckets)
}

func DeleteOrigExponentialHistogramDataPoint_Buckets(orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolExponentialHistogramDataPoint_Buckets.Put(orig)
	}
}

func CopyOrigExponentialHistogramDataPoint_Buckets(dest, src *otlpmetrics.ExponentialHistogramDataPoint_Buckets) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.Offset = src.Offset
	dest.BucketCounts = CopyOrigUint64Slice(dest.BucketCounts, src.BucketCounts)
}

func GenTestOrigExponentialHistogramDataPoint_Buckets() *otlpmetrics.ExponentialHistogramDataPoint_Buckets {
	orig := NewOrigExponentialHistogramDataPoint_Buckets()
	orig.Offset = int32(13)
	orig.BucketCounts = GenerateOrigTestUint64Slice()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExponentialHistogramDataPoint_Buckets(orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Offset != int32(0) {
		dest.WriteObjectField("offset")
		dest.WriteInt32(orig.Offset)
	}
	if len(orig.BucketCounts) > 0 {
		dest.WriteObjectField("bucketCounts")
		dest.WriteArrayStart()
		dest.WriteUint64(orig.BucketCounts[0])
		for i := 1; i < len(orig.BucketCounts); i++ {
			dest.WriteMore()
			dest.WriteUint64(orig.BucketCounts[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExponentialHistogramDataPointBuckets unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExponentialHistogramDataPoint_Buckets(orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "offset":
			orig.Offset = iter.ReadInt32()
		case "bucketCounts", "bucket_counts":
			for iter.ReadArray() {
				orig.BucketCounts = append(orig.BucketCounts, iter.ReadUint64())
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigExponentialHistogramDataPoint_Buckets(orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets) int {
	var n int
	var l int
	_ = l
	if orig.Offset != 0 {
		n += 1 + proto.Soz(uint64(orig.Offset))
	}
	if len(orig.BucketCounts) > 0 {
		l = 0
		for _, e := range orig.BucketCounts {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigExponentialHistogramDataPoint_Buckets(orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.Offset != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64((uint32(orig.Offset)<<1)^uint32(orig.Offset>>31)))
		pos--
		buf[pos] = 0x8
	}
	l = len(orig.BucketCounts)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.BucketCounts[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x12
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExponentialHistogramDataPoint_Buckets(orig *otlpmetrics.ExponentialHistogramDataPoint_Buckets, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.Offset = int32(uint32(num>>1) ^ uint32(int32((num&1)<<31)>>31))
		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field BucketCounts", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var num uint64
			for startPos < pos {
				num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
				if err != nil {
					return err
				}
				orig.BucketCounts = append(orig.BucketCounts, uint64(num))
			}
			if startPos != pos {
				return fmt.Errorf("proto: invalid field len = %d for field BucketCounts", pos-startPos)
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
