// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpcollectortrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/trace/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolExportTracePartialSuccess = sync.Pool{
		New: func() any {
			return &otlpcollectortrace.ExportTracePartialSuccess{}
		},
	}
)

func NewOrigExportTracePartialSuccess() *otlpcollectortrace.ExportTracePartialSuccess {
	if !UseProtoPooling.IsEnabled() {
		return &otlpcollectortrace.ExportTracePartialSuccess{}
	}
	return protoPoolExportTracePartialSuccess.Get().(*otlpcollectortrace.ExportTracePartialSuccess)
}

func DeleteOrigExportTracePartialSuccess(orig *otlpcollectortrace.ExportTracePartialSuccess, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolExportTracePartialSuccess.Put(orig)
	}
}

func CopyOrigExportTracePartialSuccess(dest, src *otlpcollectortrace.ExportTracePartialSuccess) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.RejectedSpans = src.RejectedSpans
	dest.ErrorMessage = src.ErrorMessage
}

func GenTestOrigExportTracePartialSuccess() *otlpcollectortrace.ExportTracePartialSuccess {
	orig := NewOrigExportTracePartialSuccess()
	orig.RejectedSpans = int64(13)
	orig.ErrorMessage = "test_errormessage"
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigExportTracePartialSuccess(orig *otlpcollectortrace.ExportTracePartialSuccess, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.RejectedSpans != int64(0) {
		dest.WriteObjectField("rejectedSpans")
		dest.WriteInt64(orig.RejectedSpans)
	}
	if orig.ErrorMessage != "" {
		dest.WriteObjectField("errorMessage")
		dest.WriteString(orig.ErrorMessage)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigExportPartialSuccess unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigExportTracePartialSuccess(orig *otlpcollectortrace.ExportTracePartialSuccess, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "rejectedSpans", "rejected_spans":
			orig.RejectedSpans = iter.ReadInt64()
		case "errorMessage", "error_message":
			orig.ErrorMessage = iter.ReadString()
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigExportTracePartialSuccess(orig *otlpcollectortrace.ExportTracePartialSuccess) int {
	var n int
	var l int
	_ = l
	if orig.RejectedSpans != 0 {
		n += 1 + proto.Sov(uint64(orig.RejectedSpans))
	}
	l = len(orig.ErrorMessage)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigExportTracePartialSuccess(orig *otlpcollectortrace.ExportTracePartialSuccess, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.RejectedSpans != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.RejectedSpans))
		pos--
		buf[pos] = 0x8
	}
	l = len(orig.ErrorMessage)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.ErrorMessage)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigExportTracePartialSuccess(orig *otlpcollectortrace.ExportTracePartialSuccess, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field RejectedSpans", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.RejectedSpans = int64(num)

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMessage", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ErrorMessage = string(buf[startPos:pos])
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
