// This file is part of MinIO DirectPV
// Copyright (c) 2021, 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/minio/directpv/pkg/apis/direct.csi.min.io/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeDirectCSIVolumes implements DirectCSIVolumeInterface
type FakeDirectCSIVolumes struct {
	Fake *FakeDirectV1alpha1
}

var directcsivolumesResource = schema.GroupVersionResource{Group: "direct.csi.min.io", Version: "v1alpha1", Resource: "directcsivolumes"}

var directcsivolumesKind = schema.GroupVersionKind{Group: "direct.csi.min.io", Version: "v1alpha1", Kind: "DirectCSIVolume"}

// Get takes name of the directCSIVolume, and returns the corresponding directCSIVolume object, and an error if there is any.
func (c *FakeDirectCSIVolumes) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.DirectCSIVolume, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(directcsivolumesResource, name), &v1alpha1.DirectCSIVolume{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DirectCSIVolume), err
}

// List takes label and field selectors, and returns the list of DirectCSIVolumes that match those selectors.
func (c *FakeDirectCSIVolumes) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.DirectCSIVolumeList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(directcsivolumesResource, directcsivolumesKind, opts), &v1alpha1.DirectCSIVolumeList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.DirectCSIVolumeList{ListMeta: obj.(*v1alpha1.DirectCSIVolumeList).ListMeta}
	for _, item := range obj.(*v1alpha1.DirectCSIVolumeList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested directCSIVolumes.
func (c *FakeDirectCSIVolumes) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(directcsivolumesResource, opts))
}

// Create takes the representation of a directCSIVolume and creates it.  Returns the server's representation of the directCSIVolume, and an error, if there is any.
func (c *FakeDirectCSIVolumes) Create(ctx context.Context, directCSIVolume *v1alpha1.DirectCSIVolume, opts v1.CreateOptions) (result *v1alpha1.DirectCSIVolume, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(directcsivolumesResource, directCSIVolume), &v1alpha1.DirectCSIVolume{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DirectCSIVolume), err
}

// Update takes the representation of a directCSIVolume and updates it. Returns the server's representation of the directCSIVolume, and an error, if there is any.
func (c *FakeDirectCSIVolumes) Update(ctx context.Context, directCSIVolume *v1alpha1.DirectCSIVolume, opts v1.UpdateOptions) (result *v1alpha1.DirectCSIVolume, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(directcsivolumesResource, directCSIVolume), &v1alpha1.DirectCSIVolume{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DirectCSIVolume), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeDirectCSIVolumes) UpdateStatus(ctx context.Context, directCSIVolume *v1alpha1.DirectCSIVolume, opts v1.UpdateOptions) (*v1alpha1.DirectCSIVolume, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(directcsivolumesResource, "status", directCSIVolume), &v1alpha1.DirectCSIVolume{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DirectCSIVolume), err
}

// Delete takes name of the directCSIVolume and deletes it. Returns an error if one occurs.
func (c *FakeDirectCSIVolumes) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(directcsivolumesResource, name, opts), &v1alpha1.DirectCSIVolume{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeDirectCSIVolumes) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(directcsivolumesResource, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.DirectCSIVolumeList{})
	return err
}

// Patch applies the patch and returns the patched directCSIVolume.
func (c *FakeDirectCSIVolumes) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.DirectCSIVolume, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(directcsivolumesResource, name, pt, data, subresources...), &v1alpha1.DirectCSIVolume{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.DirectCSIVolume), err
}
