/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ImageDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Options;

public class CopyImage
extends BaseCmd {
    private static final String SOURCE_REGION = "source-region";
    private static final String SOURCE_REGION_DESC = "The region from which to copy the AMI.";
    private static final String SOURCE_AMI_ID = "source-ami-id";
    private static final String SOURCE_AMI_ID_DESC = "The AMI to copy.";
    private static final String AMI_NAME = "name";
    private static final String AMI_NAME_DESC = "The name of the AMI.";
    private static final String AMI_DESCRIPTION = "description";
    private static final String AMI_DESCRIPTION_DESC = "An optional description of the AMI.";
    private static final String CLIENT_TOKEN = "client-token";
    private static final String CLIENT_TOKEN_DESC = "An optional client token for idempotency.";

    public CopyImage(String[] args) {
        super("ec2cpimg", "ec2-copy-image");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options options = new Options();
        options.addOption(CopyImage.createOptionWithArgs("r", SOURCE_REGION, SOURCE_REGION_DESC, "SOURCE_REGION"));
        options.addOption(CopyImage.createOptionWithArgs("s", SOURCE_AMI_ID, SOURCE_AMI_ID_DESC, "SOURCE_AMI_ID"));
        options.addOption(CopyImage.createOptionWithArgs("n", AMI_NAME, AMI_NAME_DESC));
        options.addOption(CopyImage.createOptionWithArgs("d", AMI_DESCRIPTION, AMI_DESCRIPTION_DESC));
        options.addOption(CopyImage.createOptionWithArgs("c", CLIENT_TOKEN, CLIENT_TOKEN_DESC, "TOKEN"));
        return options;
    }

    @Override
    protected String getOptionString() {
        return "-r SOURCE_REGION -s SOURCE_AMI_ID -n AMI_NAME [-d DESCRIPTION] [-c CLIENT_TOKEN]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Copies an AMI to this region from another region.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption(SOURCE_REGION);
        this.printOption(SOURCE_AMI_ID);
        this.printOption(AMI_NAME);
        this.printOption(AMI_DESCRIPTION);
        this.printOption(CLIENT_TOKEN);
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair imageDescriptions;
        this.assertOptionSet(SOURCE_REGION);
        this.assertOptionSet(SOURCE_AMI_ID);
        String sourceRegion = this.getOptionValue(SOURCE_REGION);
        String sourceAmiId = this.getOptionValue(SOURCE_AMI_ID);
        String name = this.getOptionValue(AMI_NAME);
        String description = this.getOptionValue(AMI_DESCRIPTION);
        String clientToken = this.getOptionValue(CLIENT_TOKEN);
        String sourceEndpoint = "cn-north-1".equalsIgnoreCase(sourceRegion) ? "https://ec2.cn-north-1.amazonaws.com.cn" : String.format("https://ec2.%s.amazonaws.com", sourceRegion);
        String destEndpoint = jec2.getEndpoint();
        String destRegion = jec2.getRegion();
        try {
            jec2.setEndpoint(sourceEndpoint, sourceRegion);
        }
        catch (MalformedURLException e) {
            throw new GeneralError("Invalid region specified: " + sourceRegion);
        }
        String[] sourceImage = new String[]{sourceAmiId};
        try {
            imageDescriptions = jec2.describeImages(sourceImage, new ArrayList(0));
        }
        catch (AmazonServiceException e) {
            throw e;
        }
        catch (AmazonClientException e) {
            throw new GeneralError("Unable to connect to host: '" + sourceEndpoint + "'", (Exception)((Object)e));
        }
        catch (UnknownHostException e) {
            throw new GeneralError("Unknown host: '" + sourceEndpoint + "'", e);
        }
        if (((List)imageDescriptions.getResponse()).isEmpty()) {
            throw new GeneralError("Invalid source image: '" + sourceAmiId + "'");
        }
        String imageState = ((ImageDescription)((List)imageDescriptions.getResponse()).get((int)0)).imageState;
        if (!"available".equals(imageState)) {
            throw new GeneralError("Preventing copy of source image '" + sourceAmiId + "' because its status is '" + imageState + "'.");
        }
        jec2.setEndpoint(destEndpoint, destRegion);
        RequestResultPair rsp = jec2.copyImage(sourceRegion, sourceAmiId, name, description, clientToken);
        out.outputImageId(System.out, (String)rsp.getResponse());
        return true;
    }

    public static void main(String[] args) {
        new CopyImage(args).invoke();
    }
}

