/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.processor.Processor;
import org.apache.ws.security.util.Loader;
import org.apache.xml.security.Init;
import org.apache.xml.security.transforms.Transform;

public class WSSConfig {
    private static Log log = LogFactory.getLog((String)(class$org$apache$ws$security$WSSConfig == null ? (class$org$apache$ws$security$WSSConfig = WSSConfig.class$("org.apache.ws.security.WSSConfig")) : class$org$apache$ws$security$WSSConfig).getName());
    protected static WSSConfig defaultConfig = WSSConfig.getNewInstance();
    protected boolean wsiBSPCompliant = false;
    protected boolean precisionInMilliSeconds = true;
    protected boolean enableSignatureConfirmation = true;
    protected boolean timeStampStrict = true;
    protected HashMap jceProvider = new HashMap(10);
    static /* synthetic */ Class class$org$apache$ws$security$WSSConfig;

    protected WSSConfig() {
        Init.init();
        this.addJceProvider("BC", "org.bouncycastle.jce.provider.BouncyCastleProvider");
        this.addJceProvider("JuiCE", "org.apache.security.juice.provider.JuiCEProviderOpenSSL");
        Transform.init();
        try {
            Transform.register((String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", (String)"org.apache.ws.security.transform.STRTransform");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static WSSConfig getNewInstance() {
        WSSConfig config = new WSSConfig();
        return config;
    }

    public static WSSConfig getDefaultWSConfig() {
        return defaultConfig;
    }

    public boolean isWsiBSPCompliant() {
        return this.wsiBSPCompliant;
    }

    public void setWsiBSPCompliant(boolean wsiBSPCompliant) {
        this.wsiBSPCompliant = wsiBSPCompliant;
    }

    public boolean isPrecisionInMilliSeconds() {
        return this.precisionInMilliSeconds;
    }

    public void setPrecisionInMilliSeconds(boolean precisionInMilliSeconds) {
        this.precisionInMilliSeconds = precisionInMilliSeconds;
    }

    public boolean isEnableSignatureConfirmation() {
        return this.enableSignatureConfirmation;
    }

    public void setEnableSignatureConfirmation(boolean enableSignatureConfirmation) {
        this.enableSignatureConfirmation = enableSignatureConfirmation;
    }

    public boolean isTimeStampStrict() {
        return this.timeStampStrict;
    }

    public void setTimeStampStrict(boolean timeStampStrict) {
        this.timeStampStrict = timeStampStrict;
    }

    public Action getAction(int action) throws WSSecurityException {
        String name = null;
        switch (action) {
            case 1: {
                name = "org.apache.ws.security.action.UsernameTokenAction";
                break;
            }
            case 4: {
                name = "org.apache.ws.security.action.EncryptionAction";
                break;
            }
            case 2: {
                name = "org.apache.ws.security.action.SignatureAction";
                break;
            }
            case 16: {
                name = "org.apache.ws.security.action.SAMLTokenSignedAction";
                break;
            }
            case 8: {
                name = "org.apache.ws.security.action.SAMLTokenUnsignedAction";
                break;
            }
            case 32: {
                name = "org.apache.ws.security.action.TimestampAction";
                break;
            }
            case 64: {
                name = "org.apache.ws.security.action.UsernameTokenSignedAction";
                break;
            }
            case 128: {
                name = "org.apache.ws.security.action.SignatureConfirmationAction";
            }
        }
        if (name == null) {
            throw new WSSecurityException(0, "unknownAction", new Object[]{new Integer(action)});
        }
        try {
            return (Action)Loader.loadClass(name).newInstance();
        }
        catch (Throwable t) {
            throw new WSSecurityException(0, "unableToLoadClass", new Object[]{name});
        }
    }

    public Processor getProcessor(QName el) throws WSSecurityException {
        String name = null;
        if (el.equals(WSSecurityEngine.SAML_TOKEN)) {
            name = "org.apache.ws.security.processor.SAMLTokenProcessor";
        } else if (el.equals(WSSecurityEngine.ENCRYPTED_KEY)) {
            name = "org.apache.ws.security.processor.EncryptedKeyProcessor";
        } else if (el.equals(WSSecurityEngine.SIGNATURE)) {
            name = "org.apache.ws.security.processor.SignatureProcessor";
        } else if (el.equals(WSSecurityEngine.timeStamp)) {
            name = "org.apache.ws.security.processor.TimestampProcessor";
        } else if (el.equals(WSSecurityEngine.usernameToken)) {
            name = "org.apache.ws.security.processor.UsernameTokenProcessor";
        } else if (el.equals(WSSecurityEngine.REFERENCE_LIST)) {
            name = "org.apache.ws.security.processor.ReferenceListProcessor";
        } else if (el.equals(WSSecurityEngine.signatureConfirmation)) {
            name = "org.apache.ws.security.processor.SignatureConfirmationProcessor";
        } else if (el.equals(WSSecurityEngine.DERIVED_KEY_TOKEN_05_02) || el.equals(WSSecurityEngine.DERIVED_KEY_TOKEN_05_12)) {
            name = "org.apache.ws.security.processor.DerivedKeyTokenProcessor";
        } else if (el.equals(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_02) || el.equals(WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_12)) {
            name = "org.apache.ws.security.processor.SecurityContextTokenProcessor";
        } else if (el.equals(WSSecurityEngine.binaryToken)) {
            name = "org.apache.ws.security.processor.BinarySecurityTokenProcessor";
        } else if (el.equals(WSSecurityEngine.ENCRYPTED_DATA)) {
            name = "org.apache.ws.security.processor.EncryptedDataProcessor";
        }
        if (name != null) {
            try {
                return (Processor)Loader.loadClass(name).newInstance();
            }
            catch (Throwable t) {
                throw new WSSecurityException(0, "unableToLoadClass", new Object[]{name});
            }
        }
        return null;
    }

    private boolean loadProvider(String id, String className) {
        try {
            Class c = Loader.loadClass(className);
            if (Security.getProvider(id) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The provider " + id + " had to be added to the java.security.Security"));
                }
                int ret = Security.insertProviderAt((Provider)c.newInstance(), 2);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("The provider " + id + " was added at: " + ret));
                }
            }
            return true;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("The provider " + id + " could not be added: " + t.getMessage()));
            }
            return false;
        }
    }

    public boolean addJceProvider(String id, String className) {
        if (this.jceProvider.get(id) == null && this.loadProvider(id, className)) {
            this.jceProvider.put(id, className);
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

