/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.security.wss4j.crypto;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Merlin;
import org.apache.ws.security.util.Loader;
import org.codehaus.xfire.security.wss4j.crypto.AbstractDecrypter;
import org.codehaus.xfire.util.ClassLoaderUtils;

public class SecuredCrypto
extends Merlin {
    private static final Log log = LogFactory.getLog((Class)SecuredCrypto.class);
    private static final String ENCRYPTER_KEY = "xfire.encrypter.class";
    private AbstractDecrypter decrypter;
    private static final String[] PASS_KEYS = new String[]{"org.apache.ws.security.crypto.merlin.keystore.password", "org.apache.ws.security.crypto.merlin.alias.password"};

    public SecuredCrypto(Properties props) throws CredentialException, IOException {
        super(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecuredCrypto(Properties props, ClassLoader cl) throws CredentialException, IOException {
        super(null, cl);
        if (props == null) {
            return;
        }
        try {
            this.decrypter = this.loadDecrypter(props);
        }
        catch (Throwable e) {
            log.error((Object)"Can't load decrypter.");
        }
        this.properties = this.decryptProperties(props);
        String location = this.properties.getProperty("org.apache.ws.security.crypto.merlin.file");
        InputStream is = null;
        URL url = Loader.getResource((ClassLoader)cl, (String)location);
        is = url != null ? url.openStream() : new FileInputStream(location);
        if (is == null) {
            try {
                is = new FileInputStream(location);
            }
            catch (Exception e) {
                throw new CredentialException(3, "proxyNotFound", new Object[]{location});
            }
        }
        try {
            this.load(is);
        }
        finally {
            is.close();
        }
    }

    protected AbstractDecrypter loadDecrypter(Map props) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String clazzName = (String)props.get(ENCRYPTER_KEY);
        if (clazzName == null) {
            log.debug((Object)"Using dummy decrypter");
            return new AbstractDecrypter(){

                public String decryptString(String value) {
                    return value;
                }
            };
        }
        log.debug((Object)("Loading decrypter : " + clazzName));
        Class clazz = ClassLoaderUtils.loadClass(clazzName, ((Object)((Object)this)).getClass());
        if (!AbstractDecrypter.class.isAssignableFrom(clazz)) {
            log.error((Object)(clazzName + " is not instance of AbstractEncrypter"));
            throw new RuntimeException(clazzName + " is not instance of AbstractEncrypter");
        }
        return (AbstractDecrypter)clazz.newInstance();
    }

    protected Properties decryptProperties(Properties props) {
        String[] keys = this.getPassKeys();
        for (int i = 0; i < keys.length; ++i) {
            String passKey = keys[i];
            String pass = props.getProperty(passKey);
            log.debug((Object)("Decrypting key value : " + passKey));
            if (pass == null) continue;
            pass = this.decryptString(pass);
            props.put(passKey, pass);
        }
        return props;
    }

    protected String decryptString(String value) {
        return this.decrypter.decryptString(value);
    }

    protected String[] getPassKeys() {
        return PASS_KEYS;
    }
}

