/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.api;

import com.ubnt.service.site.D;
import com.ubnt.service.trace.api.DeviceEvent;
import com.ubnt.service.trace.api.Trace;
import com.ubnt.service.trace.api.UUSCommitErrorEvent;
import com.ubnt.service.trace.do;
import com.ubnt.service.trace.model.common.TraceMeta;

public class TraceEventManager {
    private static final String TRACE_CONTROLLER_DEVICE_NAMESPACE = "unifi:network:controller:device";
    private static final String TRACE_UUS_ERROR_EVENT_NAMESPACE = "ubios:udapi-server";
    private final do tracer;
    private final D siteService;

    public TraceEventManager(do do_, D d2) {
        this.tracer = do_;
        this.siteService = d2;
    }

    public void sendDeviceEvent(DeviceEvent deviceEvent) {
        this.siteService.\u00d2O0000(deviceEvent.getDevice().getSiteId()).ifPresent(site -> {
            TraceMeta traceMeta = new TraceMeta(site.getAnonymousId());
            Trace trace = new Trace().setNamespace(TRACE_CONTROLLER_DEVICE_NAMESPACE).setMeta(traceMeta).setType(deviceEvent.getType()).setPayloadData(deviceEvent);
            this.tracer.\u00d200000(trace);
        });
    }

    public void sendUUSCommitErrorEvent(UUSCommitErrorEvent uUSCommitErrorEvent) {
        this.siteService.\u00d2O0000(uUSCommitErrorEvent.getDevice().getSiteId()).ifPresent(site -> {
            TraceMeta traceMeta = new TraceMeta(site.getAnonymousId());
            Trace trace = new Trace().setNamespace(TRACE_UUS_ERROR_EVENT_NAMESPACE).setMeta(traceMeta).setType(uUSCommitErrorEvent.getType()).setPayloadData(uUSCommitErrorEvent);
            this.tracer.\u00d200000(trace);
        });
    }
}

