/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.client;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.ssl.SslAutoConfiguration;
import org.springframework.boot.autoconfigure.web.client.AutoConfiguredRestClientSsl;
import org.springframework.boot.autoconfigure.web.client.HttpMessageConvertersRestClientCustomizer;
import org.springframework.boot.autoconfigure.web.client.NotReactiveWebApplicationCondition;
import org.springframework.boot.autoconfigure.web.client.RestClientBuilderConfigurer;
import org.springframework.boot.autoconfigure.web.client.RestClientSsl;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.web.client.ClientHttpRequestFactories;
import org.springframework.boot.web.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={HttpMessageConvertersAutoConfiguration.class, SslAutoConfiguration.class})
@ConditionalOnClass(value={RestClient.class})
@Conditional(value={NotReactiveWebApplicationCondition.class})
public class RestClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Order(value=0x7FFFFFFF)
    HttpMessageConvertersRestClientCustomizer httpMessageConvertersRestClientCustomizer(ObjectProvider<HttpMessageConverters> messageConverters) {
        return new HttpMessageConvertersRestClientCustomizer((HttpMessageConverters)messageConverters.getIfUnique());
    }

    @Bean
    @ConditionalOnMissingBean(value={RestClientSsl.class})
    @ConditionalOnBean(value={SslBundles.class})
    AutoConfiguredRestClientSsl restClientSsl(SslBundles sslBundles) {
        return new AutoConfiguredRestClientSsl(sslBundles);
    }

    @Bean
    @ConditionalOnMissingBean
    RestClientBuilderConfigurer restClientBuilderConfigurer(ObjectProvider<RestClientCustomizer> customizerProvider) {
        RestClientBuilderConfigurer configurer = new RestClientBuilderConfigurer();
        configurer.setRestClientCustomizers(customizerProvider.orderedStream().toList());
        return configurer;
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    RestClient.Builder restClientBuilder(RestClientBuilderConfigurer restClientBuilderConfigurer) {
        RestClient.Builder builder = RestClient.builder().requestFactory(ClientHttpRequestFactories.get((ClientHttpRequestFactorySettings)ClientHttpRequestFactorySettings.DEFAULTS));
        return restClientBuilderConfigurer.configure(builder);
    }
}

