// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/servicedirectory/v1beta1/lookup_service.proto

package servicedirectorypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	LookupService_ResolveService_FullMethodName = "/google.cloud.servicedirectory.v1beta1.LookupService/ResolveService"
)

// LookupServiceClient is the client API for LookupService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LookupServiceClient interface {
	// Returns a [service][google.cloud.servicedirectory.v1beta1.Service] and its
	// associated endpoints.
	// Resolving a service is not considered an active developer method.
	ResolveService(ctx context.Context, in *ResolveServiceRequest, opts ...grpc.CallOption) (*ResolveServiceResponse, error)
}

type lookupServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewLookupServiceClient(cc grpc.ClientConnInterface) LookupServiceClient {
	return &lookupServiceClient{cc}
}

func (c *lookupServiceClient) ResolveService(ctx context.Context, in *ResolveServiceRequest, opts ...grpc.CallOption) (*ResolveServiceResponse, error) {
	out := new(ResolveServiceResponse)
	err := c.cc.Invoke(ctx, LookupService_ResolveService_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LookupServiceServer is the server API for LookupService service.
// All implementations should embed UnimplementedLookupServiceServer
// for forward compatibility
type LookupServiceServer interface {
	// Returns a [service][google.cloud.servicedirectory.v1beta1.Service] and its
	// associated endpoints.
	// Resolving a service is not considered an active developer method.
	ResolveService(context.Context, *ResolveServiceRequest) (*ResolveServiceResponse, error)
}

// UnimplementedLookupServiceServer should be embedded to have forward compatible implementations.
type UnimplementedLookupServiceServer struct {
}

func (UnimplementedLookupServiceServer) ResolveService(context.Context, *ResolveServiceRequest) (*ResolveServiceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResolveService not implemented")
}

// UnsafeLookupServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LookupServiceServer will
// result in compilation errors.
type UnsafeLookupServiceServer interface {
	mustEmbedUnimplementedLookupServiceServer()
}

func RegisterLookupServiceServer(s grpc.ServiceRegistrar, srv LookupServiceServer) {
	s.RegisterService(&LookupService_ServiceDesc, srv)
}

func _LookupService_ResolveService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResolveServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LookupServiceServer).ResolveService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LookupService_ResolveService_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LookupServiceServer).ResolveService(ctx, req.(*ResolveServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// LookupService_ServiceDesc is the grpc.ServiceDesc for LookupService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var LookupService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.servicedirectory.v1beta1.LookupService",
	HandlerType: (*LookupServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ResolveService",
			Handler:    _LookupService_ResolveService_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/servicedirectory/v1beta1/lookup_service.proto",
}
