// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v2/resources/invoice.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v2/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v2/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An invoice. All invoice information is snapshotted to match the PDF invoice.
// For invoices older than the launch of InvoiceService, the snapshotted
// information may not match the PDF invoice.
type Invoice struct {
	// The resource name of the invoice. Multiple customers can share a given
	// invoice, so multiple resource names may point to the same invoice.
	// Invoice resource names have the form:
	//
	// `customers/{customer_id}/invoices/{invoice_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the invoice. It appears on the invoice PDF as "Invoice number".
	Id *wrappers.StringValue `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The type of invoice.
	Type enums.InvoiceTypeEnum_InvoiceType `protobuf:"varint,3,opt,name=type,proto3,enum=google.ads.googleads.v2.enums.InvoiceTypeEnum_InvoiceType" json:"type,omitempty"`
	// The resource name of this invoice’s billing setup.
	//
	// `customers/{customer_id}/billingSetups/{billing_setup_id}`
	BillingSetup *wrappers.StringValue `protobuf:"bytes,4,opt,name=billing_setup,json=billingSetup,proto3" json:"billing_setup,omitempty"`
	// A 16 digit ID used to identify the payments account associated with the
	// billing setup, e.g. "1234-5678-9012-3456". It appears on the invoice PDF as
	// "Billing Account Number".
	PaymentsAccountId *wrappers.StringValue `protobuf:"bytes,5,opt,name=payments_account_id,json=paymentsAccountId,proto3" json:"payments_account_id,omitempty"`
	// A 12 digit ID used to identify the payments profile associated with the
	// billing setup, e.g. "1234-5678-9012". It appears on the invoice PDF as
	// "Billing ID".
	PaymentsProfileId *wrappers.StringValue `protobuf:"bytes,6,opt,name=payments_profile_id,json=paymentsProfileId,proto3" json:"payments_profile_id,omitempty"`
	// The issue date in yyyy-mm-dd format. It appears on the invoice PDF as
	// either "Issue date" or "Invoice date".
	IssueDate *wrappers.StringValue `protobuf:"bytes,7,opt,name=issue_date,json=issueDate,proto3" json:"issue_date,omitempty"`
	// The due date in yyyy-mm-dd format.
	DueDate *wrappers.StringValue `protobuf:"bytes,8,opt,name=due_date,json=dueDate,proto3" json:"due_date,omitempty"`
	// The service period date range of this invoice. The end date is inclusive.
	ServiceDateRange *common.DateRange `protobuf:"bytes,9,opt,name=service_date_range,json=serviceDateRange,proto3" json:"service_date_range,omitempty"`
	// The currency code. All costs are returned in this currency. A subset of the
	// currency codes derived from the ISO 4217 standard is supported.
	CurrencyCode *wrappers.StringValue `protobuf:"bytes,10,opt,name=currency_code,json=currencyCode,proto3" json:"currency_code,omitempty"`
	// The total amount of invoice level adjustments. These adjustments are made
	// on the invoice, not on a specific account budget.
	InvoiceLevelAdjustmentsMicros *wrappers.Int64Value `protobuf:"bytes,11,opt,name=invoice_level_adjustments_micros,json=invoiceLevelAdjustmentsMicros,proto3" json:"invoice_level_adjustments_micros,omitempty"`
	// The pretax subtotal amount, in micros. This equals the sum of the
	// AccountBudgetSummary subtotal amounts, plus the invoice level adjustments.
	SubtotalAmountMicros *wrappers.Int64Value `protobuf:"bytes,12,opt,name=subtotal_amount_micros,json=subtotalAmountMicros,proto3" json:"subtotal_amount_micros,omitempty"`
	// The sum of all taxes on the invoice, in micros. This equals the sum of the
	// AccountBudgetSummary tax amounts, plus taxes not associated with a specific
	// account budget.
	TaxAmountMicros *wrappers.Int64Value `protobuf:"bytes,13,opt,name=tax_amount_micros,json=taxAmountMicros,proto3" json:"tax_amount_micros,omitempty"`
	// The total amount, in micros. This equals the sum of the invoice subtotal
	// amount and the invoice tax amount.
	TotalAmountMicros *wrappers.Int64Value `protobuf:"bytes,14,opt,name=total_amount_micros,json=totalAmountMicros,proto3" json:"total_amount_micros,omitempty"`
	// The resource name of the original invoice corrected, wrote off, or canceled
	// by this invoice, if applicable. If `corrected_invoice` is set,
	// `replaced_invoices` will not be set.
	//
	// Invoice resource names have the form:
	//
	// `customers/{customer_id}/invoices/{invoice_id}`
	CorrectedInvoice *wrappers.StringValue `protobuf:"bytes,15,opt,name=corrected_invoice,json=correctedInvoice,proto3" json:"corrected_invoice,omitempty"`
	// The resource name of the original invoice(s) being rebilled or replaced by
	// this invoice, if applicable. There might be multiple replaced invoices due
	// to invoice consolidation. The replaced invoices may not belong to the same
	// payments account. If `replaced_invoices` is set, `corrected_invoice` will
	// not be set.
	// Invoice resource names have the form:
	//
	// `customers/{customer_id}/invoices/{invoice_id}`
	ReplacedInvoices []*wrappers.StringValue `protobuf:"bytes,16,rep,name=replaced_invoices,json=replacedInvoices,proto3" json:"replaced_invoices,omitempty"`
	// The URL to a PDF copy of the invoice. Users need to pass in their OAuth
	// token to request the PDF with this URL.
	PdfUrl *wrappers.StringValue `protobuf:"bytes,17,opt,name=pdf_url,json=pdfUrl,proto3" json:"pdf_url,omitempty"`
	// The list of summarized account budget information associated with this
	// invoice.
	AccountBudgetSummaries []*Invoice_AccountBudgetSummary `protobuf:"bytes,18,rep,name=account_budget_summaries,json=accountBudgetSummaries,proto3" json:"account_budget_summaries,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}                        `json:"-"`
	XXX_unrecognized       []byte                          `json:"-"`
	XXX_sizecache          int32                           `json:"-"`
}

func (m *Invoice) Reset()         { *m = Invoice{} }
func (m *Invoice) String() string { return proto.CompactTextString(m) }
func (*Invoice) ProtoMessage()    {}
func (*Invoice) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b8f0bbb4092e161, []int{0}
}

func (m *Invoice) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Invoice.Unmarshal(m, b)
}
func (m *Invoice) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Invoice.Marshal(b, m, deterministic)
}
func (m *Invoice) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Invoice.Merge(m, src)
}
func (m *Invoice) XXX_Size() int {
	return xxx_messageInfo_Invoice.Size(m)
}
func (m *Invoice) XXX_DiscardUnknown() {
	xxx_messageInfo_Invoice.DiscardUnknown(m)
}

var xxx_messageInfo_Invoice proto.InternalMessageInfo

func (m *Invoice) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Invoice) GetId() *wrappers.StringValue {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *Invoice) GetType() enums.InvoiceTypeEnum_InvoiceType {
	if m != nil {
		return m.Type
	}
	return enums.InvoiceTypeEnum_UNSPECIFIED
}

func (m *Invoice) GetBillingSetup() *wrappers.StringValue {
	if m != nil {
		return m.BillingSetup
	}
	return nil
}

func (m *Invoice) GetPaymentsAccountId() *wrappers.StringValue {
	if m != nil {
		return m.PaymentsAccountId
	}
	return nil
}

func (m *Invoice) GetPaymentsProfileId() *wrappers.StringValue {
	if m != nil {
		return m.PaymentsProfileId
	}
	return nil
}

func (m *Invoice) GetIssueDate() *wrappers.StringValue {
	if m != nil {
		return m.IssueDate
	}
	return nil
}

func (m *Invoice) GetDueDate() *wrappers.StringValue {
	if m != nil {
		return m.DueDate
	}
	return nil
}

func (m *Invoice) GetServiceDateRange() *common.DateRange {
	if m != nil {
		return m.ServiceDateRange
	}
	return nil
}

func (m *Invoice) GetCurrencyCode() *wrappers.StringValue {
	if m != nil {
		return m.CurrencyCode
	}
	return nil
}

func (m *Invoice) GetInvoiceLevelAdjustmentsMicros() *wrappers.Int64Value {
	if m != nil {
		return m.InvoiceLevelAdjustmentsMicros
	}
	return nil
}

func (m *Invoice) GetSubtotalAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.SubtotalAmountMicros
	}
	return nil
}

func (m *Invoice) GetTaxAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TaxAmountMicros
	}
	return nil
}

func (m *Invoice) GetTotalAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TotalAmountMicros
	}
	return nil
}

func (m *Invoice) GetCorrectedInvoice() *wrappers.StringValue {
	if m != nil {
		return m.CorrectedInvoice
	}
	return nil
}

func (m *Invoice) GetReplacedInvoices() []*wrappers.StringValue {
	if m != nil {
		return m.ReplacedInvoices
	}
	return nil
}

func (m *Invoice) GetPdfUrl() *wrappers.StringValue {
	if m != nil {
		return m.PdfUrl
	}
	return nil
}

func (m *Invoice) GetAccountBudgetSummaries() []*Invoice_AccountBudgetSummary {
	if m != nil {
		return m.AccountBudgetSummaries
	}
	return nil
}

// Represents a summarized account budget billable cost.
type Invoice_AccountBudgetSummary struct {
	// The resource name of the customer associated with this account budget.
	// This contains the customer ID, which appears on the invoice PDF as
	// "Account ID".
	// Customer resource names have the form:
	//
	// `customers/{customer_id}`
	Customer *wrappers.StringValue `protobuf:"bytes,1,opt,name=customer,proto3" json:"customer,omitempty"`
	// The descriptive name of the account budget’s customer. It appears on the
	// invoice PDF as "Account".
	CustomerDescriptiveName *wrappers.StringValue `protobuf:"bytes,2,opt,name=customer_descriptive_name,json=customerDescriptiveName,proto3" json:"customer_descriptive_name,omitempty"`
	// The resource name of the account budget associated with this summarized
	// billable cost.
	// AccountBudget resource names have the form:
	//
	// `customers/{customer_id}/accountBudgets/{account_budget_id}`
	AccountBudget *wrappers.StringValue `protobuf:"bytes,3,opt,name=account_budget,json=accountBudget,proto3" json:"account_budget,omitempty"`
	// The name of the account budget. It appears on the invoice PDF as "Account
	// budget".
	AccountBudgetName *wrappers.StringValue `protobuf:"bytes,4,opt,name=account_budget_name,json=accountBudgetName,proto3" json:"account_budget_name,omitempty"`
	// The purchase order number of the account budget. It appears on the
	// invoice PDF as "Purchase order".
	PurchaseOrderNumber *wrappers.StringValue `protobuf:"bytes,5,opt,name=purchase_order_number,json=purchaseOrderNumber,proto3" json:"purchase_order_number,omitempty"`
	// The pretax subtotal amount attributable to this budget during the service
	// period, in micros.
	SubtotalAmountMicros *wrappers.Int64Value `protobuf:"bytes,6,opt,name=subtotal_amount_micros,json=subtotalAmountMicros,proto3" json:"subtotal_amount_micros,omitempty"`
	// The tax amount attributable to this budget during the service period, in
	// micros.
	TaxAmountMicros *wrappers.Int64Value `protobuf:"bytes,7,opt,name=tax_amount_micros,json=taxAmountMicros,proto3" json:"tax_amount_micros,omitempty"`
	// The total amount attributable to this budget during the service period,
	// in micros. This equals the sum of the account budget subtotal amount and
	// the account budget tax amount.
	TotalAmountMicros *wrappers.Int64Value `protobuf:"bytes,8,opt,name=total_amount_micros,json=totalAmountMicros,proto3" json:"total_amount_micros,omitempty"`
	// The billable activity date range of the account budget, within the
	// service date range of this invoice. The end date is inclusive. This can
	// be different from the account budget's start and end time.
	BillableActivityDateRange *common.DateRange `protobuf:"bytes,9,opt,name=billable_activity_date_range,json=billableActivityDateRange,proto3" json:"billable_activity_date_range,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}          `json:"-"`
	XXX_unrecognized          []byte            `json:"-"`
	XXX_sizecache             int32             `json:"-"`
}

func (m *Invoice_AccountBudgetSummary) Reset()         { *m = Invoice_AccountBudgetSummary{} }
func (m *Invoice_AccountBudgetSummary) String() string { return proto.CompactTextString(m) }
func (*Invoice_AccountBudgetSummary) ProtoMessage()    {}
func (*Invoice_AccountBudgetSummary) Descriptor() ([]byte, []int) {
	return fileDescriptor_2b8f0bbb4092e161, []int{0, 0}
}

func (m *Invoice_AccountBudgetSummary) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Invoice_AccountBudgetSummary.Unmarshal(m, b)
}
func (m *Invoice_AccountBudgetSummary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Invoice_AccountBudgetSummary.Marshal(b, m, deterministic)
}
func (m *Invoice_AccountBudgetSummary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Invoice_AccountBudgetSummary.Merge(m, src)
}
func (m *Invoice_AccountBudgetSummary) XXX_Size() int {
	return xxx_messageInfo_Invoice_AccountBudgetSummary.Size(m)
}
func (m *Invoice_AccountBudgetSummary) XXX_DiscardUnknown() {
	xxx_messageInfo_Invoice_AccountBudgetSummary.DiscardUnknown(m)
}

var xxx_messageInfo_Invoice_AccountBudgetSummary proto.InternalMessageInfo

func (m *Invoice_AccountBudgetSummary) GetCustomer() *wrappers.StringValue {
	if m != nil {
		return m.Customer
	}
	return nil
}

func (m *Invoice_AccountBudgetSummary) GetCustomerDescriptiveName() *wrappers.StringValue {
	if m != nil {
		return m.CustomerDescriptiveName
	}
	return nil
}

func (m *Invoice_AccountBudgetSummary) GetAccountBudget() *wrappers.StringValue {
	if m != nil {
		return m.AccountBudget
	}
	return nil
}

func (m *Invoice_AccountBudgetSummary) GetAccountBudgetName() *wrappers.StringValue {
	if m != nil {
		return m.AccountBudgetName
	}
	return nil
}

func (m *Invoice_AccountBudgetSummary) GetPurchaseOrderNumber() *wrappers.StringValue {
	if m != nil {
		return m.PurchaseOrderNumber
	}
	return nil
}

func (m *Invoice_AccountBudgetSummary) GetSubtotalAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.SubtotalAmountMicros
	}
	return nil
}

func (m *Invoice_AccountBudgetSummary) GetTaxAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TaxAmountMicros
	}
	return nil
}

func (m *Invoice_AccountBudgetSummary) GetTotalAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TotalAmountMicros
	}
	return nil
}

func (m *Invoice_AccountBudgetSummary) GetBillableActivityDateRange() *common.DateRange {
	if m != nil {
		return m.BillableActivityDateRange
	}
	return nil
}

func init() {
	proto.RegisterType((*Invoice)(nil), "google.ads.googleads.v2.resources.Invoice")
	proto.RegisterType((*Invoice_AccountBudgetSummary)(nil), "google.ads.googleads.v2.resources.Invoice.AccountBudgetSummary")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v2/resources/invoice.proto", fileDescriptor_2b8f0bbb4092e161)
}

var fileDescriptor_2b8f0bbb4092e161 = []byte{
	// 875 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x96, 0xdd, 0x6e, 0xdc, 0x44,
	0x14, 0x80, 0xb5, 0x9b, 0x36, 0x9b, 0x4c, 0x93, 0x34, 0xeb, 0x94, 0xe2, 0x86, 0x80, 0xb6, 0xa0,
	0x4a, 0x01, 0x21, 0x2f, 0x5a, 0x7e, 0xe5, 0x5e, 0x20, 0xa7, 0x45, 0xd1, 0x42, 0x09, 0x61, 0x03,
	0x01, 0xa1, 0x48, 0xd6, 0xec, 0xcc, 0x89, 0x99, 0xca, 0x9e, 0xb1, 0xe6, 0x67, 0xe9, 0x3e, 0x0b,
	0x77, 0x5c, 0xf2, 0x28, 0x3c, 0x07, 0x57, 0xbc, 0x01, 0x77, 0xc8, 0xe3, 0x19, 0x87, 0x6d, 0x9a,
	0xae, 0xa1, 0xb9, 0x9b, 0xf5, 0x9c, 0xef, 0xf3, 0x99, 0x9f, 0x73, 0xd6, 0x68, 0x98, 0x09, 0x91,
	0xe5, 0x30, 0xc4, 0x54, 0xb9, 0x61, 0x35, 0x9a, 0x8d, 0x86, 0x12, 0x94, 0x30, 0x92, 0x80, 0x1a,
	0x32, 0x3e, 0x13, 0x8c, 0x40, 0x54, 0x4a, 0xa1, 0x45, 0x70, 0xbf, 0x8e, 0x8a, 0x30, 0x55, 0x51,
	0x03, 0x44, 0xb3, 0x51, 0xd4, 0x00, 0xbb, 0xef, 0x5d, 0xe5, 0x24, 0xa2, 0x28, 0x04, 0x1f, 0x52,
	0xac, 0x41, 0xd5, 0xba, 0xdd, 0x0f, 0xae, 0x8a, 0x05, 0x6e, 0x8a, 0xe6, 0xdd, 0xa9, 0x9e, 0x97,
	0x2e, 0x81, 0xdd, 0xb7, 0x1c, 0x61, 0x7f, 0x4d, 0xcd, 0xf9, 0xf0, 0x17, 0x89, 0xcb, 0x12, 0xa4,
	0x37, 0xee, 0x79, 0x63, 0xc9, 0x86, 0x98, 0x73, 0xa1, 0xb1, 0x66, 0x82, 0xbb, 0xd9, 0xb7, 0x7f,
	0xdd, 0x46, 0xbd, 0x71, 0x2d, 0x0d, 0xde, 0x41, 0x9b, 0x3e, 0xe9, 0x94, 0xe3, 0x02, 0xc2, 0xce,
	0xa0, 0xb3, 0xbf, 0x3e, 0xd9, 0xf0, 0x0f, 0x8f, 0x70, 0x01, 0xc1, 0xfb, 0xa8, 0xcb, 0x68, 0xd8,
	0x1d, 0x74, 0xf6, 0x6f, 0x8d, 0xf6, 0xdc, 0x8a, 0x23, 0xff, 0xee, 0xe8, 0x44, 0x4b, 0xc6, 0xb3,
	0x53, 0x9c, 0x1b, 0x98, 0x74, 0x19, 0x0d, 0x8e, 0xd0, 0x8d, 0x2a, 0xd5, 0x70, 0x65, 0xd0, 0xd9,
	0xdf, 0x1a, 0xc5, 0xd1, 0x55, 0x9b, 0x65, 0x57, 0x17, 0xb9, 0x44, 0xbe, 0x9b, 0x97, 0xf0, 0x05,
	0x37, 0xc5, 0xbf, 0x7f, 0x4f, 0xac, 0x27, 0x48, 0xd0, 0xe6, 0x94, 0xe5, 0x39, 0xe3, 0x59, 0xaa,
	0x40, 0x9b, 0x32, 0xbc, 0xd1, 0x22, 0x91, 0x0d, 0x87, 0x9c, 0x54, 0x44, 0xf0, 0x04, 0xed, 0x94,
	0x78, 0x5e, 0x00, 0xd7, 0x2a, 0xc5, 0x84, 0x08, 0xc3, 0x75, 0xca, 0x68, 0x78, 0xb3, 0x85, 0xa8,
	0xef, 0xc1, 0xa4, 0xe6, 0xc6, 0x74, 0xc1, 0x56, 0x4a, 0x71, 0xce, 0x72, 0xa8, 0x6c, 0xab, 0xff,
	0xc5, 0x76, 0x5c, 0x73, 0x63, 0x1a, 0x3c, 0x44, 0x88, 0x29, 0x65, 0x20, 0xad, 0xae, 0x44, 0xd8,
	0x6b, 0x21, 0x59, 0xb7, 0xf1, 0x8f, 0xb1, 0x86, 0xe0, 0x53, 0xb4, 0x46, 0x3d, 0xba, 0xd6, 0x02,
	0xed, 0x51, 0x07, 0xfe, 0x80, 0x02, 0x05, 0x72, 0x56, 0xdd, 0xab, 0x0a, 0x4e, 0x25, 0xe6, 0x19,
	0x84, 0xeb, 0x56, 0xf1, 0xee, 0x95, 0x47, 0x56, 0x5f, 0xde, 0xa8, 0x32, 0x4c, 0x2a, 0x60, 0xb2,
	0xed, 0x24, 0xcd, 0x93, 0xea, 0xb4, 0x88, 0x91, 0x12, 0x38, 0x99, 0xa7, 0x44, 0x50, 0x08, 0x51,
	0x9b, 0xd3, 0xf2, 0xc8, 0x23, 0x41, 0x21, 0xa0, 0x68, 0xe0, 0xef, 0x7c, 0x0e, 0x33, 0xc8, 0x53,
	0x4c, 0x9f, 0x1a, 0xa5, 0xeb, 0x0d, 0x2f, 0x18, 0x91, 0x42, 0x85, 0xb7, 0xac, 0xf5, 0x8d, 0x4b,
	0xd6, 0x31, 0xd7, 0x9f, 0x7c, 0x54, 0x4b, 0xdf, 0x74, 0x92, 0x27, 0x95, 0x23, 0xb9, 0x50, 0x7c,
	0x6d, 0x0d, 0xc1, 0xb7, 0xe8, 0xae, 0x32, 0x53, 0x2d, 0x34, 0xce, 0x53, 0x5c, 0xd8, 0x2b, 0xe1,
	0xdc, 0x1b, 0xcb, 0xdd, 0x77, 0x3c, 0x9a, 0x58, 0xd2, 0x29, 0x0f, 0x51, 0x5f, 0xe3, 0x67, 0xcf,
	0xd9, 0x36, 0x97, 0xdb, 0x6e, 0x6b, 0xfc, 0x6c, 0x41, 0xf4, 0x15, 0xda, 0x79, 0x51, 0x62, 0x5b,
	0xcb, 0x55, 0xfd, 0xcb, 0x59, 0x8d, 0x51, 0x9f, 0x08, 0x29, 0x81, 0x68, 0xa0, 0xa9, 0xdb, 0x93,
	0xf0, 0x76, 0x8b, 0x53, 0xd9, 0x6e, 0x30, 0xdf, 0x2d, 0xc6, 0xa8, 0x2f, 0xa1, 0xcc, 0x31, 0xb9,
	0x30, 0xa9, 0x70, 0x7b, 0xb0, 0xb2, 0x5c, 0xe5, 0x31, 0x67, 0x52, 0xc1, 0xc7, 0xa8, 0x57, 0xd2,
	0xf3, 0xd4, 0xc8, 0x3c, 0xec, 0xb7, 0xc8, 0x65, 0xb5, 0xa4, 0xe7, 0xdf, 0xcb, 0x3c, 0x98, 0xa3,
	0xd0, 0x17, 0xf0, 0xd4, 0xd0, 0x0c, 0x74, 0xaa, 0x4c, 0x51, 0x60, 0xc9, 0x40, 0x85, 0x81, 0x4d,
	0xe4, 0xf3, 0x68, 0x69, 0x77, 0xf6, 0x4d, 0x26, 0x72, 0x35, 0x7d, 0x60, 0x4d, 0x27, 0x56, 0x34,
	0x9f, 0xdc, 0xc5, 0x97, 0x9f, 0x32, 0x50, 0xbb, 0x7f, 0xde, 0x44, 0x77, 0x5e, 0x04, 0x04, 0x9f,
	0xa1, 0x35, 0x62, 0x94, 0x16, 0x05, 0x48, 0xdb, 0x3e, 0x97, 0xad, 0xa5, 0x89, 0x0e, 0x7e, 0x44,
	0xf7, 0xfc, 0x38, 0xa5, 0xa0, 0x88, 0x64, 0xa5, 0x66, 0x33, 0xd7, 0x89, 0xdb, 0xf4, 0xdb, 0xd7,
	0x3d, 0xfe, 0xf8, 0x82, 0xb6, 0x2d, 0xfb, 0x11, 0xda, 0x5a, 0xdc, 0x27, 0xdb, 0x8e, 0x97, 0xe9,
	0x36, 0x17, 0x96, 0x5e, 0x35, 0xba, 0xe7, 0x36, 0xdb, 0x26, 0xd6, 0xa6, 0xff, 0xf6, 0x17, 0x4c,
	0x36, 0xa5, 0x63, 0xf4, 0x5a, 0x69, 0x24, 0xf9, 0x19, 0x2b, 0x48, 0x85, 0xa4, 0x20, 0x53, 0x6e,
	0x8a, 0x29, 0xc8, 0x56, 0x6d, 0x78, 0xc7, 0xa3, 0xdf, 0x54, 0xe4, 0x91, 0x05, 0x5f, 0x52, 0xc2,
	0xab, 0xd7, 0x5a, 0xc2, 0xbd, 0xeb, 0x2b, 0xe1, 0xb5, 0xff, 0x55, 0xc2, 0x4f, 0xd1, 0x5e, 0xf5,
	0x7f, 0x86, 0xa7, 0x39, 0xa4, 0x98, 0x68, 0x36, 0x63, 0x7a, 0xfe, 0x4a, 0x7d, 0xfb, 0x9e, 0xd7,
	0x25, 0xce, 0xd6, 0x4c, 0x1d, 0xfc, 0xdd, 0x41, 0x0f, 0x88, 0x28, 0x96, 0x57, 0xd1, 0xc1, 0x86,
	0x2b, 0xa3, 0xe3, 0x6a, 0x11, 0xc7, 0x9d, 0x9f, 0xbe, 0x74, 0x48, 0x26, 0x72, 0xcc, 0xb3, 0x48,
	0xc8, 0x6c, 0x98, 0x01, 0xb7, 0x4b, 0xf4, 0xdf, 0x35, 0x25, 0x53, 0x2f, 0xf9, 0xcc, 0x7a, 0xd8,
	0x8c, 0x7e, 0xeb, 0xae, 0x1c, 0x26, 0xc9, 0xef, 0xdd, 0xfb, 0x87, 0xb5, 0x32, 0xa1, 0x2a, 0xaa,
	0x87, 0xd5, 0xe8, 0x74, 0x14, 0x4d, 0x7c, 0xe4, 0x1f, 0x3e, 0xe6, 0x2c, 0xa1, 0xea, 0xac, 0x89,
	0x39, 0x3b, 0x1d, 0x9d, 0x35, 0x31, 0x7f, 0x75, 0x1f, 0xd4, 0x13, 0x71, 0x9c, 0x50, 0x15, 0xc7,
	0x4d, 0x54, 0x1c, 0x9f, 0x8e, 0xe2, 0xb8, 0x89, 0x9b, 0xae, 0xda, 0x64, 0x3f, 0xfc, 0x27, 0x00,
	0x00, 0xff, 0xff, 0x0c, 0x87, 0x78, 0xcd, 0x12, 0x0a, 0x00, 0x00,
}
