// DO NOT EDIT: This file is autogenerated via the builtin command.

package telegram

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 6,
					Line:   70,
				},
				File:   "telegram.flux",
				Source: "package telegram\n\n\nimport \"http\"\nimport \"json\"\n\noption defaultURL = \"https://api.telegram.org/bot\"\noption defaultParseMode = \"MarkdownV2\"\noption defaultDisableWebPagePreview = false\noption defaultSilent = true\n\n// `message` sends a single message to a Telegram channel using the API descibed in https://core.telegram.org/bots/api#sendmessage\n// `url` - string - URL of the telegram bot endpoint. Defaults to: \"https://api.telegram.org/bot\"\n// `token` - string - Required telegram bot token string, such as 123456789:AAxSFgij0ln9C7zUKnr4ScDi5QXTGF71S\n// `channel` - string - Required id of the telegram channel.\n// `text` - string - The text to display.\n// `parseMode` - string - Parse mode of the message text per https://core.telegram.org/bots/api#formatting-options . Defaults to \"MarkdownV2\"\n// `disableWebPagePreview` - bool - Disables preview of web links in the sent messages when \"true\". Defaults to \"false\"\n// `silent` - bool - Messages are sent silently (https://telegram.org/blog/channels-2-0#silent-messages) when \"true\". Defaults to \"true\".\nmessage = (\n        url=defaultURL,\n        token,\n        channel,\n        text,\n        parseMode=defaultParseMode,\n        disableWebPagePreview=defaultDisableWebPagePreview,\n        silent=defaultSilent,\n) => {\n    data = {\n        chat_id: channel,\n        text: text,\n        parse_mode: parseMode,\n        disable_web_page_preview: disableWebPagePreview,\n        disable_notification: silent,\n    }\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url + token + \"/sendMessage\", data: enc)\n}\n\n// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send messages to telegram for each table row.\n// `url` - string - URL of the telegram bot endpoint. Defaults to: \"https://api.telegram.org/bot\"\n// `token` - string - Required telegram bot token string, such as 123456789:AAxSFgij0ln9C7zUKnr4ScDi5QXTGF71S\n// `parseMode` - string - Parse mode of the message text per https://core.telegram.org/bots/api#formatting-options . Defaults to \"MarkdownV2\"\n// `disableWebPagePreview` - bool - Disables preview of web links in the sent messages when \"true\". Defaults to \"false\"\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return an object with `channel`, `text`, and `silent`, as defined in the `message` function arguments.\nendpoint = (url=defaultURL, token, parseMode=defaultParseMode, disableWebPagePreview=defaultDisableWebPagePreview) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 51,
							Line:   7,
						},
						File:   "telegram.flux",
						Source: "defaultURL = \"https://api.telegram.org/bot\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   7,
							},
							File:   "telegram.flux",
							Source: "defaultURL",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "defaultURL",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   7,
							},
							File:   "telegram.flux",
							Source: "\"https://api.telegram.org/bot\"",
							Start: ast.Position{
								Column: 21,
								Line:   7,
							},
						},
					},
					Value: "https://api.telegram.org/bot",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 51,
						Line:   7,
					},
					File:   "telegram.flux",
					Source: "option defaultURL = \"https://api.telegram.org/bot\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 39,
							Line:   8,
						},
						File:   "telegram.flux",
						Source: "defaultParseMode = \"MarkdownV2\"",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   8,
							},
							File:   "telegram.flux",
							Source: "defaultParseMode",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "defaultParseMode",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   8,
							},
							File:   "telegram.flux",
							Source: "\"MarkdownV2\"",
							Start: ast.Position{
								Column: 27,
								Line:   8,
							},
						},
					},
					Value: "MarkdownV2",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 39,
						Line:   8,
					},
					File:   "telegram.flux",
					Source: "option defaultParseMode = \"MarkdownV2\"",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 44,
							Line:   9,
						},
						File:   "telegram.flux",
						Source: "defaultDisableWebPagePreview = false",
						Start: ast.Position{
							Column: 8,
							Line:   9,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   9,
							},
							File:   "telegram.flux",
							Source: "defaultDisableWebPagePreview",
							Start: ast.Position{
								Column: 8,
								Line:   9,
							},
						},
					},
					Name: "defaultDisableWebPagePreview",
				},
				Init: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   9,
							},
							File:   "telegram.flux",
							Source: "false",
							Start: ast.Position{
								Column: 39,
								Line:   9,
							},
						},
					},
					Name: "false",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 44,
						Line:   9,
					},
					File:   "telegram.flux",
					Source: "option defaultDisableWebPagePreview = false",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   10,
						},
						File:   "telegram.flux",
						Source: "defaultSilent = true",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   10,
							},
							File:   "telegram.flux",
							Source: "defaultSilent",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Name: "defaultSilent",
				},
				Init: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   10,
							},
							File:   "telegram.flux",
							Source: "true",
							Start: ast.Position{
								Column: 24,
								Line:   10,
							},
						},
					},
					Name: "true",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 28,
						Line:   10,
					},
					File:   "telegram.flux",
					Source: "option defaultSilent = true",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   42,
					},
					File:   "telegram.flux",
					Source: "message = (\n        url=defaultURL,\n        token,\n        channel,\n        text,\n        parseMode=defaultParseMode,\n        disableWebPagePreview=defaultDisableWebPagePreview,\n        silent=defaultSilent,\n) => {\n    data = {\n        chat_id: channel,\n        text: text,\n        parse_mode: parseMode,\n        disable_web_page_preview: disableWebPagePreview,\n        disable_notification: silent,\n    }\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url + token + \"/sendMessage\", data: enc)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `message` sends a single message to a Telegram channel using the API descibed in https://core.telegram.org/bots/api#sendmessage\n"}, ast.Comment{Text: "// `url` - string - URL of the telegram bot endpoint. Defaults to: \"https://api.telegram.org/bot\"\n"}, ast.Comment{Text: "// `token` - string - Required telegram bot token string, such as 123456789:AAxSFgij0ln9C7zUKnr4ScDi5QXTGF71S\n"}, ast.Comment{Text: "// `channel` - string - Required id of the telegram channel.\n"}, ast.Comment{Text: "// `text` - string - The text to display.\n"}, ast.Comment{Text: "// `parseMode` - string - Parse mode of the message text per https://core.telegram.org/bots/api#formatting-options . Defaults to \"MarkdownV2\"\n"}, ast.Comment{Text: "// `disableWebPagePreview` - bool - Disables preview of web links in the sent messages when \"true\". Defaults to \"false\"\n"}, ast.Comment{Text: "// `silent` - bool - Messages are sent silently (https://telegram.org/blog/channels-2-0#silent-messages) when \"true\". Defaults to \"true\".\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   20,
						},
						File:   "telegram.flux",
						Source: "message",
						Start: ast.Position{
							Column: 1,
							Line:   20,
						},
					},
				},
				Name: "message",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   42,
						},
						File:   "telegram.flux",
						Source: "(\n        url=defaultURL,\n        token,\n        channel,\n        text,\n        parseMode=defaultParseMode,\n        disableWebPagePreview=defaultDisableWebPagePreview,\n        silent=defaultSilent,\n) => {\n    data = {\n        chat_id: channel,\n        text: text,\n        parse_mode: parseMode,\n        disable_web_page_preview: disableWebPagePreview,\n        disable_notification: silent,\n    }\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url + token + \"/sendMessage\", data: enc)\n}",
						Start: ast.Position{
							Column: 11,
							Line:   20,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   42,
							},
							File:   "telegram.flux",
							Source: "{\n    data = {\n        chat_id: channel,\n        text: text,\n        parse_mode: parseMode,\n        disable_web_page_preview: disableWebPagePreview,\n        disable_notification: silent,\n    }\n    headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url + token + \"/sendMessage\", data: enc)\n}",
							Start: ast.Position{
								Column: 6,
								Line:   28,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   35,
								},
								File:   "telegram.flux",
								Source: "data = {\n        chat_id: channel,\n        text: text,\n        parse_mode: parseMode,\n        disable_web_page_preview: disableWebPagePreview,\n        disable_notification: silent,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   29,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   29,
									},
									File:   "telegram.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   29,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   35,
									},
									File:   "telegram.flux",
									Source: "{\n        chat_id: channel,\n        text: text,\n        parse_mode: parseMode,\n        disable_web_page_preview: disableWebPagePreview,\n        disable_notification: silent,\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   29,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   30,
										},
										File:   "telegram.flux",
										Source: "chat_id: channel",
										Start: ast.Position{
											Column: 9,
											Line:   30,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   30,
											},
											File:   "telegram.flux",
											Source: "chat_id",
											Start: ast.Position{
												Column: 9,
												Line:   30,
											},
										},
									},
									Name: "chat_id",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   30,
											},
											File:   "telegram.flux",
											Source: "channel",
											Start: ast.Position{
												Column: 18,
												Line:   30,
											},
										},
									},
									Name: "channel",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   31,
										},
										File:   "telegram.flux",
										Source: "text: text",
										Start: ast.Position{
											Column: 9,
											Line:   31,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   31,
											},
											File:   "telegram.flux",
											Source: "text",
											Start: ast.Position{
												Column: 9,
												Line:   31,
											},
										},
									},
									Name: "text",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   31,
											},
											File:   "telegram.flux",
											Source: "text",
											Start: ast.Position{
												Column: 15,
												Line:   31,
											},
										},
									},
									Name: "text",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   32,
										},
										File:   "telegram.flux",
										Source: "parse_mode: parseMode",
										Start: ast.Position{
											Column: 9,
											Line:   32,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   32,
											},
											File:   "telegram.flux",
											Source: "parse_mode",
											Start: ast.Position{
												Column: 9,
												Line:   32,
											},
										},
									},
									Name: "parse_mode",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   32,
											},
											File:   "telegram.flux",
											Source: "parseMode",
											Start: ast.Position{
												Column: 21,
												Line:   32,
											},
										},
									},
									Name: "parseMode",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   33,
										},
										File:   "telegram.flux",
										Source: "disable_web_page_preview: disableWebPagePreview",
										Start: ast.Position{
											Column: 9,
											Line:   33,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   33,
											},
											File:   "telegram.flux",
											Source: "disable_web_page_preview",
											Start: ast.Position{
												Column: 9,
												Line:   33,
											},
										},
									},
									Name: "disable_web_page_preview",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   33,
											},
											File:   "telegram.flux",
											Source: "disableWebPagePreview",
											Start: ast.Position{
												Column: 35,
												Line:   33,
											},
										},
									},
									Name: "disableWebPagePreview",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   34,
										},
										File:   "telegram.flux",
										Source: "disable_notification: silent",
										Start: ast.Position{
											Column: 9,
											Line:   34,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   34,
											},
											File:   "telegram.flux",
											Source: "disable_notification",
											Start: ast.Position{
												Column: 9,
												Line:   34,
											},
										},
									},
									Name: "disable_notification",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   34,
											},
											File:   "telegram.flux",
											Source: "silent",
											Start: ast.Position{
												Column: 31,
												Line:   34,
											},
										},
									},
									Name: "silent",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   38,
								},
								File:   "telegram.flux",
								Source: "headers = {\n        \"Content-Type\": \"application/json; charset=utf-8\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   36,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   36,
									},
									File:   "telegram.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   36,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   38,
									},
									File:   "telegram.flux",
									Source: "{\n        \"Content-Type\": \"application/json; charset=utf-8\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   36,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   37,
										},
										File:   "telegram.flux",
										Source: "\"Content-Type\": \"application/json; charset=utf-8\"",
										Start: ast.Position{
											Column: 9,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   37,
											},
											File:   "telegram.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   37,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   37,
											},
											File:   "telegram.flux",
											Source: "\"application/json; charset=utf-8\"",
											Start: ast.Position{
												Column: 25,
												Line:   37,
											},
										},
									},
									Value: "application/json; charset=utf-8",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   39,
								},
								File:   "telegram.flux",
								Source: "enc = json.encode(v: data)",
								Start: ast.Position{
									Column: 5,
									Line:   39,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   39,
									},
									File:   "telegram.flux",
									Source: "enc",
									Start: ast.Position{
										Column: 5,
										Line:   39,
									},
								},
							},
							Name: "enc",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   39,
										},
										File:   "telegram.flux",
										Source: "v: data",
										Start: ast.Position{
											Column: 23,
											Line:   39,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   39,
											},
											File:   "telegram.flux",
											Source: "v: data",
											Start: ast.Position{
												Column: 23,
												Line:   39,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   39,
												},
												File:   "telegram.flux",
												Source: "v",
												Start: ast.Position{
													Column: 23,
													Line:   39,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   39,
												},
												File:   "telegram.flux",
												Source: "data",
												Start: ast.Position{
													Column: 26,
													Line:   39,
												},
											},
										},
										Name: "data",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   39,
									},
									File:   "telegram.flux",
									Source: "json.encode(v: data)",
									Start: ast.Position{
										Column: 11,
										Line:   39,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   39,
										},
										File:   "telegram.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 11,
											Line:   39,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   39,
											},
											File:   "telegram.flux",
											Source: "json",
											Start: ast.Position{
												Column: 11,
												Line:   39,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   39,
											},
											File:   "telegram.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 16,
												Line:   39,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   41,
										},
										File:   "telegram.flux",
										Source: "headers: headers, url: url + token + \"/sendMessage\", data: enc",
										Start: ast.Position{
											Column: 22,
											Line:   41,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   41,
											},
											File:   "telegram.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   41,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   41,
												},
												File:   "telegram.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   41,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   41,
												},
												File:   "telegram.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   41,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   41,
											},
											File:   "telegram.flux",
											Source: "url: url + token + \"/sendMessage\"",
											Start: ast.Position{
												Column: 40,
												Line:   41,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   41,
												},
												File:   "telegram.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   41,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 73,
													Line:   41,
												},
												File:   "telegram.flux",
												Source: "url + token + \"/sendMessage\"",
												Start: ast.Position{
													Column: 45,
													Line:   41,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   41,
													},
													File:   "telegram.flux",
													Source: "url + token",
													Start: ast.Position{
														Column: 45,
														Line:   41,
													},
												},
											},
											Left: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 48,
															Line:   41,
														},
														File:   "telegram.flux",
														Source: "url",
														Start: ast.Position{
															Column: 45,
															Line:   41,
														},
													},
												},
												Name: "url",
											},
											Operator: 5,
											Right: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   41,
														},
														File:   "telegram.flux",
														Source: "token",
														Start: ast.Position{
															Column: 51,
															Line:   41,
														},
													},
												},
												Name: "token",
											},
										},
										Operator: 5,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   41,
													},
													File:   "telegram.flux",
													Source: "\"/sendMessage\"",
													Start: ast.Position{
														Column: 59,
														Line:   41,
													},
												},
											},
											Value: "/sendMessage",
										},
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   41,
											},
											File:   "telegram.flux",
											Source: "data: enc",
											Start: ast.Position{
												Column: 75,
												Line:   41,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   41,
												},
												File:   "telegram.flux",
												Source: "data",
												Start: ast.Position{
													Column: 75,
													Line:   41,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 84,
													Line:   41,
												},
												File:   "telegram.flux",
												Source: "enc",
												Start: ast.Position{
													Column: 81,
													Line:   41,
												},
											},
										},
										Name: "enc",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   41,
									},
									File:   "telegram.flux",
									Source: "http.post(headers: headers, url: url + token + \"/sendMessage\", data: enc)",
									Start: ast.Position{
										Column: 12,
										Line:   41,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   41,
										},
										File:   "telegram.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   41,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   41,
											},
											File:   "telegram.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   41,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   41,
											},
											File:   "telegram.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   41,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   41,
								},
								File:   "telegram.flux",
								Source: "return http.post(headers: headers, url: url + token + \"/sendMessage\", data: enc)",
								Start: ast.Position{
									Column: 5,
									Line:   41,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   21,
							},
							File:   "telegram.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 9,
								Line:   21,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   21,
								},
								File:   "telegram.flux",
								Source: "url",
								Start: ast.Position{
									Column: 9,
									Line:   21,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   21,
								},
								File:   "telegram.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 13,
									Line:   21,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   22,
							},
							File:   "telegram.flux",
							Source: "token",
							Start: ast.Position{
								Column: 9,
								Line:   22,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   22,
								},
								File:   "telegram.flux",
								Source: "token",
								Start: ast.Position{
									Column: 9,
									Line:   22,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   23,
							},
							File:   "telegram.flux",
							Source: "channel",
							Start: ast.Position{
								Column: 9,
								Line:   23,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   23,
								},
								File:   "telegram.flux",
								Source: "channel",
								Start: ast.Position{
									Column: 9,
									Line:   23,
								},
							},
						},
						Name: "channel",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   24,
							},
							File:   "telegram.flux",
							Source: "text",
							Start: ast.Position{
								Column: 9,
								Line:   24,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   24,
								},
								File:   "telegram.flux",
								Source: "text",
								Start: ast.Position{
									Column: 9,
									Line:   24,
								},
							},
						},
						Name: "text",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   25,
							},
							File:   "telegram.flux",
							Source: "parseMode=defaultParseMode",
							Start: ast.Position{
								Column: 9,
								Line:   25,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   25,
								},
								File:   "telegram.flux",
								Source: "parseMode",
								Start: ast.Position{
									Column: 9,
									Line:   25,
								},
							},
						},
						Name: "parseMode",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   25,
								},
								File:   "telegram.flux",
								Source: "defaultParseMode",
								Start: ast.Position{
									Column: 19,
									Line:   25,
								},
							},
						},
						Name: "defaultParseMode",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   26,
							},
							File:   "telegram.flux",
							Source: "disableWebPagePreview=defaultDisableWebPagePreview",
							Start: ast.Position{
								Column: 9,
								Line:   26,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   26,
								},
								File:   "telegram.flux",
								Source: "disableWebPagePreview",
								Start: ast.Position{
									Column: 9,
									Line:   26,
								},
							},
						},
						Name: "disableWebPagePreview",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   26,
								},
								File:   "telegram.flux",
								Source: "defaultDisableWebPagePreview",
								Start: ast.Position{
									Column: 31,
									Line:   26,
								},
							},
						},
						Name: "defaultDisableWebPagePreview",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   27,
							},
							File:   "telegram.flux",
							Source: "silent=defaultSilent",
							Start: ast.Position{
								Column: 9,
								Line:   27,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   27,
								},
								File:   "telegram.flux",
								Source: "silent",
								Start: ast.Position{
									Column: 9,
									Line:   27,
								},
							},
						},
						Name: "silent",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   27,
								},
								File:   "telegram.flux",
								Source: "defaultSilent",
								Start: ast.Position{
									Column: 16,
									Line:   27,
								},
							},
						},
						Name: "defaultSilent",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   70,
					},
					File:   "telegram.flux",
					Source: "endpoint = (url=defaultURL, token, parseMode=defaultParseMode, disableWebPagePreview=defaultDisableWebPagePreview) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `endpoint` creates a factory function that creates a target function for pipeline `|>` to send messages to telegram for each table row.\n"}, ast.Comment{Text: "// `url` - string - URL of the telegram bot endpoint. Defaults to: \"https://api.telegram.org/bot\"\n"}, ast.Comment{Text: "// `token` - string - Required telegram bot token string, such as 123456789:AAxSFgij0ln9C7zUKnr4ScDi5QXTGF71S\n"}, ast.Comment{Text: "// `parseMode` - string - Parse mode of the message text per https://core.telegram.org/bots/api#formatting-options . Defaults to \"MarkdownV2\"\n"}, ast.Comment{Text: "// `disableWebPagePreview` - bool - Disables preview of web links in the sent messages when \"true\". Defaults to \"false\"\n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` must return an object with `channel`, `text`, and `silent`, as defined in the `message` function arguments.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   51,
						},
						File:   "telegram.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   70,
						},
						File:   "telegram.flux",
						Source: "(url=defaultURL, token, parseMode=defaultParseMode, disableWebPagePreview=defaultDisableWebPagePreview) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   51,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   70,
							},
							File:   "telegram.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 119,
								Line:   51,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   70,
								},
								File:   "telegram.flux",
								Source: "(tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 130,
									Line:   51,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 151,
											Line:   51,
										},
										File:   "telegram.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 145,
											Line:   51,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   70,
									},
									File:   "telegram.flux",
									Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
									Start: ast.Position{
										Column: 145,
										Line:   51,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   69,
											},
											File:   "telegram.flux",
											Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                ),\n            }\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   53,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   69,
												},
												File:   "telegram.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                ),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   53,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   53,
													},
													File:   "telegram.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   53,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   69,
													},
													File:   "telegram.flux",
													Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                ),\n            }\n        }",
													Start: ast.Position{
														Column: 13,
														Line:   53,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   69,
														},
														File:   "telegram.flux",
														Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                ),\n            }\n        }",
														Start: ast.Position{
															Column: 20,
															Line:   53,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   54,
															},
															File:   "telegram.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 13,
																Line:   54,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   54,
																},
																File:   "telegram.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 13,
																	Line:   54,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   54,
																	},
																	File:   "telegram.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   54,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   54,
																		},
																		File:   "telegram.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   54,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   54,
																			},
																			File:   "telegram.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   54,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   54,
																			},
																			File:   "telegram.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 28,
																				Line:   54,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   54,
																},
																File:   "telegram.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 19,
																	Line:   54,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   54,
																	},
																	File:   "telegram.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 19,
																		Line:   54,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   68,
																},
																File:   "telegram.flux",
																Source: "{r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                ),\n            }",
																Start: ast.Position{
																	Column: 20,
																	Line:   56,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   67,
																	},
																	File:   "telegram.flux",
																	Source: "_sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                )",
																	Start: ast.Position{
																		Column: 17,
																		Line:   57,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   57,
																		},
																		File:   "telegram.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 17,
																			Line:   57,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   66,
																			},
																			File:   "telegram.flux",
																			Source: "v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100",
																			Start: ast.Position{
																				Column: 21,
																				Line:   58,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   66,
																				},
																				File:   "telegram.flux",
																				Source: "v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100",
																				Start: ast.Position{
																					Column: 21,
																					Line:   58,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   58,
																					},
																					File:   "telegram.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 21,
																						Line:   58,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   66,
																					},
																					File:   "telegram.flux",
																					Source: "2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100",
																					Start: ast.Position{
																						Column: 24,
																						Line:   58,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   58,
																						},
																						File:   "telegram.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 24,
																							Line:   58,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   66,
																						},
																						File:   "telegram.flux",
																						Source: "message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100",
																						Start: ast.Position{
																							Column: 29,
																							Line:   58,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 43,
																									Line:   65,
																								},
																								File:   "telegram.flux",
																								Source: "url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent",
																								Start: ast.Position{
																									Column: 25,
																									Line:   59,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   59,
																									},
																									File:   "telegram.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 25,
																										Line:   59,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   59,
																										},
																										File:   "telegram.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 25,
																											Line:   59,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   59,
																										},
																										File:   "telegram.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 30,
																											Line:   59,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 37,
																										Line:   60,
																									},
																									File:   "telegram.flux",
																									Source: "token: token",
																									Start: ast.Position{
																										Column: 25,
																										Line:   60,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   60,
																										},
																										File:   "telegram.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 25,
																											Line:   60,
																										},
																									},
																								},
																								Name: "token",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   60,
																										},
																										File:   "telegram.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 32,
																											Line:   60,
																										},
																									},
																								},
																								Name: "token",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   61,
																									},
																									File:   "telegram.flux",
																									Source: "channel: obj.channel",
																									Start: ast.Position{
																										Column: 25,
																										Line:   61,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 32,
																											Line:   61,
																										},
																										File:   "telegram.flux",
																										Source: "channel",
																										Start: ast.Position{
																											Column: 25,
																											Line:   61,
																										},
																									},
																								},
																								Name: "channel",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   61,
																										},
																										File:   "telegram.flux",
																										Source: "obj.channel",
																										Start: ast.Position{
																											Column: 34,
																											Line:   61,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   61,
																											},
																											File:   "telegram.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 34,
																												Line:   61,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   61,
																											},
																											File:   "telegram.flux",
																											Source: "channel",
																											Start: ast.Position{
																												Column: 38,
																												Line:   61,
																											},
																										},
																									},
																									Name: "channel",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   62,
																									},
																									File:   "telegram.flux",
																									Source: "text: obj.text",
																									Start: ast.Position{
																										Column: 25,
																										Line:   62,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   62,
																										},
																										File:   "telegram.flux",
																										Source: "text",
																										Start: ast.Position{
																											Column: 25,
																											Line:   62,
																										},
																									},
																								},
																								Name: "text",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   62,
																										},
																										File:   "telegram.flux",
																										Source: "obj.text",
																										Start: ast.Position{
																											Column: 31,
																											Line:   62,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 34,
																												Line:   62,
																											},
																											File:   "telegram.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 31,
																												Line:   62,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   62,
																											},
																											File:   "telegram.flux",
																											Source: "text",
																											Start: ast.Position{
																												Column: 35,
																												Line:   62,
																											},
																										},
																									},
																									Name: "text",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   63,
																									},
																									File:   "telegram.flux",
																									Source: "parseMode: parseMode",
																									Start: ast.Position{
																										Column: 25,
																										Line:   63,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 34,
																											Line:   63,
																										},
																										File:   "telegram.flux",
																										Source: "parseMode",
																										Start: ast.Position{
																											Column: 25,
																											Line:   63,
																										},
																									},
																								},
																								Name: "parseMode",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   63,
																										},
																										File:   "telegram.flux",
																										Source: "parseMode",
																										Start: ast.Position{
																											Column: 36,
																											Line:   63,
																										},
																									},
																								},
																								Name: "parseMode",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 69,
																										Line:   64,
																									},
																									File:   "telegram.flux",
																									Source: "disableWebPagePreview: disableWebPagePreview",
																									Start: ast.Position{
																										Column: 25,
																										Line:   64,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 46,
																											Line:   64,
																										},
																										File:   "telegram.flux",
																										Source: "disableWebPagePreview",
																										Start: ast.Position{
																											Column: 25,
																											Line:   64,
																										},
																									},
																								},
																								Name: "disableWebPagePreview",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 69,
																											Line:   64,
																										},
																										File:   "telegram.flux",
																										Source: "disableWebPagePreview",
																										Start: ast.Position{
																											Column: 48,
																											Line:   64,
																										},
																									},
																								},
																								Name: "disableWebPagePreview",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 43,
																										Line:   65,
																									},
																									File:   "telegram.flux",
																									Source: "silent: obj.silent",
																									Start: ast.Position{
																										Column: 25,
																										Line:   65,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   65,
																										},
																										File:   "telegram.flux",
																										Source: "silent",
																										Start: ast.Position{
																											Column: 25,
																											Line:   65,
																										},
																									},
																								},
																								Name: "silent",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   65,
																										},
																										File:   "telegram.flux",
																										Source: "obj.silent",
																										Start: ast.Position{
																											Column: 33,
																											Line:   65,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 36,
																												Line:   65,
																											},
																											File:   "telegram.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 33,
																												Line:   65,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 43,
																												Line:   65,
																											},
																											File:   "telegram.flux",
																											Source: "silent",
																											Start: ast.Position{
																												Column: 37,
																												Line:   65,
																											},
																										},
																									},
																									Name: "silent",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   66,
																							},
																							File:   "telegram.flux",
																							Source: "message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    )",
																							Start: ast.Position{
																								Column: 29,
																								Line:   58,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 36,
																									Line:   58,
																								},
																								File:   "telegram.flux",
																								Source: "message",
																								Start: ast.Position{
																									Column: 29,
																									Line:   58,
																								},
																							},
																						},
																						Name: "message",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   66,
																							},
																							File:   "telegram.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 25,
																								Line:   66,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   67,
																		},
																		File:   "telegram.flux",
																		Source: "string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                )",
																		Start: ast.Position{
																			Column: 24,
																			Line:   57,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   57,
																			},
																			File:   "telegram.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 24,
																				Line:   57,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   56,
																	},
																	File:   "telegram.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   56,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   68,
															},
															File:   "telegram.flux",
															Source: "return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                ),\n            }",
															Start: ast.Position{
																Column: 13,
																Line:   56,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   53,
														},
														File:   "telegram.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   53,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   53,
															},
															File:   "telegram.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   53,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   70,
										},
										File:   "telegram.flux",
										Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        parseMode: parseMode,\n                        disableWebPagePreview: disableWebPagePreview,\n                        silent: obj.silent,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   52,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   52,
											},
											File:   "telegram.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   52,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 140,
										Line:   51,
									},
									File:   "telegram.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 131,
										Line:   51,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 137,
											Line:   51,
										},
										File:   "telegram.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 131,
											Line:   51,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 140,
										Line:   51,
									},
									File:   "telegram.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 138,
										Line:   51,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 125,
									Line:   51,
								},
								File:   "telegram.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 120,
									Line:   51,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 125,
										Line:   51,
									},
									File:   "telegram.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 120,
										Line:   51,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   51,
							},
							File:   "telegram.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 13,
								Line:   51,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   51,
								},
								File:   "telegram.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   51,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   51,
								},
								File:   "telegram.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 17,
									Line:   51,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   51,
							},
							File:   "telegram.flux",
							Source: "token",
							Start: ast.Position{
								Column: 29,
								Line:   51,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   51,
								},
								File:   "telegram.flux",
								Source: "token",
								Start: ast.Position{
									Column: 29,
									Line:   51,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 62,
								Line:   51,
							},
							File:   "telegram.flux",
							Source: "parseMode=defaultParseMode",
							Start: ast.Position{
								Column: 36,
								Line:   51,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   51,
								},
								File:   "telegram.flux",
								Source: "parseMode",
								Start: ast.Position{
									Column: 36,
									Line:   51,
								},
							},
						},
						Name: "parseMode",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   51,
								},
								File:   "telegram.flux",
								Source: "defaultParseMode",
								Start: ast.Position{
									Column: 46,
									Line:   51,
								},
							},
						},
						Name: "defaultParseMode",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 114,
								Line:   51,
							},
							File:   "telegram.flux",
							Source: "disableWebPagePreview=defaultDisableWebPagePreview",
							Start: ast.Position{
								Column: 64,
								Line:   51,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   51,
								},
								File:   "telegram.flux",
								Source: "disableWebPagePreview",
								Start: ast.Position{
									Column: 64,
									Line:   51,
								},
							},
						},
						Name: "disableWebPagePreview",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 114,
									Line:   51,
								},
								File:   "telegram.flux",
								Source: "defaultDisableWebPagePreview",
								Start: ast.Position{
									Column: 86,
									Line:   51,
								},
							},
						},
						Name: "defaultDisableWebPagePreview",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "telegram.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "telegram.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "telegram.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "telegram.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "telegram.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   1,
					},
					File:   "telegram.flux",
					Source: "package telegram",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   1,
						},
						File:   "telegram.flux",
						Source: "telegram",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "telegram",
			},
		},
	}},
	Package: "telegram",
	Path:    "contrib/sranka/telegram",
}
