// DO NOT EDIT: This file is autogenerated via the builtin command.

package json

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 111,
					Line:   42,
				},
				File:   "json_test.flux",
				Source: "package json_test\n\n\nimport \"experimental/json\"\nimport \"testing\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_field,_measurement,_value\n,,0,2018-05-22T19:53:26Z,json,m,\\\"{\\\"\\\"a\\\"\\\":1,\\\"\\\"b\\\"\\\":2,\\\"\\\"c\\\"\\\":3}\\\"\n,,0,2018-05-22T19:53:36Z,json,m,\\\"{\\\"\\\"a\\\"\\\":2,\\\"\\\"b\\\"\\\":4,\\\"\\\"c\\\"\\\":6}\\\"\n,,0,2018-05-22T19:53:46Z,json,m,\\\"{\\\"\\\"a\\\"\\\":3,\\\"\\\"b\\\"\\\":5,\\\"\\\"c\\\"\\\":7}\\\"\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,double,double,double\n#group,false,false,false,false,false,false\n#default,_result,,,,,\n,result,table,_time,a,b,c\n,,0,2018-05-22T19:53:26Z,1,2,3\n,,0,2018-05-22T19:53:36Z,2,4,6\n,,0,2018-05-22T19:53:46Z,3,5,7\n\"\n_json = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(\n        fn: (r) => {\n            data = json.parse(data: bytes(v: r._value))\n\n            return {\n                _time: r._time,\n                a: data.a,\n                b: data.b,\n                c: data.c,\n            }\n        },\n    )\n\ntest parse = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: _json})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "json_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "json_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "json_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "json_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "json_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   17,
					},
					File:   "json_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_field,_measurement,_value\n,,0,2018-05-22T19:53:26Z,json,m,\\\"{\\\"\\\"a\\\"\\\":1,\\\"\\\"b\\\"\\\":2,\\\"\\\"c\\\"\\\":3}\\\"\n,,0,2018-05-22T19:53:36Z,json,m,\\\"{\\\"\\\"a\\\"\\\":2,\\\"\\\"b\\\"\\\":4,\\\"\\\"c\\\"\\\":6}\\\"\n,,0,2018-05-22T19:53:46Z,json,m,\\\"{\\\"\\\"a\\\"\\\":3,\\\"\\\"b\\\"\\\":5,\\\"\\\"c\\\"\\\":7}\\\"\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "json_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   17,
						},
						File:   "json_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_field,_measurement,_value\n,,0,2018-05-22T19:53:26Z,json,m,\\\"{\\\"\\\"a\\\"\\\":1,\\\"\\\"b\\\"\\\":2,\\\"\\\"c\\\"\\\":3}\\\"\n,,0,2018-05-22T19:53:36Z,json,m,\\\"{\\\"\\\"a\\\"\\\":2,\\\"\\\"b\\\"\\\":4,\\\"\\\"c\\\"\\\":6}\\\"\n,,0,2018-05-22T19:53:46Z,json,m,\\\"{\\\"\\\"a\\\"\\\":3,\\\"\\\"b\\\"\\\":5,\\\"\\\"c\\\"\\\":7}\\\"\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_field,_measurement,_value\n,,0,2018-05-22T19:53:26Z,json,m,\"{\"\"a\"\":1,\"\"b\"\":2,\"\"c\"\":3}\"\n,,0,2018-05-22T19:53:36Z,json,m,\"{\"\"a\"\":2,\"\"b\"\":4,\"\"c\"\":6}\"\n,,0,2018-05-22T19:53:46Z,json,m,\"{\"\"a\"\":3,\"\"b\"\":5,\"\"c\"\":7}\"\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   26,
					},
					File:   "json_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,double,double,double\n#group,false,false,false,false,false,false\n#default,_result,,,,,\n,result,table,_time,a,b,c\n,,0,2018-05-22T19:53:26Z,1,2,3\n,,0,2018-05-22T19:53:36Z,2,4,6\n,,0,2018-05-22T19:53:46Z,3,5,7\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   18,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   18,
						},
						File:   "json_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   18,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   26,
						},
						File:   "json_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,double,double,double\n#group,false,false,false,false,false,false\n#default,_result,,,,,\n,result,table,_time,a,b,c\n,,0,2018-05-22T19:53:26Z,1,2,3\n,,0,2018-05-22T19:53:36Z,2,4,6\n,,0,2018-05-22T19:53:46Z,3,5,7\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   18,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,double,double,double\n#group,false,false,false,false,false,false\n#default,_result,,,,,\n,result,table,_time,a,b,c\n,,0,2018-05-22T19:53:26Z,1,2,3\n,,0,2018-05-22T19:53:36Z,2,4,6\n,,0,2018-05-22T19:53:46Z,3,5,7\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   40,
					},
					File:   "json_test.flux",
					Source: "_json = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(\n        fn: (r) => {\n            data = json.parse(data: bytes(v: r._value))\n\n            return {\n                _time: r._time,\n                a: data.a,\n                b: data.b,\n                c: data.c,\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   27,
						},
						File:   "json_test.flux",
						Source: "_json",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "_json",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   40,
						},
						File:   "json_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(\n        fn: (r) => {\n            data = json.parse(data: bytes(v: r._value))\n\n            return {\n                _time: r._time,\n                a: data.a,\n                b: data.b,\n                c: data.c,\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 9,
							Line:   27,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   27,
									},
									File:   "json_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 23,
										Line:   27,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   28,
								},
								File:   "json_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 23,
									Line:   27,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   28,
										},
										File:   "json_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   28,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   28,
											},
											File:   "json_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   28,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   28,
												},
												File:   "json_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   28,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   28,
												},
												File:   "json_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   28,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   28,
									},
									File:   "json_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   28,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   28,
										},
										File:   "json_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   28,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   40,
							},
							File:   "json_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(\n        fn: (r) => {\n            data = json.parse(data: bytes(v: r._value))\n\n            return {\n                _time: r._time,\n                a: data.a,\n                b: data.b,\n                c: data.c,\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 23,
								Line:   27,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   39,
									},
									File:   "json_test.flux",
									Source: "fn: (r) => {\n            data = json.parse(data: bytes(v: r._value))\n\n            return {\n                _time: r._time,\n                a: data.a,\n                b: data.b,\n                c: data.c,\n            }\n        }",
									Start: ast.Position{
										Column: 9,
										Line:   30,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   39,
										},
										File:   "json_test.flux",
										Source: "fn: (r) => {\n            data = json.parse(data: bytes(v: r._value))\n\n            return {\n                _time: r._time,\n                a: data.a,\n                b: data.b,\n                c: data.c,\n            }\n        }",
										Start: ast.Position{
											Column: 9,
											Line:   30,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   30,
											},
											File:   "json_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 9,
												Line:   30,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   39,
											},
											File:   "json_test.flux",
											Source: "(r) => {\n            data = json.parse(data: bytes(v: r._value))\n\n            return {\n                _time: r._time,\n                a: data.a,\n                b: data.b,\n                c: data.c,\n            }\n        }",
											Start: ast.Position{
												Column: 13,
												Line:   30,
											},
										},
									},
									Body: &ast.Block{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   39,
												},
												File:   "json_test.flux",
												Source: "{\n            data = json.parse(data: bytes(v: r._value))\n\n            return {\n                _time: r._time,\n                a: data.a,\n                b: data.b,\n                c: data.c,\n            }\n        }",
												Start: ast.Position{
													Column: 20,
													Line:   30,
												},
											},
										},
										Body: []ast.Statement{&ast.VariableAssignment{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   31,
													},
													File:   "json_test.flux",
													Source: "data = json.parse(data: bytes(v: r._value))",
													Start: ast.Position{
														Column: 13,
														Line:   31,
													},
												},
											},
											ID: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   31,
														},
														File:   "json_test.flux",
														Source: "data",
														Start: ast.Position{
															Column: 13,
															Line:   31,
														},
													},
												},
												Name: "data",
											},
											Init: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 55,
																Line:   31,
															},
															File:   "json_test.flux",
															Source: "data: bytes(v: r._value)",
															Start: ast.Position{
																Column: 31,
																Line:   31,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   31,
																},
																File:   "json_test.flux",
																Source: "data: bytes(v: r._value)",
																Start: ast.Position{
																	Column: 31,
																	Line:   31,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 35,
																		Line:   31,
																	},
																	File:   "json_test.flux",
																	Source: "data",
																	Start: ast.Position{
																		Column: 31,
																		Line:   31,
																	},
																},
															},
															Name: "data",
														},
														Separator: nil,
														Value: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 54,
																			Line:   31,
																		},
																		File:   "json_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 43,
																			Line:   31,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 54,
																				Line:   31,
																			},
																			File:   "json_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 43,
																				Line:   31,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 44,
																					Line:   31,
																				},
																				File:   "json_test.flux",
																				Source: "v",
																				Start: ast.Position{
																					Column: 43,
																					Line:   31,
																				},
																			},
																		},
																		Name: "v",
																	},
																	Separator: nil,
																	Value: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 54,
																					Line:   31,
																				},
																				File:   "json_test.flux",
																				Source: "r._value",
																				Start: ast.Position{
																					Column: 46,
																					Line:   31,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 47,
																						Line:   31,
																					},
																					File:   "json_test.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 46,
																						Line:   31,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 54,
																						Line:   31,
																					},
																					File:   "json_test.flux",
																					Source: "_value",
																					Start: ast.Position{
																						Column: 48,
																						Line:   31,
																					},
																				},
																			},
																			Name: "_value",
																		},
																		Rbrack: nil,
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   31,
																	},
																	File:   "json_test.flux",
																	Source: "bytes(v: r._value)",
																	Start: ast.Position{
																		Column: 37,
																		Line:   31,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   31,
																		},
																		File:   "json_test.flux",
																		Source: "bytes",
																		Start: ast.Position{
																			Column: 37,
																			Line:   31,
																		},
																	},
																},
																Name: "bytes",
															},
															Lparen: nil,
															Rparen: nil,
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   31,
														},
														File:   "json_test.flux",
														Source: "json.parse(data: bytes(v: r._value))",
														Start: ast.Position{
															Column: 20,
															Line:   31,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   31,
															},
															File:   "json_test.flux",
															Source: "json.parse",
															Start: ast.Position{
																Column: 20,
																Line:   31,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   31,
																},
																File:   "json_test.flux",
																Source: "json",
																Start: ast.Position{
																	Column: 20,
																	Line:   31,
																},
															},
														},
														Name: "json",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   31,
																},
																File:   "json_test.flux",
																Source: "parse",
																Start: ast.Position{
																	Column: 25,
																	Line:   31,
																},
															},
														},
														Name: "parse",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
										}, &ast.ReturnStatement{
											Argument: &ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   38,
														},
														File:   "json_test.flux",
														Source: "{\n                _time: r._time,\n                a: data.a,\n                b: data.b,\n                c: data.c,\n            }",
														Start: ast.Position{
															Column: 20,
															Line:   33,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 31,
																Line:   34,
															},
															File:   "json_test.flux",
															Source: "_time: r._time",
															Start: ast.Position{
																Column: 17,
																Line:   34,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   34,
																},
																File:   "json_test.flux",
																Source: "_time",
																Start: ast.Position{
																	Column: 17,
																	Line:   34,
																},
															},
														},
														Name: "_time",
													},
													Separator: nil,
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   34,
																},
																File:   "json_test.flux",
																Source: "r._time",
																Start: ast.Position{
																	Column: 24,
																	Line:   34,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 25,
																		Line:   34,
																	},
																	File:   "json_test.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 24,
																		Line:   34,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   34,
																	},
																	File:   "json_test.flux",
																	Source: "_time",
																	Start: ast.Position{
																		Column: 26,
																		Line:   34,
																	},
																},
															},
															Name: "_time",
														},
														Rbrack: nil,
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   35,
															},
															File:   "json_test.flux",
															Source: "a: data.a",
															Start: ast.Position{
																Column: 17,
																Line:   35,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   35,
																},
																File:   "json_test.flux",
																Source: "a",
																Start: ast.Position{
																	Column: 17,
																	Line:   35,
																},
															},
														},
														Name: "a",
													},
													Separator: nil,
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   35,
																},
																File:   "json_test.flux",
																Source: "data.a",
																Start: ast.Position{
																	Column: 20,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   35,
																	},
																	File:   "json_test.flux",
																	Source: "data",
																	Start: ast.Position{
																		Column: 20,
																		Line:   35,
																	},
																},
															},
															Name: "data",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   35,
																	},
																	File:   "json_test.flux",
																	Source: "a",
																	Start: ast.Position{
																		Column: 25,
																		Line:   35,
																	},
																},
															},
															Name: "a",
														},
														Rbrack: nil,
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   36,
															},
															File:   "json_test.flux",
															Source: "b: data.b",
															Start: ast.Position{
																Column: 17,
																Line:   36,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   36,
																},
																File:   "json_test.flux",
																Source: "b",
																Start: ast.Position{
																	Column: 17,
																	Line:   36,
																},
															},
														},
														Name: "b",
													},
													Separator: nil,
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   36,
																},
																File:   "json_test.flux",
																Source: "data.b",
																Start: ast.Position{
																	Column: 20,
																	Line:   36,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   36,
																	},
																	File:   "json_test.flux",
																	Source: "data",
																	Start: ast.Position{
																		Column: 20,
																		Line:   36,
																	},
																},
															},
															Name: "data",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   36,
																	},
																	File:   "json_test.flux",
																	Source: "b",
																	Start: ast.Position{
																		Column: 25,
																		Line:   36,
																	},
																},
															},
															Name: "b",
														},
														Rbrack: nil,
													},
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   37,
															},
															File:   "json_test.flux",
															Source: "c: data.c",
															Start: ast.Position{
																Column: 17,
																Line:   37,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 18,
																	Line:   37,
																},
																File:   "json_test.flux",
																Source: "c",
																Start: ast.Position{
																	Column: 17,
																	Line:   37,
																},
															},
														},
														Name: "c",
													},
													Separator: nil,
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 26,
																	Line:   37,
																},
																File:   "json_test.flux",
																Source: "data.c",
																Start: ast.Position{
																	Column: 20,
																	Line:   37,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   37,
																	},
																	File:   "json_test.flux",
																	Source: "data",
																	Start: ast.Position{
																		Column: 20,
																		Line:   37,
																	},
																},
															},
															Name: "data",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 26,
																		Line:   37,
																	},
																	File:   "json_test.flux",
																	Source: "c",
																	Start: ast.Position{
																		Column: 25,
																		Line:   37,
																	},
																},
															},
															Name: "c",
														},
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   38,
													},
													File:   "json_test.flux",
													Source: "return {\n                _time: r._time,\n                a: data.a,\n                b: data.b,\n                c: data.c,\n            }",
													Start: ast.Position{
														Column: 13,
														Line:   33,
													},
												},
											},
										}},
										Lbrace: nil,
										Rbrace: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   30,
												},
												File:   "json_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 14,
													Line:   30,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   30,
													},
													File:   "json_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 14,
														Line:   30,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   40,
								},
								File:   "json_test.flux",
								Source: "map(\n        fn: (r) => {\n            data = json.parse(data: bytes(v: r._value))\n\n            return {\n                _time: r._time,\n                a: data.a,\n                b: data.b,\n                c: data.c,\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 8,
									Line:   29,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   29,
									},
									File:   "json_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   29,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   27,
							},
							File:   "json_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 10,
								Line:   27,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   27,
								},
								File:   "json_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 10,
									Line:   27,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   27,
							},
							File:   "json_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   27,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 111,
							Line:   42,
						},
						File:   "json_test.flux",
						Source: "parse = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: _json})",
						Start: ast.Position{
							Column: 6,
							Line:   42,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   42,
							},
							File:   "json_test.flux",
							Source: "parse",
							Start: ast.Position{
								Column: 6,
								Line:   42,
							},
						},
					},
					Name: "parse",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 111,
								Line:   42,
							},
							File:   "json_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: _json})",
							Start: ast.Position{
								Column: 14,
								Line:   42,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 111,
									Line:   42,
								},
								File:   "json_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: _json})",
								Start: ast.Position{
									Column: 20,
									Line:   42,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 110,
										Line:   42,
									},
									File:   "json_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: _json}",
									Start: ast.Position{
										Column: 21,
										Line:   42,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   42,
										},
										File:   "json_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 22,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   42,
											},
											File:   "json_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 22,
												Line:   42,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   42,
												},
												File:   "json_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 49,
													Line:   42,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   42,
													},
													File:   "json_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 49,
														Line:   42,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   42,
														},
														File:   "json_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 49,
															Line:   42,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   42,
														},
														File:   "json_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 54,
															Line:   42,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   42,
											},
											File:   "json_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 29,
												Line:   42,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   42,
												},
												File:   "json_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 29,
													Line:   42,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   42,
													},
													File:   "json_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 29,
														Line:   42,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   42,
													},
													File:   "json_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 37,
														Line:   42,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   42,
										},
										File:   "json_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 63,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   42,
											},
											File:   "json_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 63,
												Line:   42,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 97,
													Line:   42,
												},
												File:   "json_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 85,
													Line:   42,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 97,
														Line:   42,
													},
													File:   "json_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 85,
														Line:   42,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 88,
															Line:   42,
														},
														File:   "json_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 85,
															Line:   42,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 97,
															Line:   42,
														},
														File:   "json_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 90,
															Line:   42,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   42,
											},
											File:   "json_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 69,
												Line:   42,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 84,
													Line:   42,
												},
												File:   "json_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 69,
													Line:   42,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   42,
													},
													File:   "json_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 69,
														Line:   42,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 84,
														Line:   42,
													},
													File:   "json_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 77,
														Line:   42,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 109,
											Line:   42,
										},
										File:   "json_test.flux",
										Source: "fn: _json",
										Start: ast.Position{
											Column: 100,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 102,
												Line:   42,
											},
											File:   "json_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 100,
												Line:   42,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   42,
											},
											File:   "json_test.flux",
											Source: "_json",
											Start: ast.Position{
												Column: 104,
												Line:   42,
											},
										},
									},
									Name: "_json",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 111,
						Line:   42,
					},
					File:   "json_test.flux",
					Source: "test parse = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: _json})",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 27,
						Line:   4,
					},
					File:   "json_test.flux",
					Source: "import \"experimental/json\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 27,
							Line:   4,
						},
						File:   "json_test.flux",
						Source: "\"experimental/json\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "experimental/json",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "json_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "json_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "testing",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "json_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "json_test.flux",
					Source: "package json_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "json_test.flux",
						Source: "json_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "json_test",
			},
		},
	}},
	Package: "json_test",
	Path:    "experimental/json",
}}
