// DO NOT EDIT: This file is autogenerated via the builtin command.

package math

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 11,
					Line:   1569,
				},
				File:   "math.flux",
				Source: "package math\n\n\n// on floating point numbers.\nbuiltin pi : float\nbuiltin e : float\nbuiltin phi : float\nbuiltin sqrt2 : float\nbuiltin sqrte : float\nbuiltin sqrtpi : float\nbuiltin sqrtphi : float\nbuiltin ln2 : float\nbuiltin log2e : float\nbuiltin ln10 : float\nbuiltin log10e : float\nbuiltin maxfloat : float\nbuiltin smallestNonzeroFloat : float\nbuiltin maxint : int\nbuiltin minint : int\nbuiltin maxuint : uint\n\n// abs is a function that returns the absolute value of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.abs(x: -1.22)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.abs(x: ±Inf) // returns +Inf\n// math.abs(x: NaN) // returns NaN\n// ```\nbuiltin abs : (x: float) => float\n\n// acos is a funciton that returns the acosine of x in radians.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n//   x should be greater than -1 and less than 1. Otherwise, the operation\n//   will return NaN.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.acos(x: 0.22)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.acos(x: <-1) // returns NaN\n// math.acos(x: >1) // returns NaN\n// ```\nbuiltin acos : (x: float) => float\n\n// acosh is a function that returns the inverse hyperbolic cosine of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n//   x should be greater than 1. If less than 1 the operation will return NaN.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.acosh(x: 1.22)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.acosh(x: +Inf) // returns +Inf\n// math.acosh(x: <1) // returns NaN\n// math.acosh(x: NaN) // returns NaN\n// ```\nbuiltin acosh : (x: float) => float\n\n// asin is a function that returns the arcsine of x in radians.\n//\n// ## Parameters\n// - `x` is is value used in the operation.\n//\n//   x should be greater than -1 and less than 1. Otherwise the function will\n//   return NaN.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.asin(x: 0.22)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.asin(x: ±0) // returns ±0\n// math.asin(x: <-1) // returns NaN\n// math.asin(x: >1) // returns NaN\n// ```\nbuiltin asin : (x: float) => float\n\n// asinh is a function that returns the inverse hyperbolic sine of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.asinh(x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.asinh(x: ±0) // returns ±0\n// math.asinh(x: ±Inf) // returns ±Inf\n// math.asinh(x: NaN) // returns NaN\n// ```\nbuiltin asinh : (x: float) => float\n\n// atan is a function that returns the arctangent of x in radians.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.atan(x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.atan(x: ±0) // returns ±0\n// math.atan(x: ±Inf) // returns ±Pi/2\n// ```\nbuiltin atan : (x: float) => float\n\n// atan2 is a function that returns the artangent of x/y, using the signs\n//  of the two to determine the quadrant of the return value.\n//\n// ## Parameters\n// - `y` is the y-coordinate used in the operation.\n// - `x` is the x-corrdinate used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.atan2(y: 1.22, x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.atan2(y:y, x:NaN)        // Returns NaN\n// math.atan2(y: NaN, x:x)       // Returns NaN\n// math.atan2(y: +0, x: >=0)     // Returns +0\n// math.atan2(y: -0, x: >=0)     // Returns -0\n// math.atan2(y: +0, x: <=-0)    // Returns +Pi\n// math.atan2(y: -0, x: <=-0)    // Returns -Pi\n// math.atan2(y: >0, x: 0)       // Returns +Pi/2\n// math.atan2(y: <0, x: 0)       // Returns -Pi/2\n// math.atan2(y: +Inf, x: +Inf)  // Returns +Pi/4\n// math.atan2(y: -Inf, x: +Inf)  // Returns -Pi/4\n// math.atan2(y: +Inf, x: -Inf)  // Returns 3Pi/4\n// math.atan2(y: -Inf, x: -Inf)  // Returns -3Pi/4\n// math.atan2(y:y, x: +Inf)      // Returns 0\n// math.atan2(y: >0, x: -Inf)    // Returns +Pi\n// math.atan2(y: <0, x: -Inf)    // Returns -Pi\n// math.atan2(y: +Inf, x:x)      // Returns +Pi/2\n// math.atan2(y: -Inf, x:x)      // Returns -Pi/2\n// ```\nbuiltin atan2 : (y: float, x: float) => float\n\n// atanh is a function that returns the inverse hyperbolic tangent of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n//   x should be greater than -1 and less than 1, otherwise the operation\n//   will return NaN.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.atanh(x: 0.22)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.atanh(x: 1)   // Returns +Inf\n// math.atanh(x: ±0)  // Returns ±0\n// math.atanh(x: -1)  // Returns -Inf\n// math.atanh(x: <-1) // Returns NaN\n// math.atanh(x: >1)  // Returns NaN\n// math.atanh(x: NaN) // Returns NaN\n// ```\nbuiltin atanh : (x: float) => float\n\n// cbrt is a function that returns the cube root of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.cbrt(x: 1728.0)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.cbrt(±0)   // Returns ±0\n// math.cbrt(±Inf) // Returns ±Inf\n// math.cbrt(NaN)  // Returns NaN\n// ```\nbuiltin cbrt : (x: float) => float\n\n// ceil is a function that returns the least integer value greater than\n//  or equal to x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.ceil(x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.ceil(±0)   // Returns ±0\n// math.ceil(±Inf) // Returns ±Inf\n// math.ceil(NaN)  // Returns NaN\n// ```\nbuiltin ceil : (x: float) => float\n\n// copysign is a function that returns a value with the magnitude x and\n//  the sign of y.\n//\n// ## Parameters\n// - `x` is the magnitude used in the operation.\n// - `y` is the sign used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.copysign(x: 1.0, y: 2.0)\n// ```\nbuiltin copysign : (x: float, y: float) => float\n\n// cos is a function that returns the cosine of the radian argument x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.cos(x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.cos(±Inf) // Returns NaN\n// math.cos(NaN)  // Returns NaN\n// ```\nbuiltin cos : (x: float) => float\n\n// cosh is a function that returns the hyperbolic cosine of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.cosh(x: 1.22)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.cosh(±0)   // Returns 1\n// math.cosh(±Inf) // Returns +Inf\n// math.cosh(NaN)  // Returns NaN\n// ```\nbuiltin cosh : (x: float) => float\n\n// dim is a function that returns the maximum of x - y or 0.\n//\n// ## Parameters\n// - `x` is the X-value used in the operation .\n// - 'y' is the Y-value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.dim(x: 12.2, y: 8.1)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.dim(x: +Inf, y: +Inf) // Returns NaN\n// math.dim(x: -Inf, y: -Inf) // Returns NaN\n// math.dim(x:x, y    : NaN)  // Returns NaN\n// math.dim(x: NaN, y :y)     // Returns NaN\n// ```\nbuiltin dim : (x: float, y: float) => float\n\n// erf is a function that returns the error function of x\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.erf(x: 22.6)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.erf(+Inf) // Returns 1\n// math.erf(-Inf) // Returns -1\n// math.erf(NaN)  // Returns NaN\n// ```\nbuiltin erf : (x: float) => float\n\n// erfc is a function that returns the complementary error function of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.erfc(x: 22.6)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.erfc(+Inf) // Returns 0\n// math.erfc(-Inf) // Returns 2\n// math.erfc(NaN)  // Returns NaN\n// ```\nbuiltin erfc : (x: float) => float\n\n// erfcinv is a function that returns the inverse of math.erfc().\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n//   x should be greater than 0 and less than 2. Otherwise the operation\n//   will return NaN.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.erfcinv(x: 0.42345)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.erfcinv(x: 0)   // Returns +Inf\n// math.erfcinv(x: 2)   // Returns -Inf\n// math.erfcinv(x: <0)  // Returns NaN\n// math.erfcinv(x: >2)  // Returns NaN\n// math.erfcinv(x: NaN) // Returns NaN\n// ```\nbuiltin erfcinv : (x: float) => float\n\n// erfinv is a function that returns the inverse error function of x.\n//\n// ## Parameter\n// - `x` is the value used in the operation.\n//\n//   x should be greater than -1 and less than 1. Otherwise, the operation will\n//   return NaN.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.erfinv(x: 0.22)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.erfinv(x: 1)   // Returns +Inf\n// math.erfinv(x: -1)  // Returns -Inf\n// math.erfinv(x: <-1) // Returns NaN\n// math.erfinv(x: > 1) // Returns NaN\n// math.erfinv(x: NaN) // Returns NaN\n// ```\nbuiltin erfinv : (x: float) => float\n\n// exp is a function that returns `e**x`, the base-e exponential of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.exp(x: 21.0)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.exp(x: +Inf) // Returns +Inf\n// math.exp(x: NaN)  // Returns NaN\n// ```\nbuiltin exp : (x: float) => float\n\n// exp2 is a function that returns `2**x`, the base-2 exponential of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.exp2(x: 21.0)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.exp2(x: +Inf) // Returns +Inf\n// math.exp2(x: NaN)  // Returns NaN\n// ```\n//\n// Very large values overflow to 0 or +Inf. Very small values overflow to 1.\nbuiltin exp2 : (x: float) => float\n\n// expm1 is a function that returns `e**x - 1`, the base-e exponential of x minus\n//  1. It is more accurate than `math.exp(x:x) - 1` when x is near zero.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.expm1(x: 1.22)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.expm1(+Inf) // Returns +Inf\n// math.expm1(-Inf) // Returns -1\n// math.expm1(NaN)  // Returns NaN\n// ```\n//\n// Very large values overflow to -1 or +Inf.\nbuiltin expm1 : (x: float) => float\n\n// float64bits is a function that returns the IEEE 754 binary representation of f,\n//  with the sign bit of f and the result in the same bit position.\n//\n// ## Parameters\n// - `f` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.float64bits(f: 1234.56)\n// ```\nbuiltin float64bits : (f: float) => uint\n\n// float64frombits is a function that returns the floating-point number corresponding\n//  to the IEE 754 binary representation b, with the sign bit of b and the result in the\n//  same bit position.\n//\n// ## Parameters\n// - `b` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.float64frombits(b: 4)\n// ```\nbuiltin float64frombits : (b: uint) => float\n\n// floor is a function that returns the greatest integer value less than or\n//  equal to x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.floor(x: 1.22)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.floor(±0)   // Returns ±0\n// math.floor(±Inf) // Returns ±Inf\n// math.floor(NaN)  // Returns NaN\n// ```\nbuiltin floor : (x: float) => float\n\n// frexp is a function that breaks f into a normalized fraction and an\n//  integral part of two.\n//\n//  It returns frac and exp satisfying `f == frac x 2**exp`,\n//  with the absolute value of frac in the interval [1/2, 1).\n//\n// ## Parameters\n// - `f` the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.frexp(f: 22.0)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.frexp(f: ±0)   // Returns {frac: ±0, exp: 0}\n// math.frexp(f: ±Inf) // Returns {frac: ±Inf, exp: 0}\n// math.frexp(f: NaN)  // Returns {frac: NaN, exp: 0}\n// ```\nbuiltin frexp : (f: float) => {frac: float, exp: int}\n\n// gamma is a function that returns the gamma function of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.gamma(x: 2.12)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.gamma(x: +Inf) = +Inf\n// math.gamma(x: +0) = +Inf\n// math.gamma(x: -0) = -Inf\n// math.gamma(x: <0) = NaN for integer x < 0\n// math.gamma(x: -Inf) = NaN\n// math.gamma(x: NaN) = NaN\n// ```\nbuiltin gamma : (x: float) => float\n\n// hypot is a function that returns the square root of `p*p + q*q`, taking\n//  care to avoid overflow and underflow.\n//\n// ## Params\n// - `p` is the p-value used in the operation.\n// - `q` is the q-value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.hypot(p: 2.0, q: 5.0)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.hypot(p: ±Inf, q:q) // Returns +Inf\n// math.hypot(p:p, q: ±Inf) // Returns +Inf\n// math.hypot(p: NaN, q:q)  // Returns NaN\n// math.hypot(p:p, q: NaN)  // Returns NaN\n// ```\nbuiltin hypot : (x: float) => float\n\n// ilogb is a function that returns the binary exponent of x as an integer.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.ilogb(x: 123.45)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.ilogb(x: ±Inf) // Returns MaxInt32\n// math.ilogb(x: 0)    // Returns MinInt32\n// math.ilogb(x: NaN)  // Returns MaxInt32\n// ```\nbuiltin ilogb : (x: float) => float\n\n// mInf is a function that returns positive infinity if `sign >= 0`, negative infinity\n// if `sign < 0`\n//\n// ## Parameters\n// - `sign` is the sign value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.mInf(sign: 1)\n// ```\nbuiltin mInf : (sign: int) => float\n\n// isInf is a function that reports whether f is an infinity, according to sign.\n//\n// If `sign > 0`, math.isInf reports whether f is positive infinity.\n// If `sign < 0`, math.isInf reports whether f is negative infinity.\n// If `sign  == 0`, math.isInf reports whether f is either infinity.\n//\n// ## Parameters\n// - `f` is the value used in the evaluation.\n// - `sign` is the sign used in the eveluation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.isInf(f: 2.12, sign: 3)\n// ```\nbuiltin isInf : (f: float, sign: int) => bool\n\n// isNaN is a function that reports whether f is an IEEE 754 \"not-a-number\" value.\n//\n// ## Parameters\n// - `f` is the value used in the evaluation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.isNaN(f: 12.345)\n// ```\nbuiltin isNaN : (f: float) => bool\n\n// j0 is a function that returns the order-zero Bessel function of the first kind.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.j0(x: 1.23)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.j0(x: ±Inf) // Returns 0\n// math.j0(x: 0)    // Returns 1\n// math.j0(x: NaN)  // Returns NaN\n// ```\nbuiltin j0 : (x: float) => float\n\n// j1 is a funciton that returns the order-one Bessel function for the first kind.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.j1(x: 1.23)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.j1(±Inf) // Returns 0\n// math.j1(NaN)  // Returns NaN\n// ```\nbuiltin j1 : (x: float) => float\n\n// jn is a function that returns the order-n Bessel funciton of the first kind.\n//\n// ## Parameters\n// - `n` is the order number.\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.jn(n: 2, x: 1.23)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.jn(n:n, x: ±Inf) // Returns 0\n// math.jn(n:n, x: NaN)  // Returns NaN\n// ```\nbuiltin jn : (n: int, x: float) => float\n\n// ldexp is a function that is the inverse of math.frexp(). It returns\n//  `frac x 2**exp`. \n//\n// ## Parameters\n// - `frac` is the fraction used in the operation.\n// - `exp` is the exponent used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.ldexp(frac: 0.5, exp: 6)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.ldexp(frac: ±0, exp:exp)   // Returns ±0\n// math.ldexp(frac: ±Inf, exp:exp) // Returns ±Inf\n// math.ldexp(frac: NaN, exp:exp)  // Returns NaN\n// ```\nbuiltin ldexp : (frac: float, exp: int) => float\n\n// lgamma is a function that returns the natural logarithm and sign\n//  (-1 or +1) of math.gamma(x:x).\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.lgamma(x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.lgamma(x: +Inf)     // Returns +Inf\n// math.lgamma(x: 0)        // Returns +Inf\n// math.lgamma(x: -integer) // Returns +Inf\n// math.lgamma(x: -Inf)     // Returns -Inf\n// math.lgamma(x: NaN)      // Returns NaN\n// ```\nbuiltin lgamma : (x: float) => {lgamma: float, sign: int}\n\n// log is a function that returns the natural logarithm of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n// \n// math.log(x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.log(x: +Inf) // Returns +Inf\n// math.log(x: 0)    // Returns -Inf\n// math.log(x: <0)   // Returns NaN\n// math.log(x: NaN)  // Returns NaN\n// ```\nbuiltin log : (x: float) => float\n\n// log10 is a function that returns the decimal logarithm of x.\n//\n// ## Params\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.log10(x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.log10(x: +Inf) // Returns +Inf\n// math.log10(x: 0)    // Returns -Inf\n// math.log10(x: <0)   // Returns NaN\n// math.log10(x: NaN)  // Returns NaN\n// ```\nbuiltin log10 : (x: float) => float\n\n// log1p is a function that returns the natural logarithm of 1 plus the\n//  argument x. it is more accurate than `math.log(x: 1 + x)` when x is\n//  near zero.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.log1p(x: 0.56)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n//math.log1p(x: +Inf) // Returns +Inf\n// math.log1p(x: ±0)   // Returns ±0\n// math.log1p(x: -1)   // Returns -Inf\n// math.log1p(x: <-1)  // Returns NaN\n// math.log1p(x: NaN)  // Returns NaN\n// ```\nbuiltin log1p : (x: float) => float\n\n// log2 is a function returns the binary logarithm of x.\n//\n// ## Parameters\n// - `x` the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.log2(X: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.log2(x: +Inf) // Returns +Inf\n// math.log2(x: 0)    // Returns -Inf\n// math.log2(x: <0)   // Returns NaN\n// math.log2(x: NaN)  // Returns NaN\n// ```\nbuiltin log2 : (x: float) => float\n\n// logb is a function that returns the binary exponent of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.logb(x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.logb(x: ±Inf) // Returns +Inf\n// math.logb(x: 0)    // Returns -Inf\n// math.logb(x: NaN)  // Returns NaN\n// ```\nbuiltin logb : (x: float) => float\n\n// mMax is a function that returns the larger of x or y.\n//\n// ## Parameters\n// - `x` is the x-value used in the operation.\n// - `y` is the y-value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.mMax(x: 1.23, y: 4.56)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.mMax(x:x, y:+Inf)  // Returns +Inf\n// math.mMax(x: +Inf, y:y) // Returns +Inf\n// math.mMax(x:x, y: NaN)  // Returns NaN\n// math.mMax(x: NaN, y:y)  // Returns NaN\n// math.mMax(x: +0, y: ±0) // Returns +0\n// math.mMax(x: ±0, y: +0) // Returns +0\n// math.mMax(x: -0, y: -0) // Returns -0\n// ```\nbuiltin mMax : (x: float, y: float) => float\n\n// mMin is a function taht returns the lessser of x or y.\n//\n// ## Parameters\n// - `x` is the x-value used in the operation.\n// - `y` is the y-value used in the operation.\n//\n// ## Example\n// ```\n// import \"math\"\n//\n// math.mMin(x: 1.23, y: 4.56)\n// ```\n//\n// ## Special Cases\n// ```\n// import \"math\"\n//\n// math.mMin(x:x, y: -Inf) // Returns -Inf\n// math.mMin(x: -Inf, y:y) // Returns -Inf\n// math.mMin(x:x, y: NaN)  // Returns NaN\n// math.mMin(x: NaN, y:y)  // Returns NaN\n// math.mMin(x: -0, y: ±0) // Returns -0\n// math.mMin(x: ±0, y: -0) // Returns -0\n// ```\nbuiltin mMin : (x: float, y: float) => float\n\n// mod is a function that returns a floating-point remainder of x/y.\n//\n//  The magnitude of the result is less than y and its sign agrees\n//  with that of x.\n//\n// ## Parameters\n// - `x` is the x-value used in the operation.\n// - `y` is the y-value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.mod(x: 1.23, y: 4.56)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// math.mod(x: ±Inf, y:y)  // Returns NaN\n// math.mod(x: NaN, y:y)   // Returns NaN\n// math.mod(x:x, y: 0)     // Returns NaN\n// math.mod(x:x, y: ±Inf)  // Returns x\n// math.mod(x:x, y: NaN)   // Returns NaN\n// ```\nbuiltin mod : (x: float, y: float) => float\n\n// modf is a function that returns integer and fractional floating-point numbers\n//  that sum to f. \n//\n//  Both values have the same sign as f.\n//\n// ## Parameters\n// - `f` is the value used in the operation\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.modf(f: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.modf(f: ±Inf) // Returns {int: ±Inf, frac: NaN}\n// math.modf(f: NaN)  // Returns {int: NaN, frac: NaN}\n// ```\nbuiltin modf : (f: float) => {int: float, frac: float}\n\n// NaN is a function that returns a IEEE 754 \"not-a-number\" value.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.NaN()\n// ```\nbuiltin NaN : () => float\n\n// nextafter is a function that returns the next representable float value after\n//  x towards y.\n//\n// ## Parameters\n// - `x` is the x-vaue used in the operation.\n// - `y` is the y-value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.nextafter(x: 1.23, y: 4.56)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.nextafter(x:x, y:x)    // Returns x\n// math.nextafter(x: NaN, y:y) // Returns NaN\n// math.nextafter(x:x, y:NaN)  // Returns NaN\n// ```\nbuiltin nextafter : (x: float, y: float) => float\n\n// pow is a function that returns x**y, the base-x exponential of y.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.pow(x: 2.0, y: 3.0)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// // In order of priority\n// math.pow(x:x, y:±0)     // Returns 1 for any x\n// math.pow(x:1, y:y)      // Returns 1 for any y\n// math.pow(x:X, y:1)      // Returns x for any x\n// math.pow(x:NaN, y:y)    // Returns NaN\n// math.pow(x:x, y:NaN)    // Returns NaN\n// math.pow(x:±0, y:y)     // Returns ±Inf for y an odd integer < 0\n// math.pow(x:±0, y:-Inf)  // Returns +Inf\n// math.pow(x:±0, y:+Inf)  // Returns +0\n// math.pow(x:±0, y:y)     // Returns +Inf for finite y < 0 and not an odd integer\n// math.pow(x:±0, y:y)     // Returns ±0 for y an odd integer > 0\n// math.pow(x:±0, y:y)     // Returns +0 for finite y > 0 and not an odd integer\n// math.pow(x:-1, y:±Inf)  // Returns 1\n// math.pow(x:x, y:+Inf)   // Returns +Inf for |x| > 1\n// math.pow(x:x, y:-Inf)   // Returns +0 for |x| > 1\n// math.pow(x:x, y:+Inf)   // Returns +0 for |x| < 1\n// math.pow(x:x, y:-Inf)   // Returns +Inf for |x| < 1\n// math.pow(x:+Inf, y:y)   // Returns +Inf for y > 0\n// math.pow(x:+Inf, y:y)   // Returns +0 for y < 0\n// math.pow(x:-Inf, y:y)   // Returns math.pow(-0, -y)\n// math.pow(x:x, y:y)      // Returns NaN for finite x < 0 and finite non-integer y\n// ```\nbuiltin pow : (x: float, y: float) => float\n\n// pow10 is a function that returns 10**n, the base-10 exponential of n.\n//\n// ## Parameters\n// - `n` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.pow10(n: 3)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.pow10(n: <-323) // Returns 0\n// math.pow10(n: >308)  // Returns +Inf\n// ```\nbuiltin pow10 : (n: int) => float\n\n// remainder is a function that returns the IEEE 754 floating-point remainder\n//  of x / y.\n//\n// ## Parameters\n// - `x` is the numerator used in the operation.\n// - `y` is the denominator used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.remainder(x: 21.0, y: 4.0)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.remainder(x: ±Inf, y:y)  // Returns NaN\n// math.remainder(x: NaN, y:y)   // Returns NaN\n// math.remainder(x:x, y: 0)     // Returns NaN\n// math.remainder(x:x, y: ±Inf)  // Returns x\n// math.remainder(x:x, y: NaN)   // Returns NaN\n// ```\nbuiltin remainder : (x: float, y: float) => float\n\n// round is a function that returns the nearest integer, rounding half away\n//  from zero.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.round(x: 2.12)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.round(x: ±0)   // Returns ±0\n// math.round(x: ±Inf) // Returns ±Inf\n// math.round(x: NaN)  // Returns NaN\n// ```\nbuiltin round : (x: float) => float\n\n// roundtoeven is a function that returns the nearest integer, rounding\n//  ties to even.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.roundtoeven(x: 3.14)\n// math.roundtoeven(x: 3.5)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// math.roundtoeven(x: ±0)   // Returns ±0\n// math.roundtoeven(x: ±Inf) // Returns ±Inf\n// math.roundtoeven(x: NaN)  // Returns NaN\n// ```\nbuiltin roundtoeven : (x: float) => float\n\n// signbit is a function that reports whether x is negative of negative zero.\n//\n// ## Parameters\n// - `x` is the value used in the evaluation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.signbit(x: -1.2)\n// ```\nbuiltin signbit : (x: float) => bool\n\n// sin is a function that returns the sine of the radian argument x.\n//\n// ## Parameters\n// - `x` is the radian value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.sin(x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.sin(x: ±0)   // Returns ±0\n// math.sin(x: ±Inf) // Returns NaN\n// math.sin(x: NaN)  // Returns NaN\n// ```\nbuiltin sin : (x: float) => float\n\n// sincos is a function that returns the values of math.sin(x:x) and\n//  math.cos(x:x).\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.sincos(x: 1.23)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.sincos(x: ±0)   // Returns {sin: ±0, cos: 1}\n// math.sincos(x: ±Inf) // Returns {sin: NaN, cos: NaN}\n// math.sincos(x: NaN)  // Returns {sin: NaN, cos:  NaN}\n// ```\nbuiltin sincos : (x: float) => {sin: float, cos: float}\n\n// sinh is a function that returns the hyperbolic sine of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.sinh(x: 1.23)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.sinh(x: ±0)   // Returns ±0\n// math.sinh(x: ±Inf) // Returns ±Inf\n// math.sinh(x: NaN)  // Returns NaN\n// ```\nbuiltin sinh : (x: float) => float\n\n// sqrt is a function that returns the square root of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.sqrt(x: 4.0)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.sqrt(x: +Inf) // Returns +Inf\n// math.sqrt(x: ±0)   // Returns ±0\n// math.sqrt(x: <0)   // Returns NaN\n// math.sqrt(x: NaN)  // Returns NaN\n// ```\nbuiltin sqrt : (x: float) => float\n\n// tan is a function that returns the tangent of the radian argument.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.tan(x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.tan(x: ±0)   // Returns ±0\n// math.tan(x: ±Inf) // Returns NaN\n// math.tan(x: NaN)  // Returns NaN\n// ```\nbuiltin tan : (x: float) => float\n\n// tanh is a function that returns the hyperbolic tangent of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.tanh(x: 1.23)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.tanh(x: ±0)   // Returns ±0\n// math.tanh(x: ±Inf) // Returns ±1\n// math.tanh(x: NaN)  // Returns NaN\n// ```\nbuiltin tanh : (x: float) => float\n\n// trunc is a function that returns the integer value of x.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.trunc(x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.trunc(x: ±0)   // Returns ±0\n// math.trunc(x: ±Inf) // Returns ±Inf\n// math.trunc(x: NaN)  // Returns NaN\n// ```\nbuiltin trunc : (x: float) => float\n\n// y0 is a function that returns the order-zero Bessel function of the\n//  second kind.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.y0(x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.y0(x: +Inf) // Returns 0\n// math.y0(x: 0)    // Returns -Inf\n// math.y0(x: <0)   // Returns NaN\n// math.y0(x: NaN)  // Returns NaN\n// ```\nbuiltin y0 : (x: float) => float\n\n// y1 is a function that returns the order-one Bessel function of\n//  the second kind.\n//\n// ## Parameters\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.y1(x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.y1(x: +Inf) // Returns 0\n// math.y1(x: 0)    // Returns -Inf\n// math.y1(x: <0)   // Returns NaN\n// math.y1(x: NaN)  // Returns NaN\n// ```\nbuiltin y1 : (x: float) => float\n\n// yn is a function that returns the order-n Bessel function of\n//  the second kind.\n//\n// ## Parameters\n// - `n` is the order number used in the operation.\n// - `x` is the value used in the operation.\n//\n// ## Example\n//\n// ```\n// import \"math\"\n//\n// math.yn(n: 3, x: 3.14)\n// ```\n//\n// ## Special Cases\n//\n// ```\n// import \"math\"\n//\n// math.yn(n:n, x: +Inf) // Returns 0\n// math.yn(n: ≥0, x: 0)  // Returns -Inf\n// math.yn(n: <0, x: 0)  // Returns +Inf if n is odd, -Inf if n is even\n// math.yn(n:n, x: <0)   // Returns NaN\n// math.yn(n:n, x:NaN)   // Returns NaN\n// ```\nbuiltin yn",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// on floating point numbers.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   6,
					},
					File:   "math.flux",
					Source: "builtin pi",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   6,
						},
						File:   "math.flux",
						Source: "pi",
						Start: ast.Position{
							Column: 9,
							Line:   6,
						},
					},
				},
				Name: "pi",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   6,
						},
						File:   "math.flux",
						Source: "float",
						Start: ast.Position{
							Column: 14,
							Line:   6,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   6,
							},
							File:   "math.flux",
							Source: "float",
							Start: ast.Position{
								Column: 14,
								Line:   6,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   6,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 14,
									Line:   6,
								},
							},
						},
						Name: "float",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 10,
						Line:   7,
					},
					File:   "math.flux",
					Source: "builtin e",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   7,
						},
						File:   "math.flux",
						Source: "e",
						Start: ast.Position{
							Column: 9,
							Line:   7,
						},
					},
				},
				Name: "e",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   7,
						},
						File:   "math.flux",
						Source: "float",
						Start: ast.Position{
							Column: 13,
							Line:   7,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   7,
							},
							File:   "math.flux",
							Source: "float",
							Start: ast.Position{
								Column: 13,
								Line:   7,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   7,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 13,
									Line:   7,
								},
							},
						},
						Name: "float",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   8,
					},
					File:   "math.flux",
					Source: "builtin phi",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   8,
						},
						File:   "math.flux",
						Source: "phi",
						Start: ast.Position{
							Column: 9,
							Line:   8,
						},
					},
				},
				Name: "phi",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   8,
						},
						File:   "math.flux",
						Source: "float",
						Start: ast.Position{
							Column: 15,
							Line:   8,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   8,
							},
							File:   "math.flux",
							Source: "float",
							Start: ast.Position{
								Column: 15,
								Line:   8,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   8,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 15,
									Line:   8,
								},
							},
						},
						Name: "float",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   9,
					},
					File:   "math.flux",
					Source: "builtin sqrt2",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   9,
						},
						File:   "math.flux",
						Source: "sqrt2",
						Start: ast.Position{
							Column: 9,
							Line:   9,
						},
					},
				},
				Name: "sqrt2",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   9,
						},
						File:   "math.flux",
						Source: "float",
						Start: ast.Position{
							Column: 17,
							Line:   9,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   9,
							},
							File:   "math.flux",
							Source: "float",
							Start: ast.Position{
								Column: 17,
								Line:   9,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   9,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 17,
									Line:   9,
								},
							},
						},
						Name: "float",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   10,
					},
					File:   "math.flux",
					Source: "builtin sqrte",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   10,
						},
						File:   "math.flux",
						Source: "sqrte",
						Start: ast.Position{
							Column: 9,
							Line:   10,
						},
					},
				},
				Name: "sqrte",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   10,
						},
						File:   "math.flux",
						Source: "float",
						Start: ast.Position{
							Column: 17,
							Line:   10,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   10,
							},
							File:   "math.flux",
							Source: "float",
							Start: ast.Position{
								Column: 17,
								Line:   10,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   10,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 17,
									Line:   10,
								},
							},
						},
						Name: "float",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   11,
					},
					File:   "math.flux",
					Source: "builtin sqrtpi",
					Start: ast.Position{
						Column: 1,
						Line:   11,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   11,
						},
						File:   "math.flux",
						Source: "sqrtpi",
						Start: ast.Position{
							Column: 9,
							Line:   11,
						},
					},
				},
				Name: "sqrtpi",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   11,
						},
						File:   "math.flux",
						Source: "float",
						Start: ast.Position{
							Column: 18,
							Line:   11,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   11,
							},
							File:   "math.flux",
							Source: "float",
							Start: ast.Position{
								Column: 18,
								Line:   11,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   11,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 18,
									Line:   11,
								},
							},
						},
						Name: "float",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   12,
					},
					File:   "math.flux",
					Source: "builtin sqrtphi",
					Start: ast.Position{
						Column: 1,
						Line:   12,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   12,
						},
						File:   "math.flux",
						Source: "sqrtphi",
						Start: ast.Position{
							Column: 9,
							Line:   12,
						},
					},
				},
				Name: "sqrtphi",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   12,
						},
						File:   "math.flux",
						Source: "float",
						Start: ast.Position{
							Column: 19,
							Line:   12,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   12,
							},
							File:   "math.flux",
							Source: "float",
							Start: ast.Position{
								Column: 19,
								Line:   12,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   12,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 19,
									Line:   12,
								},
							},
						},
						Name: "float",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   13,
					},
					File:   "math.flux",
					Source: "builtin ln2",
					Start: ast.Position{
						Column: 1,
						Line:   13,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   13,
						},
						File:   "math.flux",
						Source: "ln2",
						Start: ast.Position{
							Column: 9,
							Line:   13,
						},
					},
				},
				Name: "ln2",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   13,
						},
						File:   "math.flux",
						Source: "float",
						Start: ast.Position{
							Column: 15,
							Line:   13,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   13,
							},
							File:   "math.flux",
							Source: "float",
							Start: ast.Position{
								Column: 15,
								Line:   13,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   13,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 15,
									Line:   13,
								},
							},
						},
						Name: "float",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   14,
					},
					File:   "math.flux",
					Source: "builtin log2e",
					Start: ast.Position{
						Column: 1,
						Line:   14,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   14,
						},
						File:   "math.flux",
						Source: "log2e",
						Start: ast.Position{
							Column: 9,
							Line:   14,
						},
					},
				},
				Name: "log2e",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   14,
						},
						File:   "math.flux",
						Source: "float",
						Start: ast.Position{
							Column: 17,
							Line:   14,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   14,
							},
							File:   "math.flux",
							Source: "float",
							Start: ast.Position{
								Column: 17,
								Line:   14,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   14,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 17,
									Line:   14,
								},
							},
						},
						Name: "float",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   15,
					},
					File:   "math.flux",
					Source: "builtin ln10",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   15,
						},
						File:   "math.flux",
						Source: "ln10",
						Start: ast.Position{
							Column: 9,
							Line:   15,
						},
					},
				},
				Name: "ln10",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   15,
						},
						File:   "math.flux",
						Source: "float",
						Start: ast.Position{
							Column: 16,
							Line:   15,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   15,
							},
							File:   "math.flux",
							Source: "float",
							Start: ast.Position{
								Column: 16,
								Line:   15,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   15,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 16,
									Line:   15,
								},
							},
						},
						Name: "float",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   16,
					},
					File:   "math.flux",
					Source: "builtin log10e",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   16,
						},
						File:   "math.flux",
						Source: "log10e",
						Start: ast.Position{
							Column: 9,
							Line:   16,
						},
					},
				},
				Name: "log10e",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   16,
						},
						File:   "math.flux",
						Source: "float",
						Start: ast.Position{
							Column: 18,
							Line:   16,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   16,
							},
							File:   "math.flux",
							Source: "float",
							Start: ast.Position{
								Column: 18,
								Line:   16,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   16,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 18,
									Line:   16,
								},
							},
						},
						Name: "float",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   17,
					},
					File:   "math.flux",
					Source: "builtin maxfloat",
					Start: ast.Position{
						Column: 1,
						Line:   17,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   17,
						},
						File:   "math.flux",
						Source: "maxfloat",
						Start: ast.Position{
							Column: 9,
							Line:   17,
						},
					},
				},
				Name: "maxfloat",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   17,
						},
						File:   "math.flux",
						Source: "float",
						Start: ast.Position{
							Column: 20,
							Line:   17,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   17,
							},
							File:   "math.flux",
							Source: "float",
							Start: ast.Position{
								Column: 20,
								Line:   17,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   17,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 20,
									Line:   17,
								},
							},
						},
						Name: "float",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   18,
					},
					File:   "math.flux",
					Source: "builtin smallestNonzeroFloat",
					Start: ast.Position{
						Column: 1,
						Line:   18,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   18,
						},
						File:   "math.flux",
						Source: "smallestNonzeroFloat",
						Start: ast.Position{
							Column: 9,
							Line:   18,
						},
					},
				},
				Name: "smallestNonzeroFloat",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   18,
						},
						File:   "math.flux",
						Source: "float",
						Start: ast.Position{
							Column: 32,
							Line:   18,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   18,
							},
							File:   "math.flux",
							Source: "float",
							Start: ast.Position{
								Column: 32,
								Line:   18,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   18,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 32,
									Line:   18,
								},
							},
						},
						Name: "float",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   19,
					},
					File:   "math.flux",
					Source: "builtin maxint",
					Start: ast.Position{
						Column: 1,
						Line:   19,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   19,
						},
						File:   "math.flux",
						Source: "maxint",
						Start: ast.Position{
							Column: 9,
							Line:   19,
						},
					},
				},
				Name: "maxint",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   19,
						},
						File:   "math.flux",
						Source: "int",
						Start: ast.Position{
							Column: 18,
							Line:   19,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   19,
							},
							File:   "math.flux",
							Source: "int",
							Start: ast.Position{
								Column: 18,
								Line:   19,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   19,
								},
								File:   "math.flux",
								Source: "int",
								Start: ast.Position{
									Column: 18,
									Line:   19,
								},
							},
						},
						Name: "int",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   20,
					},
					File:   "math.flux",
					Source: "builtin minint",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   20,
						},
						File:   "math.flux",
						Source: "minint",
						Start: ast.Position{
							Column: 9,
							Line:   20,
						},
					},
				},
				Name: "minint",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   20,
						},
						File:   "math.flux",
						Source: "int",
						Start: ast.Position{
							Column: 18,
							Line:   20,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   20,
							},
							File:   "math.flux",
							Source: "int",
							Start: ast.Position{
								Column: 18,
								Line:   20,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   20,
								},
								File:   "math.flux",
								Source: "int",
								Start: ast.Position{
									Column: 18,
									Line:   20,
								},
							},
						},
						Name: "int",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   21,
					},
					File:   "math.flux",
					Source: "builtin maxuint",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   21,
						},
						File:   "math.flux",
						Source: "maxuint",
						Start: ast.Position{
							Column: 9,
							Line:   21,
						},
					},
				},
				Name: "maxuint",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   21,
						},
						File:   "math.flux",
						Source: "uint",
						Start: ast.Position{
							Column: 19,
							Line:   21,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   21,
							},
							File:   "math.flux",
							Source: "uint",
							Start: ast.Position{
								Column: 19,
								Line:   21,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   21,
								},
								File:   "math.flux",
								Source: "uint",
								Start: ast.Position{
									Column: 19,
									Line:   21,
								},
							},
						},
						Name: "uint",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// abs is a function that returns the absolute value of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.abs(x: -1.22)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.abs(x: ±Inf) // returns +Inf\n"}, ast.Comment{Text: "// math.abs(x: NaN) // returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   44,
					},
					File:   "math.flux",
					Source: "builtin abs",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   44,
						},
						File:   "math.flux",
						Source: "abs",
						Start: ast.Position{
							Column: 9,
							Line:   44,
						},
					},
				},
				Name: "abs",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 34,
							Line:   44,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 15,
							Line:   44,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   44,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 15,
								Line:   44,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   44,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 16,
									Line:   44,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   44,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 16,
										Line:   44,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   44,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 19,
										Line:   44,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   44,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 19,
											Line:   44,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   44,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 29,
									Line:   44,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   44,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 29,
										Line:   44,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// acos is a funciton that returns the acosine of x in radians.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   x should be greater than -1 and less than 1. Otherwise, the operation\n"}, ast.Comment{Text: "//   will return NaN.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.acos(x: 0.22)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.acos(x: <-1) // returns NaN\n"}, ast.Comment{Text: "// math.acos(x: >1) // returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   70,
					},
					File:   "math.flux",
					Source: "builtin acos",
					Start: ast.Position{
						Column: 1,
						Line:   70,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   70,
						},
						File:   "math.flux",
						Source: "acos",
						Start: ast.Position{
							Column: 9,
							Line:   70,
						},
					},
				},
				Name: "acos",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   70,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   70,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   70,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   70,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   70,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   70,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   70,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   70,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   70,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   70,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   70,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   70,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   70,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 30,
									Line:   70,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   70,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   70,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// acosh is a function that returns the inverse hyperbolic cosine of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   x should be greater than 1. If less than 1 the operation will return NaN.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.acosh(x: 1.22)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.acosh(x: +Inf) // returns +Inf\n"}, ast.Comment{Text: "// math.acosh(x: <1) // returns NaN\n"}, ast.Comment{Text: "// math.acosh(x: NaN) // returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   96,
					},
					File:   "math.flux",
					Source: "builtin acosh",
					Start: ast.Position{
						Column: 1,
						Line:   96,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   96,
						},
						File:   "math.flux",
						Source: "acosh",
						Start: ast.Position{
							Column: 9,
							Line:   96,
						},
					},
				},
				Name: "acosh",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   96,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 17,
							Line:   96,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   96,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 17,
								Line:   96,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   96,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 18,
									Line:   96,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   96,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 18,
										Line:   96,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   96,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   96,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   96,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   96,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   96,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 31,
									Line:   96,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   96,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   96,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// asin is a function that returns the arcsine of x in radians.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is is value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   x should be greater than -1 and less than 1. Otherwise the function will\n"}, ast.Comment{Text: "//   return NaN.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.asin(x: 0.22)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.asin(x: ±0) // returns ±0\n"}, ast.Comment{Text: "// math.asin(x: <-1) // returns NaN\n"}, ast.Comment{Text: "// math.asin(x: >1) // returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   123,
					},
					File:   "math.flux",
					Source: "builtin asin",
					Start: ast.Position{
						Column: 1,
						Line:   123,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   123,
						},
						File:   "math.flux",
						Source: "asin",
						Start: ast.Position{
							Column: 9,
							Line:   123,
						},
					},
				},
				Name: "asin",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   123,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   123,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   123,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   123,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   123,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   123,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   123,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   123,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   123,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   123,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   123,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   123,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   123,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 30,
									Line:   123,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   123,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   123,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// asinh is a function that returns the inverse hyperbolic sine of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.asinh(x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.asinh(x: ±0) // returns ±0\n"}, ast.Comment{Text: "// math.asinh(x: ±Inf) // returns ±Inf\n"}, ast.Comment{Text: "// math.asinh(x: NaN) // returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   147,
					},
					File:   "math.flux",
					Source: "builtin asinh",
					Start: ast.Position{
						Column: 1,
						Line:   147,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   147,
						},
						File:   "math.flux",
						Source: "asinh",
						Start: ast.Position{
							Column: 9,
							Line:   147,
						},
					},
				},
				Name: "asinh",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   147,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 17,
							Line:   147,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   147,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 17,
								Line:   147,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   147,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 18,
									Line:   147,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   147,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 18,
										Line:   147,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   147,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   147,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   147,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   147,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   147,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 31,
									Line:   147,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   147,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   147,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// atan is a function that returns the arctangent of x in radians.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.atan(x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.atan(x: ±0) // returns ±0\n"}, ast.Comment{Text: "// math.atan(x: ±Inf) // returns ±Pi/2\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   170,
					},
					File:   "math.flux",
					Source: "builtin atan",
					Start: ast.Position{
						Column: 1,
						Line:   170,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   170,
						},
						File:   "math.flux",
						Source: "atan",
						Start: ast.Position{
							Column: 9,
							Line:   170,
						},
					},
				},
				Name: "atan",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   170,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   170,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   170,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   170,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   170,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   170,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   170,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   170,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   170,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   170,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   170,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   170,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   170,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 30,
									Line:   170,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   170,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   170,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// atan2 is a function that returns the artangent of x/y, using the signs\n"}, ast.Comment{Text: "//  of the two to determine the quadrant of the return value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `y` is the y-coordinate used in the operation.\n"}, ast.Comment{Text: "// - `x` is the x-corrdinate used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.atan2(y: 1.22, x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.atan2(y:y, x:NaN)        // Returns NaN\n"}, ast.Comment{Text: "// math.atan2(y: NaN, x:x)       // Returns NaN\n"}, ast.Comment{Text: "// math.atan2(y: +0, x: >=0)     // Returns +0\n"}, ast.Comment{Text: "// math.atan2(y: -0, x: >=0)     // Returns -0\n"}, ast.Comment{Text: "// math.atan2(y: +0, x: <=-0)    // Returns +Pi\n"}, ast.Comment{Text: "// math.atan2(y: -0, x: <=-0)    // Returns -Pi\n"}, ast.Comment{Text: "// math.atan2(y: >0, x: 0)       // Returns +Pi/2\n"}, ast.Comment{Text: "// math.atan2(y: <0, x: 0)       // Returns -Pi/2\n"}, ast.Comment{Text: "// math.atan2(y: +Inf, x: +Inf)  // Returns +Pi/4\n"}, ast.Comment{Text: "// math.atan2(y: -Inf, x: +Inf)  // Returns -Pi/4\n"}, ast.Comment{Text: "// math.atan2(y: +Inf, x: -Inf)  // Returns 3Pi/4\n"}, ast.Comment{Text: "// math.atan2(y: -Inf, x: -Inf)  // Returns -3Pi/4\n"}, ast.Comment{Text: "// math.atan2(y:y, x: +Inf)      // Returns 0\n"}, ast.Comment{Text: "// math.atan2(y: >0, x: -Inf)    // Returns +Pi\n"}, ast.Comment{Text: "// math.atan2(y: <0, x: -Inf)    // Returns -Pi\n"}, ast.Comment{Text: "// math.atan2(y: +Inf, x:x)      // Returns +Pi/2\n"}, ast.Comment{Text: "// math.atan2(y: -Inf, x:x)      // Returns -Pi/2\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   210,
					},
					File:   "math.flux",
					Source: "builtin atan2",
					Start: ast.Position{
						Column: 1,
						Line:   210,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   210,
						},
						File:   "math.flux",
						Source: "atan2",
						Start: ast.Position{
							Column: 9,
							Line:   210,
						},
					},
				},
				Name: "atan2",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 46,
							Line:   210,
						},
						File:   "math.flux",
						Source: "(y: float, x: float) => float",
						Start: ast.Position{
							Column: 17,
							Line:   210,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 46,
								Line:   210,
							},
							File:   "math.flux",
							Source: "(y: float, x: float) => float",
							Start: ast.Position{
								Column: 17,
								Line:   210,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   210,
								},
								File:   "math.flux",
								Source: "y: float",
								Start: ast.Position{
									Column: 18,
									Line:   210,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   210,
									},
									File:   "math.flux",
									Source: "y",
									Start: ast.Position{
										Column: 18,
										Line:   210,
									},
								},
							},
							Name: "y",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   210,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   210,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   210,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   210,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   210,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 28,
									Line:   210,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   210,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 28,
										Line:   210,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   210,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   210,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   210,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 31,
											Line:   210,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   210,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 41,
									Line:   210,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   210,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 41,
										Line:   210,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// atanh is a function that returns the inverse hyperbolic tangent of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   x should be greater than -1 and less than 1, otherwise the operation\n"}, ast.Comment{Text: "//   will return NaN.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.atanh(x: 0.22)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.atanh(x: 1)   // Returns +Inf\n"}, ast.Comment{Text: "// math.atanh(x: ±0)  // Returns ±0\n"}, ast.Comment{Text: "// math.atanh(x: -1)  // Returns -Inf\n"}, ast.Comment{Text: "// math.atanh(x: <-1) // Returns NaN\n"}, ast.Comment{Text: "// math.atanh(x: >1)  // Returns NaN\n"}, ast.Comment{Text: "// math.atanh(x: NaN) // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   240,
					},
					File:   "math.flux",
					Source: "builtin atanh",
					Start: ast.Position{
						Column: 1,
						Line:   240,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   240,
						},
						File:   "math.flux",
						Source: "atanh",
						Start: ast.Position{
							Column: 9,
							Line:   240,
						},
					},
				},
				Name: "atanh",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   240,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 17,
							Line:   240,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   240,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 17,
								Line:   240,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   240,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 18,
									Line:   240,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   240,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 18,
										Line:   240,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   240,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   240,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   240,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   240,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   240,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 31,
									Line:   240,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   240,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   240,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// cbrt is a function that returns the cube root of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.cbrt(x: 1728.0)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.cbrt(±0)   // Returns ±0\n"}, ast.Comment{Text: "// math.cbrt(±Inf) // Returns ±Inf\n"}, ast.Comment{Text: "// math.cbrt(NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   264,
					},
					File:   "math.flux",
					Source: "builtin cbrt",
					Start: ast.Position{
						Column: 1,
						Line:   264,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   264,
						},
						File:   "math.flux",
						Source: "cbrt",
						Start: ast.Position{
							Column: 9,
							Line:   264,
						},
					},
				},
				Name: "cbrt",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   264,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   264,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   264,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   264,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   264,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   264,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   264,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   264,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   264,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   264,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   264,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   264,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   264,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 30,
									Line:   264,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   264,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   264,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// ceil is a function that returns the least integer value greater than\n"}, ast.Comment{Text: "//  or equal to x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.ceil(x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.ceil(±0)   // Returns ±0\n"}, ast.Comment{Text: "// math.ceil(±Inf) // Returns ±Inf\n"}, ast.Comment{Text: "// math.ceil(NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   289,
					},
					File:   "math.flux",
					Source: "builtin ceil",
					Start: ast.Position{
						Column: 1,
						Line:   289,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   289,
						},
						File:   "math.flux",
						Source: "ceil",
						Start: ast.Position{
							Column: 9,
							Line:   289,
						},
					},
				},
				Name: "ceil",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   289,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   289,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   289,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   289,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   289,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   289,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   289,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   289,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   289,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   289,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   289,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   289,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   289,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 30,
									Line:   289,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   289,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   289,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// copysign is a function that returns a value with the magnitude x and\n"}, ast.Comment{Text: "//  the sign of y.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the magnitude used in the operation.\n"}, ast.Comment{Text: "// - `y` is the sign used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.copysign(x: 1.0, y: 2.0)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   305,
					},
					File:   "math.flux",
					Source: "builtin copysign",
					Start: ast.Position{
						Column: 1,
						Line:   305,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   305,
						},
						File:   "math.flux",
						Source: "copysign",
						Start: ast.Position{
							Column: 9,
							Line:   305,
						},
					},
				},
				Name: "copysign",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 49,
							Line:   305,
						},
						File:   "math.flux",
						Source: "(x: float, y: float) => float",
						Start: ast.Position{
							Column: 20,
							Line:   305,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   305,
							},
							File:   "math.flux",
							Source: "(x: float, y: float) => float",
							Start: ast.Position{
								Column: 20,
								Line:   305,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   305,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 21,
									Line:   305,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   305,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 21,
										Line:   305,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   305,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 24,
										Line:   305,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   305,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 24,
											Line:   305,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   305,
								},
								File:   "math.flux",
								Source: "y: float",
								Start: ast.Position{
									Column: 31,
									Line:   305,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   305,
									},
									File:   "math.flux",
									Source: "y",
									Start: ast.Position{
										Column: 31,
										Line:   305,
									},
								},
							},
							Name: "y",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   305,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 34,
										Line:   305,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   305,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 34,
											Line:   305,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   305,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 44,
									Line:   305,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   305,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 44,
										Line:   305,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// cos is a function that returns the cosine of the radian argument x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.cos(x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.cos(±Inf) // Returns NaN\n"}, ast.Comment{Text: "// math.cos(NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   328,
					},
					File:   "math.flux",
					Source: "builtin cos",
					Start: ast.Position{
						Column: 1,
						Line:   328,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   328,
						},
						File:   "math.flux",
						Source: "cos",
						Start: ast.Position{
							Column: 9,
							Line:   328,
						},
					},
				},
				Name: "cos",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 34,
							Line:   328,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 15,
							Line:   328,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   328,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 15,
								Line:   328,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   328,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 16,
									Line:   328,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   328,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 16,
										Line:   328,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   328,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 19,
										Line:   328,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   328,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 19,
											Line:   328,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   328,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 29,
									Line:   328,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   328,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 29,
										Line:   328,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// cosh is a function that returns the hyperbolic cosine of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.cosh(x: 1.22)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.cosh(±0)   // Returns 1\n"}, ast.Comment{Text: "// math.cosh(±Inf) // Returns +Inf\n"}, ast.Comment{Text: "// math.cosh(NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   352,
					},
					File:   "math.flux",
					Source: "builtin cosh",
					Start: ast.Position{
						Column: 1,
						Line:   352,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   352,
						},
						File:   "math.flux",
						Source: "cosh",
						Start: ast.Position{
							Column: 9,
							Line:   352,
						},
					},
				},
				Name: "cosh",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   352,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   352,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   352,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   352,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   352,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   352,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   352,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   352,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   352,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   352,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   352,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   352,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   352,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 30,
									Line:   352,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   352,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   352,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// dim is a function that returns the maximum of x - y or 0.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the X-value used in the operation .\n"}, ast.Comment{Text: "// - 'y' is the Y-value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.dim(x: 12.2, y: 8.1)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.dim(x: +Inf, y: +Inf) // Returns NaN\n"}, ast.Comment{Text: "// math.dim(x: -Inf, y: -Inf) // Returns NaN\n"}, ast.Comment{Text: "// math.dim(x:x, y    : NaN)  // Returns NaN\n"}, ast.Comment{Text: "// math.dim(x: NaN, y :y)     // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   378,
					},
					File:   "math.flux",
					Source: "builtin dim",
					Start: ast.Position{
						Column: 1,
						Line:   378,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   378,
						},
						File:   "math.flux",
						Source: "dim",
						Start: ast.Position{
							Column: 9,
							Line:   378,
						},
					},
				},
				Name: "dim",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 44,
							Line:   378,
						},
						File:   "math.flux",
						Source: "(x: float, y: float) => float",
						Start: ast.Position{
							Column: 15,
							Line:   378,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   378,
							},
							File:   "math.flux",
							Source: "(x: float, y: float) => float",
							Start: ast.Position{
								Column: 15,
								Line:   378,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   378,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 16,
									Line:   378,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   378,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 16,
										Line:   378,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   378,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 19,
										Line:   378,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   378,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 19,
											Line:   378,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   378,
								},
								File:   "math.flux",
								Source: "y: float",
								Start: ast.Position{
									Column: 26,
									Line:   378,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   378,
									},
									File:   "math.flux",
									Source: "y",
									Start: ast.Position{
										Column: 26,
										Line:   378,
									},
								},
							},
							Name: "y",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   378,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 29,
										Line:   378,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   378,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 29,
											Line:   378,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   378,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 39,
									Line:   378,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   378,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 39,
										Line:   378,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// erf is a function that returns the error function of x\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.erf(x: 22.6)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.erf(+Inf) // Returns 1\n"}, ast.Comment{Text: "// math.erf(-Inf) // Returns -1\n"}, ast.Comment{Text: "// math.erf(NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   402,
					},
					File:   "math.flux",
					Source: "builtin erf",
					Start: ast.Position{
						Column: 1,
						Line:   402,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   402,
						},
						File:   "math.flux",
						Source: "erf",
						Start: ast.Position{
							Column: 9,
							Line:   402,
						},
					},
				},
				Name: "erf",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 34,
							Line:   402,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 15,
							Line:   402,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   402,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 15,
								Line:   402,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   402,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 16,
									Line:   402,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   402,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 16,
										Line:   402,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   402,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 19,
										Line:   402,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   402,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 19,
											Line:   402,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   402,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 29,
									Line:   402,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   402,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 29,
										Line:   402,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// erfc is a function that returns the complementary error function of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.erfc(x: 22.6)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.erfc(+Inf) // Returns 0\n"}, ast.Comment{Text: "// math.erfc(-Inf) // Returns 2\n"}, ast.Comment{Text: "// math.erfc(NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   426,
					},
					File:   "math.flux",
					Source: "builtin erfc",
					Start: ast.Position{
						Column: 1,
						Line:   426,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   426,
						},
						File:   "math.flux",
						Source: "erfc",
						Start: ast.Position{
							Column: 9,
							Line:   426,
						},
					},
				},
				Name: "erfc",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   426,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   426,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   426,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   426,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   426,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   426,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   426,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   426,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   426,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   426,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   426,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   426,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   426,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 30,
									Line:   426,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   426,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   426,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// erfcinv is a function that returns the inverse of math.erfc().\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   x should be greater than 0 and less than 2. Otherwise the operation\n"}, ast.Comment{Text: "//   will return NaN.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.erfcinv(x: 0.42345)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.erfcinv(x: 0)   // Returns +Inf\n"}, ast.Comment{Text: "// math.erfcinv(x: 2)   // Returns -Inf\n"}, ast.Comment{Text: "// math.erfcinv(x: <0)  // Returns NaN\n"}, ast.Comment{Text: "// math.erfcinv(x: >2)  // Returns NaN\n"}, ast.Comment{Text: "// math.erfcinv(x: NaN) // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   455,
					},
					File:   "math.flux",
					Source: "builtin erfcinv",
					Start: ast.Position{
						Column: 1,
						Line:   455,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   455,
						},
						File:   "math.flux",
						Source: "erfcinv",
						Start: ast.Position{
							Column: 9,
							Line:   455,
						},
					},
				},
				Name: "erfcinv",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   455,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 19,
							Line:   455,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   455,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 19,
								Line:   455,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   455,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 20,
									Line:   455,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   455,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 20,
										Line:   455,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   455,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 23,
										Line:   455,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   455,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 23,
											Line:   455,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   455,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 33,
									Line:   455,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   455,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 33,
										Line:   455,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// erfinv is a function that returns the inverse error function of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameter\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   x should be greater than -1 and less than 1. Otherwise, the operation will\n"}, ast.Comment{Text: "//   return NaN.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.erfinv(x: 0.22)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.erfinv(x: 1)   // Returns +Inf\n"}, ast.Comment{Text: "// math.erfinv(x: -1)  // Returns -Inf\n"}, ast.Comment{Text: "// math.erfinv(x: <-1) // Returns NaN\n"}, ast.Comment{Text: "// math.erfinv(x: > 1) // Returns NaN\n"}, ast.Comment{Text: "// math.erfinv(x: NaN) // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   484,
					},
					File:   "math.flux",
					Source: "builtin erfinv",
					Start: ast.Position{
						Column: 1,
						Line:   484,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   484,
						},
						File:   "math.flux",
						Source: "erfinv",
						Start: ast.Position{
							Column: 9,
							Line:   484,
						},
					},
				},
				Name: "erfinv",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   484,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 18,
							Line:   484,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   484,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 18,
								Line:   484,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   484,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 19,
									Line:   484,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   484,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 19,
										Line:   484,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   484,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 22,
										Line:   484,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   484,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 22,
											Line:   484,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   484,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 32,
									Line:   484,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   484,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 32,
										Line:   484,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// exp is a function that returns `e**x`, the base-e exponential of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.exp(x: 21.0)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.exp(x: +Inf) // Returns +Inf\n"}, ast.Comment{Text: "// math.exp(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   507,
					},
					File:   "math.flux",
					Source: "builtin exp",
					Start: ast.Position{
						Column: 1,
						Line:   507,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   507,
						},
						File:   "math.flux",
						Source: "exp",
						Start: ast.Position{
							Column: 9,
							Line:   507,
						},
					},
				},
				Name: "exp",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 34,
							Line:   507,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 15,
							Line:   507,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   507,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 15,
								Line:   507,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   507,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 16,
									Line:   507,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   507,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 16,
										Line:   507,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   507,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 19,
										Line:   507,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   507,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 19,
											Line:   507,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   507,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 29,
									Line:   507,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   507,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 29,
										Line:   507,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// exp2 is a function that returns `2**x`, the base-2 exponential of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.exp2(x: 21.0)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.exp2(x: +Inf) // Returns +Inf\n"}, ast.Comment{Text: "// math.exp2(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Very large values overflow to 0 or +Inf. Very small values overflow to 1.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   532,
					},
					File:   "math.flux",
					Source: "builtin exp2",
					Start: ast.Position{
						Column: 1,
						Line:   532,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   532,
						},
						File:   "math.flux",
						Source: "exp2",
						Start: ast.Position{
							Column: 9,
							Line:   532,
						},
					},
				},
				Name: "exp2",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   532,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   532,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   532,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   532,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   532,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   532,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   532,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   532,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   532,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   532,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   532,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   532,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   532,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 30,
									Line:   532,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   532,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   532,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// expm1 is a function that returns `e**x - 1`, the base-e exponential of x minus\n"}, ast.Comment{Text: "//  1. It is more accurate than `math.exp(x:x) - 1` when x is near zero.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.expm1(x: 1.22)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.expm1(+Inf) // Returns +Inf\n"}, ast.Comment{Text: "// math.expm1(-Inf) // Returns -1\n"}, ast.Comment{Text: "// math.expm1(NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Very large values overflow to -1 or +Inf.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   559,
					},
					File:   "math.flux",
					Source: "builtin expm1",
					Start: ast.Position{
						Column: 1,
						Line:   559,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   559,
						},
						File:   "math.flux",
						Source: "expm1",
						Start: ast.Position{
							Column: 9,
							Line:   559,
						},
					},
				},
				Name: "expm1",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   559,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 17,
							Line:   559,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   559,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 17,
								Line:   559,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   559,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 18,
									Line:   559,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   559,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 18,
										Line:   559,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   559,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   559,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   559,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   559,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   559,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 31,
									Line:   559,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   559,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   559,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// float64bits is a function that returns the IEEE 754 binary representation of f,\n"}, ast.Comment{Text: "//  with the sign bit of f and the result in the same bit position.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `f` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.float64bits(f: 1234.56)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   574,
					},
					File:   "math.flux",
					Source: "builtin float64bits",
					Start: ast.Position{
						Column: 1,
						Line:   574,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   574,
						},
						File:   "math.flux",
						Source: "float64bits",
						Start: ast.Position{
							Column: 9,
							Line:   574,
						},
					},
				},
				Name: "float64bits",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 41,
							Line:   574,
						},
						File:   "math.flux",
						Source: "(f: float) => uint",
						Start: ast.Position{
							Column: 23,
							Line:   574,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 41,
								Line:   574,
							},
							File:   "math.flux",
							Source: "(f: float) => uint",
							Start: ast.Position{
								Column: 23,
								Line:   574,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   574,
								},
								File:   "math.flux",
								Source: "f: float",
								Start: ast.Position{
									Column: 24,
									Line:   574,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   574,
									},
									File:   "math.flux",
									Source: "f",
									Start: ast.Position{
										Column: 24,
										Line:   574,
									},
								},
							},
							Name: "f",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   574,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 27,
										Line:   574,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   574,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 27,
											Line:   574,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   574,
								},
								File:   "math.flux",
								Source: "uint",
								Start: ast.Position{
									Column: 37,
									Line:   574,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   574,
									},
									File:   "math.flux",
									Source: "uint",
									Start: ast.Position{
										Column: 37,
										Line:   574,
									},
								},
							},
							Name: "uint",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// float64frombits is a function that returns the floating-point number corresponding\n"}, ast.Comment{Text: "//  to the IEE 754 binary representation b, with the sign bit of b and the result in the\n"}, ast.Comment{Text: "//  same bit position.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `b` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.float64frombits(b: 4)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   590,
					},
					File:   "math.flux",
					Source: "builtin float64frombits",
					Start: ast.Position{
						Column: 1,
						Line:   590,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   590,
						},
						File:   "math.flux",
						Source: "float64frombits",
						Start: ast.Position{
							Column: 9,
							Line:   590,
						},
					},
				},
				Name: "float64frombits",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   590,
						},
						File:   "math.flux",
						Source: "(b: uint) => float",
						Start: ast.Position{
							Column: 27,
							Line:   590,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   590,
							},
							File:   "math.flux",
							Source: "(b: uint) => float",
							Start: ast.Position{
								Column: 27,
								Line:   590,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   590,
								},
								File:   "math.flux",
								Source: "b: uint",
								Start: ast.Position{
									Column: 28,
									Line:   590,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   590,
									},
									File:   "math.flux",
									Source: "b",
									Start: ast.Position{
										Column: 28,
										Line:   590,
									},
								},
							},
							Name: "b",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   590,
									},
									File:   "math.flux",
									Source: "uint",
									Start: ast.Position{
										Column: 31,
										Line:   590,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   590,
										},
										File:   "math.flux",
										Source: "uint",
										Start: ast.Position{
											Column: 31,
											Line:   590,
										},
									},
								},
								Name: "uint",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   590,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 40,
									Line:   590,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   590,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 40,
										Line:   590,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// floor is a function that returns the greatest integer value less than or\n"}, ast.Comment{Text: "//  equal to x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.floor(x: 1.22)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.floor(±0)   // Returns ±0\n"}, ast.Comment{Text: "// math.floor(±Inf) // Returns ±Inf\n"}, ast.Comment{Text: "// math.floor(NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   615,
					},
					File:   "math.flux",
					Source: "builtin floor",
					Start: ast.Position{
						Column: 1,
						Line:   615,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   615,
						},
						File:   "math.flux",
						Source: "floor",
						Start: ast.Position{
							Column: 9,
							Line:   615,
						},
					},
				},
				Name: "floor",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   615,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 17,
							Line:   615,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   615,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 17,
								Line:   615,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   615,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 18,
									Line:   615,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   615,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 18,
										Line:   615,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   615,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   615,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   615,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   615,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   615,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 31,
									Line:   615,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   615,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   615,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// frexp is a function that breaks f into a normalized fraction and an\n"}, ast.Comment{Text: "//  integral part of two.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//  It returns frac and exp satisfying `f == frac x 2**exp`,\n"}, ast.Comment{Text: "//  with the absolute value of frac in the interval [1/2, 1).\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `f` the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.frexp(f: 22.0)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.frexp(f: ±0)   // Returns {frac: ±0, exp: 0}\n"}, ast.Comment{Text: "// math.frexp(f: ±Inf) // Returns {frac: ±Inf, exp: 0}\n"}, ast.Comment{Text: "// math.frexp(f: NaN)  // Returns {frac: NaN, exp: 0}\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   643,
					},
					File:   "math.flux",
					Source: "builtin frexp",
					Start: ast.Position{
						Column: 1,
						Line:   643,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   643,
						},
						File:   "math.flux",
						Source: "frexp",
						Start: ast.Position{
							Column: 9,
							Line:   643,
						},
					},
				},
				Name: "frexp",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 54,
							Line:   643,
						},
						File:   "math.flux",
						Source: "(f: float) => {frac: float, exp: int}",
						Start: ast.Position{
							Column: 17,
							Line:   643,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   643,
							},
							File:   "math.flux",
							Source: "(f: float) => {frac: float, exp: int}",
							Start: ast.Position{
								Column: 17,
								Line:   643,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   643,
								},
								File:   "math.flux",
								Source: "f: float",
								Start: ast.Position{
									Column: 18,
									Line:   643,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   643,
									},
									File:   "math.flux",
									Source: "f",
									Start: ast.Position{
										Column: 18,
										Line:   643,
									},
								},
							},
							Name: "f",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   643,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   643,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   643,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   643,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.RecordType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   643,
								},
								File:   "math.flux",
								Source: "{frac: float, exp: int}",
								Start: ast.Position{
									Column: 31,
									Line:   643,
								},
							},
						},
						Properties: []*ast.PropertyType{&ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   643,
									},
									File:   "math.flux",
									Source: "frac: float",
									Start: ast.Position{
										Column: 32,
										Line:   643,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   643,
										},
										File:   "math.flux",
										Source: "frac",
										Start: ast.Position{
											Column: 32,
											Line:   643,
										},
									},
								},
								Name: "frac",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   643,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 38,
											Line:   643,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   643,
											},
											File:   "math.flux",
											Source: "float",
											Start: ast.Position{
												Column: 38,
												Line:   643,
											},
										},
									},
									Name: "float",
								},
							},
						}, &ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   643,
									},
									File:   "math.flux",
									Source: "exp: int",
									Start: ast.Position{
										Column: 45,
										Line:   643,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   643,
										},
										File:   "math.flux",
										Source: "exp",
										Start: ast.Position{
											Column: 45,
											Line:   643,
										},
									},
								},
								Name: "exp",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   643,
										},
										File:   "math.flux",
										Source: "int",
										Start: ast.Position{
											Column: 50,
											Line:   643,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   643,
											},
											File:   "math.flux",
											Source: "int",
											Start: ast.Position{
												Column: 50,
												Line:   643,
											},
										},
									},
									Name: "int",
								},
							},
						}},
						Tvar: nil,
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// gamma is a function that returns the gamma function of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.gamma(x: 2.12)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.gamma(x: +Inf) = +Inf\n"}, ast.Comment{Text: "// math.gamma(x: +0) = +Inf\n"}, ast.Comment{Text: "// math.gamma(x: -0) = -Inf\n"}, ast.Comment{Text: "// math.gamma(x: <0) = NaN for integer x < 0\n"}, ast.Comment{Text: "// math.gamma(x: -Inf) = NaN\n"}, ast.Comment{Text: "// math.gamma(x: NaN) = NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   670,
					},
					File:   "math.flux",
					Source: "builtin gamma",
					Start: ast.Position{
						Column: 1,
						Line:   670,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   670,
						},
						File:   "math.flux",
						Source: "gamma",
						Start: ast.Position{
							Column: 9,
							Line:   670,
						},
					},
				},
				Name: "gamma",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   670,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 17,
							Line:   670,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   670,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 17,
								Line:   670,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   670,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 18,
									Line:   670,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   670,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 18,
										Line:   670,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   670,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   670,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   670,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   670,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   670,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 31,
									Line:   670,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   670,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   670,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// hypot is a function that returns the square root of `p*p + q*q`, taking\n"}, ast.Comment{Text: "//  care to avoid overflow and underflow.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Params\n"}, ast.Comment{Text: "// - `p` is the p-value used in the operation.\n"}, ast.Comment{Text: "// - `q` is the q-value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.hypot(p: 2.0, q: 5.0)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.hypot(p: ±Inf, q:q) // Returns +Inf\n"}, ast.Comment{Text: "// math.hypot(p:p, q: ±Inf) // Returns +Inf\n"}, ast.Comment{Text: "// math.hypot(p: NaN, q:q)  // Returns NaN\n"}, ast.Comment{Text: "// math.hypot(p:p, q: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   697,
					},
					File:   "math.flux",
					Source: "builtin hypot",
					Start: ast.Position{
						Column: 1,
						Line:   697,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   697,
						},
						File:   "math.flux",
						Source: "hypot",
						Start: ast.Position{
							Column: 9,
							Line:   697,
						},
					},
				},
				Name: "hypot",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   697,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 17,
							Line:   697,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   697,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 17,
								Line:   697,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   697,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 18,
									Line:   697,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   697,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 18,
										Line:   697,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   697,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   697,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   697,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   697,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   697,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 31,
									Line:   697,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   697,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   697,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// ilogb is a function that returns the binary exponent of x as an integer.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.ilogb(x: 123.45)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.ilogb(x: ±Inf) // Returns MaxInt32\n"}, ast.Comment{Text: "// math.ilogb(x: 0)    // Returns MinInt32\n"}, ast.Comment{Text: "// math.ilogb(x: NaN)  // Returns MaxInt32\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   721,
					},
					File:   "math.flux",
					Source: "builtin ilogb",
					Start: ast.Position{
						Column: 1,
						Line:   721,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   721,
						},
						File:   "math.flux",
						Source: "ilogb",
						Start: ast.Position{
							Column: 9,
							Line:   721,
						},
					},
				},
				Name: "ilogb",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   721,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 17,
							Line:   721,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   721,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 17,
								Line:   721,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   721,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 18,
									Line:   721,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   721,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 18,
										Line:   721,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   721,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   721,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   721,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   721,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   721,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 31,
									Line:   721,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   721,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   721,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// mInf is a function that returns positive infinity if `sign >= 0`, negative infinity\n"}, ast.Comment{Text: "// if `sign < 0`\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `sign` is the sign value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.mInf(sign: 1)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   736,
					},
					File:   "math.flux",
					Source: "builtin mInf",
					Start: ast.Position{
						Column: 1,
						Line:   736,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   736,
						},
						File:   "math.flux",
						Source: "mInf",
						Start: ast.Position{
							Column: 9,
							Line:   736,
						},
					},
				},
				Name: "mInf",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   736,
						},
						File:   "math.flux",
						Source: "(sign: int) => float",
						Start: ast.Position{
							Column: 16,
							Line:   736,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   736,
							},
							File:   "math.flux",
							Source: "(sign: int) => float",
							Start: ast.Position{
								Column: 16,
								Line:   736,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   736,
								},
								File:   "math.flux",
								Source: "sign: int",
								Start: ast.Position{
									Column: 17,
									Line:   736,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   736,
									},
									File:   "math.flux",
									Source: "sign",
									Start: ast.Position{
										Column: 17,
										Line:   736,
									},
								},
							},
							Name: "sign",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   736,
									},
									File:   "math.flux",
									Source: "int",
									Start: ast.Position{
										Column: 23,
										Line:   736,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   736,
										},
										File:   "math.flux",
										Source: "int",
										Start: ast.Position{
											Column: 23,
											Line:   736,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   736,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 31,
									Line:   736,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   736,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   736,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// isInf is a function that reports whether f is an infinity, according to sign.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// If `sign > 0`, math.isInf reports whether f is positive infinity.\n"}, ast.Comment{Text: "// If `sign < 0`, math.isInf reports whether f is negative infinity.\n"}, ast.Comment{Text: "// If `sign  == 0`, math.isInf reports whether f is either infinity.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `f` is the value used in the evaluation.\n"}, ast.Comment{Text: "// - `sign` is the sign used in the eveluation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.isInf(f: 2.12, sign: 3)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   755,
					},
					File:   "math.flux",
					Source: "builtin isInf",
					Start: ast.Position{
						Column: 1,
						Line:   755,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   755,
						},
						File:   "math.flux",
						Source: "isInf",
						Start: ast.Position{
							Column: 9,
							Line:   755,
						},
					},
				},
				Name: "isInf",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 46,
							Line:   755,
						},
						File:   "math.flux",
						Source: "(f: float, sign: int) => bool",
						Start: ast.Position{
							Column: 17,
							Line:   755,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 46,
								Line:   755,
							},
							File:   "math.flux",
							Source: "(f: float, sign: int) => bool",
							Start: ast.Position{
								Column: 17,
								Line:   755,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   755,
								},
								File:   "math.flux",
								Source: "f: float",
								Start: ast.Position{
									Column: 18,
									Line:   755,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   755,
									},
									File:   "math.flux",
									Source: "f",
									Start: ast.Position{
										Column: 18,
										Line:   755,
									},
								},
							},
							Name: "f",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   755,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   755,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   755,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   755,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   755,
								},
								File:   "math.flux",
								Source: "sign: int",
								Start: ast.Position{
									Column: 28,
									Line:   755,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   755,
									},
									File:   "math.flux",
									Source: "sign",
									Start: ast.Position{
										Column: 28,
										Line:   755,
									},
								},
							},
							Name: "sign",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   755,
									},
									File:   "math.flux",
									Source: "int",
									Start: ast.Position{
										Column: 34,
										Line:   755,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   755,
										},
										File:   "math.flux",
										Source: "int",
										Start: ast.Position{
											Column: 34,
											Line:   755,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   755,
								},
								File:   "math.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 42,
									Line:   755,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   755,
									},
									File:   "math.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 42,
										Line:   755,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// isNaN is a function that reports whether f is an IEEE 754 \"not-a-number\" value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `f` is the value used in the evaluation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.isNaN(f: 12.345)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   769,
					},
					File:   "math.flux",
					Source: "builtin isNaN",
					Start: ast.Position{
						Column: 1,
						Line:   769,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   769,
						},
						File:   "math.flux",
						Source: "isNaN",
						Start: ast.Position{
							Column: 9,
							Line:   769,
						},
					},
				},
				Name: "isNaN",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   769,
						},
						File:   "math.flux",
						Source: "(f: float) => bool",
						Start: ast.Position{
							Column: 17,
							Line:   769,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   769,
							},
							File:   "math.flux",
							Source: "(f: float) => bool",
							Start: ast.Position{
								Column: 17,
								Line:   769,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   769,
								},
								File:   "math.flux",
								Source: "f: float",
								Start: ast.Position{
									Column: 18,
									Line:   769,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   769,
									},
									File:   "math.flux",
									Source: "f",
									Start: ast.Position{
										Column: 18,
										Line:   769,
									},
								},
							},
							Name: "f",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   769,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   769,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   769,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   769,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   769,
								},
								File:   "math.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 31,
									Line:   769,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   769,
									},
									File:   "math.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 31,
										Line:   769,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// j0 is a function that returns the order-zero Bessel function of the first kind.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.j0(x: 1.23)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.j0(x: ±Inf) // Returns 0\n"}, ast.Comment{Text: "// math.j0(x: 0)    // Returns 1\n"}, ast.Comment{Text: "// math.j0(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   793,
					},
					File:   "math.flux",
					Source: "builtin j0",
					Start: ast.Position{
						Column: 1,
						Line:   793,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   793,
						},
						File:   "math.flux",
						Source: "j0",
						Start: ast.Position{
							Column: 9,
							Line:   793,
						},
					},
				},
				Name: "j0",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   793,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 14,
							Line:   793,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   793,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 14,
								Line:   793,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   793,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 15,
									Line:   793,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   793,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 15,
										Line:   793,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   793,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 18,
										Line:   793,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   793,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 18,
											Line:   793,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   793,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 28,
									Line:   793,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   793,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 28,
										Line:   793,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// j1 is a funciton that returns the order-one Bessel function for the first kind.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.j1(x: 1.23)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.j1(±Inf) // Returns 0\n"}, ast.Comment{Text: "// math.j1(NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   816,
					},
					File:   "math.flux",
					Source: "builtin j1",
					Start: ast.Position{
						Column: 1,
						Line:   816,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   816,
						},
						File:   "math.flux",
						Source: "j1",
						Start: ast.Position{
							Column: 9,
							Line:   816,
						},
					},
				},
				Name: "j1",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   816,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 14,
							Line:   816,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   816,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 14,
								Line:   816,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   816,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 15,
									Line:   816,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   816,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 15,
										Line:   816,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   816,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 18,
										Line:   816,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   816,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 18,
											Line:   816,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   816,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 28,
									Line:   816,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   816,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 28,
										Line:   816,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// jn is a function that returns the order-n Bessel funciton of the first kind.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `n` is the order number.\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.jn(n: 2, x: 1.23)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.jn(n:n, x: ±Inf) // Returns 0\n"}, ast.Comment{Text: "// math.jn(n:n, x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   840,
					},
					File:   "math.flux",
					Source: "builtin jn",
					Start: ast.Position{
						Column: 1,
						Line:   840,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   840,
						},
						File:   "math.flux",
						Source: "jn",
						Start: ast.Position{
							Column: 9,
							Line:   840,
						},
					},
				},
				Name: "jn",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 41,
							Line:   840,
						},
						File:   "math.flux",
						Source: "(n: int, x: float) => float",
						Start: ast.Position{
							Column: 14,
							Line:   840,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 41,
								Line:   840,
							},
							File:   "math.flux",
							Source: "(n: int, x: float) => float",
							Start: ast.Position{
								Column: 14,
								Line:   840,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   840,
								},
								File:   "math.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 15,
									Line:   840,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   840,
									},
									File:   "math.flux",
									Source: "n",
									Start: ast.Position{
										Column: 15,
										Line:   840,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   840,
									},
									File:   "math.flux",
									Source: "int",
									Start: ast.Position{
										Column: 18,
										Line:   840,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   840,
										},
										File:   "math.flux",
										Source: "int",
										Start: ast.Position{
											Column: 18,
											Line:   840,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   840,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 23,
									Line:   840,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   840,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 23,
										Line:   840,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   840,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 26,
										Line:   840,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   840,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 26,
											Line:   840,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   840,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 36,
									Line:   840,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   840,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 36,
										Line:   840,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// ldexp is a function that is the inverse of math.frexp(). It returns\n"}, ast.Comment{Text: "//  `frac x 2**exp`. \n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `frac` is the fraction used in the operation.\n"}, ast.Comment{Text: "// - `exp` is the exponent used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.ldexp(frac: 0.5, exp: 6)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.ldexp(frac: ±0, exp:exp)   // Returns ±0\n"}, ast.Comment{Text: "// math.ldexp(frac: ±Inf, exp:exp) // Returns ±Inf\n"}, ast.Comment{Text: "// math.ldexp(frac: NaN, exp:exp)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   866,
					},
					File:   "math.flux",
					Source: "builtin ldexp",
					Start: ast.Position{
						Column: 1,
						Line:   866,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   866,
						},
						File:   "math.flux",
						Source: "ldexp",
						Start: ast.Position{
							Column: 9,
							Line:   866,
						},
					},
				},
				Name: "ldexp",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 49,
							Line:   866,
						},
						File:   "math.flux",
						Source: "(frac: float, exp: int) => float",
						Start: ast.Position{
							Column: 17,
							Line:   866,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   866,
							},
							File:   "math.flux",
							Source: "(frac: float, exp: int) => float",
							Start: ast.Position{
								Column: 17,
								Line:   866,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   866,
								},
								File:   "math.flux",
								Source: "frac: float",
								Start: ast.Position{
									Column: 18,
									Line:   866,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   866,
									},
									File:   "math.flux",
									Source: "frac",
									Start: ast.Position{
										Column: 18,
										Line:   866,
									},
								},
							},
							Name: "frac",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   866,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 24,
										Line:   866,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   866,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 24,
											Line:   866,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   866,
								},
								File:   "math.flux",
								Source: "exp: int",
								Start: ast.Position{
									Column: 31,
									Line:   866,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   866,
									},
									File:   "math.flux",
									Source: "exp",
									Start: ast.Position{
										Column: 31,
										Line:   866,
									},
								},
							},
							Name: "exp",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   866,
									},
									File:   "math.flux",
									Source: "int",
									Start: ast.Position{
										Column: 36,
										Line:   866,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   866,
										},
										File:   "math.flux",
										Source: "int",
										Start: ast.Position{
											Column: 36,
											Line:   866,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   866,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 44,
									Line:   866,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   866,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 44,
										Line:   866,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// lgamma is a function that returns the natural logarithm and sign\n"}, ast.Comment{Text: "//  (-1 or +1) of math.gamma(x:x).\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.lgamma(x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.lgamma(x: +Inf)     // Returns +Inf\n"}, ast.Comment{Text: "// math.lgamma(x: 0)        // Returns +Inf\n"}, ast.Comment{Text: "// math.lgamma(x: -integer) // Returns +Inf\n"}, ast.Comment{Text: "// math.lgamma(x: -Inf)     // Returns -Inf\n"}, ast.Comment{Text: "// math.lgamma(x: NaN)      // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   893,
					},
					File:   "math.flux",
					Source: "builtin lgamma",
					Start: ast.Position{
						Column: 1,
						Line:   893,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   893,
						},
						File:   "math.flux",
						Source: "lgamma",
						Start: ast.Position{
							Column: 9,
							Line:   893,
						},
					},
				},
				Name: "lgamma",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 58,
							Line:   893,
						},
						File:   "math.flux",
						Source: "(x: float) => {lgamma: float, sign: int}",
						Start: ast.Position{
							Column: 18,
							Line:   893,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   893,
							},
							File:   "math.flux",
							Source: "(x: float) => {lgamma: float, sign: int}",
							Start: ast.Position{
								Column: 18,
								Line:   893,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   893,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 19,
									Line:   893,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   893,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 19,
										Line:   893,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   893,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 22,
										Line:   893,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   893,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 22,
											Line:   893,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.RecordType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   893,
								},
								File:   "math.flux",
								Source: "{lgamma: float, sign: int}",
								Start: ast.Position{
									Column: 32,
									Line:   893,
								},
							},
						},
						Properties: []*ast.PropertyType{&ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   893,
									},
									File:   "math.flux",
									Source: "lgamma: float",
									Start: ast.Position{
										Column: 33,
										Line:   893,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   893,
										},
										File:   "math.flux",
										Source: "lgamma",
										Start: ast.Position{
											Column: 33,
											Line:   893,
										},
									},
								},
								Name: "lgamma",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   893,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 41,
											Line:   893,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   893,
											},
											File:   "math.flux",
											Source: "float",
											Start: ast.Position{
												Column: 41,
												Line:   893,
											},
										},
									},
									Name: "float",
								},
							},
						}, &ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   893,
									},
									File:   "math.flux",
									Source: "sign: int",
									Start: ast.Position{
										Column: 48,
										Line:   893,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   893,
										},
										File:   "math.flux",
										Source: "sign",
										Start: ast.Position{
											Column: 48,
											Line:   893,
										},
									},
								},
								Name: "sign",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   893,
										},
										File:   "math.flux",
										Source: "int",
										Start: ast.Position{
											Column: 54,
											Line:   893,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   893,
											},
											File:   "math.flux",
											Source: "int",
											Start: ast.Position{
												Column: 54,
												Line:   893,
											},
										},
									},
									Name: "int",
								},
							},
						}},
						Tvar: nil,
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// log is a function that returns the natural logarithm of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "// \n"}, ast.Comment{Text: "// math.log(x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.log(x: +Inf) // Returns +Inf\n"}, ast.Comment{Text: "// math.log(x: 0)    // Returns -Inf\n"}, ast.Comment{Text: "// math.log(x: <0)   // Returns NaN\n"}, ast.Comment{Text: "// math.log(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   918,
					},
					File:   "math.flux",
					Source: "builtin log",
					Start: ast.Position{
						Column: 1,
						Line:   918,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   918,
						},
						File:   "math.flux",
						Source: "log",
						Start: ast.Position{
							Column: 9,
							Line:   918,
						},
					},
				},
				Name: "log",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 34,
							Line:   918,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 15,
							Line:   918,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   918,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 15,
								Line:   918,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   918,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 16,
									Line:   918,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   918,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 16,
										Line:   918,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   918,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 19,
										Line:   918,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   918,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 19,
											Line:   918,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   918,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 29,
									Line:   918,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   918,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 29,
										Line:   918,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// log10 is a function that returns the decimal logarithm of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Params\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.log10(x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.log10(x: +Inf) // Returns +Inf\n"}, ast.Comment{Text: "// math.log10(x: 0)    // Returns -Inf\n"}, ast.Comment{Text: "// math.log10(x: <0)   // Returns NaN\n"}, ast.Comment{Text: "// math.log10(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   943,
					},
					File:   "math.flux",
					Source: "builtin log10",
					Start: ast.Position{
						Column: 1,
						Line:   943,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   943,
						},
						File:   "math.flux",
						Source: "log10",
						Start: ast.Position{
							Column: 9,
							Line:   943,
						},
					},
				},
				Name: "log10",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   943,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 17,
							Line:   943,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   943,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 17,
								Line:   943,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   943,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 18,
									Line:   943,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   943,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 18,
										Line:   943,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   943,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   943,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   943,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   943,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   943,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 31,
									Line:   943,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   943,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   943,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// log1p is a function that returns the natural logarithm of 1 plus the\n"}, ast.Comment{Text: "//  argument x. it is more accurate than `math.log(x: 1 + x)` when x is\n"}, ast.Comment{Text: "//  near zero.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.log1p(x: 0.56)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//math.log1p(x: +Inf) // Returns +Inf\n"}, ast.Comment{Text: "// math.log1p(x: ±0)   // Returns ±0\n"}, ast.Comment{Text: "// math.log1p(x: -1)   // Returns -Inf\n"}, ast.Comment{Text: "// math.log1p(x: <-1)  // Returns NaN\n"}, ast.Comment{Text: "// math.log1p(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   971,
					},
					File:   "math.flux",
					Source: "builtin log1p",
					Start: ast.Position{
						Column: 1,
						Line:   971,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   971,
						},
						File:   "math.flux",
						Source: "log1p",
						Start: ast.Position{
							Column: 9,
							Line:   971,
						},
					},
				},
				Name: "log1p",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   971,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 17,
							Line:   971,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   971,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 17,
								Line:   971,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   971,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 18,
									Line:   971,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   971,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 18,
										Line:   971,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   971,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   971,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   971,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   971,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   971,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 31,
									Line:   971,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   971,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   971,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// log2 is a function returns the binary logarithm of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.log2(X: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.log2(x: +Inf) // Returns +Inf\n"}, ast.Comment{Text: "// math.log2(x: 0)    // Returns -Inf\n"}, ast.Comment{Text: "// math.log2(x: <0)   // Returns NaN\n"}, ast.Comment{Text: "// math.log2(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   996,
					},
					File:   "math.flux",
					Source: "builtin log2",
					Start: ast.Position{
						Column: 1,
						Line:   996,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   996,
						},
						File:   "math.flux",
						Source: "log2",
						Start: ast.Position{
							Column: 9,
							Line:   996,
						},
					},
				},
				Name: "log2",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   996,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   996,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   996,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   996,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   996,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   996,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   996,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   996,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   996,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   996,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   996,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   996,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   996,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 30,
									Line:   996,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   996,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   996,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// logb is a function that returns the binary exponent of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.logb(x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.logb(x: ±Inf) // Returns +Inf\n"}, ast.Comment{Text: "// math.logb(x: 0)    // Returns -Inf\n"}, ast.Comment{Text: "// math.logb(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   1020,
					},
					File:   "math.flux",
					Source: "builtin logb",
					Start: ast.Position{
						Column: 1,
						Line:   1020,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   1020,
						},
						File:   "math.flux",
						Source: "logb",
						Start: ast.Position{
							Column: 9,
							Line:   1020,
						},
					},
				},
				Name: "logb",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   1020,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   1020,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   1020,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   1020,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   1020,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   1020,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   1020,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   1020,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   1020,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   1020,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   1020,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   1020,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   1020,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 30,
									Line:   1020,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   1020,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   1020,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// mMax is a function that returns the larger of x or y.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the x-value used in the operation.\n"}, ast.Comment{Text: "// - `y` is the y-value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.mMax(x: 1.23, y: 4.56)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.mMax(x:x, y:+Inf)  // Returns +Inf\n"}, ast.Comment{Text: "// math.mMax(x: +Inf, y:y) // Returns +Inf\n"}, ast.Comment{Text: "// math.mMax(x:x, y: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// math.mMax(x: NaN, y:y)  // Returns NaN\n"}, ast.Comment{Text: "// math.mMax(x: +0, y: ±0) // Returns +0\n"}, ast.Comment{Text: "// math.mMax(x: ±0, y: +0) // Returns +0\n"}, ast.Comment{Text: "// math.mMax(x: -0, y: -0) // Returns -0\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   1049,
					},
					File:   "math.flux",
					Source: "builtin mMax",
					Start: ast.Position{
						Column: 1,
						Line:   1049,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   1049,
						},
						File:   "math.flux",
						Source: "mMax",
						Start: ast.Position{
							Column: 9,
							Line:   1049,
						},
					},
				},
				Name: "mMax",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   1049,
						},
						File:   "math.flux",
						Source: "(x: float, y: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   1049,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   1049,
							},
							File:   "math.flux",
							Source: "(x: float, y: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   1049,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   1049,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   1049,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   1049,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   1049,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   1049,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   1049,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   1049,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   1049,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   1049,
								},
								File:   "math.flux",
								Source: "y: float",
								Start: ast.Position{
									Column: 27,
									Line:   1049,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   1049,
									},
									File:   "math.flux",
									Source: "y",
									Start: ast.Position{
										Column: 27,
										Line:   1049,
									},
								},
							},
							Name: "y",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   1049,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   1049,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   1049,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 30,
											Line:   1049,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   1049,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 40,
									Line:   1049,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   1049,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 40,
										Line:   1049,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// mMin is a function taht returns the lessser of x or y.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the x-value used in the operation.\n"}, ast.Comment{Text: "// - `y` is the y-value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.mMin(x: 1.23, y: 4.56)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.mMin(x:x, y: -Inf) // Returns -Inf\n"}, ast.Comment{Text: "// math.mMin(x: -Inf, y:y) // Returns -Inf\n"}, ast.Comment{Text: "// math.mMin(x:x, y: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// math.mMin(x: NaN, y:y)  // Returns NaN\n"}, ast.Comment{Text: "// math.mMin(x: -0, y: ±0) // Returns -0\n"}, ast.Comment{Text: "// math.mMin(x: ±0, y: -0) // Returns -0\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   1075,
					},
					File:   "math.flux",
					Source: "builtin mMin",
					Start: ast.Position{
						Column: 1,
						Line:   1075,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   1075,
						},
						File:   "math.flux",
						Source: "mMin",
						Start: ast.Position{
							Column: 9,
							Line:   1075,
						},
					},
				},
				Name: "mMin",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 45,
							Line:   1075,
						},
						File:   "math.flux",
						Source: "(x: float, y: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   1075,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 45,
								Line:   1075,
							},
							File:   "math.flux",
							Source: "(x: float, y: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   1075,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   1075,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   1075,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   1075,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   1075,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   1075,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   1075,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   1075,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   1075,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   1075,
								},
								File:   "math.flux",
								Source: "y: float",
								Start: ast.Position{
									Column: 27,
									Line:   1075,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   1075,
									},
									File:   "math.flux",
									Source: "y",
									Start: ast.Position{
										Column: 27,
										Line:   1075,
									},
								},
							},
							Name: "y",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   1075,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   1075,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   1075,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 30,
											Line:   1075,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   1075,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 40,
									Line:   1075,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   1075,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 40,
										Line:   1075,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// mod is a function that returns a floating-point remainder of x/y.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//  The magnitude of the result is less than y and its sign agrees\n"}, ast.Comment{Text: "//  with that of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the x-value used in the operation.\n"}, ast.Comment{Text: "// - `y` is the y-value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.mod(x: 1.23, y: 4.56)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// math.mod(x: ±Inf, y:y)  // Returns NaN\n"}, ast.Comment{Text: "// math.mod(x: NaN, y:y)   // Returns NaN\n"}, ast.Comment{Text: "// math.mod(x:x, y: 0)     // Returns NaN\n"}, ast.Comment{Text: "// math.mod(x:x, y: ±Inf)  // Returns x\n"}, ast.Comment{Text: "// math.mod(x:x, y: NaN)   // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   1103,
					},
					File:   "math.flux",
					Source: "builtin mod",
					Start: ast.Position{
						Column: 1,
						Line:   1103,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   1103,
						},
						File:   "math.flux",
						Source: "mod",
						Start: ast.Position{
							Column: 9,
							Line:   1103,
						},
					},
				},
				Name: "mod",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 44,
							Line:   1103,
						},
						File:   "math.flux",
						Source: "(x: float, y: float) => float",
						Start: ast.Position{
							Column: 15,
							Line:   1103,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   1103,
							},
							File:   "math.flux",
							Source: "(x: float, y: float) => float",
							Start: ast.Position{
								Column: 15,
								Line:   1103,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   1103,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 16,
									Line:   1103,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   1103,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 16,
										Line:   1103,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   1103,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 19,
										Line:   1103,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   1103,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 19,
											Line:   1103,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   1103,
								},
								File:   "math.flux",
								Source: "y: float",
								Start: ast.Position{
									Column: 26,
									Line:   1103,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   1103,
									},
									File:   "math.flux",
									Source: "y",
									Start: ast.Position{
										Column: 26,
										Line:   1103,
									},
								},
							},
							Name: "y",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   1103,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 29,
										Line:   1103,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   1103,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 29,
											Line:   1103,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   1103,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 39,
									Line:   1103,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   1103,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 39,
										Line:   1103,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// modf is a function that returns integer and fractional floating-point numbers\n"}, ast.Comment{Text: "//  that sum to f. \n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//  Both values have the same sign as f.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `f` is the value used in the operation\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.modf(f: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.modf(f: ±Inf) // Returns {int: ±Inf, frac: NaN}\n"}, ast.Comment{Text: "// math.modf(f: NaN)  // Returns {int: NaN, frac: NaN}\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   1129,
					},
					File:   "math.flux",
					Source: "builtin modf",
					Start: ast.Position{
						Column: 1,
						Line:   1129,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   1129,
						},
						File:   "math.flux",
						Source: "modf",
						Start: ast.Position{
							Column: 9,
							Line:   1129,
						},
					},
				},
				Name: "modf",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 55,
							Line:   1129,
						},
						File:   "math.flux",
						Source: "(f: float) => {int: float, frac: float}",
						Start: ast.Position{
							Column: 16,
							Line:   1129,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   1129,
							},
							File:   "math.flux",
							Source: "(f: float) => {int: float, frac: float}",
							Start: ast.Position{
								Column: 16,
								Line:   1129,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   1129,
								},
								File:   "math.flux",
								Source: "f: float",
								Start: ast.Position{
									Column: 17,
									Line:   1129,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   1129,
									},
									File:   "math.flux",
									Source: "f",
									Start: ast.Position{
										Column: 17,
										Line:   1129,
									},
								},
							},
							Name: "f",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   1129,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   1129,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   1129,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   1129,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.RecordType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   1129,
								},
								File:   "math.flux",
								Source: "{int: float, frac: float}",
								Start: ast.Position{
									Column: 30,
									Line:   1129,
								},
							},
						},
						Properties: []*ast.PropertyType{&ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   1129,
									},
									File:   "math.flux",
									Source: "int: float",
									Start: ast.Position{
										Column: 31,
										Line:   1129,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   1129,
										},
										File:   "math.flux",
										Source: "int",
										Start: ast.Position{
											Column: 31,
											Line:   1129,
										},
									},
								},
								Name: "int",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   1129,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 36,
											Line:   1129,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   1129,
											},
											File:   "math.flux",
											Source: "float",
											Start: ast.Position{
												Column: 36,
												Line:   1129,
											},
										},
									},
									Name: "float",
								},
							},
						}, &ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   1129,
									},
									File:   "math.flux",
									Source: "frac: float",
									Start: ast.Position{
										Column: 43,
										Line:   1129,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   1129,
										},
										File:   "math.flux",
										Source: "frac",
										Start: ast.Position{
											Column: 43,
											Line:   1129,
										},
									},
								},
								Name: "frac",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   1129,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 49,
											Line:   1129,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   1129,
											},
											File:   "math.flux",
											Source: "float",
											Start: ast.Position{
												Column: 49,
												Line:   1129,
											},
										},
									},
									Name: "float",
								},
							},
						}},
						Tvar: nil,
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// NaN is a function that returns a IEEE 754 \"not-a-number\" value.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.NaN()\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   1140,
					},
					File:   "math.flux",
					Source: "builtin NaN",
					Start: ast.Position{
						Column: 1,
						Line:   1140,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   1140,
						},
						File:   "math.flux",
						Source: "NaN",
						Start: ast.Position{
							Column: 9,
							Line:   1140,
						},
					},
				},
				Name: "NaN",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   1140,
						},
						File:   "math.flux",
						Source: "() => float",
						Start: ast.Position{
							Column: 15,
							Line:   1140,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   1140,
							},
							File:   "math.flux",
							Source: "() => float",
							Start: ast.Position{
								Column: 15,
								Line:   1140,
							},
						},
					},
					Parameters: []*ast.ParameterType{},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   1140,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 21,
									Line:   1140,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   1140,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   1140,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// nextafter is a function that returns the next representable float value after\n"}, ast.Comment{Text: "//  x towards y.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the x-vaue used in the operation.\n"}, ast.Comment{Text: "// - `y` is the y-value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.nextafter(x: 1.23, y: 4.56)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.nextafter(x:x, y:x)    // Returns x\n"}, ast.Comment{Text: "// math.nextafter(x: NaN, y:y) // Returns NaN\n"}, ast.Comment{Text: "// math.nextafter(x:x, y:NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1166,
					},
					File:   "math.flux",
					Source: "builtin nextafter",
					Start: ast.Position{
						Column: 1,
						Line:   1166,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1166,
						},
						File:   "math.flux",
						Source: "nextafter",
						Start: ast.Position{
							Column: 9,
							Line:   1166,
						},
					},
				},
				Name: "nextafter",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   1166,
						},
						File:   "math.flux",
						Source: "(x: float, y: float) => float",
						Start: ast.Position{
							Column: 21,
							Line:   1166,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   1166,
							},
							File:   "math.flux",
							Source: "(x: float, y: float) => float",
							Start: ast.Position{
								Column: 21,
								Line:   1166,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   1166,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 22,
									Line:   1166,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   1166,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 22,
										Line:   1166,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   1166,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 25,
										Line:   1166,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   1166,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 25,
											Line:   1166,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   1166,
								},
								File:   "math.flux",
								Source: "y: float",
								Start: ast.Position{
									Column: 32,
									Line:   1166,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   1166,
									},
									File:   "math.flux",
									Source: "y",
									Start: ast.Position{
										Column: 32,
										Line:   1166,
									},
								},
							},
							Name: "y",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   1166,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 35,
										Line:   1166,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   1166,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 35,
											Line:   1166,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   1166,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 45,
									Line:   1166,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   1166,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 45,
										Line:   1166,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// pow is a function that returns x**y, the base-x exponential of y.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.pow(x: 2.0, y: 3.0)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// // In order of priority\n"}, ast.Comment{Text: "// math.pow(x:x, y:±0)     // Returns 1 for any x\n"}, ast.Comment{Text: "// math.pow(x:1, y:y)      // Returns 1 for any y\n"}, ast.Comment{Text: "// math.pow(x:X, y:1)      // Returns x for any x\n"}, ast.Comment{Text: "// math.pow(x:NaN, y:y)    // Returns NaN\n"}, ast.Comment{Text: "// math.pow(x:x, y:NaN)    // Returns NaN\n"}, ast.Comment{Text: "// math.pow(x:±0, y:y)     // Returns ±Inf for y an odd integer < 0\n"}, ast.Comment{Text: "// math.pow(x:±0, y:-Inf)  // Returns +Inf\n"}, ast.Comment{Text: "// math.pow(x:±0, y:+Inf)  // Returns +0\n"}, ast.Comment{Text: "// math.pow(x:±0, y:y)     // Returns +Inf for finite y < 0 and not an odd integer\n"}, ast.Comment{Text: "// math.pow(x:±0, y:y)     // Returns ±0 for y an odd integer > 0\n"}, ast.Comment{Text: "// math.pow(x:±0, y:y)     // Returns +0 for finite y > 0 and not an odd integer\n"}, ast.Comment{Text: "// math.pow(x:-1, y:±Inf)  // Returns 1\n"}, ast.Comment{Text: "// math.pow(x:x, y:+Inf)   // Returns +Inf for |x| > 1\n"}, ast.Comment{Text: "// math.pow(x:x, y:-Inf)   // Returns +0 for |x| > 1\n"}, ast.Comment{Text: "// math.pow(x:x, y:+Inf)   // Returns +0 for |x| < 1\n"}, ast.Comment{Text: "// math.pow(x:x, y:-Inf)   // Returns +Inf for |x| < 1\n"}, ast.Comment{Text: "// math.pow(x:+Inf, y:y)   // Returns +Inf for y > 0\n"}, ast.Comment{Text: "// math.pow(x:+Inf, y:y)   // Returns +0 for y < 0\n"}, ast.Comment{Text: "// math.pow(x:-Inf, y:y)   // Returns math.pow(-0, -y)\n"}, ast.Comment{Text: "// math.pow(x:x, y:y)      // Returns NaN for finite x < 0 and finite non-integer y\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   1205,
					},
					File:   "math.flux",
					Source: "builtin pow",
					Start: ast.Position{
						Column: 1,
						Line:   1205,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   1205,
						},
						File:   "math.flux",
						Source: "pow",
						Start: ast.Position{
							Column: 9,
							Line:   1205,
						},
					},
				},
				Name: "pow",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 44,
							Line:   1205,
						},
						File:   "math.flux",
						Source: "(x: float, y: float) => float",
						Start: ast.Position{
							Column: 15,
							Line:   1205,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 44,
								Line:   1205,
							},
							File:   "math.flux",
							Source: "(x: float, y: float) => float",
							Start: ast.Position{
								Column: 15,
								Line:   1205,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   1205,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 16,
									Line:   1205,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   1205,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 16,
										Line:   1205,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   1205,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 19,
										Line:   1205,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   1205,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 19,
											Line:   1205,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   1205,
								},
								File:   "math.flux",
								Source: "y: float",
								Start: ast.Position{
									Column: 26,
									Line:   1205,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   1205,
									},
									File:   "math.flux",
									Source: "y",
									Start: ast.Position{
										Column: 26,
										Line:   1205,
									},
								},
							},
							Name: "y",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   1205,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 29,
										Line:   1205,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   1205,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 29,
											Line:   1205,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   1205,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 39,
									Line:   1205,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   1205,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 39,
										Line:   1205,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// pow10 is a function that returns 10**n, the base-10 exponential of n.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `n` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.pow10(n: 3)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.pow10(n: <-323) // Returns 0\n"}, ast.Comment{Text: "// math.pow10(n: >308)  // Returns +Inf\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   1228,
					},
					File:   "math.flux",
					Source: "builtin pow10",
					Start: ast.Position{
						Column: 1,
						Line:   1228,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   1228,
						},
						File:   "math.flux",
						Source: "pow10",
						Start: ast.Position{
							Column: 9,
							Line:   1228,
						},
					},
				},
				Name: "pow10",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 34,
							Line:   1228,
						},
						File:   "math.flux",
						Source: "(n: int) => float",
						Start: ast.Position{
							Column: 17,
							Line:   1228,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   1228,
							},
							File:   "math.flux",
							Source: "(n: int) => float",
							Start: ast.Position{
								Column: 17,
								Line:   1228,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   1228,
								},
								File:   "math.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 18,
									Line:   1228,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   1228,
									},
									File:   "math.flux",
									Source: "n",
									Start: ast.Position{
										Column: 18,
										Line:   1228,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   1228,
									},
									File:   "math.flux",
									Source: "int",
									Start: ast.Position{
										Column: 21,
										Line:   1228,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   1228,
										},
										File:   "math.flux",
										Source: "int",
										Start: ast.Position{
											Column: 21,
											Line:   1228,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   1228,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 29,
									Line:   1228,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   1228,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 29,
										Line:   1228,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// remainder is a function that returns the IEEE 754 floating-point remainder\n"}, ast.Comment{Text: "//  of x / y.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the numerator used in the operation.\n"}, ast.Comment{Text: "// - `y` is the denominator used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.remainder(x: 21.0, y: 4.0)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.remainder(x: ±Inf, y:y)  // Returns NaN\n"}, ast.Comment{Text: "// math.remainder(x: NaN, y:y)   // Returns NaN\n"}, ast.Comment{Text: "// math.remainder(x:x, y: 0)     // Returns NaN\n"}, ast.Comment{Text: "// math.remainder(x:x, y: ±Inf)  // Returns x\n"}, ast.Comment{Text: "// math.remainder(x:x, y: NaN)   // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1256,
					},
					File:   "math.flux",
					Source: "builtin remainder",
					Start: ast.Position{
						Column: 1,
						Line:   1256,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1256,
						},
						File:   "math.flux",
						Source: "remainder",
						Start: ast.Position{
							Column: 9,
							Line:   1256,
						},
					},
				},
				Name: "remainder",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   1256,
						},
						File:   "math.flux",
						Source: "(x: float, y: float) => float",
						Start: ast.Position{
							Column: 21,
							Line:   1256,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   1256,
							},
							File:   "math.flux",
							Source: "(x: float, y: float) => float",
							Start: ast.Position{
								Column: 21,
								Line:   1256,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   1256,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 22,
									Line:   1256,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   1256,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 22,
										Line:   1256,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   1256,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 25,
										Line:   1256,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   1256,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 25,
											Line:   1256,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   1256,
								},
								File:   "math.flux",
								Source: "y: float",
								Start: ast.Position{
									Column: 32,
									Line:   1256,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   1256,
									},
									File:   "math.flux",
									Source: "y",
									Start: ast.Position{
										Column: 32,
										Line:   1256,
									},
								},
							},
							Name: "y",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   1256,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 35,
										Line:   1256,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   1256,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 35,
											Line:   1256,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   1256,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 45,
									Line:   1256,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   1256,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 45,
										Line:   1256,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// round is a function that returns the nearest integer, rounding half away\n"}, ast.Comment{Text: "//  from zero.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.round(x: 2.12)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.round(x: ±0)   // Returns ±0\n"}, ast.Comment{Text: "// math.round(x: ±Inf) // Returns ±Inf\n"}, ast.Comment{Text: "// math.round(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   1281,
					},
					File:   "math.flux",
					Source: "builtin round",
					Start: ast.Position{
						Column: 1,
						Line:   1281,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   1281,
						},
						File:   "math.flux",
						Source: "round",
						Start: ast.Position{
							Column: 9,
							Line:   1281,
						},
					},
				},
				Name: "round",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   1281,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 17,
							Line:   1281,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   1281,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 17,
								Line:   1281,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   1281,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 18,
									Line:   1281,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   1281,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 18,
										Line:   1281,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   1281,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   1281,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   1281,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   1281,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   1281,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 31,
									Line:   1281,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   1281,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   1281,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// roundtoeven is a function that returns the nearest integer, rounding\n"}, ast.Comment{Text: "//  ties to even.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.roundtoeven(x: 3.14)\n"}, ast.Comment{Text: "// math.roundtoeven(x: 3.5)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// math.roundtoeven(x: ±0)   // Returns ±0\n"}, ast.Comment{Text: "// math.roundtoeven(x: ±Inf) // Returns ±Inf\n"}, ast.Comment{Text: "// math.roundtoeven(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1305,
					},
					File:   "math.flux",
					Source: "builtin roundtoeven",
					Start: ast.Position{
						Column: 1,
						Line:   1305,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1305,
						},
						File:   "math.flux",
						Source: "roundtoeven",
						Start: ast.Position{
							Column: 9,
							Line:   1305,
						},
					},
				},
				Name: "roundtoeven",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   1305,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 23,
							Line:   1305,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   1305,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 23,
								Line:   1305,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   1305,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 24,
									Line:   1305,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   1305,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 24,
										Line:   1305,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   1305,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 27,
										Line:   1305,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   1305,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 27,
											Line:   1305,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   1305,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 37,
									Line:   1305,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   1305,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 37,
										Line:   1305,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// signbit is a function that reports whether x is negative of negative zero.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the evaluation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.signbit(x: -1.2)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   1319,
					},
					File:   "math.flux",
					Source: "builtin signbit",
					Start: ast.Position{
						Column: 1,
						Line:   1319,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   1319,
						},
						File:   "math.flux",
						Source: "signbit",
						Start: ast.Position{
							Column: 9,
							Line:   1319,
						},
					},
				},
				Name: "signbit",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 37,
							Line:   1319,
						},
						File:   "math.flux",
						Source: "(x: float) => bool",
						Start: ast.Position{
							Column: 19,
							Line:   1319,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   1319,
							},
							File:   "math.flux",
							Source: "(x: float) => bool",
							Start: ast.Position{
								Column: 19,
								Line:   1319,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   1319,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 20,
									Line:   1319,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   1319,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 20,
										Line:   1319,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   1319,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 23,
										Line:   1319,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   1319,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 23,
											Line:   1319,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   1319,
								},
								File:   "math.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 33,
									Line:   1319,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   1319,
									},
									File:   "math.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 33,
										Line:   1319,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// sin is a function that returns the sine of the radian argument x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the radian value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.sin(x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.sin(x: ±0)   // Returns ±0\n"}, ast.Comment{Text: "// math.sin(x: ±Inf) // Returns NaN\n"}, ast.Comment{Text: "// math.sin(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   1343,
					},
					File:   "math.flux",
					Source: "builtin sin",
					Start: ast.Position{
						Column: 1,
						Line:   1343,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   1343,
						},
						File:   "math.flux",
						Source: "sin",
						Start: ast.Position{
							Column: 9,
							Line:   1343,
						},
					},
				},
				Name: "sin",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 34,
							Line:   1343,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 15,
							Line:   1343,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   1343,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 15,
								Line:   1343,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   1343,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 16,
									Line:   1343,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   1343,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 16,
										Line:   1343,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   1343,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 19,
										Line:   1343,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   1343,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 19,
											Line:   1343,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   1343,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 29,
									Line:   1343,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   1343,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 29,
										Line:   1343,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// sincos is a function that returns the values of math.sin(x:x) and\n"}, ast.Comment{Text: "//  math.cos(x:x).\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.sincos(x: 1.23)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.sincos(x: ±0)   // Returns {sin: ±0, cos: 1}\n"}, ast.Comment{Text: "// math.sincos(x: ±Inf) // Returns {sin: NaN, cos: NaN}\n"}, ast.Comment{Text: "// math.sincos(x: NaN)  // Returns {sin: NaN, cos:  NaN}\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   1368,
					},
					File:   "math.flux",
					Source: "builtin sincos",
					Start: ast.Position{
						Column: 1,
						Line:   1368,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   1368,
						},
						File:   "math.flux",
						Source: "sincos",
						Start: ast.Position{
							Column: 9,
							Line:   1368,
						},
					},
				},
				Name: "sincos",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 56,
							Line:   1368,
						},
						File:   "math.flux",
						Source: "(x: float) => {sin: float, cos: float}",
						Start: ast.Position{
							Column: 18,
							Line:   1368,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   1368,
							},
							File:   "math.flux",
							Source: "(x: float) => {sin: float, cos: float}",
							Start: ast.Position{
								Column: 18,
								Line:   1368,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   1368,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 19,
									Line:   1368,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   1368,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 19,
										Line:   1368,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   1368,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 22,
										Line:   1368,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   1368,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 22,
											Line:   1368,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.RecordType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   1368,
								},
								File:   "math.flux",
								Source: "{sin: float, cos: float}",
								Start: ast.Position{
									Column: 32,
									Line:   1368,
								},
							},
						},
						Properties: []*ast.PropertyType{&ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   1368,
									},
									File:   "math.flux",
									Source: "sin: float",
									Start: ast.Position{
										Column: 33,
										Line:   1368,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   1368,
										},
										File:   "math.flux",
										Source: "sin",
										Start: ast.Position{
											Column: 33,
											Line:   1368,
										},
									},
								},
								Name: "sin",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   1368,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 38,
											Line:   1368,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   1368,
											},
											File:   "math.flux",
											Source: "float",
											Start: ast.Position{
												Column: 38,
												Line:   1368,
											},
										},
									},
									Name: "float",
								},
							},
						}, &ast.PropertyType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   1368,
									},
									File:   "math.flux",
									Source: "cos: float",
									Start: ast.Position{
										Column: 45,
										Line:   1368,
									},
								},
							},
							Name: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   1368,
										},
										File:   "math.flux",
										Source: "cos",
										Start: ast.Position{
											Column: 45,
											Line:   1368,
										},
									},
								},
								Name: "cos",
							},
							Ty: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   1368,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 50,
											Line:   1368,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   1368,
											},
											File:   "math.flux",
											Source: "float",
											Start: ast.Position{
												Column: 50,
												Line:   1368,
											},
										},
									},
									Name: "float",
								},
							},
						}},
						Tvar: nil,
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// sinh is a function that returns the hyperbolic sine of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.sinh(x: 1.23)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.sinh(x: ±0)   // Returns ±0\n"}, ast.Comment{Text: "// math.sinh(x: ±Inf) // Returns ±Inf\n"}, ast.Comment{Text: "// math.sinh(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   1392,
					},
					File:   "math.flux",
					Source: "builtin sinh",
					Start: ast.Position{
						Column: 1,
						Line:   1392,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   1392,
						},
						File:   "math.flux",
						Source: "sinh",
						Start: ast.Position{
							Column: 9,
							Line:   1392,
						},
					},
				},
				Name: "sinh",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   1392,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   1392,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   1392,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   1392,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   1392,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   1392,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   1392,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   1392,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   1392,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   1392,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   1392,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   1392,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   1392,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 30,
									Line:   1392,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   1392,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   1392,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// sqrt is a function that returns the square root of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.sqrt(x: 4.0)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.sqrt(x: +Inf) // Returns +Inf\n"}, ast.Comment{Text: "// math.sqrt(x: ±0)   // Returns ±0\n"}, ast.Comment{Text: "// math.sqrt(x: <0)   // Returns NaN\n"}, ast.Comment{Text: "// math.sqrt(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   1417,
					},
					File:   "math.flux",
					Source: "builtin sqrt",
					Start: ast.Position{
						Column: 1,
						Line:   1417,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   1417,
						},
						File:   "math.flux",
						Source: "sqrt",
						Start: ast.Position{
							Column: 9,
							Line:   1417,
						},
					},
				},
				Name: "sqrt",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   1417,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   1417,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   1417,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   1417,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   1417,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   1417,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   1417,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   1417,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   1417,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   1417,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   1417,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   1417,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   1417,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 30,
									Line:   1417,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   1417,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   1417,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// tan is a function that returns the tangent of the radian argument.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.tan(x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.tan(x: ±0)   // Returns ±0\n"}, ast.Comment{Text: "// math.tan(x: ±Inf) // Returns NaN\n"}, ast.Comment{Text: "// math.tan(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   1441,
					},
					File:   "math.flux",
					Source: "builtin tan",
					Start: ast.Position{
						Column: 1,
						Line:   1441,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   1441,
						},
						File:   "math.flux",
						Source: "tan",
						Start: ast.Position{
							Column: 9,
							Line:   1441,
						},
					},
				},
				Name: "tan",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 34,
							Line:   1441,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 15,
							Line:   1441,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   1441,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 15,
								Line:   1441,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   1441,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 16,
									Line:   1441,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   1441,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 16,
										Line:   1441,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   1441,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 19,
										Line:   1441,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   1441,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 19,
											Line:   1441,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   1441,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 29,
									Line:   1441,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   1441,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 29,
										Line:   1441,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// tanh is a function that returns the hyperbolic tangent of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.tanh(x: 1.23)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.tanh(x: ±0)   // Returns ±0\n"}, ast.Comment{Text: "// math.tanh(x: ±Inf) // Returns ±1\n"}, ast.Comment{Text: "// math.tanh(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   1465,
					},
					File:   "math.flux",
					Source: "builtin tanh",
					Start: ast.Position{
						Column: 1,
						Line:   1465,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   1465,
						},
						File:   "math.flux",
						Source: "tanh",
						Start: ast.Position{
							Column: 9,
							Line:   1465,
						},
					},
				},
				Name: "tanh",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   1465,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 16,
							Line:   1465,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   1465,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 16,
								Line:   1465,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   1465,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 17,
									Line:   1465,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   1465,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 17,
										Line:   1465,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   1465,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 20,
										Line:   1465,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   1465,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 20,
											Line:   1465,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   1465,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 30,
									Line:   1465,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   1465,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   1465,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// trunc is a function that returns the integer value of x.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.trunc(x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.trunc(x: ±0)   // Returns ±0\n"}, ast.Comment{Text: "// math.trunc(x: ±Inf) // Returns ±Inf\n"}, ast.Comment{Text: "// math.trunc(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   1489,
					},
					File:   "math.flux",
					Source: "builtin trunc",
					Start: ast.Position{
						Column: 1,
						Line:   1489,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   1489,
						},
						File:   "math.flux",
						Source: "trunc",
						Start: ast.Position{
							Column: 9,
							Line:   1489,
						},
					},
				},
				Name: "trunc",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   1489,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 17,
							Line:   1489,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   1489,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 17,
								Line:   1489,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   1489,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 18,
									Line:   1489,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   1489,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 18,
										Line:   1489,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   1489,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 21,
										Line:   1489,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   1489,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 21,
											Line:   1489,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   1489,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 31,
									Line:   1489,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   1489,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 31,
										Line:   1489,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// y0 is a function that returns the order-zero Bessel function of the\n"}, ast.Comment{Text: "//  second kind.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.y0(x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.y0(x: +Inf) // Returns 0\n"}, ast.Comment{Text: "// math.y0(x: 0)    // Returns -Inf\n"}, ast.Comment{Text: "// math.y0(x: <0)   // Returns NaN\n"}, ast.Comment{Text: "// math.y0(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   1515,
					},
					File:   "math.flux",
					Source: "builtin y0",
					Start: ast.Position{
						Column: 1,
						Line:   1515,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   1515,
						},
						File:   "math.flux",
						Source: "y0",
						Start: ast.Position{
							Column: 9,
							Line:   1515,
						},
					},
				},
				Name: "y0",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   1515,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 14,
							Line:   1515,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   1515,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 14,
								Line:   1515,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   1515,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 15,
									Line:   1515,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   1515,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 15,
										Line:   1515,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   1515,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 18,
										Line:   1515,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   1515,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 18,
											Line:   1515,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   1515,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 28,
									Line:   1515,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   1515,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 28,
										Line:   1515,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// y1 is a function that returns the order-one Bessel function of\n"}, ast.Comment{Text: "//  the second kind.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.y1(x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.y1(x: +Inf) // Returns 0\n"}, ast.Comment{Text: "// math.y1(x: 0)    // Returns -Inf\n"}, ast.Comment{Text: "// math.y1(x: <0)   // Returns NaN\n"}, ast.Comment{Text: "// math.y1(x: NaN)  // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   1541,
					},
					File:   "math.flux",
					Source: "builtin y1",
					Start: ast.Position{
						Column: 1,
						Line:   1541,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   1541,
						},
						File:   "math.flux",
						Source: "y1",
						Start: ast.Position{
							Column: 9,
							Line:   1541,
						},
					},
				},
				Name: "y1",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   1541,
						},
						File:   "math.flux",
						Source: "(x: float) => float",
						Start: ast.Position{
							Column: 14,
							Line:   1541,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   1541,
							},
							File:   "math.flux",
							Source: "(x: float) => float",
							Start: ast.Position{
								Column: 14,
								Line:   1541,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   1541,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 15,
									Line:   1541,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   1541,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 15,
										Line:   1541,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   1541,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 18,
										Line:   1541,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   1541,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 18,
											Line:   1541,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   1541,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 28,
									Line:   1541,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   1541,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 28,
										Line:   1541,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// yn is a function that returns the order-n Bessel function of\n"}, ast.Comment{Text: "//  the second kind.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `n` is the order number used in the operation.\n"}, ast.Comment{Text: "// - `x` is the value used in the operation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.yn(n: 3, x: 3.14)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Special Cases\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"math\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// math.yn(n:n, x: +Inf) // Returns 0\n"}, ast.Comment{Text: "// math.yn(n: ≥0, x: 0)  // Returns -Inf\n"}, ast.Comment{Text: "// math.yn(n: <0, x: 0)  // Returns +Inf if n is odd, -Inf if n is even\n"}, ast.Comment{Text: "// math.yn(n:n, x: <0)   // Returns NaN\n"}, ast.Comment{Text: "// math.yn(n:n, x:NaN)   // Returns NaN\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   1569,
					},
					File:   "math.flux",
					Source: "builtin yn",
					Start: ast.Position{
						Column: 1,
						Line:   1569,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   1569,
						},
						File:   "math.flux",
						Source: "yn",
						Start: ast.Position{
							Column: 9,
							Line:   1569,
						},
					},
				},
				Name: "yn",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 41,
							Line:   1569,
						},
						File:   "math.flux",
						Source: "(n: int, x: float) => float",
						Start: ast.Position{
							Column: 14,
							Line:   1569,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 41,
								Line:   1569,
							},
							File:   "math.flux",
							Source: "(n: int, x: float) => float",
							Start: ast.Position{
								Column: 14,
								Line:   1569,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   1569,
								},
								File:   "math.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 15,
									Line:   1569,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   1569,
									},
									File:   "math.flux",
									Source: "n",
									Start: ast.Position{
										Column: 15,
										Line:   1569,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   1569,
									},
									File:   "math.flux",
									Source: "int",
									Start: ast.Position{
										Column: 18,
										Line:   1569,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   1569,
										},
										File:   "math.flux",
										Source: "int",
										Start: ast.Position{
											Column: 18,
											Line:   1569,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   1569,
								},
								File:   "math.flux",
								Source: "x: float",
								Start: ast.Position{
									Column: 23,
									Line:   1569,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   1569,
									},
									File:   "math.flux",
									Source: "x",
									Start: ast.Position{
										Column: 23,
										Line:   1569,
									},
								},
							},
							Name: "x",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   1569,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 26,
										Line:   1569,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   1569,
										},
										File:   "math.flux",
										Source: "float",
										Start: ast.Position{
											Column: 26,
											Line:   1569,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   1569,
								},
								File:   "math.flux",
								Source: "float",
								Start: ast.Position{
									Column: 36,
									Line:   1569,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   1569,
									},
									File:   "math.flux",
									Source: "float",
									Start: ast.Position{
										Column: 36,
										Line:   1569,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}},
		Eof:      nil,
		Imports:  nil,
		Metadata: "parser-type=rust",
		Name:     "math.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package math provides basic constants and mathematical functions\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   2,
					},
					File:   "math.flux",
					Source: "package math",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   2,
						},
						File:   "math.flux",
						Source: "math",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "math",
			},
		},
	}},
	Package: "math",
	Path:    "math",
}
