package spark

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// BatchClient is the client for the Batch methods of the Spark service.
type BatchClient struct {
	BaseClient
}

// NewBatchClient creates an instance of the BatchClient client.
func NewBatchClient(endpoint string, sparkPoolName string) BatchClient {
	return BatchClient{New(endpoint, sparkPoolName)}
}

// CancelSparkBatchJob cancels a running spark batch job.
// Parameters:
// batchID - identifier for the batch job.
func (client BatchClient) CancelSparkBatchJob(ctx context.Context, batchID int32) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BatchClient.CancelSparkBatchJob")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CancelSparkBatchJobPreparer(ctx, batchID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "spark.BatchClient", "CancelSparkBatchJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.CancelSparkBatchJobSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "spark.BatchClient", "CancelSparkBatchJob", resp, "Failure sending request")
		return
	}

	result, err = client.CancelSparkBatchJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "spark.BatchClient", "CancelSparkBatchJob", resp, "Failure responding to request")
		return
	}

	return
}

// CancelSparkBatchJobPreparer prepares the CancelSparkBatchJob request.
func (client BatchClient) CancelSparkBatchJobPreparer(ctx context.Context, batchID int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint":       client.Endpoint,
		"livyApiVersion": client.LivyAPIVersion,
		"sparkPoolName":  client.SparkPoolName,
	}

	pathParameters := map[string]interface{}{
		"batchId": autorest.Encode("path", batchID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{endpoint}/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}", urlParameters),
		autorest.WithPathParameters("/batches/{batchId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CancelSparkBatchJobSender sends the CancelSparkBatchJob request. The method will close the
// http.Response Body if it receives an error.
func (client BatchClient) CancelSparkBatchJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CancelSparkBatchJobResponder handles the response to the CancelSparkBatchJob request. The method always
// closes the http.Response Body.
func (client BatchClient) CancelSparkBatchJobResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// CreateSparkBatchJob create new spark batch job.
// Parameters:
// sparkBatchJobOptions - livy compatible batch job request payload.
// detailed - optional query param specifying whether detailed response is returned beyond plain livy.
func (client BatchClient) CreateSparkBatchJob(ctx context.Context, sparkBatchJobOptions BatchJobOptions, detailed *bool) (result BatchJob, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BatchClient.CreateSparkBatchJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: sparkBatchJobOptions,
			Constraints: []validation.Constraint{{Target: "sparkBatchJobOptions.Name", Name: validation.Null, Rule: true, Chain: nil},
				{Target: "sparkBatchJobOptions.File", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("spark.BatchClient", "CreateSparkBatchJob", err.Error())
	}

	req, err := client.CreateSparkBatchJobPreparer(ctx, sparkBatchJobOptions, detailed)
	if err != nil {
		err = autorest.NewErrorWithError(err, "spark.BatchClient", "CreateSparkBatchJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSparkBatchJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "spark.BatchClient", "CreateSparkBatchJob", resp, "Failure sending request")
		return
	}

	result, err = client.CreateSparkBatchJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "spark.BatchClient", "CreateSparkBatchJob", resp, "Failure responding to request")
		return
	}

	return
}

// CreateSparkBatchJobPreparer prepares the CreateSparkBatchJob request.
func (client BatchClient) CreateSparkBatchJobPreparer(ctx context.Context, sparkBatchJobOptions BatchJobOptions, detailed *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint":       client.Endpoint,
		"livyApiVersion": client.LivyAPIVersion,
		"sparkPoolName":  client.SparkPoolName,
	}

	queryParameters := map[string]interface{}{}
	if detailed != nil {
		queryParameters["detailed"] = autorest.Encode("query", *detailed)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{endpoint}/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}", urlParameters),
		autorest.WithPath("/batches"),
		autorest.WithJSON(sparkBatchJobOptions),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSparkBatchJobSender sends the CreateSparkBatchJob request. The method will close the
// http.Response Body if it receives an error.
func (client BatchClient) CreateSparkBatchJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateSparkBatchJobResponder handles the response to the CreateSparkBatchJob request. The method always
// closes the http.Response Body.
func (client BatchClient) CreateSparkBatchJobResponder(resp *http.Response) (result BatchJob, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSparkBatchJob gets a single spark batch job.
// Parameters:
// batchID - identifier for the batch job.
// detailed - optional query param specifying whether detailed response is returned beyond plain livy.
func (client BatchClient) GetSparkBatchJob(ctx context.Context, batchID int32, detailed *bool) (result BatchJob, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BatchClient.GetSparkBatchJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSparkBatchJobPreparer(ctx, batchID, detailed)
	if err != nil {
		err = autorest.NewErrorWithError(err, "spark.BatchClient", "GetSparkBatchJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSparkBatchJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "spark.BatchClient", "GetSparkBatchJob", resp, "Failure sending request")
		return
	}

	result, err = client.GetSparkBatchJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "spark.BatchClient", "GetSparkBatchJob", resp, "Failure responding to request")
		return
	}

	return
}

// GetSparkBatchJobPreparer prepares the GetSparkBatchJob request.
func (client BatchClient) GetSparkBatchJobPreparer(ctx context.Context, batchID int32, detailed *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint":       client.Endpoint,
		"livyApiVersion": client.LivyAPIVersion,
		"sparkPoolName":  client.SparkPoolName,
	}

	pathParameters := map[string]interface{}{
		"batchId": autorest.Encode("path", batchID),
	}

	queryParameters := map[string]interface{}{}
	if detailed != nil {
		queryParameters["detailed"] = autorest.Encode("query", *detailed)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}", urlParameters),
		autorest.WithPathParameters("/batches/{batchId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSparkBatchJobSender sends the GetSparkBatchJob request. The method will close the
// http.Response Body if it receives an error.
func (client BatchClient) GetSparkBatchJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSparkBatchJobResponder handles the response to the GetSparkBatchJob request. The method always
// closes the http.Response Body.
func (client BatchClient) GetSparkBatchJobResponder(resp *http.Response) (result BatchJob, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSparkBatchJobs list all spark batch jobs which are running under a particular spark pool.
// Parameters:
// from - optional param specifying which index the list should begin from.
// size - optional param specifying the size of the returned list.
// By default it is 20 and that is the maximum.
// detailed - optional query param specifying whether detailed response is returned beyond plain livy.
func (client BatchClient) GetSparkBatchJobs(ctx context.Context, from *int32, size *int32, detailed *bool) (result BatchJobCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BatchClient.GetSparkBatchJobs")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSparkBatchJobsPreparer(ctx, from, size, detailed)
	if err != nil {
		err = autorest.NewErrorWithError(err, "spark.BatchClient", "GetSparkBatchJobs", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSparkBatchJobsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "spark.BatchClient", "GetSparkBatchJobs", resp, "Failure sending request")
		return
	}

	result, err = client.GetSparkBatchJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "spark.BatchClient", "GetSparkBatchJobs", resp, "Failure responding to request")
		return
	}

	return
}

// GetSparkBatchJobsPreparer prepares the GetSparkBatchJobs request.
func (client BatchClient) GetSparkBatchJobsPreparer(ctx context.Context, from *int32, size *int32, detailed *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint":       client.Endpoint,
		"livyApiVersion": client.LivyAPIVersion,
		"sparkPoolName":  client.SparkPoolName,
	}

	queryParameters := map[string]interface{}{}
	if from != nil {
		queryParameters["from"] = autorest.Encode("query", *from)
	}
	if size != nil {
		queryParameters["size"] = autorest.Encode("query", *size)
	}
	if detailed != nil {
		queryParameters["detailed"] = autorest.Encode("query", *detailed)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{endpoint}/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}", urlParameters),
		autorest.WithPath("/batches"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSparkBatchJobsSender sends the GetSparkBatchJobs request. The method will close the
// http.Response Body if it receives an error.
func (client BatchClient) GetSparkBatchJobsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSparkBatchJobsResponder handles the response to the GetSparkBatchJobs request. The method always
// closes the http.Response Body.
func (client BatchClient) GetSparkBatchJobsResponder(resp *http.Response) (result BatchJobCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
