// SPDX-License-Identifier: Unlicense OR BSD-3-Clause

package harfbuzz

// Code generated by typesettings-utils/generators/unicodedata/cmd/main.go DO NOT EDIT.
var indicTable = [...]uint16{

	/* Basic Latin */
	0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x40a, 0xe00, 0xe00,
	/* 0030 */ 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,

	/* Latin-1 Supplement */

	/* 00B0 */ 0xe00, 0xe00, 0xd08, 0xd08, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,
	/* 00C0 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,
	/* 00D0 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x40a,

	/* Devanagari */

	/* 0900 */ 0xd08, 0xd08, 0xd08, 0xd08, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402,
	/* 0910 */ 0x402, 0x402, 0x402, 0x402, 0x402, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0920 */ 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0930 */ 0x40f, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x907, 0x907, 0xe03, 0xd11, 0x907, 0x207,
	/* 0940 */ 0x907, 0x907, 0x907, 0x907, 0x907, 0x907, 0x907, 0x907, 0x907, 0x907, 0x907, 0x907, 0x907, 0x804, 0x207, 0x907,
	/* 0950 */ 0xe00, 0xd09, 0xd09, 0xd08, 0xd08, 0x907, 0x907, 0x907, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0960 */ 0x402, 0x402, 0x907, 0x907, 0xe00, 0xe00, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a,
	/* 0970 */ 0xe00, 0xe00, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,

	/* Bengali */

	/* 0980 */ 0x40a, 0xd08, 0xd08, 0xd08, 0xe00, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0xe00, 0xe00, 0x402,
	/* 0990 */ 0x402, 0xe00, 0xe00, 0x402, 0x402, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 09A0 */ 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0xe00, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 09B0 */ 0x40f, 0xe00, 0x401, 0xe00, 0xe00, 0xe00, 0x401, 0x401, 0x401, 0x401, 0xe00, 0xe00, 0xe03, 0xd11, 0xc07, 0x207,
	/* 09C0 */ 0xc07, 0x907, 0x907, 0x907, 0x907, 0xe00, 0xe00, 0x207, 0x207, 0xe00, 0xe00, 0xc07, 0xc07, 0x804, 0x401, 0xe00,
	/* 09D0 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xc07, 0xe00, 0xe00, 0xe00, 0xe00, 0x401, 0x401, 0xe00, 0x401,
	/* 09E0 */ 0x402, 0x402, 0x907, 0x907, 0xe00, 0xe00, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a,
	/* 09F0 */ 0x40f, 0x401, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x40a, 0xe00, 0xd08, 0xe00,

	/* Gurmukhi */

	/* 0A00 */ 0xe00, 0xd08, 0xd08, 0xd08, 0xe00, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0xe00, 0xe00, 0xe00, 0xe00, 0x402,
	/* 0A10 */ 0x402, 0xe00, 0xe00, 0x402, 0x402, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0A20 */ 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0xe00, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0A30 */ 0x40f, 0xe00, 0x401, 0x401, 0xe00, 0x401, 0x401, 0xe00, 0x401, 0x401, 0xe00, 0xe00, 0xe03, 0xe00, 0xc07, 0x207,
	/* 0A40 */ 0xc0d, 0xc07, 0xc07, 0xe00, 0xe00, 0xe00, 0xe00, 0xc07, 0xc07, 0xe00, 0xe00, 0xc07, 0xc07, 0x804, 0xe00, 0xe00,
	/* 0A50 */ 0xe00, 0x807, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x401, 0x401, 0x401, 0x401, 0xe00, 0x401, 0xe00,
	/* 0A60 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a,
	/* 0A70 */ 0xd08, 0xd08, 0x401, 0x401, 0xe00, 0x410, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,

	/* Gujarati */

	/* 0A80 */ 0xe00, 0xd08, 0xd08, 0xd08, 0xe00, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0xe00, 0x402,
	/* 0A90 */ 0x402, 0x402, 0xe00, 0x402, 0x402, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0AA0 */ 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0xe00, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0AB0 */ 0x40f, 0xe00, 0x401, 0x401, 0xe00, 0x401, 0x401, 0x401, 0x401, 0x401, 0xe00, 0xe00, 0xe03, 0xd11, 0xc07, 0x207,
	/* 0AC0 */ 0xc07, 0xc07, 0xc07, 0xc07, 0xc07, 0x907, 0xe00, 0x907, 0x907, 0xc07, 0xe00, 0xc07, 0xc07, 0x804, 0xe00, 0xe00,
	/* 0AD0 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,
	/* 0AE0 */ 0x402, 0x402, 0xc07, 0xc07, 0xe00, 0xe00, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a,
	/* 0AF0 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x401, 0xd09, 0xe03, 0xd09, 0xe03, 0xe03, 0xe03,

	/* Oriya */

	/* 0B00 */ 0xe00, 0x708, 0xd08, 0xd08, 0xe00, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0xe00, 0xe00, 0x402,
	/* 0B10 */ 0x402, 0xe00, 0xe00, 0x402, 0x402, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0B20 */ 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0xe00, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0B30 */ 0x40f, 0xe00, 0x401, 0x401, 0xe00, 0x401, 0x401, 0x401, 0x401, 0x401, 0xe00, 0xe00, 0xe03, 0xd11, 0xc07, 0x507,
	/* 0B40 */ 0xc07, 0x907, 0x907, 0x907, 0x907, 0xe00, 0xe00, 0x207, 0x507, 0xe00, 0xe00, 0xc07, 0xc07, 0x804, 0xe00, 0xe00,
	/* 0B50 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe03, 0x507, 0xc07, 0xe00, 0xe00, 0xe00, 0xe00, 0x401, 0x401, 0xe00, 0x401,
	/* 0B60 */ 0x402, 0x402, 0x907, 0x907, 0xe00, 0xe00, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a,
	/* 0B70 */ 0xe00, 0x401, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,

	/* Tamil */

	/* 0B80 */ 0xe00, 0xe00, 0xd08, 0xe00, 0xe00, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0xe00, 0xe00, 0xe00, 0x402, 0x402,
	/* 0B90 */ 0x402, 0xe00, 0x402, 0x402, 0x402, 0x401, 0xe00, 0xe00, 0xe00, 0x401, 0x401, 0xe00, 0x401, 0xe00, 0x401, 0x401,
	/* 0BA0 */ 0xe00, 0xe00, 0xe00, 0x401, 0x401, 0xe00, 0xe00, 0xe00, 0x401, 0x401, 0x401, 0xe00, 0xe00, 0xe00, 0x401, 0x401,
	/* 0BB0 */ 0x40f, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0xe00, 0xe00, 0xe00, 0xe00, 0xc07, 0xc07,
	/* 0BC0 */ 0x907, 0xc07, 0xc07, 0xe00, 0xe00, 0xe00, 0x207, 0x207, 0x207, 0xe00, 0xc07, 0xc07, 0xc07, 0x604, 0xe00, 0xe00,
	/* 0BD0 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xc07, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,
	/* 0BE0 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a,
	/* 0BF0 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,

	/* Telugu */

	/* 0C00 */ 0xd08, 0xd08, 0xd08, 0xd08, 0xd08, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0xe00, 0x402, 0x402,
	/* 0C10 */ 0x402, 0xe00, 0x402, 0x402, 0x402, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0C20 */ 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0xe00, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0C30 */ 0x40f, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0xe00, 0xe00, 0xe03, 0xd11, 0x707, 0x707,
	/* 0C40 */ 0x707, 0x707, 0x707, 0x907, 0x907, 0xe00, 0x707, 0x707, 0x707, 0xe00, 0x707, 0x707, 0x707, 0x604, 0xe00, 0xe00,
	/* 0C50 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x707, 0x707, 0xe00, 0x401, 0x401, 0x401, 0xe00, 0xe00, 0x401, 0xe00, 0xe00,
	/* 0C60 */ 0x402, 0x402, 0x707, 0x707, 0xe00, 0xe00, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a,
	/* 0C70 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,

	/* Kannada */

	/* 0C80 */ 0x40a, 0xd08, 0xd08, 0xd08, 0xe00, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0xe00, 0x402, 0x402,
	/* 0C90 */ 0x402, 0xe00, 0x402, 0x402, 0x402, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0CA0 */ 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0xe00, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0CB0 */ 0x40f, 0x401, 0x401, 0x401, 0xe00, 0x401, 0x401, 0x401, 0x401, 0x401, 0xe00, 0xe00, 0xe03, 0xd11, 0x707, 0x707,
	/* 0CC0 */ 0x707, 0x707, 0x707, 0x907, 0x907, 0xe00, 0x707, 0x907, 0x907, 0xe00, 0x907, 0x907, 0x707, 0x604, 0xe00, 0xe00,
	/* 0CD0 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x907, 0x907, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x401, 0x401, 0xe00,
	/* 0CE0 */ 0x402, 0x402, 0x707, 0x707, 0xe00, 0xe00, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a,
	/* 0CF0 */ 0xe00, 0x412, 0x412, 0xd08, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,

	/* Malayalam */

	/* 0D00 */ 0xd08, 0xd08, 0xd08, 0xd08, 0x40a, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0xe00, 0x402, 0x402,
	/* 0D10 */ 0x402, 0xe00, 0x402, 0x402, 0x402, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0D20 */ 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 0D30 */ 0x40f, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x907, 0x907, 0xd11, 0xc07, 0xc07,
	/* 0D40 */ 0xc07, 0xc07, 0xc07, 0xc07, 0xc07, 0xe00, 0x207, 0x207, 0x207, 0xe00, 0xc07, 0xc07, 0xc07, 0x604, 0xe0e, 0xe00,
	/* 0D50 */ 0xe00, 0xe00, 0xe00, 0xe00, 0x401, 0x401, 0x401, 0xc07, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x402,
	/* 0D60 */ 0x402, 0x402, 0xc07, 0xc07, 0xe00, 0xe00, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a,
	/* 0D70 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,

	/* Myanmar */

	/* 1000 */ 0x401, 0x401, 0x401, 0x401, 0x40f, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 1010 */ 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x40f, 0x401, 0x401, 0x401, 0x401,
	/* 1020 */ 0x401, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0xb17, 0xb17, 0x614, 0x614, 0x815,
	/* 1030 */ 0x815, 0x316, 0xd09, 0x614, 0x614, 0x614, 0xd09, 0xe03, 0xd08, 0xe04, 0xe20, 0xe26, 0xe24, 0xe25, 0xe23, 0x401,
	/* 1040 */ 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0xe00, 0xe00, 0x401, 0xe00,
	/* 1050 */ 0x401, 0x401, 0x402, 0x402, 0x402, 0x402, 0xb17, 0xb17, 0x815, 0x815, 0x40f, 0x401, 0x401, 0x401, 0xe26, 0xe26,
	/* 1060 */ 0xe29, 0x401, 0xb17, 0xe27, 0xe27, 0x401, 0x401, 0xb17, 0xb17, 0xe27, 0xe27, 0xe27, 0xe27, 0xe27, 0x401, 0x401,
	/* 1070 */ 0x401, 0x614, 0x614, 0x614, 0x614, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 1080 */ 0x401, 0x401, 0xe25, 0xb17, 0x316, 0x614, 0x614, 0xd08, 0xd08, 0xd08, 0xd08, 0xd08, 0xd08, 0xd08, 0x401, 0xd08,
	/* 1090 */ 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0xd08, 0xd08, 0xd08, 0x614, 0xe00, 0xe00,

	/* Khmer */

	/* 1780 */ 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 1790 */ 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x40f, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* 17A0 */ 0x401, 0x401, 0x401, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402, 0x402,
	/* 17B0 */ 0x402, 0x402, 0x402, 0x402, 0xe00, 0xe00, 0xb17, 0x614, 0x614, 0x614, 0x614, 0x815, 0x815, 0x815, 0x614, 0xb17,
	/* 17C0 */ 0xb17, 0x316, 0x316, 0x316, 0xb17, 0xb17, 0xe1a, 0xe1b, 0xe1b, 0xe19, 0xe19, 0xe1a, 0xe19, 0xe1a, 0xe1a, 0xe1a,
	/* 17D0 */ 0xe1a, 0xe1a, 0xe04, 0xe1b, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x40a, 0xe00, 0xe00, 0xd11, 0xe1b, 0xe00, 0xe00,
	/* 17E0 */ 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,

	/* Vedic Extensions */

	/* 1CD0 */ 0xd09, 0xd09, 0xd09, 0xe00, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09,
	/* 1CE0 */ 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd11, 0xd11, 0xd11, 0xd11, 0xd09, 0xd11, 0xd11,
	/* 1CF0 */ 0xd11, 0xd11, 0x401, 0x401, 0xd09, 0x401, 0x401, 0xd09, 0xd09, 0xd09, 0x40a, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,

	/* General Punctuation */
	0xe00, 0xe00, 0xe00, 0xe00, 0xe05, 0xe06, 0xe00, 0xe00,
	/* 2010 */ 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,
	/* 2020 */ 0xe00, 0xe00, 0x40a, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,

	/* Superscripts and Subscripts */

	/* 2070 */ 0xe00, 0xe00, 0xe00, 0xe00, 0xd08, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00,
	/* 2080 */ 0xe00, 0xe00, 0xd08, 0xd08, 0xd08, 0xe00, 0xe00, 0xe00,

	/* Geometric Shapes */
	0xe00, 0xe00, 0xe00, 0x40a, 0x40a, 0x40a, 0x40a, 0xe00,

	/* Devanagari Extended */

	/* A8E0 */ 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09, 0xd09,
	/* A8F0 */ 0xd09, 0xd09, 0xd11, 0xd11, 0xd11, 0xd11, 0xd11, 0xd11, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0xe00, 0x402, 0x907,

	/* Myanmar Extended-B */

	/* A9E0 */ 0x401, 0x401, 0x401, 0x401, 0x401, 0x614, 0xe00, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* A9F0 */ 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x40a, 0x401, 0x401, 0x401, 0x401, 0x401, 0xe00,

	/* Myanmar Extended-A */

	/* AA60 */ 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401, 0x401,
	/* AA70 */ 0xe00, 0x401, 0x401, 0x401, 0x40a, 0x40a, 0x40a, 0xe00, 0xe00, 0xe00, 0x401, 0xe27, 0xe03, 0xe03, 0x401, 0x401,

	/* Variation Selectors */

	/* FE00 */ 0xe28, 0xe28, 0xe28, 0xe28, 0xe28, 0xe28, 0xe28, 0xe28, 0xe28, 0xe28, 0xe28, 0xe28, 0xe28, 0xe28, 0xe28, 0xe28,

	/* Grantha */

	/* 11300 */ 0xe00, 0xd08, 0xd08, 0xd08, 0xe00, 0xe00, 0xe00, 0xe00,

	0xe00, 0xe00, 0xe00, 0xe03, 0xe03, 0xe00, 0xe00, 0xe00,
} /* Table items: 1728; occupancy: 71% */

const (
	offsetIndic0x0028u  = 0
	offsetIndic0x00b0u  = 24
	offsetIndic0x0900u  = 64
	offsetIndic0x1000u  = 1216
	offsetIndic0x1780u  = 1376
	offsetIndic0x1cd0u  = 1488
	offsetIndic0x2008u  = 1536
	offsetIndic0x2070u  = 1568
	offsetIndic0x25f8u  = 1592
	offsetIndic0xa8e0u  = 1600
	offsetIndic0xa9e0u  = 1632
	offsetIndic0xaa60u  = 1664
	offsetIndic0xfe00u  = 1696
	offsetIndic0x11300u = 1712
	offsetIndic0x11338u = 1720
)

func indicGetCategories(u rune) uint16 {
	switch u >> 12 {
	case 0x0:
		if u == 0x00A0 {
			return 0x40a
		}
		if 0x0028 <= u && u <= 0x003F {
			return indicTable[u-0x0028+offsetIndic0x0028u]
		}
		if 0x00B0 <= u && u <= 0x00D7 {
			return indicTable[u-0x00B0+offsetIndic0x00b0u]
		}
		if 0x0900 <= u && u <= 0x0D7F {
			return indicTable[u-0x0900+offsetIndic0x0900u]
		}

	case 0x1:
		if 0x1000 <= u && u <= 0x109F {
			return indicTable[u-0x1000+offsetIndic0x1000u]
		}
		if 0x1780 <= u && u <= 0x17EF {
			return indicTable[u-0x1780+offsetIndic0x1780u]
		}
		if 0x1CD0 <= u && u <= 0x1CFF {
			return indicTable[u-0x1CD0+offsetIndic0x1cd0u]
		}

	case 0x2:
		if u == 0x25CC {
			return 0x40b
		}
		if 0x2008 <= u && u <= 0x2027 {
			return indicTable[u-0x2008+offsetIndic0x2008u]
		}
		if 0x2070 <= u && u <= 0x2087 {
			return indicTable[u-0x2070+offsetIndic0x2070u]
		}
		if 0x25F8 <= u && u <= 0x25FF {
			return indicTable[u-0x25F8+offsetIndic0x25f8u]
		}

	case 0xA:
		if 0xA8E0 <= u && u <= 0xA8FF {
			return indicTable[u-0xA8E0+offsetIndic0xa8e0u]
		}
		if 0xA9E0 <= u && u <= 0xA9FF {
			return indicTable[u-0xA9E0+offsetIndic0xa9e0u]
		}
		if 0xAA60 <= u && u <= 0xAA7F {
			return indicTable[u-0xAA60+offsetIndic0xaa60u]
		}

	case 0xF:
		if 0xFE00 <= u && u <= 0xFE0F {
			return indicTable[u-0xFE00+offsetIndic0xfe00u]
		}

	case 0x11:
		if 0x11300 <= u && u <= 0x11307 {
			return indicTable[u-0x11300+offsetIndic0x11300u]
		}
		if 0x11338 <= u && u <= 0x1133F {
			return indicTable[u-0x11338+offsetIndic0x11338u]
		}

	}
	return 0xe00
}
