package harfbuzz

import (
	"strings"

	"github.com/go-text/typesetting/language"
	"github.com/go-text/typesetting/opentype/loader"
)

// Code generated by typesetting-utils/generators/langs/gen.go. DO NOT EDIT.

var otLanguages = [...]langTag{
	{"aa", 0x41465220},  /* Afar */
	{"aae", 0x53514920}, /* Arbëreshë Albanian -> Albanian */
	{"aao", 0x41524120}, /* Algerian Saharan Arabic -> Arabic */
	{"aat", 0x53514920}, /* Arvanitika Albanian -> Albanian */
	{"ab", 0x41424b20},  /* Abkhazian */
	{"aba", 0},          /* Abé != Abaza */
	{"abh", 0x41524120}, /* Tajiki Arabic -> Arabic */
	{"abq", 0x41424120}, /* Abaza */
	{"abs", 0x43505020}, /* Ambonese Malay -> Creoles */
	{"abv", 0x41524120}, /* Baharna Arabic -> Arabic */
	{"acf", 0x46414e20}, /* Saint Lucian Creole French -> French Antillean */
	{"acf", 0x43505020}, /* Saint Lucian Creole French -> Creoles */
	/*{"ach",	0x41434820},*/ /* Acoli -> Acholi */
	{"acm", 0x41524120},     /* Mesopotamian Arabic -> Arabic */
	{"acq", 0x41524120},     /* Ta'izzi-Adeni Arabic -> Arabic */
	{"acr", 0x41435220},     /* Achi */
	{"acr", 0x4d594e20},     /* Achi -> Mayan */
	{"acw", 0x41524120},     /* Hijazi Arabic -> Arabic */
	{"acx", 0x41524120},     /* Omani Arabic -> Arabic */
	{"acy", 0x41524120},     /* Cypriot Arabic -> Arabic */
	{"ada", 0x444e4720},     /* Adangme -> Dangme */
	{"adf", 0x41524120},     /* Dhofari Arabic -> Arabic */
	{"adp", 0x445a4e20},     /* Adap (retired code) (retired code) -> Dzongkha */
	/*{"ady",	0x41445920},*/ /* Adyghe */
	{"aeb", 0x41524120},     /* Tunisian Arabic -> Arabic */
	{"aec", 0x41524120},     /* Saidi Arabic -> Arabic */
	{"af", 0x41464b20},      /* Afrikaans */
	{"afb", 0x41524120},     /* Gulf Arabic -> Arabic */
	{"afk", 0},              /* Nanubae != Afrikaans */
	{"afs", 0x43505020},     /* Afro-Seminole Creole -> Creoles */
	{"agu", 0x4d594e20},     /* Aguacateco -> Mayan */
	{"agw", 0},              /* Kahua != Agaw */
	{"ahg", 0x41475720},     /* Qimant -> Agaw */
	{"aht", 0x41544820},     /* Ahtena -> Athapaskan */
	{"aig", 0x43505020},     /* Antigua and Barbuda Creole English -> Creoles */
	{"aii", 0x53574120},     /* Assyrian Neo-Aramaic -> Swadaya Aramaic */
	{"aii", 0x53595220},     /* Assyrian Neo-Aramaic -> Syriac */
	/*{"aio",	0x41494f20},*/ /* Aiton */
	{"aiw", 0x41524920},     /* Aari */
	{"ajp", 0x41524120},     /* South Levantine Arabic (retired code) (retired code) -> Arabic */
	{"ajt", 0x41524120},     /* Judeo-Tunisian Arabic (retired code) (retired code) -> Arabic */
	{"ak", 0x414b4120},      /* Akan [macrolanguage] */
	{"akb", 0x414b4220},     /* Batak Angkola */
	{"akb", 0x42544b20},     /* Batak Angkola -> Batak */
	{"aln", 0x53514920},     /* Gheg Albanian -> Albanian */
	{"als", 0x53514920},     /* Tosk Albanian -> Albanian */
	/*{"alt",	0x414c5420},*/ /* Southern Altai -> Altai */
	{"am", 0x414d4820},      /* Amharic */
	{"amf", 0x48424e20},     /* Hamer-Banna -> Hammer-Banna */
	{"amw", 0x53595220},     /* Western Neo-Aramaic -> Syriac */
	{"an", 0x41524720},      /* Aragonese */
	/*{"ang",	0x414e4720},*/ /* Old English (ca. 450-1100) -> Anglo-Saxon */
	{"aoa", 0x43505020},     /* Angolar -> Creoles */
	{"apa", 0x41544820},     /* Apache [collection] -> Athapaskan */
	{"apc", 0x41524120},     /* Levantine Arabic -> Arabic */
	{"apd", 0x41524120},     /* Sudanese Arabic -> Arabic */
	{"apj", 0x41544820},     /* Jicarilla Apache -> Athapaskan */
	{"apk", 0x41544820},     /* Kiowa Apache -> Athapaskan */
	{"apl", 0x41544820},     /* Lipan Apache -> Athapaskan */
	{"apm", 0x41544820},     /* Mescalero-Chiricahua Apache -> Athapaskan */
	{"apw", 0x41544820},     /* Western Apache -> Athapaskan */
	{"ar", 0x41524120},      /* Arabic [macrolanguage] */
	{"arb", 0x41524120},     /* Standard Arabic -> Arabic */
	{"ari", 0},              /* Arikara != Aari */
	{"ark", 0},              /* Arikapú != Rakhine */
	{"arn", 0x4d415020},     /* Mapudungun */
	{"arq", 0x41524120},     /* Algerian Arabic -> Arabic */
	{"ars", 0x41524120},     /* Najdi Arabic -> Arabic */
	{"ary", 0x4d4f5220},     /* Moroccan Arabic ->  */
	{"ary", 0x41524120},     /* Moroccan Arabic -> Arabic */
	{"arz", 0x41524120},     /* Egyptian Arabic -> Arabic */
	{"as", 0x41534d20},      /* Assamese */
	/*{"ast",	0x41535420},*/ /* Asturian */
	/*{"ath",	0x41544820},*/ /* Athapascan [collection] -> Athapaskan */
	{"atj", 0x52435220},     /* Atikamekw -> R-Cree */
	{"atv", 0x414c5420},     /* Northern Altai -> Altai */
	{"auj", 0x42425220},     /* Awjilah -> Berber */
	{"auz", 0x41524120},     /* Uzbeki Arabic -> Arabic */
	{"av", 0x41565220},      /* Avaric -> Avar */
	{"avl", 0x41524120},     /* Eastern Egyptian Bedawi Arabic -> Arabic */
	/*{"avn",	0x41564e20},*/ /* Avatime */
	/*{"awa",	0x41574120},*/ /* Awadhi */
	{"ay", 0x41594d20},      /* Aymara [macrolanguage] */
	{"ayc", 0x41594d20},     /* Southern Aymara -> Aymara */
	{"ayh", 0x41524120},     /* Hadrami Arabic -> Arabic */
	{"ayl", 0x41524120},     /* Libyan Arabic -> Arabic */
	{"ayn", 0x41524120},     /* Sanaani Arabic -> Arabic */
	{"ayp", 0x41524120},     /* North Mesopotamian Arabic -> Arabic */
	{"ayr", 0x41594d20},     /* Central Aymara -> Aymara */
	{"az", 0x415a4520},      /* Azerbaijani [macrolanguage] */
	{"azb", 0x415a4220},     /* South Azerbaijani -> Torki */
	{"azb", 0x415a4520},     /* South Azerbaijani -> Azerbaijani */
	{"azd", 0x4e414820},     /* Eastern Durango Nahuatl -> Nahuatl */
	{"azj", 0x415a4520},     /* North Azerbaijani -> Azerbaijani */
	{"azn", 0x4e414820},     /* Western Durango Nahuatl -> Nahuatl */
	{"azz", 0x4e414820},     /* Highland Puebla Nahuatl -> Nahuatl */
	{"ba", 0x42534820},      /* Bashkir */
	{"bad", 0x42414430},     /* Banda [collection] */
	{"bag", 0},              /* Tuki != Baghelkhandi */
	{"bah", 0x43505020},     /* Bahamas Creole English -> Creoles */
	{"bai", 0x424d4c20},     /* Bamileke [collection] */
	{"bal", 0x424c4920},     /* Baluchi [macrolanguage] */
	/*{"ban",	0x42414e20},*/ /* Balinese */
	/*{"bar",	0x42415220},*/ /* Bavarian */
	{"bau", 0},              /* Bada (Nigeria) != Baulé */
	{"bbc", 0x42424320},     /* Batak Toba */
	{"bbc", 0x42544b20},     /* Batak Toba -> Batak */
	{"bbj", 0x424d4c20},     /* Ghomálá' -> Bamileke */
	{"bbp", 0x42414430},     /* West Central Banda -> Banda */
	{"bbr", 0},              /* Girawa != Berber */
	{"bbz", 0x41524120},     /* Babalia Creole Arabic (retired code) (retired code) -> Arabic */
	{"bcc", 0x424c4920},     /* Southern Balochi -> Baluchi */
	{"bch", 0},              /* Bariai != Bench */
	{"bci", 0x42415520},     /* Baoulé -> Baulé */
	{"bcl", 0x42494b20},     /* Central Bikol -> Bikol */
	{"bcq", 0x42434820},     /* Bench */
	{"bcr", 0x41544820},     /* Babine -> Athapaskan */
	/*{"bdy",	0x42445920},*/ /* Bandjalang */
	{"be", 0x42454c20},      /* Belarusian -> Belarussian */
	{"bea", 0x41544820},     /* Beaver -> Athapaskan */
	{"beb", 0x42544920},     /* Bebele -> Beti */
	/*{"bem",	0x42454d20},*/ /* Bemba (Zambia) */
	{"ber", 0x42425220},     /* Berber [collection] */
	{"bew", 0x43505020},     /* Betawi -> Creoles */
	{"bfl", 0x42414430},     /* Banda-Ndélé -> Banda */
	{"bfq", 0x42414420},     /* Badaga */
	{"bft", 0x424c5420},     /* Balti */
	{"bfu", 0x4c414820},     /* Gahri -> Lahuli */
	{"bfy", 0x42414720},     /* Bagheli -> Baghelkhandi */
	{"bg", 0x42475220},      /* Bulgarian */
	/*{"bgc",	0x42474320},*/ /* Haryanvi */
	{"bgn", 0x424c4920},     /* Western Balochi -> Baluchi */
	{"bgp", 0x424c4920},     /* Eastern Balochi -> Baluchi */
	{"bgq", 0x42475120},     /* Bagri */
	{"bgq", 0x52414a20},     /* Bagri -> Rajasthani */
	{"bgr", 0x51494e20},     /* Bawm Chin -> Chin */
	{"bhb", 0x42484920},     /* Bhili */
	/*{"bhi",	0x42484920},*/ /* Bhilali -> Bhili */
	{"bhk", 0x42494b20},     /* Albay Bicolano (retired code) (retired code) -> Bikol */
	/*{"bho",	0x42484f20},*/ /* Bhojpuri */
	{"bhr", 0x4d4c4720},     /* Bara Malagasy -> Malagasy */
	{"bi", 0x42495320},      /* Bislama */
	{"bi", 0x43505020},      /* Bislama -> Creoles */
	/*{"bik",	0x42494b20},*/ /* Bikol [macrolanguage] */
	{"bil", 0},              /* Bile != Bilen */
	{"bin", 0x45444f20},     /* Edo */
	{"biu", 0x51494e20},     /* Biete -> Chin */
	/*{"bjj",	0x424a4a20},*/ /* Kanauji */
	{"bjn", 0x4d4c5920},     /* Banjar -> Malay */
	{"bjo", 0x42414430},     /* Mid-Southern Banda -> Banda */
	{"bjq", 0x4d4c4720},     /* Southern Betsimisaraka Malagasy (retired code) (retired code) -> Malagasy */
	{"bjs", 0x43505020},     /* Bajan -> Creoles */
	{"bjt", 0x424c4e20},     /* Balanta-Ganja -> Balante */
	{"bkf", 0},              /* Beeke != Blackfoot */
	{"bko", 0x424d4c20},     /* Kwa' -> Bamileke */
	{"bla", 0x424b4620},     /* Siksika -> Blackfoot */
	{"ble", 0x424c4e20},     /* Balanta-Kentohe -> Balante */
	{"blg", 0x49424120},     /* Balau (retired code) (retired code) -> Iban */
	{"bli", 0},              /* Bolia != Baluchi */
	{"blk", 0x424c4b20},     /* Pa’o Karen */
	{"blk", 0x4b524e20},     /* Pa'o Karen -> Karen */
	{"bln", 0x42494b20},     /* Southern Catanduanes Bikol -> Bikol */
	{"blt", 0},              /* Tai Dam != Balti */
	{"bm", 0x424d4220},      /* Bambara (Bamanankan) */
	{"bmb", 0},              /* Bembe != Bambara (Bamanankan) */
	{"bml", 0},              /* Bomboli != Bamileke */
	{"bmm", 0x4d4c4720},     /* Northern Betsimisaraka Malagasy -> Malagasy */
	{"bn", 0x42454e20},      /* Bengali */
	{"bo", 0x54494220},      /* Tibetan */
	{"bpd", 0x42414430},     /* Banda-Banda -> Banda */
	{"bpl", 0x43505020},     /* Broome Pearling Lugger Pidgin -> Creoles */
	{"bpq", 0x43505020},     /* Banda Malay -> Creoles */
	/*{"bpy",	0x42505920},*/ /* Bishnupriya -> Bishnupriya Manipuri */
	{"bqi", 0x4c524320},     /* Bakhtiari -> Luri */
	{"bqk", 0x42414430},     /* Banda-Mbrès -> Banda */
	{"br", 0x42524520},      /* Breton */
	{"bra", 0x42524920},     /* Braj -> Braj Bhasha */
	{"brc", 0x43505020},     /* Berbice Creole Dutch -> Creoles */
	/*{"brh",	0x42524820},*/ /* Brahui */
	{"bri", 0},              /* Mokpwe != Braj Bhasha */
	{"brm", 0},              /* Barambu != Burmese */
	/*{"brx",	0x42525820},*/ /* Bodo (India) */
	{"bs", 0x424f5320},      /* Bosnian */
	{"bsh", 0},              /* Kati != Bashkir */
	/*{"bsk",	0x42534b20},*/ /* Burushaski */
	{"btb", 0x42544920},     /* Beti (Cameroon) (retired code) (retired code) */
	{"btd", 0x42544420},     /* Batak Dairi (Pakpak) */
	{"btd", 0x42544b20},     /* Batak Dairi -> Batak */
	{"bti", 0},              /* Burate != Beti */
	{"btj", 0x4d4c5920},     /* Bacanese Malay -> Malay */
	/*{"btk",	0x42544b20},*/ /* Batak [collection] */
	{"btm", 0x42544d20},     /* Batak Mandailing */
	{"btm", 0x42544b20},     /* Batak Mandailing -> Batak */
	{"bto", 0x42494b20},     /* Rinconada Bikol -> Bikol */
	{"bts", 0x42545320},     /* Batak Simalungun */
	{"bts", 0x42544b20},     /* Batak Simalungun -> Batak */
	{"btx", 0x42545820},     /* Batak Karo */
	{"btx", 0x42544b20},     /* Batak Karo -> Batak */
	{"btz", 0x42545a20},     /* Batak Alas-Kluet */
	{"btz", 0x42544b20},     /* Batak Alas-Kluet -> Batak */
	/*{"bug",	0x42554720},*/ /* Buginese -> Bugis */
	{"bum", 0x42544920},     /* Bulu (Cameroon) -> Beti */
	{"bve", 0x4d4c5920},     /* Berau Malay -> Malay */
	{"bvu", 0x4d4c5920},     /* Bukit Malay -> Malay */
	{"bwe", 0x4b524e20},     /* Bwe Karen -> Karen */
	{"bxk", 0x4c554820},     /* Bukusu -> Luyia */
	{"bxo", 0x43505020},     /* Barikanchi -> Creoles */
	{"bxp", 0x42544920},     /* Bebil -> Beti */
	{"bxr", 0x52425520},     /* Russia Buriat -> Russian Buriat */
	{"byn", 0x42494c20},     /* Bilin -> Bilen */
	{"byv", 0x42595620},     /* Medumba */
	{"byv", 0x424d4c20},     /* Medumba -> Bamileke */
	{"bzc", 0x4d4c4720},     /* Southern Betsimisaraka Malagasy -> Malagasy */
	{"bzj", 0x43505020},     /* Belize Kriol English -> Creoles */
	{"bzk", 0x43505020},     /* Nicaragua Creole English -> Creoles */
	{"ca", 0x43415420},      /* Catalan */
	{"caa", 0x4d594e20},     /* Chortí -> Mayan */
	{"cac", 0x4d594e20},     /* Chuj -> Mayan */
	{"caf", 0x43525220},     /* Southern Carrier -> Carrier */
	{"caf", 0x41544820},     /* Southern Carrier -> Athapaskan */
	{"cak", 0x43414b20},     /* Kaqchikel */
	{"cak", 0x4d594e20},     /* Kaqchikel -> Mayan */
	{"cbk", 0x43424b20},     /* Chavacano -> Zamboanga Chavacano */
	{"cbk", 0x43505020},     /* Chavacano -> Creoles */
	{"cbl", 0x51494e20},     /* Bualkhaw Chin -> Chin */
	{"ccl", 0x43505020},     /* Cutchi-Swahili -> Creoles */
	{"ccm", 0x43505020},     /* Malaccan Creole Malay -> Creoles */
	{"cco", 0x4343484e},     /* Comaltepec Chinantec -> Chinantec */
	{"ccq", 0x41524b20},     /* Chaungtha (retired code) (retired code) -> Rakhine */
	{"cdo", 0x5a485320},     /* Min Dong Chinese -> Chinese, Simplified */
	{"ce", 0x43484520},      /* Chechen */
	/*{"ceb",	0x43454220},*/ /* Cebuano */
	{"cek", 0x51494e20},     /* Eastern Khumi Chin -> Chin */
	{"cey", 0x51494e20},     /* Ekai Chin -> Chin */
	{"cfm", 0x48414c20},     /* Halam (Falam Chin) */
	{"cfm", 0x51494e20},     /* Falam Chin -> Chin */
	/*{"cgg",	0x43474720},*/ /* Chiga */
	{"ch", 0x43484120},      /* Chamorro */
	{"chf", 0x4d594e20},     /* Tabasco Chontal -> Mayan */
	{"chg", 0},              /* Chagatai != Chaha Gurage */
	{"chh", 0},              /* Chinook != Chattisgarhi */
	{"chj", 0x4343484e},     /* Ojitlán Chinantec -> Chinantec */
	{"chk", 0x43484b30},     /* Chuukese */
	{"chm", 0x484d4120},     /* Mari (Russia) [macrolanguage] -> High Mari */
	{"chm", 0x4c4d4120},     /* Mari (Russia) [macrolanguage] -> Low Mari */
	{"chn", 0x43505020},     /* Chinook jargon -> Creoles */
	/*{"cho",	0x43484f20},*/ /* Choctaw */
	{"chp", 0x43485020},     /* Chipewyan */
	{"chp", 0x53415920},     /* Chipewyan -> Sayisi */
	{"chp", 0x41544820},     /* Chipewyan -> Athapaskan */
	{"chq", 0x4343484e},     /* Quiotepec Chinantec -> Chinantec */
	/*{"chr",	0x43485220},*/ /* Cherokee */
	/*{"chy",	0x43485920},*/ /* Cheyenne */
	{"chz", 0x4343484e},     /* Ozumacín Chinantec -> Chinantec */
	{"ciw", 0x4f4a4220},     /* Chippewa -> Ojibway */
	/*{"cja",	0x434a4120},*/ /* Western Cham */
	/*{"cjm",	0x434a4d20},*/ /* Eastern Cham */
	{"cjy", 0x5a485320},     /* Jinyu Chinese -> Chinese, Simplified */
	{"cka", 0x51494e20},     /* Khumi Awa Chin (retired code) (retired code) -> Chin */
	{"ckb", 0x4b555220},     /* Central Kurdish -> Kurdish */
	{"ckn", 0x51494e20},     /* Kaang Chin -> Chin */
	{"cks", 0x43505020},     /* Tayo -> Creoles */
	{"ckt", 0x43484b20},     /* Chukot -> Chukchi */
	{"ckz", 0x4d594e20},     /* Cakchiquel-Quiché Mixed Language -> Mayan */
	{"clc", 0x41544820},     /* Chilcotin -> Athapaskan */
	{"cld", 0x53595220},     /* Chaldean Neo-Aramaic -> Syriac */
	{"cle", 0x4343484e},     /* Lealao Chinantec -> Chinantec */
	{"clj", 0x51494e20},     /* Laitu Chin -> Chin */
	{"clt", 0x51494e20},     /* Lautu Chin -> Chin */
	{"cmn", 0x5a485320},     /* Mandarin Chinese -> Chinese, Simplified */
	{"cmr", 0x51494e20},     /* Mro-Khimi Chin -> Chin */
	{"cnb", 0x51494e20},     /* Chinbon Chin -> Chin */
	{"cnh", 0x51494e20},     /* Hakha Chin -> Chin */
	{"cnk", 0x51494e20},     /* Khumi Chin -> Chin */
	{"cnl", 0x4343484e},     /* Lalana Chinantec -> Chinantec */
	{"cnp", 0x5a485320},     /* Northern Ping Chinese -> Chinese, Simplified */
	{"cnr", 0x53524220},     /* Montenegrin -> Serbian */
	{"cnt", 0x4343484e},     /* Tepetotutla Chinantec -> Chinantec */
	{"cnu", 0x42425220},     /* Chenoua -> Berber */
	{"cnw", 0x51494e20},     /* Ngawn Chin -> Chin */
	{"co", 0x434f5320},      /* Corsican */
	{"coa", 0x4d4c5920},     /* Cocos Islands Malay -> Malay */
	{"cob", 0x4d594e20},     /* Chicomuceltec -> Mayan */
	/*{"cop",	0x434f5020},*/ /* Coptic */
	{"coq", 0x41544820},     /* Coquille -> Athapaskan */
	{"cpa", 0x4343484e},     /* Palantla Chinantec -> Chinantec */
	{"cpe", 0x43505020},     /* English-based creoles and pidgins [collection] -> Creoles */
	{"cpf", 0x43505020},     /* French-based creoles and pidgins [collection] -> Creoles */
	{"cpi", 0x43505020},     /* Chinese Pidgin English -> Creoles */
	/*{"cpp",	0x43505020},*/ /* Portuguese-based creoles and pidgins [collection] -> Creoles */
	{"cpx", 0x5a485320},     /* Pu-Xian Chinese -> Chinese, Simplified */
	{"cqd", 0x484d4e20},     /* Chuanqiandian Cluster Miao -> Hmong */
	{"cqu", 0x51554820},     /* Chilean Quechua (retired code) (retired code) -> Quechua (Bolivia) */
	{"cqu", 0x51555a20},     /* Chilean Quechua (retired code) (retired code) -> Quechua */
	{"cr", 0x43524520},      /* Cree [macrolanguage] */
	{"crh", 0x43525420},     /* Crimean Tatar */
	{"cri", 0x43505020},     /* Sãotomense -> Creoles */
	{"crj", 0x45435220},     /* Southern East Cree -> Eastern Cree */
	{"crj", 0x59435220},     /* Southern East Cree -> Y-Cree */
	{"crj", 0x43524520},     /* Southern East Cree -> Cree */
	{"crk", 0x57435220},     /* Plains Cree -> West-Cree */
	{"crk", 0x59435220},     /* Plains Cree -> Y-Cree */
	{"crk", 0x43524520},     /* Plains Cree -> Cree */
	{"crl", 0x45435220},     /* Northern East Cree -> Eastern Cree */
	{"crl", 0x59435220},     /* Northern East Cree -> Y-Cree */
	{"crl", 0x43524520},     /* Northern East Cree -> Cree */
	{"crm", 0x4d435220},     /* Moose Cree */
	{"crm", 0x4c435220},     /* Moose Cree -> L-Cree */
	{"crm", 0x43524520},     /* Moose Cree -> Cree */
	{"crp", 0x43505020},     /* Creoles and pidgins [collection] -> Creoles */
	{"crr", 0},              /* Carolina Algonquian != Carrier */
	{"crs", 0x43505020},     /* Seselwa Creole French -> Creoles */
	{"crt", 0},              /* Iyojwa'ja Chorote != Crimean Tatar */
	{"crx", 0x43525220},     /* Carrier */
	{"crx", 0x41544820},     /* Carrier -> Athapaskan */
	{"cs", 0x43535920},      /* Czech */
	{"csa", 0x4343484e},     /* Chiltepec Chinantec -> Chinantec */
	/*{"csb",	0x43534220},*/ /* Kashubian */
	{"csh", 0x51494e20},     /* Asho Chin -> Chin */
	{"csj", 0x51494e20},     /* Songlai Chin -> Chin */
	{"csl", 0},              /* Chinese Sign Language != Church Slavonic */
	{"cso", 0x4343484e},     /* Sochiapam Chinantec -> Chinantec */
	{"csp", 0x5a485320},     /* Southern Ping Chinese -> Chinese, Simplified */
	{"csv", 0x51494e20},     /* Sumtu Chin -> Chin */
	{"csw", 0x4e435220},     /* Swampy Cree -> N-Cree */
	{"csw", 0x4e484320},     /* Swampy Cree -> Norway House Cree */
	{"csw", 0x43524520},     /* Swampy Cree -> Cree */
	{"csy", 0x51494e20},     /* Siyin Chin -> Chin */
	{"ctc", 0x41544820},     /* Chetco -> Athapaskan */
	{"ctd", 0x51494e20},     /* Tedim Chin -> Chin */
	{"cte", 0x4343484e},     /* Tepinapa Chinantec -> Chinantec */
	/*{"ctg",	0x43544720},*/ /* Chittagonian */
	{"cth", 0x51494e20},     /* Thaiphum Chin -> Chin */
	{"ctl", 0x4343484e},     /* Tlacoatzintepec Chinantec -> Chinantec */
	{"cts", 0x42494b20},     /* Northern Catanduanes Bikol -> Bikol */
	/*{"ctt",	0x43545420},*/ /* Wayanad Chetti */
	{"ctu", 0x4d594e20},     /* Chol -> Mayan */
	{"cu", 0x43534c20},      /* Church Slavonic */
	{"cuc", 0x4343484e},     /* Usila Chinantec -> Chinantec */
	/*{"cuk",	0x43554b20},*/ /* San Blas Kuna */
	{"cv", 0x43485520},      /* Chuvash */
	{"cvn", 0x4343484e},     /* Valle Nacional Chinantec -> Chinantec */
	{"cwd", 0x44435220},     /* Woods Cree */
	{"cwd", 0x54435220},     /* Woods Cree -> TH-Cree */
	{"cwd", 0x43524520},     /* Woods Cree -> Cree */
	{"cy", 0x57454c20},      /* Welsh */
	{"czh", 0x5a485320},     /* Huizhou Chinese -> Chinese, Simplified */
	{"czo", 0x5a485320},     /* Min Zhong Chinese -> Chinese, Simplified */
	{"czt", 0x51494e20},     /* Zotung Chin -> Chin */
	{"da", 0x44414e20},      /* Danish */
	/*{"dag",	0x44414720},*/ /* Dagbani */
	{"dao", 0x51494e20},     /* Daai Chin -> Chin */
	{"dap", 0x4e495320},     /* Nisi (India) (retired code) (retired code) */
	/*{"dar",	0x44415220},*/ /* Dargwa */
	/*{"dax",	0x44415820},*/ /* Dayi */
	{"dcr", 0x43505020},     /* Negerhollands -> Creoles */
	{"de", 0x44455520},      /* German */
	{"den", 0x534c4120},     /* Slave (Athapascan) [macrolanguage] -> Slavey */
	{"den", 0x41544820},     /* Slave (Athapascan) [macrolanguage] -> Athapaskan */
	{"dep", 0x43505020},     /* Pidgin Delaware -> Creoles */
	{"dgo", 0x44474f20},     /* Dogri (individual language) */
	{"dgo", 0x44475220},     /* Dogri (macrolanguage) */
	{"dgr", 0x41544820},     /* Dogrib -> Athapaskan */
	{"dhd", 0x4d415720},     /* Dhundari -> Marwari */
	/*{"dhg",	0x44484720},*/ /* Dhangu */
	{"dhv", 0},              /* Dehu != Divehi (Dhivehi, Maldivian) (deprecated) */
	{"dib", 0x444e4b20},     /* South Central Dinka -> Dinka */
	{"dik", 0x444e4b20},     /* Southwestern Dinka -> Dinka */
	{"din", 0x444e4b20},     /* Dinka [macrolanguage] */
	{"dip", 0x444e4b20},     /* Northeastern Dinka -> Dinka */
	{"diq", 0x44495120},     /* Dimli */
	{"diq", 0x5a5a4120},     /* Dimli -> Zazaki */
	{"diw", 0x444e4b20},     /* Northwestern Dinka -> Dinka */
	{"dje", 0x444a5220},     /* Zarma */
	{"djk", 0x43505020},     /* Eastern Maroon Creole -> Creoles */
	{"djr", 0x444a5230},     /* Djambarrpuyngu */
	{"dks", 0x444e4b20},     /* Southeastern Dinka -> Dinka */
	{"dng", 0x44554e20},     /* Dungan */
	/*{"dnj",	0x444e4a20},*/ /* Dan */
	{"dnk", 0},              /* Dengka != Dinka */
	{"doi", 0x44475220},     /* Dogri (macrolanguage) [macrolanguage] */
	{"drh", 0x4d4e4720},     /* Darkhat (retired code) (retired code) -> Mongolian */
	{"dri", 0},              /* C'Lela != Dari */
	{"drw", 0x44524920},     /* Darwazi (retired code) (retired code) -> Dari */
	{"drw", 0x46415220},     /* Darwazi (retired code) (retired code) -> Persian */
	{"dsb", 0x4c534220},     /* Lower Sorbian */
	{"dty", 0x4e455020},     /* Dotyali -> Nepali */
	/*{"duj",	0x44554a20},*/ /* Dhuwal (retired code) (retired code) */
	{"dun", 0},              /* Dusun Deyah != Dungan */
	{"dup", 0x4d4c5920},     /* Duano -> Malay */
	{"dv", 0x44495620},      /* Divehi (Dhivehi, Maldivian) */
	{"dv", 0x44485620},      /* Divehi (Dhivehi, Maldivian) (deprecated) */
	{"dwk", 0x4b554920},     /* Dawik Kui -> Kui */
	{"dwu", 0x44554a20},     /* Dhuwal */
	{"dwy", 0x44554a20},     /* Dhuwaya -> Dhuwal */
	{"dyu", 0x4a554c20},     /* Dyula -> Jula */
	{"dz", 0x445a4e20},      /* Dzongkha */
	{"dzn", 0},              /* Dzando != Dzongkha */
	{"ecr", 0},              /* Eteocretan != Eastern Cree */
	{"ee", 0x45574520},      /* Ewe */
	/*{"efi",	0x45464920},*/ /* Efik */
	{"ekk", 0x45544920},     /* Standard Estonian -> Estonian */
	{"eky", 0x4b524e20},     /* Eastern Kayah -> Karen */
	{"el", 0x454c4c20},      /* Modern Greek (1453-) -> Greek */
	{"emk", 0x454d4b20},     /* Eastern Maninkakan */
	{"emk", 0x4d4e4b20},     /* Eastern Maninkakan -> Maninka */
	{"emy", 0x4d594e20},     /* Epigraphic Mayan -> Mayan */
	{"en", 0x454e4720},      /* English */
	{"enb", 0x4b414c20},     /* Markweeta -> Kalenjin */
	{"enf", 0x464e4520},     /* Forest Enets */
	{"enh", 0x544e4520},     /* Tundra Enets */
	{"eo", 0x4e544f20},      /* Esperanto */
	{"es", 0x45535020},      /* Spanish */
	{"esg", 0x474f4e20},     /* Aheri Gondi -> Gondi */
	{"esi", 0x49504b20},     /* North Alaskan Inupiatun -> Inupiat */
	{"esk", 0x49504b20},     /* Northwest Alaska Inupiatun -> Inupiat */
	/*{"esu",	0x45535520},*/ /* Central Yupik */
	{"et", 0x45544920},      /* Estonian [macrolanguage] */
	{"eto", 0x42544920},     /* Eton (Cameroon) -> Beti */
	{"eu", 0x45555120},      /* Basque */
	{"euq", 0},              /* Basque [collection] != Basque */
	{"eve", 0x45564e20},     /* Even */
	{"evn", 0x45564b20},     /* Evenki */
	{"ewo", 0x42544920},     /* Ewondo -> Beti */
	{"eyo", 0x4b414c20},     /* Keiyo -> Kalenjin */
	{"fa", 0x46415220},      /* Persian [macrolanguage] */
	{"fab", 0x43505020},     /* Fa d'Ambu -> Creoles */
	{"fan", 0x46414e30},     /* Fang (Equatorial Guinea) */
	{"fan", 0x42544920},     /* Fang (Equatorial Guinea) -> Beti */
	{"far", 0},              /* Fataleka != Persian */
	{"fat", 0x46415420},     /* Fanti */
	{"fat", 0x414b4120},     /* Fanti -> Akan */
	{"fbl", 0x42494b20},     /* West Albay Bikol -> Bikol */
	{"ff", 0x46554c20},      /* Fulah [macrolanguage] */
	{"ffm", 0x46554c20},     /* Maasina Fulfulde -> Fulah */
	{"fi", 0x46494e20},      /* Finnish */
	{"fil", 0x50494c20},     /* Filipino */
	{"fj", 0x464a4920},      /* Fijian */
	{"flm", 0x48414c20},     /* Halam (Falam Chin) (retired code) */
	{"flm", 0x51494e20},     /* Falam Chin (retired code) -> Chin */
	{"fmp", 0x464d5020},     /* Fe’fe’ */
	{"fmp", 0x424d4c20},     /* Fe'fe' -> Bamileke */
	{"fng", 0x43505020},     /* Fanagalo -> Creoles */
	{"fo", 0x464f5320},      /* Faroese */
	/*{"fon",	0x464f4e20},*/ /* Fon */
	{"fos", 0},              /* Siraya != Faroese */
	{"fpe", 0x43505020},     /* Fernando Po Creole English -> Creoles */
	{"fr", 0x46524120},      /* French */
	/*{"frc",	0x46524320},*/ /* Cajun French */
	/*{"frp",	0x46525020},*/ /* Arpitan */
	{"fub", 0x46554c20},     /* Adamawa Fulfulde -> Fulah */
	{"fuc", 0x46554c20},     /* Pulaar -> Fulah */
	{"fue", 0x46554c20},     /* Borgu Fulfulde -> Fulah */
	{"fuf", 0x46544120},     /* Pular -> Futa */
	{"fuf", 0x46554c20},     /* Pular -> Fulah */
	{"fuh", 0x46554c20},     /* Western Niger Fulfulde -> Fulah */
	{"fui", 0x46554c20},     /* Bagirmi Fulfulde -> Fulah */
	{"fuq", 0x46554c20},     /* Central-Eastern Niger Fulfulde -> Fulah */
	{"fur", 0x46524c20},     /* Friulian */
	{"fuv", 0x46555620},     /* Nigerian Fulfulde */
	{"fuv", 0x46554c20},     /* Nigerian Fulfulde -> Fulah */
	{"fy", 0x46524920},      /* Western Frisian -> Frisian */
	{"ga", 0x49524920},      /* Irish */
	{"gaa", 0x47414420},     /* Ga */
	{"gac", 0x43505020},     /* Mixed Great Andamanese -> Creoles */
	{"gad", 0},              /* Gaddang != Ga */
	{"gae", 0},              /* Guarequena != Scottish Gaelic (Gaelic) */
	/*{"gag",	0x47414720},*/ /* Gagauz */
	{"gal", 0},              /* Galolen != Galician */
	{"gan", 0x5a485320},     /* Gan Chinese -> Chinese, Simplified */
	{"gaw", 0},              /* Nobonob != Garhwali */
	{"gax", 0x4f524f20},     /* Borana-Arsi-Guji Oromo -> Oromo */
	{"gaz", 0x4f524f20},     /* West Central Oromo -> Oromo */
	{"gbm", 0x47415720},     /* Garhwali */
	{"gce", 0x41544820},     /* Galice -> Athapaskan */
	{"gcf", 0x43505020},     /* Guadeloupean Creole French -> Creoles */
	{"gcl", 0x43505020},     /* Grenadian Creole English -> Creoles */
	{"gcr", 0x43505020},     /* Guianese Creole French -> Creoles */
	{"gd", 0x47414520},      /* Scottish Gaelic (Gaelic) */
	{"gda", 0x52414a20},     /* Gade Lohar -> Rajasthani */
	/*{"gez",	0x47455a20},*/ /* Geez */
	{"ggo", 0x474f4e20},     /* Southern Gondi (retired code) (retired code) -> Gondi */
	{"gha", 0x42425220},     /* Ghadamès -> Berber */
	{"ghk", 0x4b524e20},     /* Geko Karen -> Karen */
	{"gho", 0x42425220},     /* Ghomara -> Berber */
	{"gib", 0x43505020},     /* Gibanawa -> Creoles */
	/*{"gih",	0x47494820},*/ /* Githabul */
	{"gil", 0x47494c30},     /* Kiribati (Gilbertese) */
	{"gju", 0x52414a20},     /* Gujari -> Rajasthani */
	{"gkp", 0x474b5020},     /* Guinea Kpelle -> Kpelle (Guinea) */
	{"gkp", 0x4b504c20},     /* Guinea Kpelle -> Kpelle */
	{"gl", 0x47414c20},      /* Galician */
	{"gld", 0x4e414e20},     /* Nanai */
	/*{"glk",	0x474c4b20},*/ /* Gilaki */
	{"gmz", 0},              /* Mgbolizhia != Gumuz */
	{"gn", 0x47554120},      /* Guarani [macrolanguage] */
	{"gnb", 0x51494e20},     /* Gangte -> Chin */
	/*{"gnn",	0x474e4e20},*/ /* Gumatj */
	{"gno", 0x474f4e20},     /* Northern Gondi -> Gondi */
	{"gnw", 0x47554120},     /* Western Bolivian Guaraní -> Guarani */
	/*{"gog",	0x474f4720},*/ /* Gogo */
	{"gom", 0x4b4f4b20},     /* Goan Konkani -> Konkani */
	/*{"gon",	0x474f4e20},*/ /* Gondi [macrolanguage] */
	{"goq", 0x43505020},     /* Gorap -> Creoles */
	{"gox", 0x42414430},     /* Gobu -> Banda */
	{"gpe", 0x43505020},     /* Ghanaian Pidgin English -> Creoles */
	{"gro", 0},              /* Groma != Garo */
	{"grr", 0x42425220},     /* Taznatit -> Berber */
	{"grt", 0x47524f20},     /* Garo */
	{"gru", 0x534f4720},     /* Kistane -> Sodo Gurage */
	{"gsw", 0x414c5320},     /* Alsatian */
	{"gu", 0x47554a20},      /* Gujarati */
	{"gua", 0},              /* Shiki != Guarani */
	/*{"guc",	0x47554320},*/ /* Wayuu */
	/*{"guf",	0x47554620},*/ /* Gupapuyngu */
	{"gug", 0x47554120},     /* Paraguayan Guaraní -> Guarani */
	{"gui", 0x47554120},     /* Eastern Bolivian Guaraní -> Guarani */
	{"guk", 0x474d5a20},     /* Gumuz */
	{"gul", 0x43505020},     /* Sea Island Creole English -> Creoles */
	{"gun", 0x47554120},     /* Mbyá Guaraní -> Guarani */
	/*{"guz",	0x47555a20},*/ /* Gusii */
	{"gv", 0x4d4e5820},      /* Manx */
	{"gwi", 0x41544820},     /* Gwichʼin -> Athapaskan */
	{"gyn", 0x43505020},     /* Guyanese Creole English -> Creoles */
	{"ha", 0x48415520},      /* Hausa */
	{"haa", 0x41544820},     /* Han -> Athapaskan */
	{"hae", 0x4f524f20},     /* Eastern Oromo -> Oromo */
	{"hai", 0x48414930},     /* Haida [macrolanguage] */
	{"hak", 0x5a485320},     /* Hakka Chinese -> Chinese, Simplified */
	{"hal", 0},              /* Halang != Halam (Falam Chin) */
	{"har", 0x48524920},     /* Harari */
	/*{"haw",	0x48415720},*/ /* Hawaiian */
	{"hax", 0x48414930},     /* Southern Haida -> Haida */
	/*{"hay",	0x48415920},*/ /* Haya */
	/*{"haz",	0x48415a20},*/ /* Hazaragi */
	{"hbn", 0},              /* Heiban != Hammer-Banna */
	{"hca", 0x43505020},     /* Andaman Creole Hindi -> Creoles */
	{"hdn", 0x48414930},     /* Northern Haida -> Haida */
	{"he", 0x49575220},      /* Hebrew */
	{"hea", 0x484d4e20},     /* Northern Qiandong Miao -> Hmong */
	/*{"hei",	0x48454920},*/ /* Heiltsuk */
	{"hi", 0x48494e20},      /* Hindi */
	/*{"hil",	0x48494c20},*/ /* Hiligaynon */
	{"hji", 0x4d4c5920},     /* Haji -> Malay */
	{"hlt", 0x51494e20},     /* Matu Chin -> Chin */
	{"hma", 0x484d4e20},     /* Southern Mashan Hmong -> Hmong */
	{"hmc", 0x484d4e20},     /* Central Huishui Hmong -> Hmong */
	{"hmd", 0x484d4420},     /* Large Flowery Miao -> A-Hmao */
	{"hmd", 0x484d4e20},     /* Large Flowery Miao -> Hmong */
	{"hme", 0x484d4e20},     /* Eastern Huishui Hmong -> Hmong */
	{"hmg", 0x484d4e20},     /* Southwestern Guiyang Hmong -> Hmong */
	{"hmh", 0x484d4e20},     /* Southwestern Huishui Hmong -> Hmong */
	{"hmi", 0x484d4e20},     /* Northern Huishui Hmong -> Hmong */
	{"hmj", 0x484d4e20},     /* Ge -> Hmong */
	{"hml", 0x484d4e20},     /* Luopohe Hmong -> Hmong */
	{"hmm", 0x484d4e20},     /* Central Mashan Hmong -> Hmong */
	/*{"hmn",	0x484d4e20},*/ /* Hmong [macrolanguage] */
	{"hmp", 0x484d4e20},     /* Northern Mashan Hmong -> Hmong */
	{"hmq", 0x484d4e20},     /* Eastern Qiandong Miao -> Hmong */
	{"hmr", 0x51494e20},     /* Hmar -> Chin */
	{"hms", 0x484d4e20},     /* Southern Qiandong Miao -> Hmong */
	{"hmw", 0x484d4e20},     /* Western Mashan Hmong -> Hmong */
	{"hmy", 0x484d4e20},     /* Southern Guiyang Hmong -> Hmong */
	{"hmz", 0x484d5a20},     /* Hmong Shua -> Hmong Shuat */
	{"hmz", 0x484d4e20},     /* Hmong Shua -> Hmong */
	/*{"hnd",	0x484e4420},*/ /* Southern Hindko -> Hindko */
	{"hne", 0x43484820},     /* Chhattisgarhi -> Chattisgarhi */
	{"hnj", 0x484d4e20},     /* Hmong Njua -> Hmong */
	{"hno", 0x484e4420},     /* Northern Hindko -> Hindko */
	{"ho", 0x484d4f20},      /* Hiri Motu */
	{"ho", 0x43505020},      /* Hiri Motu -> Creoles */
	{"hoc", 0x484f2020},     /* Ho */
	{"hoi", 0x41544820},     /* Holikachuk -> Athapaskan */
	{"hoj", 0x48415220},     /* Hadothi -> Harauti */
	{"hoj", 0x52414a20},     /* Hadothi -> Rajasthani */
	{"hr", 0x48525620},      /* Croatian */
	{"hra", 0x51494e20},     /* Hrangkhol -> Chin */
	{"hrm", 0x484d4e20},     /* Horned Miao -> Hmong */
	{"hsb", 0x55534220},     /* Upper Sorbian */
	{"hsn", 0x5a485320},     /* Xiang Chinese -> Chinese, Simplified */
	{"ht", 0x48414920},      /* Haitian (Haitian Creole) */
	{"ht", 0x43505020},      /* Haitian -> Creoles */
	{"hu", 0x48554e20},      /* Hungarian */
	{"huj", 0x484d4e20},     /* Northern Guiyang Hmong -> Hmong */
	{"hup", 0x41544820},     /* Hupa -> Athapaskan */
	{"hus", 0x4d594e20},     /* Huastec -> Mayan */
	{"hwc", 0x43505020},     /* Hawai'i Creole English -> Creoles */
	{"hy", 0x48594530},      /* Armenian -> Armenian East */
	{"hy", 0x48594520},      /* Armenian */
	{"hyw", 0x48594520},     /* Western Armenian -> Armenian */
	{"hz", 0x48455220},      /* Herero */
	{"ia", 0x494e4120},      /* Interlingua (International Auxiliary Language Association) */
	/*{"iba",	0x49424120},*/ /* Iban */
	/*{"ibb",	0x49424220},*/ /* Ibibio */
	{"iby", 0x494a4f20},     /* Ibani -> Ijo */
	{"icr", 0x43505020},     /* Islander Creole English -> Creoles */
	{"id", 0x494e4420},      /* Indonesian */
	{"id", 0x4d4c5920},      /* Indonesian -> Malay */
	{"ida", 0x4c554820},     /* Idakho-Isukha-Tiriki -> Luyia */
	{"idb", 0x43505020},     /* Indo-Portuguese -> Creoles */
	{"ie", 0x494c4520},      /* Interlingue */
	{"ig", 0x49424f20},      /* Igbo */
	{"igb", 0x45424920},     /* Ebira */
	{"ihb", 0x43505020},     /* Iha Based Pidgin -> Creoles */
	{"ii", 0x59494d20},      /* Sichuan Yi -> Yi Modern */
	{"ijc", 0x494a4f20},     /* Izon -> Ijo */
	{"ije", 0x494a4f20},     /* Biseni -> Ijo */
	{"ijn", 0x494a4f20},     /* Kalabari -> Ijo */
	/*{"ijo",	0x494a4f20},*/ /* Ijo [collection] */
	{"ijs", 0x494a4f20},     /* Southeast Ijo -> Ijo */
	{"ik", 0x49504b20},      /* Inupiaq [macrolanguage] -> Inupiat */
	{"ike", 0x494e5520},     /* Eastern Canadian Inuktitut -> Inuktitut */
	{"ike", 0x494e554b},     /* Eastern Canadian Inuktitut -> Nunavik Inuktitut */
	{"ikt", 0x494e5520},     /* Inuinnaqtun -> Inuktitut */
	{"ikt", 0x494e554b},     /* Inuinnaqtun -> Nunavik Inuktitut */
	/*{"ilo",	0x494c4f20},*/ /* Iloko -> Ilokano */
	{"in", 0x494e4420},      /* Indonesian (retired code) (retired code) */
	{"in", 0x4d4c5920},      /* Indonesian (retired code) (retired code) -> Malay */
	{"ing", 0x41544820},     /* Degexit'an -> Athapaskan */
	{"inh", 0x494e4720},     /* Ingush */
	{"io", 0x49444f20},      /* Ido */
	{"iri", 0},              /* Rigwe != Irish */
	/*{"iru",	0x49525520},*/ /* Irula */
	{"is", 0x49534c20},      /* Icelandic */
	{"ism", 0},              /* Masimasi != Inari Sami */
	{"it", 0x49544120},      /* Italian */
	{"itz", 0x4d594e20},     /* Itzá -> Mayan */
	{"iu", 0x494e5520},      /* Inuktitut [macrolanguage] */
	{"iu", 0x494e554b},      /* Inuktitut [macrolanguage] -> Nunavik Inuktitut */
	{"iw", 0x49575220},      /* Hebrew (retired code) (retired code) */
	{"ixl", 0x4d594e20},     /* Ixil -> Mayan */
	{"ja", 0x4a414e20},      /* Japanese */
	{"jac", 0x4d594e20},     /* Popti' -> Mayan */
	{"jak", 0x4d4c5920},     /* Jakun -> Malay */
	{"jam", 0x4a414d20},     /* Jamaican Creole English -> Jamaican Creole */
	{"jam", 0x43505020},     /* Jamaican Creole English -> Creoles */
	{"jan", 0},              /* Jandai != Japanese */
	{"jax", 0x4d4c5920},     /* Jambi Malay -> Malay */
	{"jbe", 0x42425220},     /* Judeo-Berber -> Berber */
	{"jbn", 0x42425220},     /* Nafusi -> Berber */
	/*{"jbo",	0x4a424f20},*/ /* Lojban */
	/*{"jct",	0x4a435420},*/ /* Krymchak */
	{"jgo", 0x424d4c20},     /* Ngomba -> Bamileke */
	{"ji", 0x4a494920},      /* Yiddish (retired code) (retired code) */
	{"jii", 0},              /* Jiiddu != Yiddish */
	{"jkm", 0x4b524e20},     /* Mobwa Karen -> Karen */
	{"jkp", 0x4b524e20},     /* Paku Karen -> Karen */
	{"jud", 0},              /* Worodougou != Ladino */
	{"jul", 0},              /* Jirel != Jula */
	{"jv", 0x4a415620},      /* Javanese */
	{"jvd", 0x43505020},     /* Javindo -> Creoles */
	{"jw", 0x4a415620},      /* Javanese (retired code) (retired code) */
	{"ka", 0x4b415420},      /* Georgian */
	{"kaa", 0x4b524b20},     /* Karakalpak */
	{"kab", 0x4b414230},     /* Kabyle */
	{"kab", 0x42425220},     /* Kabyle -> Berber */
	{"kac", 0},              /* Kachin != Kachchi */
	{"kam", 0x4b4d4220},     /* Kamba (Kenya) */
	{"kar", 0x4b524e20},     /* Karen [collection] */
	/*{"kaw",	0x4b415720},*/ /* Kawi (Old Javanese) */
	{"kbd", 0x4b414220},     /* Kabardian */
	{"kby", 0x4b4e5220},     /* Manga Kanuri -> Kanuri */
	{"kca", 0x4b484b20},     /* Khanty -> Khanty-Kazim */
	{"kca", 0x4b485320},     /* Khanty -> Khanty-Shurishkar */
	{"kca", 0x4b485620},     /* Khanty -> Khanty-Vakhi */
	{"kcn", 0x43505020},     /* Nubi -> Creoles */
	/*{"kde",	0x4b444520},*/ /* Makonde */
	{"kdr", 0x4b524d20},     /* Karaim */
	{"kdt", 0x4b555920},     /* Kuy */
	{"kea", 0x4b454120},     /* Kabuverdianu (Crioulo) */
	{"kea", 0x43505020},     /* Kabuverdianu -> Creoles */
	{"keb", 0},              /* Kélé != Kebena */
	{"kek", 0x4b454b20},     /* Kekchí */
	{"kek", 0x4d594e20},     /* Kekchí -> Mayan */
	{"kex", 0x4b4b4e20},     /* Kukna -> Kokni */
	{"kfa", 0x4b4f4420},     /* Kodava -> Kodagu */
	{"kfr", 0x4b414320},     /* Kachhi -> Kachchi */
	{"kfx", 0x4b554c20},     /* Kullu Pahari -> Kulvi */
	{"kfy", 0x4b4d4e20},     /* Kumaoni */
	{"kg", 0x4b4f4e30},      /* Kongo [macrolanguage] */
	{"kge", 0},              /* Komering != Khutsuri Georgian */
	{"kha", 0x4b534920},     /* Khasi */
	{"khb", 0x58424420},     /* Lü */
	{"khk", 0x4d4e4720},     /* Halh Mongolian -> Mongolian */
	{"khn", 0},              /* Khandesi != Khamti Shan (Microsoft fonts) */
	{"khs", 0},              /* Kasua != Khanty-Shurishkar */
	{"kht", 0x4b485420},     /* Khamti -> Khamti Shan */
	{"kht", 0x4b484e20},     /* Khamti -> Khamti Shan (Microsoft fonts) */
	{"khv", 0},              /* Khvarshi != Khanty-Vakhi */
	/*{"khw",	0x4b485720},*/ /* Khowar */
	{"ki", 0x4b494b20},      /* Kikuyu (Gikuyu) */
	{"kis", 0},              /* Kis != Kisii */
	{"kiu", 0x4b495520},     /* Kirmanjki */
	{"kiu", 0x5a5a4120},     /* Kirmanjki -> Zazaki */
	{"kj", 0x4b554120},      /* Kuanyama */
	{"kjb", 0x4d594e20},     /* Q'anjob'al -> Mayan */
	/*{"kjd",	0x4b4a4420},*/ /* Southern Kiwai */
	{"kjh", 0x4b484120},     /* Khakas -> Khakass */
	{"kjp", 0x4b4a5020},     /* Pwo Eastern Karen -> Eastern Pwo Karen */
	{"kjp", 0x4b524e20},     /* Pwo Eastern Karen -> Karen */
	{"kjt", 0x4b524e20},     /* Phrae Pwo Karen -> Karen */
	/*{"kjz",	0x4b4a5a20},*/ /* Bumthangkha */
	{"kk", 0x4b415a20},      /* Kazakh */
	{"kkn", 0},              /* Kon Keu != Kokni */
	{"kkz", 0x41544820},     /* Kaska -> Athapaskan */
	{"kl", 0x47524e20},      /* Greenlandic */
	{"klm", 0},              /* Migum != Kalmyk */
	{"kln", 0x4b414c20},     /* Kalenjin [macrolanguage] */
	{"km", 0x4b484d20},      /* Khmer */
	{"kmb", 0x4d424e20},     /* Kimbundu -> Mbundu */
	{"kmn", 0},              /* Awtuw != Kumaoni */
	{"kmo", 0},              /* Kwoma != Komo */
	{"kmr", 0x4b555220},     /* Northern Kurdish -> Kurdish */
	{"kms", 0},              /* Kamasau != Komso */
	{"kmv", 0x43505020},     /* Karipúna Creole French -> Creoles */
	{"kmw", 0x4b4d4f20},     /* Komo (Democratic Republic of Congo) */
	/*{"kmz",	0x4b4d5a20},*/ /* Khorasani Turkish -> Khorasani Turkic */
	{"kn", 0x4b414e20},      /* Kannada */
	{"knc", 0x4b4e5220},     /* Central Kanuri -> Kanuri */
	{"kng", 0x4b4f4e30},     /* Koongo -> Kongo */
	{"knj", 0x4d594e20},     /* Western Kanjobal -> Mayan */
	{"knn", 0x4b4f4b20},     /* Konkani */
	{"knr", 0},              /* Kaningra != Kanuri */
	{"ko", 0x4b4f5220},      /* Korean */
	{"ko", 0x4b4f4820},      /* Korean -> Korean Old Hangul */
	{"kod", 0},              /* Kodi != Kodagu */
	{"koh", 0},              /* Koyo != Korean Old Hangul */
	{"koi", 0x4b4f5020},     /* Komi-Permyak */
	{"koi", 0x4b4f4d20},     /* Komi-Permyak -> Komi */
	/*{"kok",	0x4b4f4b20},*/ /* Konkani [macrolanguage] */
	{"kop", 0},              /* Waube != Komi-Permyak */
	/*{"kos",	0x4b4f5320},*/ /* Kosraean */
	{"koy", 0x41544820},     /* Koyukon -> Athapaskan */
	{"koz", 0},              /* Korak != Komi-Zyrian */
	{"kpe", 0x4b504c20},     /* Kpelle [macrolanguage] */
	{"kpl", 0},              /* Kpala != Kpelle */
	{"kpp", 0x4b524e20},     /* Paku Karen (retired code) (retired code) -> Karen */
	{"kpv", 0x4b4f5a20},     /* Komi-Zyrian */
	{"kpv", 0x4b4f4d20},     /* Komi-Zyrian -> Komi */
	{"kpy", 0x4b594b20},     /* Koryak */
	{"kqs", 0x4b495320},     /* Northern Kissi -> Kisii */
	{"kqy", 0x4b525420},     /* Koorete */
	{"kr", 0x4b4e5220},      /* Kanuri [macrolanguage] */
	{"krc", 0x4b415220},     /* Karachay-Balkar -> Karachay */
	{"krc", 0x42414c20},     /* Karachay-Balkar -> Balkar */
	{"kri", 0x4b524920},     /* Krio */
	{"kri", 0x43505020},     /* Krio -> Creoles */
	{"krk", 0},              /* Kerek != Karakalpak */
	/*{"krl",	0x4b524c20},*/ /* Karelian */
	{"krm", 0},              /* Krim (retired code) (retired code) != Karaim */
	{"krn", 0},              /* Sapo != Karen */
	{"krt", 0x4b4e5220},     /* Tumari Kanuri -> Kanuri */
	{"kru", 0x4b555520},     /* Kurukh */
	{"ks", 0x4b534820},      /* Kashmiri */
	{"ksh", 0x4b534830},     /* Kölsch -> Ripuarian */
	{"ksi", 0},              /* Krisa != Khasi */
	{"ksm", 0},              /* Kumba != Kildin Sami */
	{"kss", 0x4b495320},     /* Southern Kisi -> Kisii */
	{"ksw", 0x4b535720},     /* S’gaw Karen */
	{"ksw", 0x4b524e20},     /* S'gaw Karen -> Karen */
	{"ktb", 0x4b454220},     /* Kambaata -> Kebena */
	{"ktu", 0x4b4f4e20},     /* Kituba (Democratic Republic of Congo) -> Kikongo */
	{"ktw", 0x41544820},     /* Kato -> Athapaskan */
	{"ku", 0x4b555220},      /* Kurdish [macrolanguage] */
	{"kui", 0},              /* Kuikúro-Kalapálo != Kui */
	{"kul", 0},              /* Kulere != Kulvi */
	/*{"kum",	0x4b554d20},*/ /* Kumyk */
	{"kuu", 0x41544820},     /* Upper Kuskokwim -> Athapaskan */
	{"kuw", 0x42414430},     /* Kpagua -> Banda */
	{"kuy", 0},              /* Kuuku-Ya'u != Kuy */
	{"kv", 0x4b4f4d20},      /* Komi [macrolanguage] */
	{"kvb", 0x4d4c5920},     /* Kubu -> Malay */
	{"kvl", 0x4b524e20},     /* Kayaw -> Karen */
	{"kvq", 0x4b524e20},     /* Geba Karen -> Karen */
	{"kvr", 0x4d4c5920},     /* Kerinci -> Malay */
	{"kvt", 0x4b524e20},     /* Lahta Karen -> Karen */
	{"kvu", 0x4b524e20},     /* Yinbaw Karen -> Karen */
	{"kvy", 0x4b524e20},     /* Yintale Karen -> Karen */
	{"kw", 0x434f5220},      /* Cornish */
	/*{"kwk",	0x4b574b20},*/ /* Kwakiutl -> Kwakʼwala */
	{"kww", 0x43505020},     /* Kwinti -> Creoles */
	{"kwy", 0x4b4f4e30},     /* San Salvador Kongo -> Kongo */
	{"kxc", 0x4b4d5320},     /* Konso -> Komso */
	{"kxd", 0x4d4c5920},     /* Brunei -> Malay */
	{"kxf", 0x4b524e20},     /* Manumanaw Karen -> Karen */
	{"kxk", 0x4b524e20},     /* Zayein Karen -> Karen */
	{"kxl", 0x4b555520},     /* Nepali Kurux (retired code) (retired code) -> Kurukh */
	{"kxu", 0x4b554920},     /* Kui (India) (retired code) (retired code) */
	{"ky", 0x4b495220},      /* Kirghiz (Kyrgyz) */
	{"kyk", 0},              /* Kamayo != Koryak */
	{"kyu", 0x4b595520},     /* Western Kayah */
	{"kyu", 0x4b524e20},     /* Western Kayah -> Karen */
	{"la", 0x4c415420},      /* Latin */
	{"lac", 0x4d594e20},     /* Lacandon -> Mayan */
	{"lad", 0x4a554420},     /* Ladino */
	{"lah", 0},              /* Lahnda [macrolanguage] != Lahuli */
	{"lak", 0},              /* Laka (Nigeria) (retired code) (retired code) != Lak */
	{"lam", 0},              /* Lamba != Lambani */
	{"laz", 0},              /* Aribwatsa != Laz */
	{"lb", 0x4c545a20},      /* Luxembourgish */
	{"lbe", 0x4c414b20},     /* Lak */
	{"lbj", 0x4c444b20},     /* Ladakhi */
	{"lbl", 0x42494b20},     /* Libon Bikol -> Bikol */
	{"lce", 0x4d4c5920},     /* Loncong -> Malay */
	{"lcf", 0x4d4c5920},     /* Lubu -> Malay */
	{"ldi", 0x4b4f4e30},     /* Laari -> Kongo */
	{"ldk", 0},              /* Leelau != Ladakhi */
	/*{"lef",	0x4c454620},*/ /* Lelemi */
	/*{"lez",	0x4c455a20},*/ /* Lezghian -> Lezgi */
	{"lg", 0x4c554720},      /* Ganda */
	{"li", 0x4c494d20},      /* Limburgish */
	{"lif", 0x4c4d4220},     /* Limbu */
	/*{"lij",	0x4c494a20},*/ /* Ligurian */
	{"lir", 0x43505020},     /* Liberian English -> Creoles */
	/*{"lis",	0x4c495320},*/ /* Lisu */
	{"liw", 0x4d4c5920},     /* Col -> Malay */
	{"liy", 0x42414430},     /* Banda-Bambari -> Banda */
	/*{"ljp",	0x4c4a5020},*/ /* Lampung Api -> Lampung */
	{"lkb", 0x4c554820},     /* Kabras -> Luyia */
	/*{"lki",	0x4c4b4920},*/ /* Laki */
	{"lko", 0x4c554820},     /* Khayo -> Luyia */
	{"lks", 0x4c554820},     /* Kisa -> Luyia */
	{"lld", 0x4c414420},     /* Ladin */
	{"lma", 0},              /* East Limba != Low Mari */
	{"lmb", 0},              /* Merei != Limbu */
	{"lmn", 0x4c414d20},     /* Lambadi -> Lambani */
	/*{"lmo",	0x4c4d4f20},*/ /* Lombard */
	{"lmw", 0},              /* Lake Miwok != Lomwe */
	{"ln", 0x4c494e20},      /* Lingala */
	{"lna", 0x42414430},     /* Langbashe -> Banda */
	{"lnl", 0x42414430},     /* South Central Banda -> Banda */
	{"lo", 0x4c414f20},      /* Lao */
	/*{"lom",	0x4c4f4d20},*/ /* Loma (Liberia) */
	{"lou", 0x43505020},     /* Louisiana Creole -> Creoles */
	/*{"lpo",	0x4c504f20},*/ /* Lipo */
	/*{"lrc",	0x4c524320},*/ /* Northern Luri -> Luri */
	{"lri", 0x4c554820},     /* Marachi -> Luyia */
	{"lrm", 0x4c554820},     /* Marama -> Luyia */
	{"lrt", 0x43505020},     /* Larantuka Malay -> Creoles */
	{"lsb", 0},              /* Burundian Sign Language != Lower Sorbian */
	{"lsm", 0x4c554820},     /* Saamia -> Luyia */
	{"lt", 0x4c544820},      /* Lithuanian */
	{"ltg", 0x4c564920},     /* Latgalian -> Latvian */
	{"lth", 0},              /* Thur != Lithuanian */
	{"lto", 0x4c554820},     /* Tsotso -> Luyia */
	{"lts", 0x4c554820},     /* Tachoni -> Luyia */
	{"lu", 0x4c554220},      /* Luba-Katanga */
	/*{"lua",	0x4c554120},*/ /* Luba-Lulua */
	/*{"luo",	0x4c554f20},*/ /* Luo (Kenya and Tanzania) */
	{"lus", 0x4d495a20},     /* Lushai -> Mizo */
	{"lus", 0x51494e20},     /* Lushai -> Chin */
	{"luy", 0x4c554820},     /* Luyia [macrolanguage] */
	{"luz", 0x4c524320},     /* Southern Luri -> Luri */
	{"lv", 0x4c564920},      /* Latvian [macrolanguage] */
	{"lvi", 0},              /* Lavi != Latvian */
	{"lvs", 0x4c564920},     /* Standard Latvian -> Latvian */
	{"lwg", 0x4c554820},     /* Wanga -> Luyia */
	{"lzh", 0x5a485420},     /* Literary Chinese -> Chinese, Traditional */
	{"lzz", 0x4c415a20},     /* Laz */
	/*{"mad",	0x4d414420},*/ /* Madurese -> Madura */
	/*{"mag",	0x4d414720},*/ /* Magahi */
	{"mai", 0x4d544820},     /* Maithili */
	{"maj", 0},              /* Jalapa De Díaz Mazatec != Majang */
	{"mak", 0x4d4b5220},     /* Makasar */
	{"mam", 0x4d414d20},     /* Mam */
	{"mam", 0x4d594e20},     /* Mam -> Mayan */
	{"man", 0x4d4e4b20},     /* Mandingo [macrolanguage] -> Maninka */
	{"map", 0},              /* Austronesian [collection] != Mapudungun */
	{"maw", 0},              /* Mampruli != Marwari */
	{"max", 0x4d4c5920},     /* North Moluccan Malay -> Malay */
	{"max", 0x43505020},     /* North Moluccan Malay -> Creoles */
	{"mbf", 0x43505020},     /* Baba Malay -> Creoles */
	{"mbn", 0},              /* Macaguán != Mbundu */
	/*{"mbo",	0x4d424f20},*/ /* Mbo (Cameroon) */
	{"mch", 0},              /* Maquiritari != Manchu */
	{"mcm", 0x43505020},     /* Malaccan Creole Portuguese -> Creoles */
	{"mcr", 0},              /* Menya != Moose Cree */
	{"mct", 0x42544920},     /* Mengisa -> Beti */
	{"mde", 0},              /* Maba (Chad) != Mende */
	{"mdf", 0x4d4f4b20},     /* Moksha */
	/*{"mdr",	0x4d445220},*/ /* Mandar */
	{"mdy", 0x4d4c4520},     /* Male (Ethiopia) */
	{"men", 0x4d444520},     /* Mende (Sierra Leone) */
	{"meo", 0x4d4c5920},     /* Kedah Malay -> Malay */
	/*{"mer",	0x4d455220},*/ /* Meru */
	{"mfa", 0x4d464120},     /* Pattani Malay */
	{"mfa", 0x4d4c5920},     /* Pattani Malay -> Malay */
	{"mfb", 0x4d4c5920},     /* Bangka -> Malay */
	{"mfe", 0x4d464520},     /* Morisyen */
	{"mfe", 0x43505020},     /* Morisyen -> Creoles */
	{"mfp", 0x43505020},     /* Makassar Malay -> Creoles */
	{"mg", 0x4d4c4720},      /* Malagasy [macrolanguage] */
	{"mh", 0x4d414820},      /* Marshallese */
	{"mhc", 0x4d594e20},     /* Mocho -> Mayan */
	{"mhr", 0x4c4d4120},     /* Eastern Mari -> Low Mari */
	{"mhv", 0x41524b20},     /* Arakanese (retired code) -> Rakhine */
	{"mi", 0x4d524920},      /* Maori */
	{"min", 0x4d494e20},     /* Minangkabau */
	{"min", 0x4d4c5920},     /* Minangkabau -> Malay */
	{"miz", 0},              /* Coatzospan Mixtec != Mizo */
	{"mk", 0x4d4b4420},      /* Macedonian */
	{"mkn", 0x43505020},     /* Kupang Malay -> Creoles */
	{"mkr", 0},              /* Malas != Makasar */
	{"mku", 0x4d4e4b20},     /* Konyanka Maninka -> Maninka */
	/*{"mkw",	0x4d4b5720},*/ /* Kituba (Congo) */
	{"ml", 0x4d414c20},      /* Malayalam -> Malayalam Traditional */
	{"ml", 0x4d4c5220},      /* Malayalam -> Malayalam Reformed */
	{"mle", 0},              /* Manambu != Male */
	{"mln", 0},              /* Malango != Malinke */
	{"mlq", 0x4d4c4e20},     /* Western Maninkakan -> Malinke */
	{"mlq", 0x4d4e4b20},     /* Western Maninkakan -> Maninka */
	{"mlr", 0},              /* Vame != Malayalam Reformed */
	{"mmr", 0x484d4e20},     /* Western Xiangxi Miao -> Hmong */
	{"mn", 0x4d4e4720},      /* Mongolian [macrolanguage] */
	{"mnc", 0x4d434820},     /* Manchu */
	{"mnd", 0},              /* Mondé != Mandinka */
	{"mng", 0},              /* Eastern Mnong != Mongolian */
	{"mnh", 0x42414430},     /* Mono (Democratic Republic of Congo) -> Banda */
	/*{"mni",	0x4d4e4920},*/ /* Manipuri */
	{"mnk", 0x4d4e4420},     /* Mandinka */
	{"mnk", 0x4d4e4b20},     /* Mandinka -> Maninka */
	{"mnp", 0x5a485320},     /* Min Bei Chinese -> Chinese, Simplified */
	{"mns", 0x4d414e20},     /* Mansi */
	{"mnw", 0x4d4f4e20},     /* Mon */
	{"mnw", 0x4d4f4e54},     /* Mon -> Thailand Mon */
	{"mnx", 0},              /* Manikion != Manx */
	{"mo", 0x4d4f4c20},      /* Moldavian (retired code) (retired code) */
	{"mo", 0x524f4d20},      /* Moldavian (retired code) (retired code) -> Romanian */
	{"mod", 0x43505020},     /* Mobilian -> Creoles */
	/*{"moh",	0x4d4f4820},*/ /* Mohawk */
	{"mok", 0},              /* Morori != Moksha */
	{"mop", 0x4d594e20},     /* Mopán Maya -> Mayan */
	/*{"mos",	0x4d4f5320},*/ /* Mossi */
	{"mpe", 0x4d414a20},     /* Majang */
	{"mqg", 0x4d4c5920},     /* Kota Bangun Kutai Malay -> Malay */
	{"mr", 0x4d415220},      /* Marathi */
	{"mrh", 0x51494e20},     /* Mara Chin -> Chin */
	{"mrj", 0x484d4120},     /* Western Mari -> High Mari */
	{"ms", 0x4d4c5920},      /* Malay [macrolanguage] */
	{"msc", 0x4d4e4b20},     /* Sankaran Maninka -> Maninka */
	{"msh", 0x4d4c4720},     /* Masikoro Malagasy -> Malagasy */
	{"msi", 0x4d4c5920},     /* Sabah Malay -> Malay */
	{"msi", 0x43505020},     /* Sabah Malay -> Creoles */
	{"mt", 0x4d545320},      /* Maltese */
	{"mth", 0},              /* Munggui != Maithili */
	{"mtr", 0x4d415720},     /* Mewari -> Marwari */
	{"mts", 0},              /* Yora != Maltese */
	{"mud", 0x43505020},     /* Mednyj Aleut -> Creoles */
	{"mui", 0x4d4c5920},     /* Musi -> Malay */
	{"mun", 0},              /* Munda [collection] != Mundari */
	{"mup", 0x52414a20},     /* Malvi -> Rajasthani */
	{"muq", 0x484d4e20},     /* Eastern Xiangxi Miao -> Hmong */
	/*{"mus",	0x4d555320},*/ /* Creek -> Muscogee */
	{"mvb", 0x41544820},     /* Mattole -> Athapaskan */
	{"mve", 0x4d415720},     /* Marwari (Pakistan) */
	{"mvf", 0x4d4e4720},     /* Peripheral Mongolian -> Mongolian */
	{"mwk", 0x4d4e4b20},     /* Kita Maninkakan -> Maninka */
	/*{"mwl",	0x4d574c20},*/ /* Mirandese */
	{"mwq", 0x51494e20},     /* Mün Chin -> Chin */
	{"mwr", 0x4d415720},     /* Marwari [macrolanguage] */
	{"mww", 0x4d575720},     /* Hmong Daw */
	{"mww", 0x484d4e20},     /* Hmong Daw -> Hmong */
	{"my", 0x42524d20},      /* Burmese */
	{"mym", 0x4d454e20},     /* Me’en */
	/*{"myn",	0x4d594e20},*/ /* Mayan [collection] */
	{"myq", 0x4d4e4b20},     /* Forest Maninka (retired code) (retired code) -> Maninka */
	{"myv", 0x45525a20},     /* Erzya */
	{"mzb", 0x42425220},     /* Tumzabt -> Berber */
	/*{"mzn",	0x4d5a4e20},*/ /* Mazanderani */
	{"mzs", 0x43505020},     /* Macanese -> Creoles */
	{"na", 0x4e415520},      /* Nauru -> Nauruan */
	{"nag", 0x4e414720},     /* Naga Pidgin -> Naga-Assamese */
	{"nag", 0x43505020},     /* Naga Pidgin -> Creoles */
	/*{"nah",	0x4e414820},*/ /* Nahuatl [collection] */
	{"nan", 0x5a485320},     /* Min Nan Chinese -> Chinese, Simplified */
	/*{"nap",	0x4e415020},*/ /* Neapolitan */
	{"nas", 0},              /* Naasioi != Naskapi */
	{"naz", 0x4e414820},     /* Coatepec Nahuatl -> Nahuatl */
	{"nb", 0x4e4f5220},      /* Norwegian Bokmål -> Norwegian */
	{"nch", 0x4e414820},     /* Central Huasteca Nahuatl -> Nahuatl */
	{"nci", 0x4e414820},     /* Classical Nahuatl -> Nahuatl */
	{"ncj", 0x4e414820},     /* Northern Puebla Nahuatl -> Nahuatl */
	{"ncl", 0x4e414820},     /* Michoacán Nahuatl -> Nahuatl */
	{"ncr", 0},              /* Ncane != N-Cree */
	{"ncx", 0x4e414820},     /* Central Puebla Nahuatl -> Nahuatl */
	{"nd", 0x4e444220},      /* North Ndebele -> Ndebele */
	{"ndb", 0},              /* Kenswei Nsei != Ndebele */
	/*{"ndc",	0x4e444320},*/ /* Ndau */
	{"ndg", 0},              /* Ndengereko != Ndonga */
	/*{"nds",	0x4e445320},*/ /* Low Saxon */
	{"ne", 0x4e455020},      /* Nepali [macrolanguage] */
	{"nef", 0x43505020},     /* Nefamese -> Creoles */
	/*{"new",	0x4e455720},*/ /* Newari */
	{"ng", 0x4e444720},      /* Ndonga */
	/*{"nga",	0x4e474120},*/ /* Ngbaka */
	{"ngl", 0x4c4d5720},     /* Lomwe */
	{"ngm", 0x43505020},     /* Ngatik Men's Creole -> Creoles */
	{"ngo", 0x53585420},     /* Ngoni (retired code) (retired code) -> Sutu */
	{"ngu", 0x4e414820},     /* Guerrero Nahuatl -> Nahuatl */
	{"nhc", 0x4e414820},     /* Tabasco Nahuatl -> Nahuatl */
	{"nhd", 0x47554120},     /* Chiripá -> Guarani */
	{"nhe", 0x4e414820},     /* Eastern Huasteca Nahuatl -> Nahuatl */
	{"nhg", 0x4e414820},     /* Tetelcingo Nahuatl -> Nahuatl */
	{"nhi", 0x4e414820},     /* Zacatlán-Ahuacatlán-Tepetzintla Nahuatl -> Nahuatl */
	{"nhk", 0x4e414820},     /* Isthmus-Cosoleacaque Nahuatl -> Nahuatl */
	{"nhm", 0x4e414820},     /* Morelos Nahuatl -> Nahuatl */
	{"nhn", 0x4e414820},     /* Central Nahuatl -> Nahuatl */
	{"nhp", 0x4e414820},     /* Isthmus-Pajapan Nahuatl -> Nahuatl */
	{"nhq", 0x4e414820},     /* Huaxcaleca Nahuatl -> Nahuatl */
	{"nht", 0x4e414820},     /* Ometepec Nahuatl -> Nahuatl */
	{"nhv", 0x4e414820},     /* Temascaltepec Nahuatl -> Nahuatl */
	{"nhw", 0x4e414820},     /* Western Huasteca Nahuatl -> Nahuatl */
	{"nhx", 0x4e414820},     /* Isthmus-Mecayapan Nahuatl -> Nahuatl */
	{"nhy", 0x4e414820},     /* Northern Oaxaca Nahuatl -> Nahuatl */
	{"nhz", 0x4e414820},     /* Santa María La Alta Nahuatl -> Nahuatl */
	{"niq", 0x4b414c20},     /* Nandi -> Kalenjin */
	{"nis", 0},              /* Nimi != Nisi */
	/*{"niu",	0x4e495520},*/ /* Niuean */
	{"niv", 0x47494c20},     /* Gilyak */
	{"njt", 0x43505020},     /* Ndyuka-Trio Pidgin -> Creoles */
	{"njz", 0x4e495320},     /* Nyishi -> Nisi */
	{"nko", 0},              /* Nkonya != N’Ko */
	{"nkx", 0x494a4f20},     /* Nkoroo -> Ijo */
	{"nl", 0x4e4c4420},      /* Dutch */
	{"nla", 0x424d4c20},     /* Ngombale -> Bamileke */
	{"nle", 0x4c554820},     /* East Nyala -> Luyia */
	{"nln", 0x4e414820},     /* Durango Nahuatl (retired code) (retired code) -> Nahuatl */
	{"nlv", 0x4e414820},     /* Orizaba Nahuatl -> Nahuatl */
	{"nn", 0x4e594e20},      /* Norwegian Nynorsk (Nynorsk, Norwegian) */
	{"nn", 0x4e4f5220},      /* Norwegian Nynorsk -> Norwegian */
	{"nnh", 0x424d4c20},     /* Ngiemboon -> Bamileke */
	{"nnz", 0x424d4c20},     /* Nda'nda' -> Bamileke */
	{"no", 0x4e4f5220},      /* Norwegian [macrolanguage] */
	{"nod", 0x4e544120},     /* Northern Thai -> Northern Tai */
	/*{"noe",	0x4e4f4520},*/ /* Nimadi */
	/*{"nog",	0x4e4f4720},*/ /* Nogai */
	/*{"nov",	0x4e4f5620},*/ /* Novial */
	{"npi", 0x4e455020},     /* Nepali */
	{"npl", 0x4e414820},     /* Southeastern Puebla Nahuatl -> Nahuatl */
	{"nqo", 0x4e4b4f20},     /* N’Ko */
	{"nr", 0x4e444220},      /* South Ndebele -> Ndebele */
	{"nsk", 0x4e415320},     /* Naskapi */
	{"nsm", 0},              /* Sumi Naga != Northern Sami */
	/*{"nso",	0x4e534f20},*/ /* Northern Sotho */
	{"nsu", 0x4e414820},     /* Sierra Negra Nahuatl -> Nahuatl */
	{"nto", 0},              /* Ntomba != Esperanto */
	{"nue", 0x42414430},     /* Ngundu -> Banda */
	{"nuu", 0x42414430},     /* Ngbundu -> Banda */
	{"nuz", 0x4e414820},     /* Tlamacazapa Nahuatl -> Nahuatl */
	{"nv", 0x4e415620},      /* Navajo */
	{"nv", 0x41544820},      /* Navajo -> Athapaskan */
	{"nwe", 0x424d4c20},     /* Ngwe -> Bamileke */
	{"ny", 0x43484920},      /* Chichewa (Chewa, Nyanja) */
	{"nyd", 0x4c554820},     /* Nyore -> Luyia */
	/*{"nym",	0x4e594d20},*/ /* Nyamwezi */
	{"nyn", 0x4e4b4c20},     /* Nyankole */
	/*{"nza",	0x4e5a4120},*/ /* Tigon Mbembe -> Mbembe Tigon */
	{"oc", 0x4f434920},      /* Occitan (post 1500) */
	{"oj", 0x4f4a4220},      /* Ojibwa [macrolanguage] -> Ojibway */
	/*{"ojb",	0x4f4a4220},*/ /* Northwestern Ojibwa -> Ojibway */
	{"ojc", 0x4f4a4220},     /* Central Ojibwa -> Ojibway */
	{"ojg", 0x4f4a4220},     /* Eastern Ojibwa -> Ojibway */
	{"ojs", 0x4f435220},     /* Severn Ojibwa -> Oji-Cree */
	{"ojs", 0x4f4a4220},     /* Severn Ojibwa -> Ojibway */
	{"ojw", 0x4f4a4220},     /* Western Ojibwa -> Ojibway */
	{"okd", 0x494a4f20},     /* Okodia -> Ijo */
	{"oki", 0x4b414c20},     /* Okiek -> Kalenjin */
	{"okm", 0x4b4f4820},     /* Middle Korean (10th-16th cent.) -> Korean Old Hangul */
	{"okr", 0x494a4f20},     /* Kirike -> Ijo */
	{"om", 0x4f524f20},      /* Oromo [macrolanguage] */
	{"onx", 0x43505020},     /* Onin Based Pidgin -> Creoles */
	{"oor", 0x43505020},     /* Oorlams -> Creoles */
	{"orc", 0x4f524f20},     /* Orma -> Oromo */
	{"orn", 0x4d4c5920},     /* Orang Kanaq -> Malay */
	{"oro", 0},              /* Orokolo != Oromo */
	{"orr", 0x494a4f20},     /* Oruma -> Ijo */
	{"ors", 0x4d4c5920},     /* Orang Seletar -> Malay */
	{"os", 0x4f535320},      /* Ossetian */
	{"otw", 0x4f4a4220},     /* Ottawa -> Ojibway */
	{"oua", 0x42425220},     /* Tagargrent -> Berber */
	{"pa", 0x50414e20},      /* Punjabi */
	{"paa", 0},              /* Papuan [collection] != Palestinian Aramaic */
	/*{"pag",	0x50414720},*/ /* Pangasinan */
	{"pal", 0},              /* Pahlavi != Pali */
	/*{"pam",	0x50414d20},*/ /* Pampanga -> Pampangan */
	{"pap", 0x50415030},     /* Papiamento -> Papiamentu */
	{"pap", 0x43505020},     /* Papiamento -> Creoles */
	{"pas", 0},              /* Papasena != Pashto */
	/*{"pau",	0x50415520},*/ /* Palauan */
	{"pbt", 0x50415320},     /* Southern Pashto -> Pashto */
	{"pbu", 0x50415320},     /* Northern Pashto -> Pashto */
	/*{"pcc",	0x50434320},*/ /* Bouyei */
	/*{"pcd",	0x50434420},*/ /* Picard */
	{"pce", 0x504c4720},     /* Ruching Palaung -> Palaung */
	{"pck", 0x51494e20},     /* Paite Chin -> Chin */
	{"pcm", 0x43505020},     /* Nigerian Pidgin -> Creoles */
	/*{"pdc",	0x50444320},*/ /* Pennsylvania German */
	{"pdu", 0x4b524e20},     /* Kayan -> Karen */
	{"pea", 0x43505020},     /* Peranakan Indonesian -> Creoles */
	{"pel", 0x4d4c5920},     /* Pekal -> Malay */
	{"pes", 0x46415220},     /* Iranian Persian -> Persian */
	{"pey", 0x43505020},     /* Petjo -> Creoles */
	{"pga", 0x41524120},     /* Sudanese Creole Arabic -> Arabic */
	{"pga", 0x43505020},     /* Sudanese Creole Arabic -> Creoles */
	/*{"phk",	0x50484b20},*/ /* Phake */
	{"pi", 0x50414c20},      /* Pali */
	{"pih", 0x50494820},     /* Pitcairn-Norfolk -> Norfolk */
	{"pih", 0x43505020},     /* Pitcairn-Norfolk -> Creoles */
	{"pil", 0},              /* Yom != Filipino */
	{"pis", 0x43505020},     /* Pijin -> Creoles */
	{"pkh", 0x51494e20},     /* Pankhu -> Chin */
	{"pko", 0x4b414c20},     /* Pökoot -> Kalenjin */
	{"pl", 0x504c4b20},      /* Polish */
	{"plg", 0},              /* Pilagá != Palaung */
	{"plk", 0},              /* Kohistani Shina != Polish */
	{"pll", 0x504c4720},     /* Shwe Palaung -> Palaung */
	{"pln", 0x43505020},     /* Palenquero -> Creoles */
	{"plp", 0x50415020},     /* Palpa (retired code) (retired code) */
	{"plt", 0x4d4c4720},     /* Plateau Malagasy -> Malagasy */
	{"pml", 0x43505020},     /* Lingua Franca -> Creoles */
	/*{"pms",	0x504d5320},*/ /* Piemontese */
	{"pmy", 0x43505020},     /* Papuan Malay -> Creoles */
	/*{"pnb",	0x504e4220},*/ /* Western Panjabi */
	{"poc", 0x4d594e20},     /* Poqomam -> Mayan */
	{"poh", 0x504f4820},     /* Poqomchi' -> Pocomchi */
	{"poh", 0x4d594e20},     /* Poqomchi' -> Mayan */
	/*{"pon",	0x504f4e20},*/ /* Pohnpeian */
	{"pov", 0x43505020},     /* Upper Guinea Crioulo -> Creoles */
	{"ppa", 0x42414720},     /* Pao (retired code) (retired code) -> Baghelkhandi */
	{"pre", 0x43505020},     /* Principense -> Creoles */
	/*{"pro",	0x50524f20},*/ /* Old Provençal (to 1500) -> Provençal / Old Provençal */
	{"prp", 0x47554a20},     /* Parsi (retired code) (retired code) -> Gujarati */
	{"prs", 0x44524920},     /* Dari */
	{"prs", 0x46415220},     /* Dari -> Persian */
	{"ps", 0x50415320},      /* Pashto [macrolanguage] */
	{"pse", 0x4d4c5920},     /* Central Malay -> Malay */
	{"pst", 0x50415320},     /* Central Pashto -> Pashto */
	{"pt", 0x50544720},      /* Portuguese */
	{"pub", 0x51494e20},     /* Purum -> Chin */
	{"puz", 0x51494e20},     /* Purum Naga (retired code) (retired code) -> Chin */
	{"pwo", 0x50574f20},     /* Pwo Western Karen -> Western Pwo Karen */
	{"pwo", 0x4b524e20},     /* Pwo Western Karen -> Karen */
	{"pww", 0x4b524e20},     /* Pwo Northern Karen -> Karen */
	{"qu", 0x51555a20},      /* Quechua [macrolanguage] */
	{"qub", 0x51574820},     /* Huallaga Huánuco Quechua -> Quechua (Peru) */
	{"qub", 0x51555a20},     /* Huallaga Huánuco Quechua -> Quechua */
	{"quc", 0x51554320},     /* K’iche’ */
	{"quc", 0x4d594e20},     /* K'iche' -> Mayan */
	{"qud", 0x51564920},     /* Calderón Highland Quichua -> Quechua (Ecuador) */
	{"qud", 0x51555a20},     /* Calderón Highland Quichua -> Quechua */
	{"quf", 0x51555a20},     /* Lambayeque Quechua -> Quechua */
	{"qug", 0x51564920},     /* Chimborazo Highland Quichua -> Quechua (Ecuador) */
	{"qug", 0x51555a20},     /* Chimborazo Highland Quichua -> Quechua */
	{"quh", 0x51554820},     /* South Bolivian Quechua -> Quechua (Bolivia) */
	{"quh", 0x51555a20},     /* South Bolivian Quechua -> Quechua */
	{"quk", 0x51555a20},     /* Chachapoyas Quechua -> Quechua */
	{"qul", 0x51554820},     /* North Bolivian Quechua -> Quechua (Bolivia) */
	{"qul", 0x51555a20},     /* North Bolivian Quechua -> Quechua */
	{"qum", 0x4d594e20},     /* Sipacapense -> Mayan */
	{"qup", 0x51564920},     /* Southern Pastaza Quechua -> Quechua (Ecuador) */
	{"qup", 0x51555a20},     /* Southern Pastaza Quechua -> Quechua */
	{"qur", 0x51574820},     /* Yanahuanca Pasco Quechua -> Quechua (Peru) */
	{"qur", 0x51555a20},     /* Yanahuanca Pasco Quechua -> Quechua */
	{"qus", 0x51554820},     /* Santiago del Estero Quichua -> Quechua (Bolivia) */
	{"qus", 0x51555a20},     /* Santiago del Estero Quichua -> Quechua */
	{"quv", 0x4d594e20},     /* Sacapulteco -> Mayan */
	{"quw", 0x51564920},     /* Tena Lowland Quichua -> Quechua (Ecuador) */
	{"quw", 0x51555a20},     /* Tena Lowland Quichua -> Quechua */
	{"qux", 0x51574820},     /* Yauyos Quechua -> Quechua (Peru) */
	{"qux", 0x51555a20},     /* Yauyos Quechua -> Quechua */
	{"quy", 0x51555a20},     /* Ayacucho Quechua -> Quechua */
	/*{"quz",	0x51555a20},*/ /* Cusco Quechua -> Quechua */
	{"qva", 0x51574820},     /* Ambo-Pasco Quechua -> Quechua (Peru) */
	{"qva", 0x51555a20},     /* Ambo-Pasco Quechua -> Quechua */
	{"qvc", 0x51555a20},     /* Cajamarca Quechua -> Quechua */
	{"qve", 0x51555a20},     /* Eastern Apurímac Quechua -> Quechua */
	{"qvh", 0x51574820},     /* Huamalíes-Dos de Mayo Huánuco Quechua -> Quechua (Peru) */
	{"qvh", 0x51555a20},     /* Huamalíes-Dos de Mayo Huánuco Quechua -> Quechua */
	{"qvi", 0x51564920},     /* Imbabura Highland Quichua -> Quechua (Ecuador) */
	{"qvi", 0x51555a20},     /* Imbabura Highland Quichua -> Quechua */
	{"qvj", 0x51564920},     /* Loja Highland Quichua -> Quechua (Ecuador) */
	{"qvj", 0x51555a20},     /* Loja Highland Quichua -> Quechua */
	{"qvl", 0x51574820},     /* Cajatambo North Lima Quechua -> Quechua (Peru) */
	{"qvl", 0x51555a20},     /* Cajatambo North Lima Quechua -> Quechua */
	{"qvm", 0x51574820},     /* Margos-Yarowilca-Lauricocha Quechua -> Quechua (Peru) */
	{"qvm", 0x51555a20},     /* Margos-Yarowilca-Lauricocha Quechua -> Quechua */
	{"qvn", 0x51574820},     /* North Junín Quechua -> Quechua (Peru) */
	{"qvn", 0x51555a20},     /* North Junín Quechua -> Quechua */
	{"qvo", 0x51564920},     /* Napo Lowland Quechua -> Quechua (Ecuador) */
	{"qvo", 0x51555a20},     /* Napo Lowland Quechua -> Quechua */
	{"qvp", 0x51574820},     /* Pacaraos Quechua -> Quechua (Peru) */
	{"qvp", 0x51555a20},     /* Pacaraos Quechua -> Quechua */
	{"qvs", 0x51555a20},     /* San Martín Quechua -> Quechua */
	{"qvw", 0x51574820},     /* Huaylla Wanca Quechua -> Quechua (Peru) */
	{"qvw", 0x51555a20},     /* Huaylla Wanca Quechua -> Quechua */
	{"qvz", 0x51564920},     /* Northern Pastaza Quichua -> Quechua (Ecuador) */
	{"qvz", 0x51555a20},     /* Northern Pastaza Quichua -> Quechua */
	{"qwa", 0x51574820},     /* Corongo Ancash Quechua -> Quechua (Peru) */
	{"qwa", 0x51555a20},     /* Corongo Ancash Quechua -> Quechua */
	{"qwc", 0x51555a20},     /* Classical Quechua -> Quechua */
	{"qwh", 0x51574820},     /* Huaylas Ancash Quechua -> Quechua (Peru) */
	{"qwh", 0x51555a20},     /* Huaylas Ancash Quechua -> Quechua */
	{"qws", 0x51574820},     /* Sihuas Ancash Quechua -> Quechua (Peru) */
	{"qws", 0x51555a20},     /* Sihuas Ancash Quechua -> Quechua */
	{"qwt", 0x41544820},     /* Kwalhioqua-Tlatskanai -> Athapaskan */
	{"qxa", 0x51574820},     /* Chiquián Ancash Quechua -> Quechua (Peru) */
	{"qxa", 0x51555a20},     /* Chiquián Ancash Quechua -> Quechua */
	{"qxc", 0x51574820},     /* Chincha Quechua -> Quechua (Peru) */
	{"qxc", 0x51555a20},     /* Chincha Quechua -> Quechua */
	{"qxh", 0x51574820},     /* Panao Huánuco Quechua -> Quechua (Peru) */
	{"qxh", 0x51555a20},     /* Panao Huánuco Quechua -> Quechua */
	{"qxl", 0x51564920},     /* Salasaca Highland Quichua -> Quechua (Ecuador) */
	{"qxl", 0x51555a20},     /* Salasaca Highland Quichua -> Quechua */
	{"qxn", 0x51574820},     /* Northern Conchucos Ancash Quechua -> Quechua (Peru) */
	{"qxn", 0x51555a20},     /* Northern Conchucos Ancash Quechua -> Quechua */
	{"qxo", 0x51574820},     /* Southern Conchucos Ancash Quechua -> Quechua (Peru) */
	{"qxo", 0x51555a20},     /* Southern Conchucos Ancash Quechua -> Quechua */
	{"qxp", 0x51555a20},     /* Puno Quechua -> Quechua */
	{"qxr", 0x51564920},     /* Cañar Highland Quichua -> Quechua (Ecuador) */
	{"qxr", 0x51555a20},     /* Cañar Highland Quichua -> Quechua */
	{"qxt", 0x51574820},     /* Santa Ana de Tusi Pasco Quechua -> Quechua (Peru) */
	{"qxt", 0x51555a20},     /* Santa Ana de Tusi Pasco Quechua -> Quechua */
	{"qxu", 0x51555a20},     /* Arequipa-La Unión Quechua -> Quechua */
	{"qxw", 0x51574820},     /* Jauja Wanca Quechua -> Quechua (Peru) */
	{"qxw", 0x51555a20},     /* Jauja Wanca Quechua -> Quechua */
	{"rag", 0x4c554820},     /* Logooli -> Luyia */
	/*{"raj",	0x52414a20},*/ /* Rajasthani [macrolanguage] */
	{"ral", 0x51494e20},     /* Ralte -> Chin */
	/*{"rar",	0x52415220},*/ /* Rarotongan */
	{"rbb", 0x504c4720},     /* Rumai Palaung -> Palaung */
	{"rbl", 0x42494b20},     /* Miraya Bikol -> Bikol */
	{"rcf", 0x43505020},     /* Réunion Creole French -> Creoles */
	/*{"rej",	0x52454a20},*/ /* Rejang */
	/*{"rhg",	0x52484720},*/ /* Rohingya */
	/*{"ria",	0x52494120},*/ /* Riang (India) */
	{"rif", 0x52494620},     /* Tarifit */
	{"rif", 0x42425220},     /* Tarifit -> Berber */
	/*{"rit",	0x52495420},*/ /* Ritharrngu -> Ritarungo */
	{"rki", 0x41524b20},     /* Rakhine */
	/*{"rkw",	0x524b5720},*/ /* Arakwal */
	{"rm", 0x524d5320},      /* Romansh */
	{"rmc", 0x524f5920},     /* Carpathian Romani -> Romany */
	{"rmf", 0x524f5920},     /* Kalo Finnish Romani -> Romany */
	{"rml", 0x524f5920},     /* Baltic Romani -> Romany */
	{"rmn", 0x524f5920},     /* Balkan Romani -> Romany */
	{"rmo", 0x524f5920},     /* Sinte Romani -> Romany */
	{"rms", 0},              /* Romanian Sign Language != Romansh */
	{"rmw", 0x524f5920},     /* Welsh Romani -> Romany */
	{"rmy", 0x524d5920},     /* Vlax Romani */
	{"rmy", 0x524f5920},     /* Vlax Romani -> Romany */
	{"rmz", 0x41524b20},     /* Marma -> Rakhine */
	{"rn", 0x52554e20},      /* Rundi */
	{"ro", 0x524f4d20},      /* Romanian */
	{"rom", 0x524f5920},     /* Romany [macrolanguage] */
	{"rop", 0x43505020},     /* Kriol -> Creoles */
	{"rtc", 0x51494e20},     /* Rungtu Chin -> Chin */
	/*{"rtm",	0x52544d20},*/ /* Rotuman */
	{"ru", 0x52555320},      /* Russian */
	{"rue", 0x52535920},     /* Rusyn */
	/*{"rup",	0x52555020},*/ /* Aromanian */
	{"rw", 0x52554120},      /* Kinyarwanda */
	{"rwr", 0x4d415720},     /* Marwari (India) */
	{"sa", 0x53414e20},      /* Sanskrit */
	{"sad", 0},              /* Sandawe != Sadri */
	{"sah", 0x59414b20},     /* Yakut -> Sakha */
	{"sam", 0x50414120},     /* Samaritan Aramaic -> Palestinian Aramaic */
	/*{"sas",	0x53415320},*/ /* Sasak */
	/*{"sat",	0x53415420},*/ /* Santali */
	{"say", 0},              /* Saya != Sayisi */
	{"sc", 0x53524420},      /* Sardinian [macrolanguage] */
	{"scf", 0x43505020},     /* San Miguel Creole French -> Creoles */
	{"sch", 0x51494e20},     /* Sakachep -> Chin */
	{"sci", 0x43505020},     /* Sri Lankan Creole Malay -> Creoles */
	{"sck", 0x53414420},     /* Sadri */
	/*{"scn",	0x53434e20},*/ /* Sicilian */
	/*{"sco",	0x53434f20},*/ /* Scots */
	{"scs", 0x53435320},     /* North Slavey */
	{"scs", 0x534c4120},     /* North Slavey -> Slavey */
	{"scs", 0x41544820},     /* North Slavey -> Athapaskan */
	{"sd", 0x534e4420},      /* Sindhi */
	{"sdc", 0x53524420},     /* Sassarese Sardinian -> Sardinian */
	{"sdh", 0x4b555220},     /* Southern Kurdish -> Kurdish */
	{"sdn", 0x53524420},     /* Gallurese Sardinian -> Sardinian */
	{"sds", 0x42425220},     /* Sened -> Berber */
	{"se", 0x4e534d20},      /* Northern Sami */
	{"seh", 0x534e4120},     /* Sena */
	{"sek", 0x41544820},     /* Sekani -> Athapaskan */
	/*{"sel",	0x53454c20},*/ /* Selkup */
	{"sez", 0x51494e20},     /* Senthang Chin -> Chin */
	{"sfm", 0x53464d20},     /* Small Flowery Miao */
	{"sfm", 0x484d4e20},     /* Small Flowery Miao -> Hmong */
	{"sg", 0x53474f20},      /* Sango */
	/*{"sga",	0x53474120},*/ /* Old Irish (to 900) */
	{"sgc", 0x4b414c20},     /* Kipsigis -> Kalenjin */
	{"sgo", 0},              /* Songa (retired code) (retired code) != Sango */
	/*{"sgs",	0x53475320},*/ /* Samogitian */
	{"sgw", 0x43484720},     /* Sebat Bet Gurage -> Chaha Gurage */
	{"sh", 0x424f5320},      /* Serbo-Croatian [macrolanguage] -> Bosnian */
	{"sh", 0x48525620},      /* Serbo-Croatian [macrolanguage] -> Croatian */
	{"sh", 0x53524220},      /* Serbo-Croatian [macrolanguage] -> Serbian */
	{"shi", 0x53484920},     /* Tachelhit */
	{"shi", 0x42425220},     /* Tachelhit -> Berber */
	{"shl", 0x51494e20},     /* Shendu -> Chin */
	/*{"shn",	0x53484e20},*/ /* Shan */
	{"shu", 0x41524120},     /* Chadian Arabic -> Arabic */
	{"shy", 0x42425220},     /* Tachawit -> Berber */
	{"si", 0x534e4820},      /* Sinhala (Sinhalese) */
	{"sib", 0},              /* Sebop != Sibe */
	/*{"sid",	0x53494420},*/ /* Sidamo */
	{"sig", 0},              /* Paasaal != Silte Gurage */
	{"siz", 0x42425220},     /* Siwi -> Berber */
	{"sjd", 0x4b534d20},     /* Kildin Sami */
	{"sjo", 0x53494220},     /* Xibe -> Sibe */
	{"sjs", 0x42425220},     /* Senhaja De Srair -> Berber */
	{"sk", 0x534b5920},      /* Slovak */
	{"skg", 0x4d4c4720},     /* Sakalava Malagasy -> Malagasy */
	{"skr", 0x53524b20},     /* Saraiki */
	{"sks", 0},              /* Maia != Skolt Sami */
	{"skw", 0x43505020},     /* Skepi Creole Dutch -> Creoles */
	{"sky", 0},              /* Sikaiana != Slovak */
	{"sl", 0x534c5620},      /* Slovenian */
	{"sla", 0},              /* Slavic [collection] != Slavey */
	{"sm", 0x534d4f20},      /* Samoan */
	{"sma", 0x53534d20},     /* Southern Sami */
	{"smd", 0x4d424e20},     /* Sama (retired code) (retired code) -> Mbundu */
	{"smj", 0x4c534d20},     /* Lule Sami */
	{"sml", 0},              /* Central Sama != Somali */
	{"smn", 0x49534d20},     /* Inari Sami */
	{"sms", 0x534b5320},     /* Skolt Sami */
	{"smt", 0x51494e20},     /* Simte -> Chin */
	{"sn", 0x534e4130},      /* Shona */
	{"snb", 0x49424120},     /* Sebuyau (retired code) (retired code) -> Iban */
	{"snh", 0},              /* Shinabo (retired code) (retired code) != Sinhala (Sinhalese) */
	/*{"snk",	0x534e4b20},*/ /* Soninke */
	{"so", 0x534d4c20},      /* Somali */
	{"sog", 0},              /* Sogdian != Sodo Gurage */
	/*{"sop",	0x534f5020},*/ /* Songe */
	{"spy", 0x4b414c20},     /* Sabaot -> Kalenjin */
	{"sq", 0x53514920},      /* Albanian [macrolanguage] */
	{"sr", 0x53524220},      /* Serbian */
	{"srb", 0},              /* Sora != Serbian */
	{"src", 0x53524420},     /* Logudorese Sardinian -> Sardinian */
	{"srk", 0},              /* Serudung Murut != Saraiki */
	{"srm", 0x43505020},     /* Saramaccan -> Creoles */
	{"srn", 0x43505020},     /* Sranan Tongo -> Creoles */
	{"sro", 0x53524420},     /* Campidanese Sardinian -> Sardinian */
	/*{"srr",	0x53525220},*/ /* Serer */
	{"srs", 0x41544820},     /* Sarsi -> Athapaskan */
	{"ss", 0x53575a20},      /* Swati */
	{"ssh", 0x41524120},     /* Shihhi Arabic -> Arabic */
	{"ssl", 0},              /* Western Sisaala != South Slavey */
	{"ssm", 0},              /* Semnam != Southern Sami */
	{"st", 0x534f5420},      /* Southern Sotho */
	{"sta", 0x43505020},     /* Settla -> Creoles */
	/*{"stq",	0x53545120},*/ /* Saterfriesisch -> Saterland Frisian */
	{"stv", 0x53494720},     /* Silt'e -> Silte Gurage */
	{"su", 0x53554e20},      /* Sundanese */
	/*{"suk",	0x53554b20},*/ /* Sukuma */
	{"suq", 0x53555220},     /* Suri */
	{"sur", 0},              /* Mwaghavul != Suri */
	{"sv", 0x53564520},      /* Swedish */
	/*{"sva",	0x53564120},*/ /* Svan */
	{"svc", 0x43505020},     /* Vincentian Creole English -> Creoles */
	{"sve", 0},              /* Serili != Swedish */
	{"sw", 0x53574b20},      /* Swahili [macrolanguage] */
	{"swb", 0x434d5220},     /* Maore Comorian -> Comorian */
	{"swc", 0x53574b20},     /* Congo Swahili -> Swahili */
	{"swh", 0x53574b20},     /* Swahili */
	{"swk", 0},              /* Malawi Sena != Swahili */
	{"swn", 0x42425220},     /* Sawknah -> Berber */
	{"swv", 0x4d415720},     /* Shekhawati -> Marwari */
	/*{"sxu",	0x53585520},*/ /* Upper Saxon */
	{"syc", 0x53595220},     /* Classical Syriac -> Syriac */
	/*{"syl",	0x53594c20},*/ /* Sylheti */
	/*{"syr",	0x53595220},*/ /* Syriac [macrolanguage] */
	/*{"szl",	0x535a4c20},*/ /* Silesian */
	{"ta", 0x54414d20},      /* Tamil */
	{"taa", 0x41544820},     /* Lower Tanana -> Athapaskan */
	/*{"tab",	0x54414220},*/ /* Tabassaran -> Tabasaran */
	{"taj", 0},              /* Eastern Tamang != Tajiki */
	{"taq", 0x544d4820},     /* Tamasheq -> Tamashek */
	{"taq", 0x42425220},     /* Tamasheq -> Berber */
	{"tas", 0x43505020},     /* Tay Boi -> Creoles */
	{"tau", 0x41544820},     /* Upper Tanana -> Athapaskan */
	{"tcb", 0x41544820},     /* Tanacross -> Athapaskan */
	{"tce", 0x41544820},     /* Southern Tutchone -> Athapaskan */
	{"tch", 0x43505020},     /* Turks And Caicos Creole English -> Creoles */
	{"tcp", 0x51494e20},     /* Tawr Chin -> Chin */
	{"tcs", 0x43505020},     /* Torres Strait Creole -> Creoles */
	{"tcy", 0x54554c20},     /* Tulu */
	{"tcz", 0x51494e20},     /* Thado Chin -> Chin */
	/*{"tdd",	0x54444420},*/ /* Tai Nüa -> Dehong Dai */
	{"tdx", 0x4d4c4720},     /* Tandroy-Mahafaly Malagasy -> Malagasy */
	{"te", 0x54454c20},      /* Telugu */
	{"tec", 0x4b414c20},     /* Terik -> Kalenjin */
	{"tem", 0x544d4e20},     /* Timne -> Temne */
	/*{"tet",	0x54455420},*/ /* Tetum */
	{"tez", 0x42425220},     /* Tetserret -> Berber */
	{"tfn", 0x41544820},     /* Tanaina -> Athapaskan */
	{"tg", 0x54414a20},      /* Tajik -> Tajiki */
	{"tgh", 0x43505020},     /* Tobagonian Creole English -> Creoles */
	{"tgj", 0x4e495320},     /* Tagin -> Nisi */
	{"tgn", 0},              /* Tandaganon != Tongan */
	{"tgr", 0},              /* Tareng != Tigre */
	{"tgx", 0x41544820},     /* Tagish -> Athapaskan */
	{"tgy", 0},              /* Togoyo != Tigrinya */
	{"th", 0x54484120},      /* Thai */
	{"tht", 0x41544820},     /* Tahltan -> Athapaskan */
	{"thv", 0x544d4820},     /* Tahaggart Tamahaq -> Tamashek */
	{"thv", 0x42425220},     /* Tahaggart Tamahaq -> Berber */
	{"thz", 0x544d4820},     /* Tayart Tamajeq -> Tamashek */
	{"thz", 0x42425220},     /* Tayart Tamajeq -> Berber */
	{"ti", 0x54475920},      /* Tigrinya */
	{"tia", 0x42425220},     /* Tidikelt Tamazight -> Berber */
	{"tig", 0x54475220},     /* Tigre */
	/*{"tiv",	0x54495620},*/ /* Tiv */
	/*{"tjl",	0x544a4c20},*/ /* Tai Laing */
	{"tjo", 0x42425220},     /* Temacine Tamazight -> Berber */
	{"tk", 0x544b4d20},      /* Turkmen */
	{"tkg", 0x4d4c4720},     /* Tesaka Malagasy -> Malagasy */
	{"tkm", 0},              /* Takelma != Turkmen */
	{"tl", 0x54474c20},      /* Tagalog */
	/*{"tli",	0x544c4920},*/ /* Tlingit */
	{"tmg", 0x43505020},     /* Ternateño -> Creoles */
	{"tmh", 0x544d4820},     /* Tamashek [macrolanguage] */
	{"tmh", 0x42425220},     /* Tamashek [macrolanguage] -> Berber */
	{"tmn", 0},              /* Taman (Indonesia) != Temne */
	{"tmw", 0x4d4c5920},     /* Temuan -> Malay */
	{"tn", 0x544e4120},      /* Tswana */
	{"tna", 0},              /* Tacana != Tswana */
	{"tne", 0},              /* Tinoc Kallahan (retired code) (retired code) != Tundra Enets */
	{"tnf", 0x44524920},     /* Tangshewi (retired code) (retired code) -> Dari */
	{"tnf", 0x46415220},     /* Tangshewi (retired code) (retired code) -> Persian */
	{"tng", 0},              /* Tobanga != Tonga */
	{"to", 0x54474e20},      /* Tonga (Tonga Islands) -> Tongan */
	{"tod", 0x544f4430},     /* Toma */
	{"toi", 0x544e4720},     /* Tonga (Zambia) */
	{"toj", 0x4d594e20},     /* Tojolabal -> Mayan */
	{"tol", 0x41544820},     /* Tolowa -> Athapaskan */
	{"tor", 0x42414430},     /* Togbo-Vara Banda -> Banda */
	{"tpi", 0x54504920},     /* Tok Pisin */
	{"tpi", 0x43505020},     /* Tok Pisin -> Creoles */
	{"tr", 0x54524b20},      /* Turkish */
	{"trf", 0x43505020},     /* Trinidadian Creole English -> Creoles */
	{"trk", 0},              /* Turkic [collection] != Turkish */
	{"tru", 0x54554120},     /* Turoyo -> Turoyo Aramaic */
	{"tru", 0x53595220},     /* Turoyo -> Syriac */
	{"ts", 0x54534720},      /* Tsonga */
	{"tsg", 0},              /* Tausug != Tsonga */
	/*{"tsj",	0x54534a20},*/ /* Tshangla */
	{"tt", 0x54415420},      /* Tatar */
	{"ttc", 0x4d594e20},     /* Tektiteko -> Mayan */
	{"ttm", 0x41544820},     /* Northern Tutchone -> Athapaskan */
	{"ttq", 0x544d4820},     /* Tawallammat Tamajaq -> Tamashek */
	{"ttq", 0x42425220},     /* Tawallammat Tamajaq -> Berber */
	{"tua", 0},              /* Wiarumus != Turoyo Aramaic */
	{"tul", 0},              /* Tula != Tulu */
	/*{"tum",	0x54554d20},*/ /* Tumbuka */
	{"tuu", 0x41544820},     /* Tututni -> Athapaskan */
	{"tuv", 0},              /* Turkana != Tuvin */
	{"tuy", 0x4b414c20},     /* Tugen -> Kalenjin */
	/*{"tvl",	0x54564c20},*/ /* Tuvalu */
	{"tvy", 0x43505020},     /* Timor Pidgin -> Creoles */
	{"tw", 0x54574920},      /* Twi */
	{"tw", 0x414b4120},      /* Twi -> Akan */
	{"txc", 0x41544820},     /* Tsetsaut -> Athapaskan */
	{"txy", 0x4d4c4720},     /* Tanosy Malagasy -> Malagasy */
	{"ty", 0x54485420},      /* Tahitian */
	{"tyv", 0x54555620},     /* Tuvinian -> Tuvin */
	/*{"tyz",	0x54595a20},*/ /* Tày */
	{"tzh", 0x4d594e20},     /* Tzeltal -> Mayan */
	{"tzj", 0x4d594e20},     /* Tz'utujil -> Mayan */
	{"tzm", 0x545a4d20},     /* Central Atlas Tamazight -> Tamazight */
	{"tzm", 0x42425220},     /* Central Atlas Tamazight -> Berber */
	{"tzo", 0x545a4f20},     /* Tzotzil */
	{"tzo", 0x4d594e20},     /* Tzotzil -> Mayan */
	{"ubl", 0x42494b20},     /* Buhi'non Bikol -> Bikol */
	/*{"udm",	0x55444d20},*/ /* Udmurt */
	{"ug", 0x55594720},      /* Uyghur */
	{"uk", 0x554b5220},      /* Ukrainian */
	{"uki", 0x4b554920},     /* Kui (India) */
	{"uln", 0x43505020},     /* Unserdeutsch -> Creoles */
	/*{"umb",	0x554d4220},*/ /* Umbundu */
	{"unr", 0x4d554e20},     /* Mundari */
	{"ur", 0x55524420},      /* Urdu */
	{"urk", 0x4d4c5920},     /* Urak Lawoi' -> Malay */
	{"usp", 0x4d594e20},     /* Uspanteco -> Mayan */
	{"uz", 0x555a4220},      /* Uzbek [macrolanguage] */
	{"uzn", 0x555a4220},     /* Northern Uzbek -> Uzbek */
	{"uzs", 0x555a4220},     /* Southern Uzbek -> Uzbek */
	{"vap", 0x51494e20},     /* Vaiphei -> Chin */
	{"ve", 0x56454e20},      /* Venda */
	/*{"vec",	0x56454320},*/ /* Venetian */
	{"vi", 0x56495420},      /* Vietnamese */
	{"vic", 0x43505020},     /* Virgin Islands Creole English -> Creoles */
	{"vit", 0},              /* Viti != Vietnamese */
	{"vkk", 0x4d4c5920},     /* Kaur -> Malay */
	{"vkp", 0x43505020},     /* Korlai Creole Portuguese -> Creoles */
	{"vkt", 0x4d4c5920},     /* Tenggarong Kutai Malay -> Malay */
	{"vls", 0x464c4520},     /* Vlaams -> Dutch (Flemish) */
	{"vmw", 0x4d414b20},     /* Makhuwa */
	{"vo", 0x564f4c20},      /* Volapük */
	/*{"vro",	0x56524f20},*/ /* Võro */
	{"wa", 0x574c4e20},      /* Walloon */
	{"wag", 0},              /* Wa'ema != Wagdi */
	/*{"war",	0x57415220},*/ /* Waray (Philippines) -> Waray-Waray */
	{"wbm", 0x57412020},     /* Wa */
	{"wbr", 0x57414720},     /* Wagdi */
	{"wbr", 0x52414a20},     /* Wagdi -> Rajasthani */
	/*{"wci",	0x57434920},*/ /* Waci Gbe */
	{"wea", 0x4b524e20},     /* Wewaw -> Karen */
	{"wes", 0x43505020},     /* Cameroon Pidgin -> Creoles */
	{"weu", 0x51494e20},     /* Rawngtu Chin -> Chin */
	{"wlc", 0x434d5220},     /* Mwali Comorian -> Comorian */
	{"wle", 0x53494720},     /* Wolane -> Silte Gurage */
	{"wlk", 0x41544820},     /* Wailaki -> Athapaskan */
	{"wni", 0x434d5220},     /* Ndzwani Comorian -> Comorian */
	{"wo", 0x574c4620},      /* Wolof */
	{"wry", 0x4d415720},     /* Merwari -> Marwari */
	{"wsg", 0x474f4e20},     /* Adilabad Gondi -> Gondi */
	/*{"wtm",	0x57544d20},*/ /* Mewati */
	{"wuu", 0x5a485320},     /* Wu Chinese -> Chinese, Simplified */
	{"xal", 0x4b4c4d20},     /* Kalmyk */
	{"xal", 0x544f4420},     /* Kalmyk -> Todo */
	{"xan", 0x53454b20},     /* Xamtanga -> Sekota */
	{"xbd", 0},              /* Bindal != Lü */
	{"xh", 0x58485320},      /* Xhosa */
	/*{"xjb",	0x584a4220},*/ /* Minjungbal -> Minjangbal */
	/*{"xkf",	0x584b4620},*/ /* Khengkha */
	{"xmg", 0x424d4c20},     /* Mengaka -> Bamileke */
	{"xmm", 0x4d4c5920},     /* Manado Malay -> Malay */
	{"xmm", 0x43505020},     /* Manado Malay -> Creoles */
	{"xmv", 0x4d4c4720},     /* Antankarana Malagasy -> Malagasy */
	{"xmw", 0x4d4c4720},     /* Tsimihety Malagasy -> Malagasy */
	{"xnj", 0x53585420},     /* Ngoni (Tanzania) -> Sutu */
	{"xnq", 0x53585420},     /* Ngoni (Mozambique) -> Sutu */
	{"xnr", 0x44475220},     /* Kangri -> Dogri (macrolanguage) */
	/*{"xog",	0x584f4720},*/ /* Soga */
	{"xpe", 0x58504520},     /* Liberia Kpelle -> Kpelle (Liberia) */
	{"xpe", 0x4b504c20},     /* Liberia Kpelle -> Kpelle */
	{"xsl", 0x53534c20},     /* South Slavey */
	{"xsl", 0x534c4120},     /* South Slavey -> Slavey */
	{"xsl", 0x41544820},     /* South Slavey -> Athapaskan */
	{"xst", 0x53494720},     /* Silt'e (retired code) -> Silte Gurage */
	/*{"xub",	0x58554220},*/ /* Betta Kurumba -> Bette Kuruma */
	/*{"xuj",	0x58554a20},*/ /* Jennu Kurumba -> Jennu Kuruma */
	{"xup", 0x41544820},     /* Upper Umpqua -> Athapaskan */
	{"xwo", 0x544f4420},     /* Written Oirat -> Todo */
	{"yaj", 0x42414430},     /* Banda-Yangere -> Banda */
	{"yak", 0},              /* Yakama != Sakha */
	/*{"yao",	0x59414f20},*/ /* Yao */
	/*{"yap",	0x59415020},*/ /* Yapese */
	{"yba", 0},              /* Yala != Yoruba */
	{"ybb", 0x424d4c20},     /* Yemba -> Bamileke */
	{"ybd", 0x41524b20},     /* Yangbye (retired code) (retired code) -> Rakhine */
	{"ycr", 0},              /* Yilan Creole != Y-Cree */
	{"ydd", 0x4a494920},     /* Eastern Yiddish -> Yiddish */
	/*{"ygp",	0x59475020},*/ /* Gepo */
	{"yi", 0x4a494920},      /* Yiddish [macrolanguage] */
	{"yih", 0x4a494920},     /* Western Yiddish -> Yiddish */
	{"yim", 0},              /* Yimchungru Naga != Yi Modern */
	/*{"yna",	0x594e4120},*/ /* Aluo */
	{"yo", 0x59424120},      /* Yoruba */
	{"yos", 0x51494e20},     /* Yos (retired code) (retired code) -> Chin */
	{"yua", 0x4d594e20},     /* Yucateco -> Mayan */
	{"yue", 0x5a484820},     /* Yue Chinese -> Chinese, Traditional, Hong Kong SAR */
	/*{"ywq",	0x59575120},*/ /* Wuding-Luquan Yi */
	{"za", 0x5a484120},      /* Zhuang [macrolanguage] */
	{"zch", 0x5a484120},     /* Central Hongshuihe Zhuang -> Zhuang */
	{"zdj", 0x434d5220},     /* Ngazidja Comorian -> Comorian */
	/*{"zea",	0x5a454120},*/ /* Zeeuws -> Zealandic */
	{"zeh", 0x5a484120},     /* Eastern Hongshuihe Zhuang -> Zhuang */
	{"zen", 0x42425220},     /* Zenaga -> Berber */
	{"zgb", 0x5a484120},     /* Guibei Zhuang -> Zhuang */
	{"zgh", 0x5a474820},     /* Standard Moroccan Tamazight */
	{"zgh", 0x42425220},     /* Standard Moroccan Tamazight -> Berber */
	{"zgm", 0x5a484120},     /* Minz Zhuang -> Zhuang */
	{"zgn", 0x5a484120},     /* Guibian Zhuang -> Zhuang */
	{"zh", 0x5a485320},      /* Chinese, Simplified [macrolanguage] */
	{"zhd", 0x5a484120},     /* Dai Zhuang -> Zhuang */
	{"zhn", 0x5a484120},     /* Nong Zhuang -> Zhuang */
	{"zkb", 0x4b484120},     /* Koibal (retired code) (retired code) -> Khakass */
	{"zlj", 0x5a484120},     /* Liujiang Zhuang -> Zhuang */
	{"zlm", 0x4d4c5920},     /* Malay */
	{"zln", 0x5a484120},     /* Lianshan Zhuang -> Zhuang */
	{"zlq", 0x5a484120},     /* Liuqian Zhuang -> Zhuang */
	{"zmi", 0x4d4c5920},     /* Negeri Sembilan Malay -> Malay */
	{"zmz", 0x42414430},     /* Mbandja -> Banda */
	{"znd", 0},              /* Zande [collection] != Zande */
	{"zne", 0x5a4e4420},     /* Zande */
	{"zom", 0x51494e20},     /* Zou -> Chin */
	{"zqe", 0x5a484120},     /* Qiubei Zhuang -> Zhuang */
	{"zsm", 0x4d4c5920},     /* Standard Malay -> Malay */
	{"zu", 0x5a554c20},      /* Zulu */
	{"zum", 0x4c524320},     /* Kumzari -> Luri */
	{"zyb", 0x5a484120},     /* Yongbei Zhuang -> Zhuang */
	{"zyg", 0x5a484120},     /* Yang Zhuang -> Zhuang */
	{"zyj", 0x5a484120},     /* Youjiang Zhuang -> Zhuang */
	{"zyn", 0x5a484120},     /* Yongnan Zhuang -> Zhuang */
	{"zyp", 0x51494e20},     /* Zyphe Chin -> Chin */
	/*{"zza",	0x5a5a4120},*/ /* Zazaki [macrolanguage] */
	{"zzj", 0x5a484120},     /* Zuojiang Zhuang -> Zhuang */
	{"||", 0x4f524920},      /*  -> Odia (formerly Oriya) */
}

// Converts a multi-subtag BCP 47 language tag to language tags.
func tagsFromComplexLanguage(langStr string) []loader.Tag {
	if subtagMatches(langStr, "fonnapa") {
		/* Undetermined; North American Phonetic Alphabet */

		return []loader.Tag{0x41505048} /*  */
	}
	if subtagMatches(langStr, "fonipa") {
		/* Undetermined; International Phonetic Alphabet */

		return []loader.Tag{0x49505048} /*  */
	}
	if subtagMatches(langStr, "geok") {
		/* Undetermined;  */

		return []loader.Tag{0x4b474520} /* Khutsuri Georgian */
	}
	if subtagMatches(langStr, "syre") {
		/* Undetermined;  */

		return []loader.Tag{0x53595245} /* Syriac, Estrangela script-variant (equivalent to ISO 15924 'Syre') */
	}
	if subtagMatches(langStr, "syrj") {
		/* Undetermined;  */

		return []loader.Tag{0x5359524a} /* Syriac, Western script-variant (equivalent to ISO 15924 'Syrj') */
	}
	if subtagMatches(langStr, "syrn") {
		/* Undetermined;  */

		return []loader.Tag{0x5359524e} /* Syriac, Eastern script-variant (equivalent to ISO 15924 'Syrn') */
	}

	switch langStr[0] {
	case 'a':
		if langStr[1:] == "rt-lojban" {
			/* Lojban (retired code) (retired code) */
			return []loader.Tag{0x4a424f20} /* Lojban */
		}

	case 'c':
		if langMatches(langStr[1:], "do-hant-hk") {
			/* Min Dong Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "do-hant-mo") {
			/* Min Dong Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langMatches(langStr[1:], "jy-hant-hk") {
			/* Jinyu Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "jy-hant-mo") {
			/* Jinyu Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langMatches(langStr[1:], "mn-hant-hk") {
			/* Mandarin Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "mn-hant-mo") {
			/* Mandarin Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langMatches(langStr[1:], "np-hant-hk") {
			/* Northern Ping Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "np-hant-mo") {
			/* Northern Ping Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langMatches(langStr[1:], "px-hant-hk") {
			/* Pu-Xian Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "px-hant-mo") {
			/* Pu-Xian Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langMatches(langStr[1:], "sp-hant-hk") {
			/* Southern Ping Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "sp-hant-mo") {
			/* Southern Ping Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langMatches(langStr[1:], "zh-hant-hk") {
			/* Huizhou Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "zh-hant-mo") {
			/* Huizhou Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langMatches(langStr[1:], "zo-hant-hk") {
			/* Min Zhong Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "zo-hant-mo") {
			/* Min Zhong Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langMatches(langStr[1:], "do-hans") {
			/* Min Dong Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "do-hant") {
			/* Min Dong Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if langMatches(langStr[1:], "jy-hans") {
			/* Jinyu Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "jy-hant") {
			/* Jinyu Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if langMatches(langStr[1:], "mn-hans") {
			/* Mandarin Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "mn-hant") {
			/* Mandarin Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if langMatches(langStr[1:], "np-hans") {
			/* Northern Ping Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "np-hant") {
			/* Northern Ping Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if langMatches(langStr[1:], "px-hans") {
			/* Pu-Xian Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "px-hant") {
			/* Pu-Xian Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if langMatches(langStr[1:], "sp-hans") {
			/* Southern Ping Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "sp-hant") {
			/* Southern Ping Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if langMatches(langStr[1:], "zh-hans") {
			/* Huizhou Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "zh-hant") {
			/* Huizhou Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if langMatches(langStr[1:], "zo-hans") {
			/* Min Zhong Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "zo-hant") {
			/* Min Zhong Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "do-") &&
			subtagMatches(langStr, "hk") {
			/* Min Dong Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "do-") &&
			subtagMatches(langStr, "mo") {
			/* Min Dong Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "do-") &&
			subtagMatches(langStr, "tw") {
			/* Min Dong Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "jy-") &&
			subtagMatches(langStr, "hk") {
			/* Jinyu Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "jy-") &&
			subtagMatches(langStr, "mo") {
			/* Jinyu Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "jy-") &&
			subtagMatches(langStr, "tw") {
			/* Jinyu Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "mn-") &&
			subtagMatches(langStr, "hk") {
			/* Mandarin Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "mn-") &&
			subtagMatches(langStr, "mo") {
			/* Mandarin Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "mn-") &&
			subtagMatches(langStr, "tw") {
			/* Mandarin Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "np-") &&
			subtagMatches(langStr, "hk") {
			/* Northern Ping Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "np-") &&
			subtagMatches(langStr, "mo") {
			/* Northern Ping Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "np-") &&
			subtagMatches(langStr, "tw") {
			/* Northern Ping Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "px-") &&
			subtagMatches(langStr, "hk") {
			/* Pu-Xian Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "px-") &&
			subtagMatches(langStr, "mo") {
			/* Pu-Xian Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "px-") &&
			subtagMatches(langStr, "tw") {
			/* Pu-Xian Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "sp-") &&
			subtagMatches(langStr, "hk") {
			/* Southern Ping Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "sp-") &&
			subtagMatches(langStr, "mo") {
			/* Southern Ping Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "sp-") &&
			subtagMatches(langStr, "tw") {
			/* Southern Ping Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "zh-") &&
			subtagMatches(langStr, "hk") {
			/* Huizhou Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "zh-") &&
			subtagMatches(langStr, "mo") {
			/* Huizhou Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "zh-") &&
			subtagMatches(langStr, "tw") {
			/* Huizhou Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "zo-") &&
			subtagMatches(langStr, "hk") {
			/* Min Zhong Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "zo-") &&
			subtagMatches(langStr, "mo") {
			/* Min Zhong Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "zo-") &&
			subtagMatches(langStr, "tw") {
			/* Min Zhong Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}

	case 'e':
		if strings.HasPrefix(langStr[1:], "l-") &&
			subtagMatches(langStr, "polyton") {
			/* Modern Greek (1453-); Polytonic Greek */
			return []loader.Tag{0x50475220} /* Polytonic Greek */
		}

	case 'g':
		if langMatches(langStr[1:], "an-hant-hk") {
			/* Gan Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "an-hant-mo") {
			/* Gan Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langMatches(langStr[1:], "an-hans") {
			/* Gan Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "an-hant") {
			/* Gan Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if langMatches(langStr[1:], "a-latg") {
			/* Irish;  */
			return []loader.Tag{0x49525420} /* Irish Traditional */
		}
		if strings.HasPrefix(langStr[1:], "an-") &&
			subtagMatches(langStr, "hk") {
			/* Gan Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "an-") &&
			subtagMatches(langStr, "mo") {
			/* Gan Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "an-") &&
			subtagMatches(langStr, "tw") {
			/* Gan Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}

	case 'h':
		if langMatches(langStr[1:], "ak-hant-hk") {
			/* Hakka Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "ak-hant-mo") {
			/* Hakka Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langMatches(langStr[1:], "sn-hant-hk") {
			/* Xiang Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "sn-hant-mo") {
			/* Xiang Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "y-") &&
			subtagMatches(langStr, "arevmda") {
			/* Armenian; Western Armenian */
			return []loader.Tag{0x48594520} /* Armenian */
		}
		if langMatches(langStr[1:], "ak-hans") {
			/* Hakka Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "ak-hant") {
			/* Hakka Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if langMatches(langStr[1:], "sn-hans") {
			/* Xiang Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "sn-hant") {
			/* Xiang Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "ak-") &&
			subtagMatches(langStr, "hk") {
			/* Hakka Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "ak-") &&
			subtagMatches(langStr, "mo") {
			/* Hakka Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "ak-") &&
			subtagMatches(langStr, "tw") {
			/* Hakka Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "sn-") &&
			subtagMatches(langStr, "hk") {
			/* Xiang Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "sn-") &&
			subtagMatches(langStr, "mo") {
			/* Xiang Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "sn-") &&
			subtagMatches(langStr, "tw") {
			/* Xiang Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}

	case 'i':
		if langStr[1:] == "-navajo" {
			/* Navajo (retired code) (retired code) */
			return []loader.Tag{
				0x4e415620, /* Navajo */
				0x41544820, /* Athapaskan */
			}
		}
		if langStr[1:] == "-hak" {
			/* Hakka (retired code) (retired code) */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langStr[1:] == "-lux" {
			/* Luxembourgish (retired code) (retired code) */
			return []loader.Tag{0x4c545a20} /* Luxembourgish */
		}

	case 'l':
		if langMatches(langStr[1:], "zh-hans") {
			/* Literary Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}

	case 'm':
		if langMatches(langStr[1:], "np-hant-hk") {
			/* Min Bei Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "np-hant-mo") {
			/* Min Bei Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langMatches(langStr[1:], "np-hans") {
			/* Min Bei Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "np-hant") {
			/* Min Bei Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "np-") &&
			subtagMatches(langStr, "hk") {
			/* Min Bei Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "np-") &&
			subtagMatches(langStr, "mo") {
			/* Min Bei Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "np-") &&
			subtagMatches(langStr, "tw") {
			/* Min Bei Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "nw-") &&
			subtagMatches(langStr, "th") {
			/* Mon; Thailand */
			return []loader.Tag{0x4d4f4e54} /* Thailand Mon */
		}

	case 'n':
		if langMatches(langStr[1:], "an-hant-hk") {
			/* Min Nan Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "an-hant-mo") {
			/* Min Nan Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langMatches(langStr[1:], "an-hans") {
			/* Min Nan Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "an-hant") {
			/* Min Nan Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "an-") &&
			subtagMatches(langStr, "hk") {
			/* Min Nan Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "an-") &&
			subtagMatches(langStr, "mo") {
			/* Min Nan Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "an-") &&
			subtagMatches(langStr, "tw") {
			/* Min Nan Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if langStr[1:] == "o-bok" {
			/* Norwegian Bokmal (retired code) (retired code) */
			return []loader.Tag{0x4e4f5220} /* Norwegian */
		}
		if langStr[1:] == "o-nyn" {
			/* Norwegian Nynorsk (retired code) (retired code) */
			return []loader.Tag{
				0x4e594e20, /* Norwegian Nynorsk (Nynorsk, Norwegian) */
				0x4e4f5220, /* Norwegian */
			}
		}

	case 'o':
		if strings.HasPrefix(langStr[1:], "c-") &&
			subtagMatches(langStr, "provenc") {
			/* Occitan (post 1500); Provençal */
			return []loader.Tag{0x50524f20} /* Provençal / Old Provençal */
		}

	case 'r':
		if strings.HasPrefix(langStr[1:], "o-") &&
			subtagMatches(langStr, "md") {
			/* Romanian; Moldova */
			return []loader.Tag{0x4d4f4c20} /* Moldavian */
		}

	case 'w':
		if langMatches(langStr[1:], "uu-hant-hk") {
			/* Wu Chinese; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "uu-hant-mo") {
			/* Wu Chinese; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langMatches(langStr[1:], "uu-hans") {
			/* Wu Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "uu-hant") {
			/* Wu Chinese;  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if strings.HasPrefix(langStr[1:], "uu-") &&
			subtagMatches(langStr, "hk") {
			/* Wu Chinese; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "uu-") &&
			subtagMatches(langStr, "mo") {
			/* Wu Chinese; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "uu-") &&
			subtagMatches(langStr, "tw") {
			/* Wu Chinese; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}

	case 'y':
		if langMatches(langStr[1:], "ue-hans") {
			/* Yue Chinese;  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}

	case 'z':
		if langMatches(langStr[1:], "h-hant-hk") {
			/* Chinese [macrolanguage]; ; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if langMatches(langStr[1:], "h-hant-mo") {
			/* Chinese [macrolanguage]; ; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if langStr[1:] == "h-min-nan" {
			/* Minnan, Hokkien, Amoy, Taiwanese, Southern Min, Southern Fujian, Hoklo, Southern Fukien, Ho-lo (retired code) (retired code) */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "h-hans") {
			/* Chinese [macrolanguage];  */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if langMatches(langStr[1:], "h-hant") {
			/* Chinese [macrolanguage];  */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}
		if langStr[1:] == "h-min" {
			/* Min, Fuzhou, Hokkien, Amoy, or Taiwanese (retired code) (retired code) */
			return []loader.Tag{0x5a485320} /* Chinese, Simplified */
		}
		if strings.HasPrefix(langStr[1:], "h-") &&
			subtagMatches(langStr, "hk") {
			/* Chinese [macrolanguage]; Hong Kong */
			return []loader.Tag{0x5a484820} /* Chinese, Traditional, Hong Kong SAR */
		}
		if strings.HasPrefix(langStr[1:], "h-") &&
			subtagMatches(langStr, "mo") {
			/* Chinese [macrolanguage]; Macao */
			return []loader.Tag{
				0x5a48544d, /* Chinese, Traditional, Macao SAR */
				0x5a484820, /* Chinese, Traditional, Hong Kong SAR */
			}
		}
		if strings.HasPrefix(langStr[1:], "h-") &&
			subtagMatches(langStr, "tw") {
			/* Chinese [macrolanguage]; Taiwan, Province of China */
			return []loader.Tag{0x5a485420} /* Chinese, Traditional */
		}

	}
	return nil
}

// Converts 'tag' to a BCP 47 language tag if it is ambiguous (it corresponds to
// many language tags) and the best tag is not the alphabetically first, or if
// the best tag consists of multiple subtags, or if the best tag does not appear
// in 'otLanguages'.
func ambiguousTagToLanguage(tag loader.Tag) language.Language {
	switch tag {
	case 0x414c5420: /* Altai */
		return "alt" /* language.NewLanguage("alt") Southern Altai */
	case 0x41505048: /*  */
		return "und-fonnapa" /* language.NewLanguage("und-fonnapa") Undetermined; North American Phonetic Alphabet */
	case 0x41524120: /* Arabic */
		return "ar" /* language.NewLanguage("ar") Arabic [macrolanguage] */
	case 0x41524b20: /* Rakhine */
		return "rki" /* language.NewLanguage("rki") Rakhine */
	case 0x41544820: /* Athapaskan */
		return "ath" /* language.NewLanguage("ath") Athapascan [collection] */
	case 0x42425220: /* Berber */
		return "ber" /* language.NewLanguage("ber") Berber [collection] */
	case 0x42494b20: /* Bikol */
		return "bik" /* language.NewLanguage("bik") Bikol [macrolanguage] */
	case 0x42544b20: /* Batak */
		return "btk" /* language.NewLanguage("btk") Batak [collection] */
	case 0x43505020: /* Creoles */
		return "crp" /* language.NewLanguage("crp") Creoles and pidgins [collection] */
	case 0x43525220: /* Carrier */
		return "crx" /* language.NewLanguage("crx") Carrier */
	case 0x44475220: /* Dogri (macrolanguage) */
		return "doi" /* language.NewLanguage("doi") Dogri [macrolanguage] */
	case 0x444e4b20: /* Dinka */
		return "din" /* language.NewLanguage("din") Dinka [macrolanguage] */
	case 0x44524920: /* Dari */
		return "prs" /* language.NewLanguage("prs") Dari */
	case 0x445a4e20: /* Dzongkha */
		return "dz" /* language.NewLanguage("dz") Dzongkha */
	case 0x45544920: /* Estonian */
		return "et" /* language.NewLanguage("et") Estonian [macrolanguage] */
	case 0x46415220: /* Persian */
		return "fa" /* language.NewLanguage("fa") Persian [macrolanguage] */
	case 0x474f4e20: /* Gondi */
		return "gon" /* language.NewLanguage("gon") Gondi [macrolanguage] */
	case 0x484d4120: /* High Mari */
		return "mrj" /* language.NewLanguage("mrj") Western Mari */
	case 0x484d4e20: /* Hmong */
		return "hmn" /* language.NewLanguage("hmn") Hmong [macrolanguage] */
	case 0x484e4420: /* Hindko */
		return "hnd" /* language.NewLanguage("hnd") Southern Hindko */
	case 0x48594520: /* Armenian */
		return "hyw" /* language.NewLanguage("hyw") Western Armenian */
	case 0x49424120: /* Iban */
		return "iba" /* language.NewLanguage("iba") Iban */
	case 0x494a4f20: /* Ijo */
		return "ijo" /* language.NewLanguage("ijo") Ijo [collection] */
	case 0x494e5520: /* Inuktitut */
		return "iu" /* language.NewLanguage("iu") Inuktitut [macrolanguage] */
	case 0x49504b20: /* Inupiat */
		return "ik" /* language.NewLanguage("ik") Inupiaq [macrolanguage] */
	case 0x49505048: /*  */
		return "und-fonipa" /* language.NewLanguage("und-fonipa") Undetermined; International Phonetic Alphabet */
	case 0x49525420: /* Irish Traditional */
		return "ga-latg" /* language.NewLanguage("ga-Latg") Irish;  */
	case 0x4a494920: /* Yiddish */
		return "yi" /* language.NewLanguage("yi") Yiddish [macrolanguage] */
	case 0x4b414c20: /* Kalenjin */
		return "kln" /* language.NewLanguage("kln") Kalenjin [macrolanguage] */
	case 0x4b474520: /* Khutsuri Georgian */
		return "und-geok" /* language.NewLanguage("und-Geok") Undetermined;  */
	case 0x4b4e5220: /* Kanuri */
		return "kr" /* language.NewLanguage("kr") Kanuri [macrolanguage] */
	case 0x4b4f4820: /* Korean Old Hangul */
		return "okm" /* language.NewLanguage("okm") Middle Korean (10th-16th cent.) */
	case 0x4b4f4b20: /* Konkani */
		return "kok" /* language.NewLanguage("kok") Konkani [macrolanguage] */
	case 0x4b4f4d20: /* Komi */
		return "kv" /* language.NewLanguage("kv") Komi [macrolanguage] */
	case 0x4b504c20: /* Kpelle */
		return "kpe" /* language.NewLanguage("kpe") Kpelle [macrolanguage] */
	case 0x4b524e20: /* Karen */
		return "kar" /* language.NewLanguage("kar") Karen [collection] */
	case 0x4b554920: /* Kui */
		return "uki" /* language.NewLanguage("uki") Kui (India) */
	case 0x4b555220: /* Kurdish */
		return "ku" /* language.NewLanguage("ku") Kurdish [macrolanguage] */
	case 0x4c4d4120: /* Low Mari */
		return "mhr" /* language.NewLanguage("mhr") Eastern Mari */
	case 0x4c554820: /* Luyia */
		return "luy" /* language.NewLanguage("luy") Luyia [macrolanguage] */
	case 0x4c564920: /* Latvian */
		return "lv" /* language.NewLanguage("lv") Latvian [macrolanguage] */
	case 0x4d415720: /* Marwari */
		return "mwr" /* language.NewLanguage("mwr") Marwari [macrolanguage] */
	case 0x4d4c4720: /* Malagasy */
		return "mg" /* language.NewLanguage("mg") Malagasy [macrolanguage] */
	case 0x4d4c5920: /* Malay */
		return "ms" /* language.NewLanguage("ms") Malay [macrolanguage] */
	case 0x4d4e4720: /* Mongolian */
		return "mn" /* language.NewLanguage("mn") Mongolian [macrolanguage] */
	case 0x4d4e4b20: /* Maninka */
		return "man" /* language.NewLanguage("man") Mandingo [macrolanguage] */
	case 0x4d4f4c20: /* Moldavian */
		return "ro-md" /* language.NewLanguage("ro-MD") Romanian; Moldova */
	case 0x4d4f4e54: /* Thailand Mon */
		return "mnw-th" /* language.NewLanguage("mnw-TH") Mon; Thailand */
	case 0x4d594e20: /* Mayan */
		return "myn" /* language.NewLanguage("myn") Mayan [collection] */
	case 0x4e414820: /* Nahuatl */
		return "nah" /* language.NewLanguage("nah") Nahuatl [collection] */
	case 0x4e455020: /* Nepali */
		return "ne" /* language.NewLanguage("ne") Nepali [macrolanguage] */
	case 0x4e495320: /* Nisi */
		return "njz" /* language.NewLanguage("njz") Nyishi */
	case 0x4e4f5220: /* Norwegian */
		return "no" /* language.NewLanguage("no") Norwegian [macrolanguage] */
	case 0x4f4a4220: /* Ojibway */
		return "oj" /* language.NewLanguage("oj") Ojibwa [macrolanguage] */
	case 0x4f524f20: /* Oromo */
		return "om" /* language.NewLanguage("om") Oromo [macrolanguage] */
	case 0x50415320: /* Pashto */
		return "ps" /* language.NewLanguage("ps") Pashto [macrolanguage] */
	case 0x50475220: /* Polytonic Greek */
		return "el-polyton" /* language.NewLanguage("el-polyton") Modern Greek (1453-); Polytonic Greek */
	case 0x50524f20: /* Provençal / Old Provençal */
		return "pro" /* language.NewLanguage("pro") Old Provençal (to 1500) */
	case 0x51554820: /* Quechua (Bolivia) */
		return "quh" /* language.NewLanguage("quh") South Bolivian Quechua */
	case 0x51555a20: /* Quechua */
		return "qu" /* language.NewLanguage("qu") Quechua [macrolanguage] */
	case 0x51564920: /* Quechua (Ecuador) */
		return "qvi" /* language.NewLanguage("qvi") Imbabura Highland Quichua */
	case 0x51574820: /* Quechua (Peru) */
		return "qwh" /* language.NewLanguage("qwh") Huaylas Ancash Quechua */
	case 0x52414a20: /* Rajasthani */
		return "raj" /* language.NewLanguage("raj") Rajasthani [macrolanguage] */
	case 0x524f4d20: /* Romanian */
		return "ro" /* language.NewLanguage("ro") Romanian */
	case 0x524f5920: /* Romany */
		return "rom" /* language.NewLanguage("rom") Romany [macrolanguage] */
	case 0x53514920: /* Albanian */
		return "sq" /* language.NewLanguage("sq") Albanian [macrolanguage] */
	case 0x53524220: /* Serbian */
		return "sr" /* language.NewLanguage("sr") Serbian */
	case 0x53585420: /* Sutu */
		return "xnj" /* language.NewLanguage("xnj") Ngoni (Tanzania) */
	case 0x53595220: /* Syriac */
		return "syr" /* language.NewLanguage("syr") Syriac [macrolanguage] */
	case 0x53595245: /* Syriac, Estrangela script-variant (equivalent to ISO 15924 'Syre') */
		return "und-syre" /* language.NewLanguage("und-Syre") Undetermined;  */
	case 0x5359524a: /* Syriac, Western script-variant (equivalent to ISO 15924 'Syrj') */
		return "und-syrj" /* language.NewLanguage("und-Syrj") Undetermined;  */
	case 0x5359524e: /* Syriac, Eastern script-variant (equivalent to ISO 15924 'Syrn') */
		return "und-syrn" /* language.NewLanguage("und-Syrn") Undetermined;  */
	case 0x544d4820: /* Tamashek */
		return "tmh" /* language.NewLanguage("tmh") Tamashek [macrolanguage] */
	case 0x544f4420: /* Todo */
		return "xwo" /* language.NewLanguage("xwo") Written Oirat */
	case 0x5a484820: /* Chinese, Traditional, Hong Kong SAR */
		return "zh-hk" /* language.NewLanguage("zh-HK") Chinese [macrolanguage]; Hong Kong */
	case 0x5a485320: /* Chinese, Simplified */
		return "zh-hans" /* language.NewLanguage("zh-Hans") Chinese [macrolanguage];  */
	case 0x5a485420: /* Chinese, Traditional */
		return "zh-hant" /* language.NewLanguage("zh-Hant") Chinese [macrolanguage];  */
	case 0x5a48544d: /* Chinese, Traditional, Macao SAR */
		return "zh-mo" /* language.NewLanguage("zh-MO") Chinese [macrolanguage]; Macao */
	case 0x5a5a4120: /* Zazaki */
		return "zza" /* language.NewLanguage("zza") Zazaki [macrolanguage] */
	default:
		return ""
	}
}
