/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.hll;

class BitUtil {
    private static final int[] LEAST_SIGNIFICANT_BIT = new int[]{-1, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    BitUtil() {
    }

    public static int leastSignificantBit(long value) {
        if (value == 0L) {
            return -1;
        }
        if ((value & 0xFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 0 & 0xFFL)] + 0;
        }
        if ((value & 0xFFFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 8 & 0xFFL)] + 8;
        }
        if ((value & 0xFFFFFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 16 & 0xFFL)] + 16;
        }
        if ((value & 0xFFFFFFFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 24 & 0xFFL)] + 24;
        }
        if ((value & 0xFFFFFFFFFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 32 & 0xFFL)] + 32;
        }
        if ((value & 0xFFFFFFFFFFFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 40 & 0xFFL)] + 40;
        }
        if ((value & 0xFFFFFFFFFFFFFFL) != 0L) {
            return LEAST_SIGNIFICANT_BIT[(int)(value >>> 48 & 0xFFL)] + 48;
        }
        return LEAST_SIGNIFICANT_BIT[(int)(value >>> 56 & 0xFFL)] + 56;
    }
}

