/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.ha;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.ConnectionConfig;
import org.apache.calcite.avatica.ha.LBStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffledRoundRobinLBStrategy
implements LBStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffledRoundRobinLBStrategy.class);
    public static final ShuffledRoundRobinLBStrategy INSTANCE = new ShuffledRoundRobinLBStrategy();
    public static final String URL_SEPERATOR_CHAR = ",";
    Map<String, Integer> configToIndexServedMap = new HashMap<String, Integer>();
    Map<String, String[]> configToUrlListMap = new HashMap<String, String[]>();

    private ShuffledRoundRobinLBStrategy() {
    }

    @Override
    public synchronized String getLbURL(ConnectionConfig config) {
        String key = ShuffledRoundRobinLBStrategy.getKey(config);
        String lbURLs = config.getLbURLs();
        if (!this.configToIndexServedMap.containsKey(key)) {
            this.configToIndexServedMap.put(key, 0);
            this.initialiseUrlList(key, lbURLs);
        }
        String[] urls = this.configToUrlListMap.get(key);
        int urlIndex = this.configToIndexServedMap.get(key);
        String url = urls[urlIndex];
        LOG.info("Selected URL:{}", (Object)url);
        urlIndex = (urlIndex + 1) % urls.length;
        this.configToIndexServedMap.put(key, urlIndex);
        return url;
    }

    private void initialiseUrlList(String key, String lbURLs) {
        String[] urls = lbURLs.split(URL_SEPERATOR_CHAR);
        List<String> list = Arrays.asList(urls);
        Collections.shuffle(list);
        urls = list.toArray(urls);
        this.configToUrlListMap.put(key, urls);
    }

    private static String getKey(ConnectionConfig config) {
        return config.getLbURLs();
    }
}

