/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.internal.simple.SimpleFormat;
import org.apache.sis.internal.storage.URIDataStore;
import org.apache.sis.internal.storage.io.Markable;
import org.apache.sis.internal.storage.io.RewindableLineReader;
import org.apache.sis.measure.Range;
import org.apache.sis.storage.CanNotProbeException;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ForwardOnlyStorageException;
import org.apache.sis.storage.ProbeInputStream;
import org.apache.sis.storage.ProbeReader;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Version;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.distribution.Format;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

public abstract class DataStoreProvider {
    public static final String LOCATION = "location";
    public static final String CREATE = "create";
    private volatile Logger logger;

    protected DataStoreProvider() {
    }

    public abstract String getShortName();

    public Format getFormat() {
        return new SimpleFormat(this.getShortName());
    }

    public Range<Version> getSupportedVersions() {
        return null;
    }

    public abstract ParameterDescriptorGroup getOpenParameters();

    public abstract ProbeResult probeContent(StorageConnector var1) throws DataStoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <S> ProbeResult probeContent(StorageConnector storageConnector, Class<S> clazz, Prober<? super S> prober) throws DataStoreException {
        ArgumentChecks.ensureNonNull("prober", prober);
        boolean bl = false;
        Object object = storageConnector.storage;
        synchronized (object) {
            ProbeResult probeResult = this.tryProber(storageConnector, clazz, prober);
            boolean bl2 = bl = probeResult == ProbeResult.UNDETERMINED;
            if (probeResult != null && !bl) {
                return probeResult;
            }
            Prober<? super S> prober2 = prober;
            while (prober2 instanceof ProberList) {
                ProberList proberList = (ProberList)prober2;
                probeResult = this.tryNextProber(storageConnector, proberList);
                if (probeResult != null && probeResult != ProbeResult.UNDETERMINED) {
                    return probeResult;
                }
                bl |= probeResult == ProbeResult.UNDETERMINED;
                prober2 = proberList.next;
            }
        }
        return bl ? ProbeResult.UNDETERMINED : ProbeResult.UNSUPPORTED_STORAGE;
    }

    private <N> ProbeResult tryNextProber(StorageConnector storageConnector, ProberList<?, N> proberList) throws DataStoreException {
        return this.tryProber(storageConnector, proberList.type, proberList.next);
    }

    private <S> ProbeResult tryProber(StorageConnector storageConnector, Class<S> clazz, Prober<? super S> prober) throws DataStoreException {
        S s = storageConnector.getStorageAs(clazz);
        if (s == null) {
            return null;
        }
        if (s == storageConnector.storage && !StorageConnector.isSupportedType(clazz)) {
            throw new IllegalArgumentException(Errors.format((short)163, clazz));
        }
        ProbeResult probeResult = null;
        try {
            if (s instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)s;
                probeResult = prober.test(clazz.cast(byteBuffer.asReadOnlyBuffer()));
            } else if (s instanceof Markable) {
                Markable markable = (Markable)s;
                long l = markable.getStreamPosition();
                markable.mark();
                probeResult = prober.test(s);
                markable.reset(l);
            } else if (s instanceof ImageInputStream) {
                ImageInputStream imageInputStream = (ImageInputStream)s;
                long l = imageInputStream.getStreamPosition();
                probeResult = prober.test(s);
                imageInputStream.seek(l);
            } else if (s instanceof InputStream) {
                ProbeInputStream probeInputStream = new ProbeInputStream(storageConnector, (InputStream)s);
                probeResult = prober.test(clazz.cast(probeInputStream));
                probeInputStream.close();
            } else if (s instanceof RewindableLineReader) {
                RewindableLineReader rewindableLineReader = (RewindableLineReader)s;
                rewindableLineReader.protectedMark();
                probeResult = prober.test(s);
                rewindableLineReader.protectedReset();
            } else if (s instanceof Reader) {
                ProbeReader probeReader = new ProbeReader(storageConnector, (Reader)s);
                probeResult = prober.test(clazz.cast(probeReader));
                ((Reader)probeReader).close();
            } else {
                probeResult = prober.test(s);
            }
        }
        catch (DataStoreException dataStoreException) {
            throw dataStoreException;
        }
        catch (Exception exception) {
            String string = Errors.format((short)12, storageConnector.getStorageName());
            if (probeResult != null) {
                throw new ForwardOnlyStorageException(string, exception);
            }
            throw new CanNotProbeException(this, storageConnector, (Throwable)exception);
        }
        return probeResult;
    }

    public abstract DataStore open(StorageConnector var1) throws DataStoreException;

    public DataStore open(ParameterValueGroup parameterValueGroup) throws DataStoreException {
        ArgumentChecks.ensureNonNull("parameter", parameterValueGroup);
        return this.open(URIDataStore.Provider.connector(this, parameterValueGroup));
    }

    public Logger getLogger() {
        Logger logger = this.logger;
        if (logger == null) {
            this.logger = logger = Logging.getLogger(this.getClass());
        }
        return logger;
    }

    @FunctionalInterface
    protected static interface Prober<S> {
        public ProbeResult test(S var1) throws Exception;

        default public <A> Prober<S> orElse(Class<A> clazz, Prober<? super A> prober) {
            return new ProberList(this, clazz, prober);
        }
    }

    private static final class ProberList<S, N>
    implements Prober<S> {
        private final Prober<S> first;
        Prober<? super N> next;
        final Class<N> type;

        ProberList(Prober<S> prober, Class<N> clazz, Prober<? super N> prober2) {
            this.first = prober;
            this.type = clazz;
            this.next = prober2;
        }

        @Override
        public ProbeResult test(S s) throws Exception {
            return this.first.test(s);
        }

        @Override
        public <A> Prober<S> orElse(Class<A> clazz, Prober<? super A> prober) {
            this.next = this.next.orElse(clazz, prober);
            return this;
        }
    }
}

