//
//
// File generated from our OpenAPI spec
//
//

package stripe

import "encoding/json"

// Controls whether this PaymentIntent will accept redirect-based payment methods.
//
// Redirect-based payment methods may require your customer to be redirected to a payment method's app or site for authentication or additional steps. To [confirm](https://stripe.com/docs/api/payment_intents/confirm) this PaymentIntent, you may be required to provide a `return_url` to redirect customers back to your site after they authenticate or complete the payment.
type PaymentIntentAutomaticPaymentMethodsAllowRedirects string

// List of values that PaymentIntentAutomaticPaymentMethodsAllowRedirects can take
const (
	PaymentIntentAutomaticPaymentMethodsAllowRedirectsAlways PaymentIntentAutomaticPaymentMethodsAllowRedirects = "always"
	PaymentIntentAutomaticPaymentMethodsAllowRedirectsNever  PaymentIntentAutomaticPaymentMethodsAllowRedirects = "never"
)

// Reason for cancellation of this PaymentIntent, either user-provided (`duplicate`, `fraudulent`, `requested_by_customer`, or `abandoned`) or generated by Stripe internally (`failed_invoice`, `void_invoice`, or `automatic`).
type PaymentIntentCancellationReason string

// List of values that PaymentIntentCancellationReason can take
const (
	PaymentIntentCancellationReasonAbandoned           PaymentIntentCancellationReason = "abandoned"
	PaymentIntentCancellationReasonAutomatic           PaymentIntentCancellationReason = "automatic"
	PaymentIntentCancellationReasonDuplicate           PaymentIntentCancellationReason = "duplicate"
	PaymentIntentCancellationReasonFailedInvoice       PaymentIntentCancellationReason = "failed_invoice"
	PaymentIntentCancellationReasonFraudulent          PaymentIntentCancellationReason = "fraudulent"
	PaymentIntentCancellationReasonRequestedByCustomer PaymentIntentCancellationReason = "requested_by_customer"
	PaymentIntentCancellationReasonVoidInvoice         PaymentIntentCancellationReason = "void_invoice"
)

// Controls when the funds will be captured from the customer's account.
type PaymentIntentCaptureMethod string

// List of values that PaymentIntentCaptureMethod can take
const (
	PaymentIntentCaptureMethodAutomatic      PaymentIntentCaptureMethod = "automatic"
	PaymentIntentCaptureMethodAutomaticAsync PaymentIntentCaptureMethod = "automatic_async"
	PaymentIntentCaptureMethodManual         PaymentIntentCaptureMethod = "manual"
)

type PaymentIntentConfirmationMethod string

// List of values that PaymentIntentConfirmationMethod can take
const (
	PaymentIntentConfirmationMethodAutomatic PaymentIntentConfirmationMethod = "automatic"
	PaymentIntentConfirmationMethodManual    PaymentIntentConfirmationMethod = "manual"
)

// The payment networks supported by this FinancialAddress
type PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSupportedNetwork string

// List of values that PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSupportedNetwork can take
const (
	PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSupportedNetworkBACS   PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSupportedNetwork = "bacs"
	PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSupportedNetworkFPS    PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSupportedNetwork = "fps"
	PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSupportedNetworkSEPA   PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSupportedNetwork = "sepa"
	PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSupportedNetworkSpei   PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSupportedNetwork = "spei"
	PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSupportedNetworkZengin PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSupportedNetwork = "zengin"
)

// The type of financial address
type PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressType string

// List of values that PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressType can take
const (
	PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressTypeIBAN     PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressType = "iban"
	PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressTypeSortCode PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressType = "sort_code"
	PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressTypeSpei     PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressType = "spei"
	PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressTypeZengin   PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressType = "zengin"
)

// Type of bank transfer
type PaymentIntentNextActionDisplayBankTransferInstructionsType string

// List of values that PaymentIntentNextActionDisplayBankTransferInstructionsType can take
const (
	PaymentIntentNextActionDisplayBankTransferInstructionsTypeEUBankTransfer PaymentIntentNextActionDisplayBankTransferInstructionsType = "eu_bank_transfer"
	PaymentIntentNextActionDisplayBankTransferInstructionsTypeGBBankTransfer PaymentIntentNextActionDisplayBankTransferInstructionsType = "gb_bank_transfer"
	PaymentIntentNextActionDisplayBankTransferInstructionsTypeJPBankTransfer PaymentIntentNextActionDisplayBankTransferInstructionsType = "jp_bank_transfer"
	PaymentIntentNextActionDisplayBankTransferInstructionsTypeMXBankTransfer PaymentIntentNextActionDisplayBankTransferInstructionsType = "mx_bank_transfer"
	PaymentIntentNextActionDisplayBankTransferInstructionsTypeUSBankTransfer PaymentIntentNextActionDisplayBankTransferInstructionsType = "us_bank_transfer"
)

// Type of the next action to perform, one of `redirect_to_url`, `use_stripe_sdk`, `alipay_handle_redirect`, `oxxo_display_details`, or `verify_with_microdeposits`.
type PaymentIntentNextActionType string

// List of values that PaymentIntentNextActionType can take
const (
	PaymentIntentNextActionTypeAlipayHandleRedirect    PaymentIntentNextActionType = "alipay_handle_redirect"
	PaymentIntentNextActionTypeOXXODisplayDetails      PaymentIntentNextActionType = "oxxo_display_details"
	PaymentIntentNextActionTypeRedirectToURL           PaymentIntentNextActionType = "redirect_to_url"
	PaymentIntentNextActionTypeUseStripeSDK            PaymentIntentNextActionType = "use_stripe_sdk"
	PaymentIntentNextActionTypeVerifyWithMicrodeposits PaymentIntentNextActionType = "verify_with_microdeposits"
)

// The type of the microdeposit sent to the customer. Used to distinguish between different verification methods.
type PaymentIntentNextActionVerifyWithMicrodepositsMicrodepositType string

// List of values that PaymentIntentNextActionVerifyWithMicrodepositsMicrodepositType can take
const (
	PaymentIntentNextActionVerifyWithMicrodepositsMicrodepositTypeAmounts        PaymentIntentNextActionVerifyWithMicrodepositsMicrodepositType = "amounts"
	PaymentIntentNextActionVerifyWithMicrodepositsMicrodepositTypeDescriptorCode PaymentIntentNextActionVerifyWithMicrodepositsMicrodepositType = "descriptor_code"
)

// Payment schedule for the mandate.
type PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsPaymentSchedule string

// List of values that PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsPaymentSchedule can take
const (
	PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsPaymentScheduleCombined PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsPaymentSchedule = "combined"
	PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsPaymentScheduleInterval PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsPaymentSchedule = "interval"
	PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsPaymentScheduleSporadic PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsPaymentSchedule = "sporadic"
)

// Transaction type of the mandate.
type PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsTransactionType string

// List of values that PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsTransactionType can take
const (
	PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsTransactionTypeBusiness PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsTransactionType = "business"
	PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsTransactionTypePersonal PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsTransactionType = "personal"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsACSSDebitSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsACSSDebitSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsACSSDebitSetupFutureUsageNone       PaymentIntentPaymentMethodOptionsACSSDebitSetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsACSSDebitSetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsACSSDebitSetupFutureUsage = "off_session"
	PaymentIntentPaymentMethodOptionsACSSDebitSetupFutureUsageOnSession  PaymentIntentPaymentMethodOptionsACSSDebitSetupFutureUsage = "on_session"
)

// Bank account verification method.
type PaymentIntentPaymentMethodOptionsACSSDebitVerificationMethod string

// List of values that PaymentIntentPaymentMethodOptionsACSSDebitVerificationMethod can take
const (
	PaymentIntentPaymentMethodOptionsACSSDebitVerificationMethodAutomatic     PaymentIntentPaymentMethodOptionsACSSDebitVerificationMethod = "automatic"
	PaymentIntentPaymentMethodOptionsACSSDebitVerificationMethodInstant       PaymentIntentPaymentMethodOptionsACSSDebitVerificationMethod = "instant"
	PaymentIntentPaymentMethodOptionsACSSDebitVerificationMethodMicrodeposits PaymentIntentPaymentMethodOptionsACSSDebitVerificationMethod = "microdeposits"
)

// Controls when the funds will be captured from the customer's account.
type PaymentIntentPaymentMethodOptionsAffirmCaptureMethod string

// List of values that PaymentIntentPaymentMethodOptionsAffirmCaptureMethod can take
const (
	PaymentIntentPaymentMethodOptionsAffirmCaptureMethodManual PaymentIntentPaymentMethodOptionsAffirmCaptureMethod = "manual"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsAffirmSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsAffirmSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsAffirmSetupFutureUsageNone PaymentIntentPaymentMethodOptionsAffirmSetupFutureUsage = "none"
)

// Controls when the funds will be captured from the customer's account.
type PaymentIntentPaymentMethodOptionsAfterpayClearpayCaptureMethod string

// List of values that PaymentIntentPaymentMethodOptionsAfterpayClearpayCaptureMethod can take
const (
	PaymentIntentPaymentMethodOptionsAfterpayClearpayCaptureMethodManual PaymentIntentPaymentMethodOptionsAfterpayClearpayCaptureMethod = "manual"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsageNone PaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage = "none"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsAlipaySetupFutureUsageNone       PaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsAlipaySetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage = "off_session"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsAUBECSDebitSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsAUBECSDebitSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsAUBECSDebitSetupFutureUsageNone       PaymentIntentPaymentMethodOptionsAUBECSDebitSetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsAUBECSDebitSetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsAUBECSDebitSetupFutureUsage = "off_session"
	PaymentIntentPaymentMethodOptionsAUBECSDebitSetupFutureUsageOnSession  PaymentIntentPaymentMethodOptionsAUBECSDebitSetupFutureUsage = "on_session"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsBACSDebitSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsBACSDebitSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsBACSDebitSetupFutureUsageNone       PaymentIntentPaymentMethodOptionsBACSDebitSetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsBACSDebitSetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsBACSDebitSetupFutureUsage = "off_session"
	PaymentIntentPaymentMethodOptionsBACSDebitSetupFutureUsageOnSession  PaymentIntentPaymentMethodOptionsBACSDebitSetupFutureUsage = "on_session"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsBancontactSetupFutureUsageNone       PaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsBancontactSetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage = "off_session"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsBoletoSetupFutureUsageNone       PaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsBoletoSetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage = "off_session"
	PaymentIntentPaymentMethodOptionsBoletoSetupFutureUsageOnSession  PaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage = "on_session"
)

// Controls when the funds will be captured from the customer's account.
type PaymentIntentPaymentMethodOptionsCardCaptureMethod string

// List of values that PaymentIntentPaymentMethodOptionsCardCaptureMethod can take
const (
	PaymentIntentPaymentMethodOptionsCardCaptureMethodManual PaymentIntentPaymentMethodOptionsCardCaptureMethod = "manual"
)

// For `fixed_count` installment plans, this is the interval between installment payments your customer will make to their credit card.
// One of `month`.
type PaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval string

// List of values that PaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval can take
const (
	PaymentIntentPaymentMethodOptionsCardInstallmentsPlanIntervalMonth PaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval = "month"
)

// Type of installment plan, one of `fixed_count`.
type PaymentIntentPaymentMethodOptionsCardInstallmentsPlanType string

// List of values that PaymentIntentPaymentMethodOptionsCardInstallmentsPlanType can take
const (
	PaymentIntentPaymentMethodOptionsCardInstallmentsPlanTypeFixedCount PaymentIntentPaymentMethodOptionsCardInstallmentsPlanType = "fixed_count"
)

// One of `fixed` or `maximum`. If `fixed`, the `amount` param refers to the exact amount to be charged in future payments. If `maximum`, the amount charged can be up to the value passed for the `amount` param.
type PaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType string

// List of values that PaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType can take
const (
	PaymentIntentPaymentMethodOptionsCardMandateOptionsAmountTypeFixed   PaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType = "fixed"
	PaymentIntentPaymentMethodOptionsCardMandateOptionsAmountTypeMaximum PaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType = "maximum"
)

// Specifies payment frequency. One of `day`, `week`, `month`, `year`, or `sporadic`.
type PaymentIntentPaymentMethodOptionsCardMandateOptionsInterval string

// List of values that PaymentIntentPaymentMethodOptionsCardMandateOptionsInterval can take
const (
	PaymentIntentPaymentMethodOptionsCardMandateOptionsIntervalDay      PaymentIntentPaymentMethodOptionsCardMandateOptionsInterval = "day"
	PaymentIntentPaymentMethodOptionsCardMandateOptionsIntervalMonth    PaymentIntentPaymentMethodOptionsCardMandateOptionsInterval = "month"
	PaymentIntentPaymentMethodOptionsCardMandateOptionsIntervalSporadic PaymentIntentPaymentMethodOptionsCardMandateOptionsInterval = "sporadic"
	PaymentIntentPaymentMethodOptionsCardMandateOptionsIntervalWeek     PaymentIntentPaymentMethodOptionsCardMandateOptionsInterval = "week"
	PaymentIntentPaymentMethodOptionsCardMandateOptionsIntervalYear     PaymentIntentPaymentMethodOptionsCardMandateOptionsInterval = "year"
)

// Specifies the type of mandates supported. Possible values are `india`.
type PaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedType string

// List of values that PaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedType can take
const (
	PaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedTypeIndia PaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedType = "india"
)

// Selected network to process this payment intent on. Depends on the available networks of the card attached to the payment intent. Can be only set confirm-time.
type PaymentIntentPaymentMethodOptionsCardNetwork string

// List of values that PaymentIntentPaymentMethodOptionsCardNetwork can take
const (
	PaymentIntentPaymentMethodOptionsCardNetworkAmex            PaymentIntentPaymentMethodOptionsCardNetwork = "amex"
	PaymentIntentPaymentMethodOptionsCardNetworkCartesBancaires PaymentIntentPaymentMethodOptionsCardNetwork = "cartes_bancaires"
	PaymentIntentPaymentMethodOptionsCardNetworkDiners          PaymentIntentPaymentMethodOptionsCardNetwork = "diners"
	PaymentIntentPaymentMethodOptionsCardNetworkDiscover        PaymentIntentPaymentMethodOptionsCardNetwork = "discover"
	PaymentIntentPaymentMethodOptionsCardNetworkEFTPOSAU        PaymentIntentPaymentMethodOptionsCardNetwork = "eftpos_au"
	PaymentIntentPaymentMethodOptionsCardNetworkInterac         PaymentIntentPaymentMethodOptionsCardNetwork = "interac"
	PaymentIntentPaymentMethodOptionsCardNetworkJCB             PaymentIntentPaymentMethodOptionsCardNetwork = "jcb"
	PaymentIntentPaymentMethodOptionsCardNetworkMastercard      PaymentIntentPaymentMethodOptionsCardNetwork = "mastercard"
	PaymentIntentPaymentMethodOptionsCardNetworkUnionpay        PaymentIntentPaymentMethodOptionsCardNetwork = "unionpay"
	PaymentIntentPaymentMethodOptionsCardNetworkUnknown         PaymentIntentPaymentMethodOptionsCardNetwork = "unknown"
	PaymentIntentPaymentMethodOptionsCardNetworkVisa            PaymentIntentPaymentMethodOptionsCardNetwork = "visa"
)

// We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. Permitted values include: `automatic` or `any`. If not provided, defaults to `automatic`. Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.
type PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure string

// List of values that PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure can take
const (
	PaymentIntentPaymentMethodOptionsCardRequestThreeDSecureAny           PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure = "any"
	PaymentIntentPaymentMethodOptionsCardRequestThreeDSecureAutomatic     PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure = "automatic"
	PaymentIntentPaymentMethodOptionsCardRequestThreeDSecureChallengeOnly PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure = "challenge_only"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsCardSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsCardSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsCardSetupFutureUsageNone       PaymentIntentPaymentMethodOptionsCardSetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsCardSetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsCardSetupFutureUsage = "off_session"
	PaymentIntentPaymentMethodOptionsCardSetupFutureUsageOnSession  PaymentIntentPaymentMethodOptionsCardSetupFutureUsage = "on_session"
)

// Controls when the funds will be captured from the customer's account.
type PaymentIntentPaymentMethodOptionsCashAppCaptureMethod string

// List of values that PaymentIntentPaymentMethodOptionsCashAppCaptureMethod can take
const (
	PaymentIntentPaymentMethodOptionsCashAppCaptureMethodManual PaymentIntentPaymentMethodOptionsCashAppCaptureMethod = "manual"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsCashAppSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsCashAppSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsCashAppSetupFutureUsageNone       PaymentIntentPaymentMethodOptionsCashAppSetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsCashAppSetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsCashAppSetupFutureUsage = "off_session"
	PaymentIntentPaymentMethodOptionsCashAppSetupFutureUsageOnSession  PaymentIntentPaymentMethodOptionsCashAppSetupFutureUsage = "on_session"
)

// List of address types that should be returned in the financial_addresses response. If not specified, all valid types will be returned.
//
// Permitted values include: `sort_code`, `zengin`, `iban`, or `spei`.
type PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressType string

// List of values that PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressType can take
const (
	PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressTypeABA      PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressType = "aba"
	PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressTypeIBAN     PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressType = "iban"
	PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressTypeSEPA     PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressType = "sepa"
	PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressTypeSortCode PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressType = "sort_code"
	PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressTypeSpei     PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressType = "spei"
	PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressTypeSwift    PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressType = "swift"
	PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressTypeZengin   PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressType = "zengin"
)

// The bank transfer type that this PaymentIntent is allowed to use for funding Permitted values include: `eu_bank_transfer`, `gb_bank_transfer`, `jp_bank_transfer`, `mx_bank_transfer`, or `us_bank_transfer`.
type PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferType string

// List of values that PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferType can take
const (
	PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferTypeEUBankTransfer PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferType = "eu_bank_transfer"
	PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferTypeGBBankTransfer PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferType = "gb_bank_transfer"
	PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferTypeJPBankTransfer PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferType = "jp_bank_transfer"
	PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferTypeMXBankTransfer PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferType = "mx_bank_transfer"
	PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferTypeUSBankTransfer PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferType = "us_bank_transfer"
)

// The funding method type to be used when there are not enough funds in the customer balance. Permitted values include: `bank_transfer`.
type PaymentIntentPaymentMethodOptionsCustomerBalanceFundingType string

// List of values that PaymentIntentPaymentMethodOptionsCustomerBalanceFundingType can take
const (
	PaymentIntentPaymentMethodOptionsCustomerBalanceFundingTypeBankTransfer PaymentIntentPaymentMethodOptionsCustomerBalanceFundingType = "bank_transfer"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsCustomerBalanceSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsCustomerBalanceSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsCustomerBalanceSetupFutureUsageNone PaymentIntentPaymentMethodOptionsCustomerBalanceSetupFutureUsage = "none"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsEPSSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsEPSSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsEPSSetupFutureUsageNone PaymentIntentPaymentMethodOptionsEPSSetupFutureUsage = "none"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsFPXSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsFPXSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsFPXSetupFutureUsageNone PaymentIntentPaymentMethodOptionsFPXSetupFutureUsage = "none"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsGiropaySetupFutureUsageNone PaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage = "none"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsageNone PaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage = "none"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsIDEALSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsIDEALSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsIDEALSetupFutureUsageNone       PaymentIntentPaymentMethodOptionsIDEALSetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsIDEALSetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsIDEALSetupFutureUsage = "off_session"
)

// Controls when the funds will be captured from the customer's account.
type PaymentIntentPaymentMethodOptionsKlarnaCaptureMethod string

// List of values that PaymentIntentPaymentMethodOptionsKlarnaCaptureMethod can take
const (
	PaymentIntentPaymentMethodOptionsKlarnaCaptureMethodManual PaymentIntentPaymentMethodOptionsKlarnaCaptureMethod = "manual"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsageNone PaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage = "none"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsageNone PaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage = "none"
)

// Controls when the funds will be captured from the customer's account.
type PaymentIntentPaymentMethodOptionsLinkCaptureMethod string

// List of values that PaymentIntentPaymentMethodOptionsLinkCaptureMethod can take
const (
	PaymentIntentPaymentMethodOptionsLinkCaptureMethodManual PaymentIntentPaymentMethodOptionsLinkCaptureMethod = "manual"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsLinkSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsLinkSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsLinkSetupFutureUsageNone       PaymentIntentPaymentMethodOptionsLinkSetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsLinkSetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsLinkSetupFutureUsage = "off_session"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsOXXOSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsOXXOSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsOXXOSetupFutureUsageNone PaymentIntentPaymentMethodOptionsOXXOSetupFutureUsage = "none"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsP24SetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsP24SetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsP24SetupFutureUsageNone PaymentIntentPaymentMethodOptionsP24SetupFutureUsage = "none"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsPayNowSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsPayNowSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsPayNowSetupFutureUsageNone PaymentIntentPaymentMethodOptionsPayNowSetupFutureUsage = "none"
)

// Controls when the funds will be captured from the customer's account.
type PaymentIntentPaymentMethodOptionsPaypalCaptureMethod string

// List of values that PaymentIntentPaymentMethodOptionsPaypalCaptureMethod can take
const (
	PaymentIntentPaymentMethodOptionsPaypalCaptureMethodManual PaymentIntentPaymentMethodOptionsPaypalCaptureMethod = "manual"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsPaypalSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsPaypalSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsPaypalSetupFutureUsageNone       PaymentIntentPaymentMethodOptionsPaypalSetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsPaypalSetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsPaypalSetupFutureUsage = "off_session"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsPixSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsPixSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsPixSetupFutureUsageNone PaymentIntentPaymentMethodOptionsPixSetupFutureUsage = "none"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsPromptPaySetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsPromptPaySetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsPromptPaySetupFutureUsageNone PaymentIntentPaymentMethodOptionsPromptPaySetupFutureUsage = "none"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsSEPADebitSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsSEPADebitSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsSEPADebitSetupFutureUsageNone       PaymentIntentPaymentMethodOptionsSEPADebitSetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsSEPADebitSetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsSEPADebitSetupFutureUsage = "off_session"
	PaymentIntentPaymentMethodOptionsSEPADebitSetupFutureUsageOnSession  PaymentIntentPaymentMethodOptionsSEPADebitSetupFutureUsage = "on_session"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsSofortSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsSofortSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsSofortSetupFutureUsageNone       PaymentIntentPaymentMethodOptionsSofortSetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsSofortSetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsSofortSetupFutureUsage = "off_session"
)

// The list of permissions to request. The `payment_method` permission must be included.
type PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnectionsPermission string

// List of values that PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnectionsPermission can take
const (
	PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnectionsPermissionBalances      PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnectionsPermission = "balances"
	PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnectionsPermissionOwnership     PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnectionsPermission = "ownership"
	PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnectionsPermissionPaymentMethod PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnectionsPermission = "payment_method"
	PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnectionsPermissionTransactions  PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnectionsPermission = "transactions"
)

// Preferred transaction settlement speed
type PaymentIntentPaymentMethodOptionsUSBankAccountPreferredSettlementSpeed string

// List of values that PaymentIntentPaymentMethodOptionsUSBankAccountPreferredSettlementSpeed can take
const (
	PaymentIntentPaymentMethodOptionsUSBankAccountPreferredSettlementSpeedFastest  PaymentIntentPaymentMethodOptionsUSBankAccountPreferredSettlementSpeed = "fastest"
	PaymentIntentPaymentMethodOptionsUSBankAccountPreferredSettlementSpeedStandard PaymentIntentPaymentMethodOptionsUSBankAccountPreferredSettlementSpeed = "standard"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsUSBankAccountSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsUSBankAccountSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsUSBankAccountSetupFutureUsageNone       PaymentIntentPaymentMethodOptionsUSBankAccountSetupFutureUsage = "none"
	PaymentIntentPaymentMethodOptionsUSBankAccountSetupFutureUsageOffSession PaymentIntentPaymentMethodOptionsUSBankAccountSetupFutureUsage = "off_session"
	PaymentIntentPaymentMethodOptionsUSBankAccountSetupFutureUsageOnSession  PaymentIntentPaymentMethodOptionsUSBankAccountSetupFutureUsage = "on_session"
)

// Bank account verification method.
type PaymentIntentPaymentMethodOptionsUSBankAccountVerificationMethod string

// List of values that PaymentIntentPaymentMethodOptionsUSBankAccountVerificationMethod can take
const (
	PaymentIntentPaymentMethodOptionsUSBankAccountVerificationMethodAutomatic     PaymentIntentPaymentMethodOptionsUSBankAccountVerificationMethod = "automatic"
	PaymentIntentPaymentMethodOptionsUSBankAccountVerificationMethodInstant       PaymentIntentPaymentMethodOptionsUSBankAccountVerificationMethod = "instant"
	PaymentIntentPaymentMethodOptionsUSBankAccountVerificationMethodMicrodeposits PaymentIntentPaymentMethodOptionsUSBankAccountVerificationMethod = "microdeposits"
)

// The client type that the end customer will pay from
type PaymentIntentPaymentMethodOptionsWeChatPayClient string

// List of values that PaymentIntentPaymentMethodOptionsWeChatPayClient can take
const (
	PaymentIntentPaymentMethodOptionsWeChatPayClientAndroid PaymentIntentPaymentMethodOptionsWeChatPayClient = "android"
	PaymentIntentPaymentMethodOptionsWeChatPayClientIOS     PaymentIntentPaymentMethodOptionsWeChatPayClient = "ios"
	PaymentIntentPaymentMethodOptionsWeChatPayClientWeb     PaymentIntentPaymentMethodOptionsWeChatPayClient = "web"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsWeChatPaySetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsWeChatPaySetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsWeChatPaySetupFutureUsageNone PaymentIntentPaymentMethodOptionsWeChatPaySetupFutureUsage = "none"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentPaymentMethodOptionsZipSetupFutureUsage string

// List of values that PaymentIntentPaymentMethodOptionsZipSetupFutureUsage can take
const (
	PaymentIntentPaymentMethodOptionsZipSetupFutureUsageNone PaymentIntentPaymentMethodOptionsZipSetupFutureUsage = "none"
)

// Type of the payment method for which payment is in `processing` state, one of `card`.
type PaymentIntentProcessingType string

// List of values that PaymentIntentProcessingType can take
const (
	PaymentIntentProcessingTypeCard PaymentIntentProcessingType = "card"
)

// Indicates that you intend to make future payments with this PaymentIntent's payment method.
//
// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
//
// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
type PaymentIntentSetupFutureUsage string

// List of values that PaymentIntentSetupFutureUsage can take
const (
	PaymentIntentSetupFutureUsageOffSession PaymentIntentSetupFutureUsage = "off_session"
	PaymentIntentSetupFutureUsageOnSession  PaymentIntentSetupFutureUsage = "on_session"
)

// Status of this PaymentIntent, one of `requires_payment_method`, `requires_confirmation`, `requires_action`, `processing`, `requires_capture`, `canceled`, or `succeeded`. Read more about each PaymentIntent [status](https://stripe.com/docs/payments/intents#intent-statuses).
type PaymentIntentStatus string

// List of values that PaymentIntentStatus can take
const (
	PaymentIntentStatusCanceled              PaymentIntentStatus = "canceled"
	PaymentIntentStatusProcessing            PaymentIntentStatus = "processing"
	PaymentIntentStatusRequiresAction        PaymentIntentStatus = "requires_action"
	PaymentIntentStatusRequiresCapture       PaymentIntentStatus = "requires_capture"
	PaymentIntentStatusRequiresConfirmation  PaymentIntentStatus = "requires_confirmation"
	PaymentIntentStatusRequiresPaymentMethod PaymentIntentStatus = "requires_payment_method"
	PaymentIntentStatusSucceeded             PaymentIntentStatus = "succeeded"
)

// Search for PaymentIntents you've previously created using Stripe's [Search Query Language](https://stripe.com/docs/search#search-query-language).
// Don't use search in read-after-write flows where strict consistency is necessary. Under normal operating
// conditions, data is searchable in less than a minute. Occasionally, propagation of new or updated data can be up
// to an hour behind during outages. Search functionality is not available to merchants in India.
type PaymentIntentSearchParams struct {
	SearchParams `form:"*"`
	// A cursor for pagination across multiple pages of results. Don't include this parameter on the first call. Use the next_page value returned in a previous response to request subsequent results.
	Page *string `form:"page"`
}

// When enabled, this PaymentIntent will accept payment methods that you have enabled in the Dashboard and are compatible with this PaymentIntent's other parameters.
type PaymentIntentAutomaticPaymentMethodsParams struct {
	// Controls whether this PaymentIntent will accept redirect-based payment methods.
	//
	// Redirect-based payment methods may require your customer to be redirected to a payment method's app or site for authentication or additional steps. To [confirm](https://stripe.com/docs/api/payment_intents/confirm) this PaymentIntent, you may be required to provide a `return_url` to redirect customers back to your site after they authenticate or complete the payment.
	AllowRedirects *string `form:"allow_redirects"`
	// Whether this feature is enabled.
	Enabled *bool `form:"enabled"`
}

// If this is a Mandate accepted offline, this hash contains details about the offline acceptance.
type PaymentIntentMandateDataCustomerAcceptanceOfflineParams struct{}

// If this is a Mandate accepted online, this hash contains details about the online acceptance.
type PaymentIntentMandateDataCustomerAcceptanceOnlineParams struct {
	// The IP address from which the Mandate was accepted by the customer.
	IPAddress *string `form:"ip_address"`
	// The user agent of the browser from which the Mandate was accepted by the customer.
	UserAgent *string `form:"user_agent"`
}

// This hash contains details about the customer acceptance of the Mandate.
type PaymentIntentMandateDataCustomerAcceptanceParams struct {
	// The time at which the customer accepted the Mandate.
	AcceptedAt *int64 `form:"accepted_at"`
	// If this is a Mandate accepted offline, this hash contains details about the offline acceptance.
	Offline *PaymentIntentMandateDataCustomerAcceptanceOfflineParams `form:"offline"`
	// If this is a Mandate accepted online, this hash contains details about the online acceptance.
	Online *PaymentIntentMandateDataCustomerAcceptanceOnlineParams `form:"online"`
	// The type of customer acceptance information included with the Mandate. One of `online` or `offline`.
	Type *string `form:"type"`
}

// This hash contains details about the Mandate to create. This parameter can only be used with [`confirm=true`](https://stripe.com/docs/api/payment_intents/create#create_payment_intent-confirm).
type PaymentIntentMandateDataParams struct {
	// This hash contains details about the customer acceptance of the Mandate.
	CustomerAcceptance *PaymentIntentMandateDataCustomerAcceptanceParams `form:"customer_acceptance"`
}

// If this is an `affirm` PaymentMethod, this hash contains details about the Affirm payment method.
type PaymentIntentPaymentMethodDataAffirmParams struct{}

// Billing information associated with the PaymentMethod that may be used or required by particular types of payment methods.
type PaymentIntentPaymentMethodDataBillingDetailsParams struct {
	// Billing address.
	Address *AddressParams `form:"address"`
	// Email address.
	Email *string `form:"email"`
	// Full name.
	Name *string `form:"name"`
	// Billing phone number (including extension).
	Phone *string `form:"phone"`
}

// If this is a `blik` PaymentMethod, this hash contains details about the BLIK payment method.
type PaymentIntentPaymentMethodDataBLIKParams struct{}

// If this is a `cashapp` PaymentMethod, this hash contains details about the Cash App Pay payment method.
type PaymentIntentPaymentMethodDataCashAppParams struct{}

// If this is a `customer_balance` PaymentMethod, this hash contains details about the CustomerBalance payment method.
type PaymentIntentPaymentMethodDataCustomerBalanceParams struct{}

// If this is a `konbini` PaymentMethod, this hash contains details about the Konbini payment method.
type PaymentIntentPaymentMethodDataKonbiniParams struct{}

// If this is an `Link` PaymentMethod, this hash contains details about the Link payment method.
type PaymentIntentPaymentMethodDataLinkParams struct{}

// If this is a `paynow` PaymentMethod, this hash contains details about the PayNow payment method.
type PaymentIntentPaymentMethodDataPayNowParams struct{}

// If this is a `paypal` PaymentMethod, this hash contains details about the PayPal payment method.
type PaymentIntentPaymentMethodDataPaypalParams struct{}

// If this is a `pix` PaymentMethod, this hash contains details about the Pix payment method.
type PaymentIntentPaymentMethodDataPixParams struct{}

// If this is a `promptpay` PaymentMethod, this hash contains details about the PromptPay payment method.
type PaymentIntentPaymentMethodDataPromptPayParams struct{}

// Options to configure Radar. See [Radar Session](https://stripe.com/docs/radar/radar-session) for more information.
type PaymentIntentPaymentMethodDataRadarOptionsParams struct {
	// A [Radar Session](https://stripe.com/docs/radar/radar-session) is a snapshot of the browser metadata and device details that help Radar make more accurate predictions on your payments.
	Session *string `form:"session"`
}

// If this is an `us_bank_account` PaymentMethod, this hash contains details about the US bank account payment method.
type PaymentIntentPaymentMethodDataUSBankAccountParams struct {
	// Account holder type: individual or company.
	AccountHolderType *string `form:"account_holder_type"`
	// Account number of the bank account.
	AccountNumber *string `form:"account_number"`
	// Account type: checkings or savings. Defaults to checking if omitted.
	AccountType *string `form:"account_type"`
	// The ID of a Financial Connections Account to use as a payment method.
	FinancialConnectionsAccount *string `form:"financial_connections_account"`
	// Routing number of the bank account.
	RoutingNumber *string `form:"routing_number"`
}

// If this is a `zip` PaymentMethod, this hash contains details about the Zip payment method.
type PaymentIntentPaymentMethodDataZipParams struct{}

// If provided, this hash will be used to create a PaymentMethod. The new PaymentMethod will appear
// in the [payment_method](https://stripe.com/docs/api/payment_intents/object#payment_intent_object-payment_method)
// property on the PaymentIntent.
type PaymentIntentPaymentMethodDataParams struct {
	// If this is an `acss_debit` PaymentMethod, this hash contains details about the ACSS Debit payment method.
	ACSSDebit *PaymentMethodACSSDebitParams `form:"acss_debit"`
	// If this is an `affirm` PaymentMethod, this hash contains details about the Affirm payment method.
	Affirm *PaymentIntentPaymentMethodDataAffirmParams `form:"affirm"`
	// If this is an `AfterpayClearpay` PaymentMethod, this hash contains details about the AfterpayClearpay payment method.
	AfterpayClearpay *PaymentMethodAfterpayClearpayParams `form:"afterpay_clearpay"`
	// If this is an `Alipay` PaymentMethod, this hash contains details about the Alipay payment method.
	Alipay *PaymentMethodAlipayParams `form:"alipay"`
	// If this is an `au_becs_debit` PaymentMethod, this hash contains details about the bank account.
	AUBECSDebit *PaymentMethodAUBECSDebitParams `form:"au_becs_debit"`
	// If this is a `bacs_debit` PaymentMethod, this hash contains details about the Bacs Direct Debit bank account.
	BACSDebit *PaymentMethodBACSDebitParams `form:"bacs_debit"`
	// If this is a `bancontact` PaymentMethod, this hash contains details about the Bancontact payment method.
	Bancontact *PaymentMethodBancontactParams `form:"bancontact"`
	// Billing information associated with the PaymentMethod that may be used or required by particular types of payment methods.
	BillingDetails *PaymentIntentPaymentMethodDataBillingDetailsParams `form:"billing_details"`
	// If this is a `blik` PaymentMethod, this hash contains details about the BLIK payment method.
	BLIK *PaymentIntentPaymentMethodDataBLIKParams `form:"blik"`
	// If this is a `boleto` PaymentMethod, this hash contains details about the Boleto payment method.
	Boleto *PaymentMethodBoletoParams `form:"boleto"`
	// If this is a `cashapp` PaymentMethod, this hash contains details about the Cash App Pay payment method.
	CashApp *PaymentIntentPaymentMethodDataCashAppParams `form:"cashapp"`
	// If this is a `customer_balance` PaymentMethod, this hash contains details about the CustomerBalance payment method.
	CustomerBalance *PaymentIntentPaymentMethodDataCustomerBalanceParams `form:"customer_balance"`
	// If this is an `eps` PaymentMethod, this hash contains details about the EPS payment method.
	EPS *PaymentMethodEPSParams `form:"eps"`
	// If this is an `fpx` PaymentMethod, this hash contains details about the FPX payment method.
	FPX *PaymentMethodFPXParams `form:"fpx"`
	// If this is a `giropay` PaymentMethod, this hash contains details about the Giropay payment method.
	Giropay *PaymentMethodGiropayParams `form:"giropay"`
	// If this is a `grabpay` PaymentMethod, this hash contains details about the GrabPay payment method.
	Grabpay *PaymentMethodGrabpayParams `form:"grabpay"`
	// If this is an `ideal` PaymentMethod, this hash contains details about the iDEAL payment method.
	IDEAL *PaymentMethodIDEALParams `form:"ideal"`
	// If this is an `interac_present` PaymentMethod, this hash contains details about the Interac Present payment method.
	InteracPresent *PaymentMethodInteracPresentParams `form:"interac_present"`
	// If this is a `klarna` PaymentMethod, this hash contains details about the Klarna payment method.
	Klarna *PaymentMethodKlarnaParams `form:"klarna"`
	// If this is a `konbini` PaymentMethod, this hash contains details about the Konbini payment method.
	Konbini *PaymentIntentPaymentMethodDataKonbiniParams `form:"konbini"`
	// If this is an `Link` PaymentMethod, this hash contains details about the Link payment method.
	Link *PaymentIntentPaymentMethodDataLinkParams `form:"link"`
	// Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. Individual keys can be unset by posting an empty value to them. All keys can be unset by posting an empty value to `metadata`.
	Metadata map[string]string `form:"metadata"`
	// If this is an `oxxo` PaymentMethod, this hash contains details about the OXXO payment method.
	OXXO *PaymentMethodOXXOParams `form:"oxxo"`
	// If this is a `p24` PaymentMethod, this hash contains details about the P24 payment method.
	P24 *PaymentMethodP24Params `form:"p24"`
	// If this is a `paynow` PaymentMethod, this hash contains details about the PayNow payment method.
	PayNow *PaymentIntentPaymentMethodDataPayNowParams `form:"paynow"`
	// If this is a `paypal` PaymentMethod, this hash contains details about the PayPal payment method.
	Paypal *PaymentIntentPaymentMethodDataPaypalParams `form:"paypal"`
	// If this is a `pix` PaymentMethod, this hash contains details about the Pix payment method.
	Pix *PaymentIntentPaymentMethodDataPixParams `form:"pix"`
	// If this is a `promptpay` PaymentMethod, this hash contains details about the PromptPay payment method.
	PromptPay *PaymentIntentPaymentMethodDataPromptPayParams `form:"promptpay"`
	// Options to configure Radar. See [Radar Session](https://stripe.com/docs/radar/radar-session) for more information.
	RadarOptions *PaymentIntentPaymentMethodDataRadarOptionsParams `form:"radar_options"`
	// If this is a `sepa_debit` PaymentMethod, this hash contains details about the SEPA debit bank account.
	SEPADebit *PaymentMethodSEPADebitParams `form:"sepa_debit"`
	// If this is a `sofort` PaymentMethod, this hash contains details about the SOFORT payment method.
	Sofort *PaymentMethodSofortParams `form:"sofort"`
	// The type of the PaymentMethod. An additional hash is included on the PaymentMethod with a name matching this value. It contains additional information specific to the PaymentMethod type.
	Type *string `form:"type"`
	// If this is an `us_bank_account` PaymentMethod, this hash contains details about the US bank account payment method.
	USBankAccount *PaymentIntentPaymentMethodDataUSBankAccountParams `form:"us_bank_account"`
	// If this is an `wechat_pay` PaymentMethod, this hash contains details about the wechat_pay payment method.
	WeChatPay *PaymentMethodWeChatPayParams `form:"wechat_pay"`
	// If this is a `zip` PaymentMethod, this hash contains details about the Zip payment method.
	Zip *PaymentIntentPaymentMethodDataZipParams `form:"zip"`
}

// Additional fields for Mandate creation
type PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsParams struct {
	// A URL for custom mandate text to render during confirmation step.
	// The URL will be rendered with additional GET parameters `payment_intent` and `payment_intent_client_secret` when confirming a Payment Intent,
	// or `setup_intent` and `setup_intent_client_secret` when confirming a Setup Intent.
	CustomMandateURL *string `form:"custom_mandate_url"`
	// Description of the mandate interval. Only required if 'payment_schedule' parameter is 'interval' or 'combined'.
	IntervalDescription *string `form:"interval_description"`
	// Payment schedule for the mandate.
	PaymentSchedule *string `form:"payment_schedule"`
	// Transaction type of the mandate.
	TransactionType *string `form:"transaction_type"`
}

// If this is a `acss_debit` PaymentMethod, this sub-hash contains details about the ACSS Debit payment method options.
type PaymentIntentPaymentMethodOptionsACSSDebitParams struct {
	// Additional fields for Mandate creation
	MandateOptions *PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsParams `form:"mandate_options"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
	// Verification method for the intent
	VerificationMethod *string `form:"verification_method"`
}

// If this is an `affirm` PaymentMethod, this sub-hash contains details about the Affirm payment method options.
type PaymentIntentPaymentMethodOptionsAffirmParams struct {
	// Controls when the funds will be captured from the customer's account.
	//
	// If provided, this parameter will override the top-level `capture_method` when finalizing the payment with this payment method type.
	//
	// If `capture_method` is already set on the PaymentIntent, providing an empty value for this parameter will unset the stored value for this payment method type.
	CaptureMethod *string `form:"capture_method"`
	// Preferred language of the Affirm authorization page that the customer is redirected to.
	PreferredLocale *string `form:"preferred_locale"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `afterpay_clearpay` PaymentMethod, this sub-hash contains details about the Afterpay Clearpay payment method options.
type PaymentIntentPaymentMethodOptionsAfterpayClearpayParams struct {
	// Controls when the funds will be captured from the customer's account.
	//
	// If provided, this parameter will override the top-level `capture_method` when finalizing the payment with this payment method type.
	//
	// If `capture_method` is already set on the PaymentIntent, providing an empty value for this parameter will unset the stored value for this payment method type.
	CaptureMethod *string `form:"capture_method"`
	// Order identifier shown to the customer in Afterpay's online portal. We recommend using a value that helps you answer any questions a customer might have about
	// the payment. The identifier is limited to 128 characters and may contain only letters, digits, underscores, backslashes and dashes.
	Reference *string `form:"reference"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `alipay` PaymentMethod, this sub-hash contains details about the Alipay payment method options.
type PaymentIntentPaymentMethodOptionsAlipayParams struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `au_becs_debit` PaymentMethod, this sub-hash contains details about the AU BECS Direct Debit payment method options.
type PaymentIntentPaymentMethodOptionsAUBECSDebitParams struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `bacs_debit` PaymentMethod, this sub-hash contains details about the BACS Debit payment method options.
type PaymentIntentPaymentMethodOptionsBACSDebitParams struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `bancontact` PaymentMethod, this sub-hash contains details about the Bancontact payment method options.
type PaymentIntentPaymentMethodOptionsBancontactParams struct {
	// Preferred language of the Bancontact authorization page that the customer is redirected to.
	PreferredLanguage *string `form:"preferred_language"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `blik` PaymentMethod, this sub-hash contains details about the BLIK payment method options.
type PaymentIntentPaymentMethodOptionsBLIKParams struct {
	// The 6-digit BLIK code that a customer has generated using their banking application. Can only be set on confirmation.
	Code *string `form:"code"`
}

// If this is a `boleto` PaymentMethod, this sub-hash contains details about the Boleto payment method options.
type PaymentIntentPaymentMethodOptionsBoletoParams struct {
	// The number of calendar days before a Boleto voucher expires. For example, if you create a Boleto voucher on Monday and you set expires_after_days to 2, the Boleto invoice will expire on Wednesday at 23:59 America/Sao_Paulo time.
	ExpiresAfterDays *int64 `form:"expires_after_days"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// The selected installment plan to use for this payment attempt.
// This parameter can only be provided during confirmation.
type PaymentIntentPaymentMethodOptionsCardInstallmentsPlanParams struct {
	// For `fixed_count` installment plans, this is the number of installment payments your customer will make to their credit card.
	Count *int64 `form:"count"`
	// For `fixed_count` installment plans, this is the interval between installment payments your customer will make to their credit card.
	// One of `month`.
	Interval *string `form:"interval"`
	// Type of installment plan, one of `fixed_count`.
	Type *string `form:"type"`
}

// Installment configuration for payments attempted on this PaymentIntent (Mexico Only).
//
// For more information, see the [installments integration guide](https://stripe.com/docs/payments/installments).
type PaymentIntentPaymentMethodOptionsCardInstallmentsParams struct {
	// Setting to true enables installments for this PaymentIntent.
	// This will cause the response to contain a list of available installment plans.
	// Setting to false will prevent any selected plan from applying to a charge.
	Enabled *bool `form:"enabled"`
	// The selected installment plan to use for this payment attempt.
	// This parameter can only be provided during confirmation.
	Plan *PaymentIntentPaymentMethodOptionsCardInstallmentsPlanParams `form:"plan"`
}

// Configuration options for setting up an eMandate for cards issued in India.
type PaymentIntentPaymentMethodOptionsCardMandateOptionsParams struct {
	// Amount to be charged for future payments.
	Amount *int64 `form:"amount"`
	// One of `fixed` or `maximum`. If `fixed`, the `amount` param refers to the exact amount to be charged in future payments. If `maximum`, the amount charged can be up to the value passed for the `amount` param.
	AmountType *string `form:"amount_type"`
	// A description of the mandate or subscription that is meant to be displayed to the customer.
	Description *string `form:"description"`
	// End date of the mandate or subscription. If not provided, the mandate will be active until canceled. If provided, end date should be after start date.
	EndDate *int64 `form:"end_date"`
	// Specifies payment frequency. One of `day`, `week`, `month`, `year`, or `sporadic`.
	Interval *string `form:"interval"`
	// The number of intervals between payments. For example, `interval=month` and `interval_count=3` indicates one payment every three months. Maximum of one year interval allowed (1 year, 12 months, or 52 weeks). This parameter is optional when `interval=sporadic`.
	IntervalCount *int64 `form:"interval_count"`
	// Unique identifier for the mandate or subscription.
	Reference *string `form:"reference"`
	// Start date of the mandate or subscription. Start date should not be lesser than yesterday.
	StartDate *int64 `form:"start_date"`
	// Specifies the type of mandates supported. Possible values are `india`.
	SupportedTypes []*string `form:"supported_types"`
}

// Configuration for any card payments attempted on this PaymentIntent.
type PaymentIntentPaymentMethodOptionsCardParams struct {
	// Controls when the funds will be captured from the customer's account.
	//
	// If provided, this parameter will override the top-level `capture_method` when finalizing the payment with this payment method type.
	//
	// If `capture_method` is already set on the PaymentIntent, providing an empty value for this parameter will unset the stored value for this payment method type.
	CaptureMethod *string `form:"capture_method"`
	// A single-use `cvc_update` Token that represents a card CVC value. When provided, the CVC value will be verified during the card payment attempt. This parameter can only be provided during confirmation.
	CVCToken *string `form:"cvc_token"`
	// Installment configuration for payments attempted on this PaymentIntent (Mexico Only).
	//
	// For more information, see the [installments integration guide](https://stripe.com/docs/payments/installments).
	Installments *PaymentIntentPaymentMethodOptionsCardInstallmentsParams `form:"installments"`
	// Configuration options for setting up an eMandate for cards issued in India.
	MandateOptions *PaymentIntentPaymentMethodOptionsCardMandateOptionsParams `form:"mandate_options"`
	// When specified, this parameter indicates that a transaction will be marked
	// as MOTO (Mail Order Telephone Order) and thus out of scope for SCA. This
	// parameter can only be provided during confirmation.
	MOTO *bool `form:"moto"`
	// Selected network to process this PaymentIntent on. Depends on the available networks of the card attached to the PaymentIntent. Can be only set confirm-time.
	Network *string `form:"network"`
	// We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. Permitted values include: `automatic` or `any`. If not provided, defaults to `automatic`. Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.
	RequestThreeDSecure *string `form:"request_three_d_secure"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
	// Provides information about a card payment that customers see on their statements. Concatenated with the Kana prefix (shortened Kana descriptor) or Kana statement descriptor that's set on the account to form the complete statement descriptor. Maximum 22 characters. On card statements, the *concatenation* of both prefix and suffix (including separators) will appear truncated to 22 characters.
	StatementDescriptorSuffixKana *string `form:"statement_descriptor_suffix_kana"`
	// Provides information about a card payment that customers see on their statements. Concatenated with the Kanji prefix (shortened Kanji descriptor) or Kanji statement descriptor that's set on the account to form the complete statement descriptor. Maximum 17 characters. On card statements, the *concatenation* of both prefix and suffix (including separators) will appear truncated to 17 characters.
	StatementDescriptorSuffixKanji *string `form:"statement_descriptor_suffix_kanji"`
}

// If this is a `card_present` PaymentMethod, this sub-hash contains details about the Card Present payment method options.
type PaymentIntentPaymentMethodOptionsCardPresentParams struct {
	// Request ability to capture this payment beyond the standard [authorization validity window](https://stripe.com/docs/terminal/features/extended-authorizations#authorization-validity)
	RequestExtendedAuthorization *bool `form:"request_extended_authorization"`
	// Request ability to [increment](https://stripe.com/docs/terminal/features/incremental-authorizations) this PaymentIntent if the combination of MCC and card brand is eligible. Check [incremental_authorization_supported](https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-card_present-incremental_authorization_supported) in the [Confirm](https://stripe.com/docs/api/payment_intents/confirm) response to verify support.
	RequestIncrementalAuthorizationSupport *bool `form:"request_incremental_authorization_support"`
}

// If this is a `cashapp` PaymentMethod, this sub-hash contains details about the Cash App Pay payment method options.
type PaymentIntentPaymentMethodOptionsCashAppParams struct {
	// Controls when the funds will be captured from the customer's account.
	//
	// If provided, this parameter will override the top-level `capture_method` when finalizing the payment with this payment method type.
	//
	// If `capture_method` is already set on the PaymentIntent, providing an empty value for this parameter will unset the stored value for this payment method type.
	CaptureMethod *string `form:"capture_method"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// Configuration for the eu_bank_transfer funding type.
type PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferEUBankTransferParams struct {
	// The desired country code of the bank account information. Permitted values include: `BE`, `DE`, `ES`, `FR`, `IE`, or `NL`.
	Country *string `form:"country"`
}

// Configuration for the bank transfer funding type, if the `funding_type` is set to `bank_transfer`.
type PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferParams struct {
	// Configuration for the eu_bank_transfer funding type.
	EUBankTransfer *PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferEUBankTransferParams `form:"eu_bank_transfer"`
	// List of address types that should be returned in the financial_addresses response. If not specified, all valid types will be returned.
	//
	// Permitted values include: `sort_code`, `zengin`, `iban`, or `spei`.
	RequestedAddressTypes []*string `form:"requested_address_types"`
	// The list of bank transfer types that this PaymentIntent is allowed to use for funding Permitted values include: `eu_bank_transfer`, `gb_bank_transfer`, `jp_bank_transfer`, `mx_bank_transfer`, or `us_bank_transfer`.
	Type *string `form:"type"`
}

// If this is a `customer balance` PaymentMethod, this sub-hash contains details about the customer balance payment method options.
type PaymentIntentPaymentMethodOptionsCustomerBalanceParams struct {
	// Configuration for the bank transfer funding type, if the `funding_type` is set to `bank_transfer`.
	BankTransfer *PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferParams `form:"bank_transfer"`
	// The funding method type to be used when there are not enough funds in the customer balance. Permitted values include: `bank_transfer`.
	FundingType *string `form:"funding_type"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `eps` PaymentMethod, this sub-hash contains details about the EPS payment method options.
type PaymentIntentPaymentMethodOptionsEPSParams struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `fpx` PaymentMethod, this sub-hash contains details about the FPX payment method options.
type PaymentIntentPaymentMethodOptionsFPXParams struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `giropay` PaymentMethod, this sub-hash contains details about the Giropay payment method options.
type PaymentIntentPaymentMethodOptionsGiropayParams struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `grabpay` PaymentMethod, this sub-hash contains details about the Grabpay payment method options.
type PaymentIntentPaymentMethodOptionsGrabpayParams struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `ideal` PaymentMethod, this sub-hash contains details about the Ideal payment method options.
type PaymentIntentPaymentMethodOptionsIDEALParams struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `interac_present` PaymentMethod, this sub-hash contains details about the Card Present payment method options.
type PaymentIntentPaymentMethodOptionsInteracPresentParams struct{}

// If this is a `klarna` PaymentMethod, this sub-hash contains details about the Klarna payment method options.
type PaymentIntentPaymentMethodOptionsKlarnaParams struct {
	// Controls when the funds will be captured from the customer's account.
	//
	// If provided, this parameter will override the top-level `capture_method` when finalizing the payment with this payment method type.
	//
	// If `capture_method` is already set on the PaymentIntent, providing an empty value for this parameter will unset the stored value for this payment method type.
	CaptureMethod *string `form:"capture_method"`
	// Preferred language of the Klarna authorization page that the customer is redirected to
	PreferredLocale *string `form:"preferred_locale"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `konbini` PaymentMethod, this sub-hash contains details about the Konbini payment method options.
type PaymentIntentPaymentMethodOptionsKonbiniParams struct {
	// An optional 10 to 11 digit numeric-only string determining the confirmation code at applicable convenience stores. Must not consist of only zeroes and could be rejected in case of insufficient uniqueness. We recommend to use the customer's phone number.
	ConfirmationNumber *string `form:"confirmation_number"`
	// The number of calendar days (between 1 and 60) after which Konbini payment instructions will expire. For example, if a PaymentIntent is confirmed with Konbini and `expires_after_days` set to 2 on Monday JST, the instructions will expire on Wednesday 23:59:59 JST. Defaults to 3 days.
	ExpiresAfterDays *int64 `form:"expires_after_days"`
	// The timestamp at which the Konbini payment instructions will expire. Only one of `expires_after_days` or `expires_at` may be set.
	ExpiresAt *int64 `form:"expires_at"`
	// A product descriptor of up to 22 characters, which will appear to customers at the convenience store.
	ProductDescription *string `form:"product_description"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `link` PaymentMethod, this sub-hash contains details about the Link payment method options.
type PaymentIntentPaymentMethodOptionsLinkParams struct {
	// Controls when the funds will be captured from the customer's account.
	//
	// If provided, this parameter will override the top-level `capture_method` when finalizing the payment with this payment method type.
	//
	// If `capture_method` is already set on the PaymentIntent, providing an empty value for this parameter will unset the stored value for this payment method type.
	CaptureMethod *string `form:"capture_method"`
	// [Deprecated] This is a legacy parameter that no longer has any function.
	PersistentToken *string `form:"persistent_token"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `oxxo` PaymentMethod, this sub-hash contains details about the OXXO payment method options.
type PaymentIntentPaymentMethodOptionsOXXOParams struct {
	// The number of calendar days before an OXXO voucher expires. For example, if you create an OXXO voucher on Monday and you set expires_after_days to 2, the OXXO invoice will expire on Wednesday at 23:59 America/Mexico_City time.
	ExpiresAfterDays *int64 `form:"expires_after_days"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `p24` PaymentMethod, this sub-hash contains details about the Przelewy24 payment method options.
type PaymentIntentPaymentMethodOptionsP24Params struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
	// Confirm that the payer has accepted the P24 terms and conditions.
	TOSShownAndAccepted *bool `form:"tos_shown_and_accepted"`
}

// If this is a `paynow` PaymentMethod, this sub-hash contains details about the PayNow payment method options.
type PaymentIntentPaymentMethodOptionsPayNowParams struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `paypal` PaymentMethod, this sub-hash contains details about the PayPal payment method options.
type PaymentIntentPaymentMethodOptionsPaypalParams struct {
	// Controls when the funds will be captured from the customer's account.
	CaptureMethod *string `form:"capture_method"`
	// [Preferred locale](https://stripe.com/docs/payments/paypal/supported-locales) of the PayPal checkout page that the customer is redirected to.
	PreferredLocale *string `form:"preferred_locale"`
	// A reference of the PayPal transaction visible to customer which is mapped to PayPal's invoice ID. This must be a globally unique ID if you have configured in your PayPal settings to block multiple payments per invoice ID.
	Reference *string `form:"reference"`
	// The risk correlation ID for an on-session payment using a saved PayPal payment method.
	RiskCorrelationID *string `form:"risk_correlation_id"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `pix` PaymentMethod, this sub-hash contains details about the Pix payment method options.
type PaymentIntentPaymentMethodOptionsPixParams struct {
	// The number of seconds (between 10 and 1209600) after which Pix payment will expire. Defaults to 86400 seconds.
	ExpiresAfterSeconds *int64 `form:"expires_after_seconds"`
	// The timestamp at which the Pix expires (between 10 and 1209600 seconds in the future). Defaults to 1 day in the future.
	ExpiresAt *int64 `form:"expires_at"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `promptpay` PaymentMethod, this sub-hash contains details about the PromptPay payment method options.
type PaymentIntentPaymentMethodOptionsPromptPayParams struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// Additional fields for Mandate creation
type PaymentIntentPaymentMethodOptionsSEPADebitMandateOptionsParams struct{}

// If this is a `sepa_debit` PaymentIntent, this sub-hash contains details about the SEPA Debit payment method options.
type PaymentIntentPaymentMethodOptionsSEPADebitParams struct {
	// Additional fields for Mandate creation
	MandateOptions *PaymentIntentPaymentMethodOptionsSEPADebitMandateOptionsParams `form:"mandate_options"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `sofort` PaymentMethod, this sub-hash contains details about the SOFORT payment method options.
type PaymentIntentPaymentMethodOptionsSofortParams struct {
	// Language shown to the payer on redirect.
	PreferredLanguage *string `form:"preferred_language"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// Additional fields for Financial Connections Session creation
type PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnectionsParams struct {
	// The list of permissions to request. If this parameter is passed, the `payment_method` permission must be included. Valid permissions include: `balances`, `ownership`, `payment_method`, and `transactions`.
	Permissions []*string `form:"permissions"`
	// For webview integrations only. Upon completing OAuth login in the native browser, the user will be redirected to this URL to return to your app.
	ReturnURL *string `form:"return_url"`
}

// Additional fields for network related functions
type PaymentIntentPaymentMethodOptionsUSBankAccountNetworksParams struct {
	// Triggers validations to run across the selected networks
	Requested []*string `form:"requested"`
}

// If this is a `us_bank_account` PaymentMethod, this sub-hash contains details about the US bank account payment method options.
type PaymentIntentPaymentMethodOptionsUSBankAccountParams struct {
	// Additional fields for Financial Connections Session creation
	FinancialConnections *PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnectionsParams `form:"financial_connections"`
	// Additional fields for network related functions
	Networks *PaymentIntentPaymentMethodOptionsUSBankAccountNetworksParams `form:"networks"`
	// Preferred transaction settlement speed
	PreferredSettlementSpeed *string `form:"preferred_settlement_speed"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
	// Verification method for the intent
	VerificationMethod *string `form:"verification_method"`
}

// If this is a `wechat_pay` PaymentMethod, this sub-hash contains details about the WeChat Pay payment method options.
type PaymentIntentPaymentMethodOptionsWeChatPayParams struct {
	// The app ID registered with WeChat Pay. Only required when client is ios or android.
	AppID *string `form:"app_id"`
	// The client type that the end customer will pay from
	Client *string `form:"client"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// If this is a `zip` PaymentMethod, this sub-hash contains details about the Zip payment method options.
type PaymentIntentPaymentMethodOptionsZipParams struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
}

// Payment-method-specific configuration for this PaymentIntent.
type PaymentIntentPaymentMethodOptionsParams struct {
	// If this is a `acss_debit` PaymentMethod, this sub-hash contains details about the ACSS Debit payment method options.
	ACSSDebit *PaymentIntentPaymentMethodOptionsACSSDebitParams `form:"acss_debit"`
	// If this is an `affirm` PaymentMethod, this sub-hash contains details about the Affirm payment method options.
	Affirm *PaymentIntentPaymentMethodOptionsAffirmParams `form:"affirm"`
	// If this is a `afterpay_clearpay` PaymentMethod, this sub-hash contains details about the Afterpay Clearpay payment method options.
	AfterpayClearpay *PaymentIntentPaymentMethodOptionsAfterpayClearpayParams `form:"afterpay_clearpay"`
	// If this is a `alipay` PaymentMethod, this sub-hash contains details about the Alipay payment method options.
	Alipay *PaymentIntentPaymentMethodOptionsAlipayParams `form:"alipay"`
	// If this is a `au_becs_debit` PaymentMethod, this sub-hash contains details about the AU BECS Direct Debit payment method options.
	AUBECSDebit *PaymentIntentPaymentMethodOptionsAUBECSDebitParams `form:"au_becs_debit"`
	// If this is a `bacs_debit` PaymentMethod, this sub-hash contains details about the BACS Debit payment method options.
	BACSDebit *PaymentIntentPaymentMethodOptionsBACSDebitParams `form:"bacs_debit"`
	// If this is a `bancontact` PaymentMethod, this sub-hash contains details about the Bancontact payment method options.
	Bancontact *PaymentIntentPaymentMethodOptionsBancontactParams `form:"bancontact"`
	// If this is a `blik` PaymentMethod, this sub-hash contains details about the BLIK payment method options.
	BLIK *PaymentIntentPaymentMethodOptionsBLIKParams `form:"blik"`
	// If this is a `boleto` PaymentMethod, this sub-hash contains details about the Boleto payment method options.
	Boleto *PaymentIntentPaymentMethodOptionsBoletoParams `form:"boleto"`
	// Configuration for any card payments attempted on this PaymentIntent.
	Card *PaymentIntentPaymentMethodOptionsCardParams `form:"card"`
	// If this is a `card_present` PaymentMethod, this sub-hash contains details about the Card Present payment method options.
	CardPresent *PaymentIntentPaymentMethodOptionsCardPresentParams `form:"card_present"`
	// If this is a `cashapp` PaymentMethod, this sub-hash contains details about the Cash App Pay payment method options.
	CashApp *PaymentIntentPaymentMethodOptionsCashAppParams `form:"cashapp"`
	// If this is a `customer balance` PaymentMethod, this sub-hash contains details about the customer balance payment method options.
	CustomerBalance *PaymentIntentPaymentMethodOptionsCustomerBalanceParams `form:"customer_balance"`
	// If this is a `eps` PaymentMethod, this sub-hash contains details about the EPS payment method options.
	EPS *PaymentIntentPaymentMethodOptionsEPSParams `form:"eps"`
	// If this is a `fpx` PaymentMethod, this sub-hash contains details about the FPX payment method options.
	FPX *PaymentIntentPaymentMethodOptionsFPXParams `form:"fpx"`
	// If this is a `giropay` PaymentMethod, this sub-hash contains details about the Giropay payment method options.
	Giropay *PaymentIntentPaymentMethodOptionsGiropayParams `form:"giropay"`
	// If this is a `grabpay` PaymentMethod, this sub-hash contains details about the Grabpay payment method options.
	Grabpay *PaymentIntentPaymentMethodOptionsGrabpayParams `form:"grabpay"`
	// If this is a `ideal` PaymentMethod, this sub-hash contains details about the Ideal payment method options.
	IDEAL *PaymentIntentPaymentMethodOptionsIDEALParams `form:"ideal"`
	// If this is a `interac_present` PaymentMethod, this sub-hash contains details about the Card Present payment method options.
	InteracPresent *PaymentIntentPaymentMethodOptionsInteracPresentParams `form:"interac_present"`
	// If this is a `klarna` PaymentMethod, this sub-hash contains details about the Klarna payment method options.
	Klarna *PaymentIntentPaymentMethodOptionsKlarnaParams `form:"klarna"`
	// If this is a `konbini` PaymentMethod, this sub-hash contains details about the Konbini payment method options.
	Konbini *PaymentIntentPaymentMethodOptionsKonbiniParams `form:"konbini"`
	// If this is a `link` PaymentMethod, this sub-hash contains details about the Link payment method options.
	Link *PaymentIntentPaymentMethodOptionsLinkParams `form:"link"`
	// If this is a `oxxo` PaymentMethod, this sub-hash contains details about the OXXO payment method options.
	OXXO *PaymentIntentPaymentMethodOptionsOXXOParams `form:"oxxo"`
	// If this is a `p24` PaymentMethod, this sub-hash contains details about the Przelewy24 payment method options.
	P24 *PaymentIntentPaymentMethodOptionsP24Params `form:"p24"`
	// If this is a `paynow` PaymentMethod, this sub-hash contains details about the PayNow payment method options.
	PayNow *PaymentIntentPaymentMethodOptionsPayNowParams `form:"paynow"`
	// If this is a `paypal` PaymentMethod, this sub-hash contains details about the PayPal payment method options.
	Paypal *PaymentIntentPaymentMethodOptionsPaypalParams `form:"paypal"`
	// If this is a `pix` PaymentMethod, this sub-hash contains details about the Pix payment method options.
	Pix *PaymentIntentPaymentMethodOptionsPixParams `form:"pix"`
	// If this is a `promptpay` PaymentMethod, this sub-hash contains details about the PromptPay payment method options.
	PromptPay *PaymentIntentPaymentMethodOptionsPromptPayParams `form:"promptpay"`
	// If this is a `sepa_debit` PaymentIntent, this sub-hash contains details about the SEPA Debit payment method options.
	SEPADebit *PaymentIntentPaymentMethodOptionsSEPADebitParams `form:"sepa_debit"`
	// If this is a `sofort` PaymentMethod, this sub-hash contains details about the SOFORT payment method options.
	Sofort *PaymentIntentPaymentMethodOptionsSofortParams `form:"sofort"`
	// If this is a `us_bank_account` PaymentMethod, this sub-hash contains details about the US bank account payment method options.
	USBankAccount *PaymentIntentPaymentMethodOptionsUSBankAccountParams `form:"us_bank_account"`
	// If this is a `wechat_pay` PaymentMethod, this sub-hash contains details about the WeChat Pay payment method options.
	WeChatPay *PaymentIntentPaymentMethodOptionsWeChatPayParams `form:"wechat_pay"`
	// If this is a `zip` PaymentMethod, this sub-hash contains details about the Zip payment method options.
	Zip *PaymentIntentPaymentMethodOptionsZipParams `form:"zip"`
}

// Options to configure Radar. See [Radar Session](https://stripe.com/docs/radar/radar-session) for more information.
type PaymentIntentRadarOptionsParams struct {
	// A [Radar Session](https://stripe.com/docs/radar/radar-session) is a snapshot of the browser metadata and device details that help Radar make more accurate predictions on your payments.
	Session *string `form:"session"`
}

// The parameters used to automatically create a Transfer when the payment succeeds.
// For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
type PaymentIntentTransferDataParams struct {
	// The amount that will be transferred automatically when a charge succeeds.
	Amount *int64 `form:"amount"`
	// If specified, successful charges will be attributed to the destination
	// account for tax reporting, and the funds from charges will be transferred
	// to the destination account. The ID of the resulting transfer will be
	// returned on the successful charge's `transfer` field.
	Destination *string `form:"destination"`
}

// Creates a PaymentIntent object.
//
// After the PaymentIntent is created, attach a payment method and [confirm](https://stripe.com/docs/api/payment_intents/confirm)
// to continue the payment. You can read more about the different payment flows
// available via the Payment Intents API [here](https://stripe.com/docs/payments/payment-intents).
//
// When confirm=true is used during creation, it is equivalent to creating
// and confirming the PaymentIntent in the same call. You may use any parameters
// available in the [confirm API](https://stripe.com/docs/api/payment_intents/confirm) when confirm=true
// is supplied.
type PaymentIntentParams struct {
	Params `form:"*"`
	// Amount intended to be collected by this PaymentIntent. A positive integer representing how much to charge in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The minimum amount is $0.50 US or [equivalent in charge currency](https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts). The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).
	Amount *int64 `form:"amount"`
	// The amount of the application fee (if any) that will be requested to be applied to the payment and transferred to the application owner's Stripe account. The amount of the application fee collected will be capped at the total payment amount. For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
	ApplicationFeeAmount *int64 `form:"application_fee_amount"`
	// When enabled, this PaymentIntent will accept payment methods that you have enabled in the Dashboard and are compatible with this PaymentIntent's other parameters.
	AutomaticPaymentMethods *PaymentIntentAutomaticPaymentMethodsParams `form:"automatic_payment_methods"`
	// Controls when the funds will be captured from the customer's account.
	CaptureMethod *string `form:"capture_method"`
	// The client secret of the PaymentIntent. Required if a publishable key is used to retrieve the source.
	ClientSecret *string `form:"client_secret"`
	// Set to `true` to attempt to [confirm](https://stripe.com/docs/api/payment_intents/confirm) this PaymentIntent immediately. This parameter defaults to `false`. When creating and confirming a PaymentIntent at the same time, parameters available in the [confirm](https://stripe.com/docs/api/payment_intents/confirm) API may also be provided.
	Confirm            *bool   `form:"confirm"`
	ConfirmationMethod *string `form:"confirmation_method"`
	// Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
	Currency *string `form:"currency"`
	// ID of the Customer this PaymentIntent belongs to, if one exists.
	//
	// Payment methods attached to other Customers cannot be used with this PaymentIntent.
	//
	// If present in combination with [setup_future_usage](https://stripe.com/docs/api#payment_intent_object-setup_future_usage), this PaymentIntent's payment method will be attached to the Customer after the PaymentIntent has been confirmed and any required actions from the user are complete.
	Customer *string `form:"customer"`
	// An arbitrary string attached to the object. Often useful for displaying to users.
	Description *string `form:"description"`
	// ID of the mandate to be used for this payment. This parameter can only be used with [`confirm=true`](https://stripe.com/docs/api/payment_intents/create#create_payment_intent-confirm).
	Mandate *string `form:"mandate"`
	// This hash contains details about the Mandate to create. This parameter can only be used with [`confirm=true`](https://stripe.com/docs/api/payment_intents/create#create_payment_intent-confirm).
	MandateData *PaymentIntentMandateDataParams `form:"mandate_data"`
	// The Stripe account ID for which these funds are intended. For details, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
	OnBehalfOf *string `form:"on_behalf_of"`
	// ID of the payment method (a PaymentMethod, Card, or [compatible Source](https://stripe.com/docs/payments/payment-methods/transitioning#compatibility) object) to attach to this PaymentIntent.
	PaymentMethod *string `form:"payment_method"`
	// If provided, this hash will be used to create a PaymentMethod. The new PaymentMethod will appear
	// in the [payment_method](https://stripe.com/docs/api/payment_intents/object#payment_intent_object-payment_method)
	// property on the PaymentIntent.
	PaymentMethodData *PaymentIntentPaymentMethodDataParams `form:"payment_method_data"`
	// Payment-method-specific configuration for this PaymentIntent.
	PaymentMethodOptions *PaymentIntentPaymentMethodOptionsParams `form:"payment_method_options"`
	// The list of payment method types (e.g. card) that this PaymentIntent is allowed to use. Use automatic_payment_methods to manage payment methods from the [Stripe Dashboard](https://dashboard.stripe.com/settings/payment_methods).
	PaymentMethodTypes []*string `form:"payment_method_types"`
	// Options to configure Radar. See [Radar Session](https://stripe.com/docs/radar/radar-session) for more information.
	RadarOptions *PaymentIntentRadarOptionsParams `form:"radar_options"`
	// Email address that the receipt for the resulting payment will be sent to. If `receipt_email` is specified for a payment in live mode, a receipt will be sent regardless of your [email settings](https://dashboard.stripe.com/account/emails).
	ReceiptEmail *string `form:"receipt_email"`
	// The URL to redirect your customer back to after they authenticate or cancel their payment on the payment method's app or site. If you'd prefer to redirect to a mobile application, you can alternatively supply an application URI scheme. This parameter can only be used with [`confirm=true`](https://stripe.com/docs/api/payment_intents/create#create_payment_intent-confirm).
	ReturnURL *string `form:"return_url"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
	// Shipping information for this PaymentIntent.
	Shipping *ShippingDetailsParams `form:"shipping"`
	// For non-card charges, you can use this value as the complete description that appears on your customers' statements. Must contain at least one letter, maximum 22 characters.
	StatementDescriptor *string `form:"statement_descriptor"`
	// Provides information about a card payment that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that's set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
	StatementDescriptorSuffix *string `form:"statement_descriptor_suffix"`
	// The parameters used to automatically create a Transfer when the payment succeeds. For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
	TransferData *PaymentIntentTransferDataParams `form:"transfer_data"`
	// A string that identifies the resulting payment as part of a group. `transfer_group` may only be provided if it has not been set. See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts) for details.
	TransferGroup *string `form:"transfer_group"`
	// These parameters apply only for paymentIntent.New with `confirm=true`
	// Set to `true` to fail the payment attempt if the PaymentIntent transitions into `requires_action`. This parameter is intended for simpler integrations that do not handle customer actions, like [saving cards without authentication](https://stripe.com/docs/payments/save-card-without-authentication). This parameter can only be used with [`confirm=true`](https://stripe.com/docs/api/payment_intents/create#create_payment_intent-confirm).
	ErrorOnRequiresAction *bool `form:"error_on_requires_action"`
	// Set to `true` to indicate that the customer is not in your checkout flow during this payment attempt, and therefore is unable to authenticate. This parameter is intended for scenarios where you collect card details and [charge them later](https://stripe.com/docs/payments/cards/charging-saved-cards). This parameter can only be used with [`confirm=true`](https://stripe.com/docs/api/payment_intents/create#create_payment_intent-confirm).
	OffSession *bool `form:"off_session"`
	// Set to `true` when confirming server-side and using Stripe.js, iOS, or Android client-side SDKs to handle the next actions.
	UseStripeSDK *bool `form:"use_stripe_sdk"`
}

// Returns a list of PaymentIntents.
type PaymentIntentListParams struct {
	ListParams `form:"*"`
	// A filter on the list, based on the object `created` field. The value can be a string with an integer Unix timestamp, or it can be a dictionary with a number of different query options.
	Created *int64 `form:"created"`
	// A filter on the list, based on the object `created` field. The value can be a string with an integer Unix timestamp, or it can be a dictionary with a number of different query options.
	CreatedRange *RangeQueryParams `form:"created"`
	// Only return PaymentIntents for the customer specified by this customer ID.
	Customer *string `form:"customer"`
}

// Options to configure Radar. See [Radar Session](https://stripe.com/docs/radar/radar-session) for more information.
type PaymentIntentConfirmRadarOptionsParams struct {
	// A [Radar Session](https://stripe.com/docs/radar/radar-session) is a snapshot of the browser metadata and device details that help Radar make more accurate predictions on your payments.
	Session *string `form:"session"`
}

// Confirm that your customer intends to pay with current or provided
// payment method. Upon confirmation, the PaymentIntent will attempt to initiate
// a payment.
// If the selected payment method requires additional authentication steps, the
// PaymentIntent will transition to the requires_action status and
// suggest additional actions via next_action. If payment fails,
// the PaymentIntent transitions to the requires_payment_method status or the
// canceled status if the confirmation limit is reached. If
// payment succeeds, the PaymentIntent will transition to the succeeded
// status (or requires_capture, if capture_method is set to manual).
// If the confirmation_method is automatic, payment may be attempted
// using our [client SDKs](https://stripe.com/docs/stripe-js/reference#stripe-handle-card-payment)
// and the PaymentIntent's [client_secret](https://stripe.com/docs/api#payment_intent_object-client_secret).
// After next_actions are handled by the client, no additional
// confirmation is required to complete the payment.
// If the confirmation_method is manual, all payment attempts must be
// initiated using a secret key.
// If any actions are required for the payment, the PaymentIntent will
// return to the requires_confirmation state
// after those actions are completed. Your server needs to then
// explicitly re-confirm the PaymentIntent to initiate the next payment
// attempt. Read the [expanded documentation](https://stripe.com/docs/payments/payment-intents/web-manual)
// to learn more about manual confirmation.
type PaymentIntentConfirmParams struct {
	Params `form:"*"`
	// Controls when the funds will be captured from the customer's account.
	CaptureMethod *string `form:"capture_method"`
	// Set to `true` to fail the payment attempt if the PaymentIntent transitions into `requires_action`. This parameter is intended for simpler integrations that do not handle customer actions, like [saving cards without authentication](https://stripe.com/docs/payments/save-card-without-authentication).
	ErrorOnRequiresAction *bool `form:"error_on_requires_action"`
	// ID of the mandate to be used for this payment.
	Mandate *string `form:"mandate"`
	// This hash contains details about the Mandate to create
	MandateData *PaymentIntentMandateDataParams `form:"mandate_data"`
	// Set to `true` to indicate that the customer is not in your checkout flow during this payment attempt, and therefore is unable to authenticate. This parameter is intended for scenarios where you collect card details and [charge them later](https://stripe.com/docs/payments/cards/charging-saved-cards).
	OffSession *bool `form:"off_session"`
	// ID of the payment method (a PaymentMethod, Card, or [compatible Source](https://stripe.com/docs/payments/payment-methods/transitioning#compatibility) object) to attach to this PaymentIntent.
	PaymentMethod *string `form:"payment_method"`
	// If provided, this hash will be used to create a PaymentMethod. The new PaymentMethod will appear
	// in the [payment_method](https://stripe.com/docs/api/payment_intents/object#payment_intent_object-payment_method)
	// property on the PaymentIntent.
	PaymentMethodData *PaymentIntentPaymentMethodDataParams `form:"payment_method_data"`
	// Payment-method-specific configuration for this PaymentIntent.
	PaymentMethodOptions *PaymentIntentPaymentMethodOptionsParams `form:"payment_method_options"`
	// Options to configure Radar. See [Radar Session](https://stripe.com/docs/radar/radar-session) for more information.
	RadarOptions *PaymentIntentConfirmRadarOptionsParams `form:"radar_options"`
	// Email address that the receipt for the resulting payment will be sent to. If `receipt_email` is specified for a payment in live mode, a receipt will be sent regardless of your [email settings](https://dashboard.stripe.com/account/emails).
	ReceiptEmail *string `form:"receipt_email"`
	// The URL to redirect your customer back to after they authenticate or cancel their payment on the payment method's app or site.
	// If you'd prefer to redirect to a mobile application, you can alternatively supply an application URI scheme.
	// This parameter is only used for cards and other redirect-based payment methods.
	ReturnURL *string `form:"return_url"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	//
	// If `setup_future_usage` is already set and you are performing a request using a publishable key, you may only update the value from `on_session` to `off_session`.
	SetupFutureUsage *string `form:"setup_future_usage"`
	// Shipping information for this PaymentIntent.
	Shipping *ShippingDetailsParams `form:"shipping"`
	// Set to `true` when confirming server-side and using Stripe.js, iOS, or Android client-side SDKs to handle the next actions.
	UseStripeSDK *bool `form:"use_stripe_sdk"`
}

// A PaymentIntent object can be canceled when it is in one of these statuses: requires_payment_method, requires_capture, requires_confirmation, requires_action or, [in rare cases](https://stripe.com/docs/payments/intents), processing.
//
// Once canceled, no additional charges will be made by the PaymentIntent and any operations on the PaymentIntent will fail with an error. For PaymentIntents with a status of requires_capture, the remaining amount_capturable will automatically be refunded.
//
// You cannot cancel the PaymentIntent for a Checkout Session. [Expire the Checkout Session](https://stripe.com/docs/api/checkout/sessions/expire) instead.
type PaymentIntentCancelParams struct {
	Params `form:"*"`
	// Reason for canceling this PaymentIntent. Possible values are `duplicate`, `fraudulent`, `requested_by_customer`, or `abandoned`
	CancellationReason *string `form:"cancellation_reason"`
}

// Capture the funds of an existing uncaptured PaymentIntent when its status is requires_capture.
//
// Uncaptured PaymentIntents will be canceled a set number of days after they are created (7 by default).
//
// Learn more about [separate authorization and capture](https://stripe.com/docs/payments/capture-later).
type PaymentIntentCaptureParams struct {
	Params `form:"*"`
	// The amount to capture from the PaymentIntent, which must be less than or equal to the original amount. Any additional amount will be automatically refunded. Defaults to the full `amount_capturable` if not provided.
	AmountToCapture *int64 `form:"amount_to_capture"`
	// The amount of the application fee (if any) that will be requested to be applied to the payment and transferred to the application owner's Stripe account. The amount of the application fee collected will be capped at the total payment amount. For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
	ApplicationFeeAmount *int64 `form:"application_fee_amount"`
	// For non-card charges, you can use this value as the complete description that appears on your customers' statements. Must contain at least one letter, maximum 22 characters.
	StatementDescriptor *string `form:"statement_descriptor"`
	// Provides information about a card payment that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that's set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
	StatementDescriptorSuffix *string `form:"statement_descriptor_suffix"`
	// The parameters used to automatically create a Transfer when the payment
	// is captured. For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
	TransferData *PaymentIntentTransferDataParams `form:"transfer_data"`
}

// The parameters used to automatically create a Transfer when the payment is captured.
// For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
type PaymentIntentIncrementAuthorizationTransferDataParams struct {
	// The amount that will be transferred automatically when a charge succeeds.
	Amount *int64 `form:"amount"`
}

// Perform an incremental authorization on an eligible
// [PaymentIntent](https://stripe.com/docs/api/payment_intents/object). To be eligible, the
// PaymentIntent's status must be requires_capture and
// [incremental_authorization_supported](https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-card_present-incremental_authorization_supported)
// must be true.
//
// Incremental authorizations attempt to increase the authorized amount on
// your customer's card to the new, higher amount provided. As with the
// initial authorization, incremental authorizations may be declined. A
// single PaymentIntent can call this endpoint multiple times to further
// increase the authorized amount.
//
// If the incremental authorization succeeds, the PaymentIntent object is
// returned with the updated
// [amount](https://stripe.com/docs/api/payment_intents/object#payment_intent_object-amount).
// If the incremental authorization fails, a
// [card_declined](https://stripe.com/docs/error-codes#card-declined) error is returned, and no
// fields on the PaymentIntent or Charge are updated. The PaymentIntent
// object remains capturable for the previously authorized amount.
//
// Each PaymentIntent can have a maximum of 10 incremental authorization attempts, including declines.
// Once captured, a PaymentIntent can no longer be incremented.
//
// Learn more about [incremental authorizations](https://stripe.com/docs/terminal/features/incremental-authorizations).
type PaymentIntentIncrementAuthorizationParams struct {
	Params `form:"*"`
	// The updated total amount you intend to collect from the cardholder. This amount must be greater than the currently authorized amount.
	Amount *int64 `form:"amount"`
	// The amount of the application fee (if any) that will be requested to be applied to the payment and transferred to the application owner's Stripe account. The amount of the application fee collected will be capped at the total payment amount. For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
	ApplicationFeeAmount *int64 `form:"application_fee_amount"`
	// An arbitrary string attached to the object. Often useful for displaying to users.
	Description *string `form:"description"`
	// For non-card charges, you can use this value as the complete description that appears on your customers' statements. Must contain at least one letter, maximum 22 characters.
	StatementDescriptor *string `form:"statement_descriptor"`
	// The parameters used to automatically create a Transfer when the payment is captured.
	// For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
	TransferData *PaymentIntentIncrementAuthorizationTransferDataParams `form:"transfer_data"`
}

// Verifies microdeposits on a PaymentIntent object.
type PaymentIntentVerifyMicrodepositsParams struct {
	Params `form:"*"`
	// Two positive integers, in *cents*, equal to the values of the microdeposits sent to the bank account.
	Amounts []*int64 `form:"amounts"`
	// A six-character code starting with SM present in the microdeposit sent to the bank account.
	DescriptorCode *string `form:"descriptor_code"`
}

// Manually reconcile the remaining amount for a customer_balance PaymentIntent.
type PaymentIntentApplyCustomerBalanceParams struct {
	Params `form:"*"`
	// Amount intended to be applied to this PaymentIntent from the customer's cash balance.
	//
	// A positive integer representing how much to charge in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency).
	//
	// The maximum amount is the amount of the PaymentIntent.
	//
	// When omitted, the amount defaults to the remaining amount requested on the PaymentIntent.
	Amount *int64 `form:"amount"`
	// Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
	Currency *string `form:"currency"`
}
type PaymentIntentAmountDetailsTip struct {
	// Portion of the amount that corresponds to a tip.
	Amount int64 `json:"amount"`
}
type PaymentIntentAmountDetails struct {
	Tip *PaymentIntentAmountDetailsTip `json:"tip"`
}

// Settings to configure compatible payment methods from the [Stripe Dashboard](https://dashboard.stripe.com/settings/payment_methods)
type PaymentIntentAutomaticPaymentMethods struct {
	// Controls whether this PaymentIntent will accept redirect-based payment methods.
	//
	// Redirect-based payment methods may require your customer to be redirected to a payment method's app or site for authentication or additional steps. To [confirm](https://stripe.com/docs/api/payment_intents/confirm) this PaymentIntent, you may be required to provide a `return_url` to redirect customers back to your site after they authenticate or complete the payment.
	AllowRedirects PaymentIntentAutomaticPaymentMethodsAllowRedirects `json:"allow_redirects"`
	// Automatically calculates compatible payment methods
	Enabled bool `json:"enabled"`
}
type PaymentIntentNextActionAlipayHandleRedirect struct {
	// The native data to be used with Alipay SDK you must redirect your customer to in order to authenticate the payment in an Android App.
	NativeData string `json:"native_data"`
	// The native URL you must redirect your customer to in order to authenticate the payment in an iOS App.
	NativeURL string `json:"native_url"`
	// If the customer does not exit their browser while authenticating, they will be redirected to this specified URL after completion.
	ReturnURL string `json:"return_url"`
	// The URL you must redirect your customer to in order to authenticate the payment.
	URL string `json:"url"`
}
type PaymentIntentNextActionBoletoDisplayDetails struct {
	// The timestamp after which the boleto expires.
	ExpiresAt int64 `json:"expires_at"`
	// The URL to the hosted boleto voucher page, which allows customers to view the boleto voucher.
	HostedVoucherURL string `json:"hosted_voucher_url"`
	// The boleto number.
	Number string `json:"number"`
	// The URL to the downloadable boleto voucher PDF.
	PDF string `json:"pdf"`
}
type PaymentIntentNextActionCardAwaitNotification struct {
	// The time that payment will be attempted. If customer approval is required, they need to provide approval before this time.
	ChargeAttemptAt int64 `json:"charge_attempt_at"`
	// For payments greater than INR 15000, the customer must provide explicit approval of the payment with their bank. For payments of lower amount, no customer action is required.
	CustomerApprovalRequired bool `json:"customer_approval_required"`
}
type PaymentIntentNextActionCashAppHandleRedirectOrDisplayQRCodeQRCode struct {
	// The date (unix timestamp) when the QR code expires.
	ExpiresAt int64 `json:"expires_at"`
	// The image_url_png string used to render QR code
	ImageURLPNG string `json:"image_url_png"`
	// The image_url_svg string used to render QR code
	ImageURLSVG string `json:"image_url_svg"`
}
type PaymentIntentNextActionCashAppHandleRedirectOrDisplayQRCode struct {
	// The URL to the hosted Cash App Pay instructions page, which allows customers to view the QR code, and supports QR code refreshing on expiration.
	HostedInstructionsURL string `json:"hosted_instructions_url"`
	// The url for mobile redirect based auth
	MobileAuthURL string                                                             `json:"mobile_auth_url"`
	QRCode        *PaymentIntentNextActionCashAppHandleRedirectOrDisplayQRCodeQRCode `json:"qr_code"`
}

// Iban Records contain E.U. bank account details per the SEPA format.
type PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressIBAN struct {
	// The name of the person or business that owns the bank account
	AccountHolderName string `json:"account_holder_name"`
	// The BIC/SWIFT code of the account.
	BIC string `json:"bic"`
	// Two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
	Country string `json:"country"`
	// The IBAN of the account.
	IBAN string `json:"iban"`
}

// Sort Code Records contain U.K. bank account details per the sort code format.
type PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSortCode struct {
	// The name of the person or business that owns the bank account
	AccountHolderName string `json:"account_holder_name"`
	// The account number
	AccountNumber string `json:"account_number"`
	// The six-digit sort code
	SortCode string `json:"sort_code"`
}

// SPEI Records contain Mexico bank account details per the SPEI format.
type PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSpei struct {
	// The three-digit bank code
	BankCode string `json:"bank_code"`
	// The short banking institution name
	BankName string `json:"bank_name"`
	// The CLABE number
	Clabe string `json:"clabe"`
}

// Zengin Records contain Japan bank account details per the Zengin format.
type PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressZengin struct {
	// The account holder name
	AccountHolderName string `json:"account_holder_name"`
	// The account number
	AccountNumber string `json:"account_number"`
	// The bank account type. In Japan, this can only be `futsu` or `toza`.
	AccountType string `json:"account_type"`
	// The bank code of the account
	BankCode string `json:"bank_code"`
	// The bank name of the account
	BankName string `json:"bank_name"`
	// The branch code of the account
	BranchCode string `json:"branch_code"`
	// The branch name of the account
	BranchName string `json:"branch_name"`
}

// A list of financial addresses that can be used to fund the customer balance
type PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddress struct {
	// Iban Records contain E.U. bank account details per the SEPA format.
	IBAN *PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressIBAN `json:"iban"`
	// Sort Code Records contain U.K. bank account details per the sort code format.
	SortCode *PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSortCode `json:"sort_code"`
	// SPEI Records contain Mexico bank account details per the SPEI format.
	Spei *PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSpei `json:"spei"`
	// The payment networks supported by this FinancialAddress
	SupportedNetworks []PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressSupportedNetwork `json:"supported_networks"`
	// The type of financial address
	Type PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressType `json:"type"`
	// Zengin Records contain Japan bank account details per the Zengin format.
	Zengin *PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddressZengin `json:"zengin"`
}
type PaymentIntentNextActionDisplayBankTransferInstructions struct {
	// The remaining amount that needs to be transferred to complete the payment.
	AmountRemaining int64 `json:"amount_remaining"`
	// Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
	Currency Currency `json:"currency"`
	// A list of financial addresses that can be used to fund the customer balance
	FinancialAddresses []*PaymentIntentNextActionDisplayBankTransferInstructionsFinancialAddress `json:"financial_addresses"`
	// A link to a hosted page that guides your customer through completing the transfer.
	HostedInstructionsURL string `json:"hosted_instructions_url"`
	// A string identifying this payment. Instruct your customer to include this code in the reference or memo field of their bank transfer.
	Reference string `json:"reference"`
	// Type of bank transfer
	Type PaymentIntentNextActionDisplayBankTransferInstructionsType `json:"type"`
}

// FamilyMart instruction details.
type PaymentIntentNextActionKonbiniDisplayDetailsStoresFamilyMart struct {
	// The confirmation number.
	ConfirmationNumber string `json:"confirmation_number"`
	// The payment code.
	PaymentCode string `json:"payment_code"`
}

// Lawson instruction details.
type PaymentIntentNextActionKonbiniDisplayDetailsStoresLawson struct {
	// The confirmation number.
	ConfirmationNumber string `json:"confirmation_number"`
	// The payment code.
	PaymentCode string `json:"payment_code"`
}

// Ministop instruction details.
type PaymentIntentNextActionKonbiniDisplayDetailsStoresMinistop struct {
	// The confirmation number.
	ConfirmationNumber string `json:"confirmation_number"`
	// The payment code.
	PaymentCode string `json:"payment_code"`
}

// Seicomart instruction details.
type PaymentIntentNextActionKonbiniDisplayDetailsStoresSeicomart struct {
	// The confirmation number.
	ConfirmationNumber string `json:"confirmation_number"`
	// The payment code.
	PaymentCode string `json:"payment_code"`
}
type PaymentIntentNextActionKonbiniDisplayDetailsStores struct {
	// FamilyMart instruction details.
	FamilyMart *PaymentIntentNextActionKonbiniDisplayDetailsStoresFamilyMart `json:"familymart"`
	// Lawson instruction details.
	Lawson *PaymentIntentNextActionKonbiniDisplayDetailsStoresLawson `json:"lawson"`
	// Ministop instruction details.
	Ministop *PaymentIntentNextActionKonbiniDisplayDetailsStoresMinistop `json:"ministop"`
	// Seicomart instruction details.
	Seicomart *PaymentIntentNextActionKonbiniDisplayDetailsStoresSeicomart `json:"seicomart"`
}
type PaymentIntentNextActionKonbiniDisplayDetails struct {
	// The timestamp at which the pending Konbini payment expires.
	ExpiresAt int64 `json:"expires_at"`
	// The URL for the Konbini payment instructions page, which allows customers to view and print a Konbini voucher.
	HostedVoucherURL string                                              `json:"hosted_voucher_url"`
	Stores           *PaymentIntentNextActionKonbiniDisplayDetailsStores `json:"stores"`
}
type PaymentIntentNextActionOXXODisplayDetails struct {
	// The timestamp after which the OXXO voucher expires.
	ExpiresAfter int64 `json:"expires_after"`
	// The URL for the hosted OXXO voucher page, which allows customers to view and print an OXXO voucher.
	HostedVoucherURL string `json:"hosted_voucher_url"`
	// OXXO reference number.
	Number string `json:"number"`
}
type PaymentIntentNextActionPayNowDisplayQRCode struct {
	// The raw data string used to generate QR code, it should be used together with QR code library.
	Data string `json:"data"`
	// The URL to the hosted PayNow instructions page, which allows customers to view the PayNow QR code.
	HostedInstructionsURL string `json:"hosted_instructions_url"`
	// The image_url_png string used to render QR code
	ImageURLPNG string `json:"image_url_png"`
	// The image_url_svg string used to render QR code
	ImageURLSVG string `json:"image_url_svg"`
}
type PaymentIntentNextActionPixDisplayQRCode struct {
	// The raw data string used to generate QR code, it should be used together with QR code library.
	Data string `json:"data"`
	// The date (unix timestamp) when the PIX expires.
	ExpiresAt int64 `json:"expires_at"`
	// The URL to the hosted pix instructions page, which allows customers to view the pix QR code.
	HostedInstructionsURL string `json:"hosted_instructions_url"`
	// The image_url_png string used to render png QR code
	ImageURLPNG string `json:"image_url_png"`
	// The image_url_svg string used to render svg QR code
	ImageURLSVG string `json:"image_url_svg"`
}
type PaymentIntentNextActionPromptPayDisplayQRCode struct {
	// The raw data string used to generate QR code, it should be used together with QR code library.
	Data string `json:"data"`
	// The URL to the hosted PromptPay instructions page, which allows customers to view the PromptPay QR code.
	HostedInstructionsURL string `json:"hosted_instructions_url"`
	// The PNG path used to render the QR code, can be used as the source in an HTML img tag
	ImageURLPNG string `json:"image_url_png"`
	// The SVG path used to render the QR code, can be used as the source in an HTML img tag
	ImageURLSVG string `json:"image_url_svg"`
}
type PaymentIntentNextActionRedirectToURL struct {
	// If the customer does not exit their browser while authenticating, they will be redirected to this specified URL after completion.
	ReturnURL string `json:"return_url"`
	// The URL you must redirect your customer to in order to authenticate the payment.
	URL string `json:"url"`
}

// When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this dictionary to invoke authentication flows. The shape of the contents is subject to change and is only intended to be used by Stripe.js.
type PaymentIntentNextActionUseStripeSDK struct{}
type PaymentIntentNextActionVerifyWithMicrodeposits struct {
	// The timestamp when the microdeposits are expected to land.
	ArrivalDate int64 `json:"arrival_date"`
	// The URL for the hosted verification page, which allows customers to verify their bank account.
	HostedVerificationURL string `json:"hosted_verification_url"`
	// The type of the microdeposit sent to the customer. Used to distinguish between different verification methods.
	MicrodepositType PaymentIntentNextActionVerifyWithMicrodepositsMicrodepositType `json:"microdeposit_type"`
}
type PaymentIntentNextActionWeChatPayDisplayQRCode struct {
	// The data being used to generate QR code
	Data string `json:"data"`
	// The URL to the hosted WeChat Pay instructions page, which allows customers to view the WeChat Pay QR code.
	HostedInstructionsURL string `json:"hosted_instructions_url"`
	// The base64 image data for a pre-generated QR code
	ImageDataURL string `json:"image_data_url"`
	// The image_url_png string used to render QR code
	ImageURLPNG string `json:"image_url_png"`
	// The image_url_svg string used to render QR code
	ImageURLSVG string `json:"image_url_svg"`
}
type PaymentIntentNextActionWeChatPayRedirectToAndroidApp struct {
	// app_id is the APP ID registered on WeChat open platform
	AppID string `json:"app_id"`
	// nonce_str is a random string
	NonceStr string `json:"nonce_str"`
	// package is static value
	Package string `json:"package"`
	// an unique merchant ID assigned by WeChat Pay
	PartnerID string `json:"partner_id"`
	// an unique trading ID assigned by WeChat Pay
	PrepayID string `json:"prepay_id"`
	// A signature
	Sign string `json:"sign"`
	// Specifies the current time in epoch format
	Timestamp string `json:"timestamp"`
}
type PaymentIntentNextActionWeChatPayRedirectToIOSApp struct {
	// An universal link that redirect to WeChat Pay app
	NativeURL string `json:"native_url"`
}

// If present, this property tells you what actions you need to take in order for your customer to fulfill a payment using the provided source.
type PaymentIntentNextAction struct {
	AlipayHandleRedirect                 *PaymentIntentNextActionAlipayHandleRedirect                 `json:"alipay_handle_redirect"`
	BoletoDisplayDetails                 *PaymentIntentNextActionBoletoDisplayDetails                 `json:"boleto_display_details"`
	CardAwaitNotification                *PaymentIntentNextActionCardAwaitNotification                `json:"card_await_notification"`
	CashAppHandleRedirectOrDisplayQRCode *PaymentIntentNextActionCashAppHandleRedirectOrDisplayQRCode `json:"cashapp_handle_redirect_or_display_qr_code"`
	DisplayBankTransferInstructions      *PaymentIntentNextActionDisplayBankTransferInstructions      `json:"display_bank_transfer_instructions"`
	KonbiniDisplayDetails                *PaymentIntentNextActionKonbiniDisplayDetails                `json:"konbini_display_details"`
	OXXODisplayDetails                   *PaymentIntentNextActionOXXODisplayDetails                   `json:"oxxo_display_details"`
	PayNowDisplayQRCode                  *PaymentIntentNextActionPayNowDisplayQRCode                  `json:"paynow_display_qr_code"`
	PixDisplayQRCode                     *PaymentIntentNextActionPixDisplayQRCode                     `json:"pix_display_qr_code"`
	PromptPayDisplayQRCode               *PaymentIntentNextActionPromptPayDisplayQRCode               `json:"promptpay_display_qr_code"`
	RedirectToURL                        *PaymentIntentNextActionRedirectToURL                        `json:"redirect_to_url"`
	// Type of the next action to perform, one of `redirect_to_url`, `use_stripe_sdk`, `alipay_handle_redirect`, `oxxo_display_details`, or `verify_with_microdeposits`.
	Type PaymentIntentNextActionType `json:"type"`
	// When confirming a PaymentIntent with Stripe.js, Stripe.js depends on the contents of this dictionary to invoke authentication flows. The shape of the contents is subject to change and is only intended to be used by Stripe.js.
	UseStripeSDK                  *PaymentIntentNextActionUseStripeSDK                  `json:"use_stripe_sdk"`
	VerifyWithMicrodeposits       *PaymentIntentNextActionVerifyWithMicrodeposits       `json:"verify_with_microdeposits"`
	WeChatPayDisplayQRCode        *PaymentIntentNextActionWeChatPayDisplayQRCode        `json:"wechat_pay_display_qr_code"`
	WeChatPayRedirectToAndroidApp *PaymentIntentNextActionWeChatPayRedirectToAndroidApp `json:"wechat_pay_redirect_to_android_app"`
	WeChatPayRedirectToIOSApp     *PaymentIntentNextActionWeChatPayRedirectToIOSApp     `json:"wechat_pay_redirect_to_ios_app"`
}
type PaymentIntentPaymentMethodOptionsACSSDebitMandateOptions struct {
	// A URL for custom mandate text
	CustomMandateURL string `json:"custom_mandate_url"`
	// Description of the interval. Only required if the 'payment_schedule' parameter is 'interval' or 'combined'.
	IntervalDescription string `json:"interval_description"`
	// Payment schedule for the mandate.
	PaymentSchedule PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsPaymentSchedule `json:"payment_schedule"`
	// Transaction type of the mandate.
	TransactionType PaymentIntentPaymentMethodOptionsACSSDebitMandateOptionsTransactionType `json:"transaction_type"`
}
type PaymentIntentPaymentMethodOptionsACSSDebit struct {
	MandateOptions *PaymentIntentPaymentMethodOptionsACSSDebitMandateOptions `json:"mandate_options"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsACSSDebitSetupFutureUsage `json:"setup_future_usage"`
	// Bank account verification method.
	VerificationMethod PaymentIntentPaymentMethodOptionsACSSDebitVerificationMethod `json:"verification_method"`
}
type PaymentIntentPaymentMethodOptionsAffirm struct {
	// Controls when the funds will be captured from the customer's account.
	CaptureMethod PaymentIntentPaymentMethodOptionsAffirmCaptureMethod `json:"capture_method"`
	// Preferred language of the Affirm authorization page that the customer is redirected to.
	PreferredLocale string `json:"preferred_locale"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsAffirmSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsAfterpayClearpay struct {
	// Controls when the funds will be captured from the customer's account.
	CaptureMethod PaymentIntentPaymentMethodOptionsAfterpayClearpayCaptureMethod `json:"capture_method"`
	// Order identifier shown to the customer in Afterpay's online portal. We recommend using a value that helps you answer any questions a customer might have about
	// the payment. The identifier is limited to 128 characters and may contain only letters, digits, underscores, backslashes and dashes.
	Reference string `json:"reference"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsAfterpayClearpaySetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsAlipay struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsAlipaySetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsAUBECSDebit struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsAUBECSDebitSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsBACSDebit struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsBACSDebitSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsBancontact struct {
	// Preferred language of the Bancontact authorization page that the customer is redirected to.
	PreferredLanguage string `json:"preferred_language"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsBancontactSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsBLIK struct{}
type PaymentIntentPaymentMethodOptionsBoleto struct {
	// The number of calendar days before a Boleto voucher expires. For example, if you create a Boleto voucher on Monday and you set expires_after_days to 2, the Boleto voucher will expire on Wednesday at 23:59 America/Sao_Paulo time.
	ExpiresAfterDays int64 `json:"expires_after_days"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsBoletoSetupFutureUsage `json:"setup_future_usage"`
}

// Installment plan selected for this PaymentIntent.
type PaymentIntentPaymentMethodOptionsCardInstallmentsPlan struct {
	// For `fixed_count` installment plans, this is the number of installment payments your customer will make to their credit card.
	Count int64 `json:"count"`
	// For `fixed_count` installment plans, this is the interval between installment payments your customer will make to their credit card.
	// One of `month`.
	Interval PaymentIntentPaymentMethodOptionsCardInstallmentsPlanInterval `json:"interval"`
	// Type of installment plan, one of `fixed_count`.
	Type PaymentIntentPaymentMethodOptionsCardInstallmentsPlanType `json:"type"`
}

// Installment details for this payment (Mexico only).
//
// For more information, see the [installments integration guide](https://stripe.com/docs/payments/installments).
type PaymentIntentPaymentMethodOptionsCardInstallments struct {
	// Installment plans that may be selected for this PaymentIntent.
	AvailablePlans []*PaymentIntentPaymentMethodOptionsCardInstallmentsPlan `json:"available_plans"`
	// Whether Installments are enabled for this PaymentIntent.
	Enabled bool `json:"enabled"`
	// Installment plan selected for this PaymentIntent.
	Plan *PaymentIntentPaymentMethodOptionsCardInstallmentsPlan `json:"plan"`
}

// Configuration options for setting up an eMandate for cards issued in India.
type PaymentIntentPaymentMethodOptionsCardMandateOptions struct {
	// Amount to be charged for future payments.
	Amount int64 `json:"amount"`
	// One of `fixed` or `maximum`. If `fixed`, the `amount` param refers to the exact amount to be charged in future payments. If `maximum`, the amount charged can be up to the value passed for the `amount` param.
	AmountType PaymentIntentPaymentMethodOptionsCardMandateOptionsAmountType `json:"amount_type"`
	// A description of the mandate or subscription that is meant to be displayed to the customer.
	Description string `json:"description"`
	// End date of the mandate or subscription. If not provided, the mandate will be active until canceled. If provided, end date should be after start date.
	EndDate int64 `json:"end_date"`
	// Specifies payment frequency. One of `day`, `week`, `month`, `year`, or `sporadic`.
	Interval PaymentIntentPaymentMethodOptionsCardMandateOptionsInterval `json:"interval"`
	// The number of intervals between payments. For example, `interval=month` and `interval_count=3` indicates one payment every three months. Maximum of one year interval allowed (1 year, 12 months, or 52 weeks). This parameter is optional when `interval=sporadic`.
	IntervalCount int64 `json:"interval_count"`
	// Unique identifier for the mandate or subscription.
	Reference string `json:"reference"`
	// Start date of the mandate or subscription. Start date should not be lesser than yesterday.
	StartDate int64 `json:"start_date"`
	// Specifies the type of mandates supported. Possible values are `india`.
	SupportedTypes []PaymentIntentPaymentMethodOptionsCardMandateOptionsSupportedType `json:"supported_types"`
}
type PaymentIntentPaymentMethodOptionsCard struct {
	// Controls when the funds will be captured from the customer's account.
	CaptureMethod PaymentIntentPaymentMethodOptionsCardCaptureMethod `json:"capture_method"`
	// Installment details for this payment (Mexico only).
	//
	// For more information, see the [installments integration guide](https://stripe.com/docs/payments/installments).
	Installments *PaymentIntentPaymentMethodOptionsCardInstallments `json:"installments"`
	// Configuration options for setting up an eMandate for cards issued in India.
	MandateOptions *PaymentIntentPaymentMethodOptionsCardMandateOptions `json:"mandate_options"`
	// Selected network to process this payment intent on. Depends on the available networks of the card attached to the payment intent. Can be only set confirm-time.
	Network PaymentIntentPaymentMethodOptionsCardNetwork `json:"network"`
	// We strongly recommend that you rely on our SCA Engine to automatically prompt your customers for authentication based on risk level and [other requirements](https://stripe.com/docs/strong-customer-authentication). However, if you wish to request 3D Secure based on logic from your own fraud engine, provide this option. Permitted values include: `automatic` or `any`. If not provided, defaults to `automatic`. Read our guide on [manually requesting 3D Secure](https://stripe.com/docs/payments/3d-secure#manual-three-ds) for more information on how this configuration interacts with Radar and our SCA Engine.
	RequestThreeDSecure PaymentIntentPaymentMethodOptionsCardRequestThreeDSecure `json:"request_three_d_secure"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsCardSetupFutureUsage `json:"setup_future_usage"`
	// Provides information about a card payment that customers see on their statements. Concatenated with the Kana prefix (shortened Kana descriptor) or Kana statement descriptor that's set on the account to form the complete statement descriptor. Maximum 22 characters. On card statements, the *concatenation* of both prefix and suffix (including separators) will appear truncated to 22 characters.
	StatementDescriptorSuffixKana string `json:"statement_descriptor_suffix_kana"`
	// Provides information about a card payment that customers see on their statements. Concatenated with the Kanji prefix (shortened Kanji descriptor) or Kanji statement descriptor that's set on the account to form the complete statement descriptor. Maximum 17 characters. On card statements, the *concatenation* of both prefix and suffix (including separators) will appear truncated to 17 characters.
	StatementDescriptorSuffixKanji string `json:"statement_descriptor_suffix_kanji"`
}
type PaymentIntentPaymentMethodOptionsCardPresent struct {
	// Request ability to capture this payment beyond the standard [authorization validity window](https://stripe.com/docs/terminal/features/extended-authorizations#authorization-validity)
	RequestExtendedAuthorization bool `json:"request_extended_authorization"`
	// Request ability to [increment](https://stripe.com/docs/terminal/features/incremental-authorizations) this PaymentIntent if the combination of MCC and card brand is eligible. Check [incremental_authorization_supported](https://stripe.com/docs/api/charges/object#charge_object-payment_method_details-card_present-incremental_authorization_supported) in the [Confirm](https://stripe.com/docs/api/payment_intents/confirm) response to verify support.
	RequestIncrementalAuthorizationSupport bool `json:"request_incremental_authorization_support"`
}
type PaymentIntentPaymentMethodOptionsCashApp struct {
	// Controls when the funds will be captured from the customer's account.
	CaptureMethod PaymentIntentPaymentMethodOptionsCashAppCaptureMethod `json:"capture_method"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsCashAppSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferEUBankTransfer struct {
	// The desired country code of the bank account information. Permitted values include: `BE`, `DE`, `ES`, `FR`, `IE`, or `NL`.
	Country string `json:"country"`
}
type PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransfer struct {
	EUBankTransfer *PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferEUBankTransfer `json:"eu_bank_transfer"`
	// List of address types that should be returned in the financial_addresses response. If not specified, all valid types will be returned.
	//
	// Permitted values include: `sort_code`, `zengin`, `iban`, or `spei`.
	RequestedAddressTypes []PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferRequestedAddressType `json:"requested_address_types"`
	// The bank transfer type that this PaymentIntent is allowed to use for funding Permitted values include: `eu_bank_transfer`, `gb_bank_transfer`, `jp_bank_transfer`, `mx_bank_transfer`, or `us_bank_transfer`.
	Type PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransferType `json:"type"`
}
type PaymentIntentPaymentMethodOptionsCustomerBalance struct {
	BankTransfer *PaymentIntentPaymentMethodOptionsCustomerBalanceBankTransfer `json:"bank_transfer"`
	// The funding method type to be used when there are not enough funds in the customer balance. Permitted values include: `bank_transfer`.
	FundingType PaymentIntentPaymentMethodOptionsCustomerBalanceFundingType `json:"funding_type"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsCustomerBalanceSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsEPS struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsEPSSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsFPX struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsFPXSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsGiropay struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsGiropaySetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsGrabpay struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsGrabpaySetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsIDEAL struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsIDEALSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsInteracPresent struct{}
type PaymentIntentPaymentMethodOptionsKlarna struct {
	// Controls when the funds will be captured from the customer's account.
	CaptureMethod PaymentIntentPaymentMethodOptionsKlarnaCaptureMethod `json:"capture_method"`
	// Preferred locale of the Klarna checkout page that the customer is redirected to.
	PreferredLocale string `json:"preferred_locale"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsKlarnaSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsKonbini struct {
	// An optional 10 to 11 digit numeric-only string determining the confirmation code at applicable convenience stores.
	ConfirmationNumber string `json:"confirmation_number"`
	// The number of calendar days (between 1 and 60) after which Konbini payment instructions will expire. For example, if a PaymentIntent is confirmed with Konbini and `expires_after_days` set to 2 on Monday JST, the instructions will expire on Wednesday 23:59:59 JST.
	ExpiresAfterDays int64 `json:"expires_after_days"`
	// The timestamp at which the Konbini payment instructions will expire. Only one of `expires_after_days` or `expires_at` may be set.
	ExpiresAt int64 `json:"expires_at"`
	// A product descriptor of up to 22 characters, which will appear to customers at the convenience store.
	ProductDescription string `json:"product_description"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsKonbiniSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsLink struct {
	// Controls when the funds will be captured from the customer's account.
	CaptureMethod PaymentIntentPaymentMethodOptionsLinkCaptureMethod `json:"capture_method"`
	// [Deprecated] This is a legacy parameter that no longer has any function.
	PersistentToken string `json:"persistent_token"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsLinkSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsOXXO struct {
	// The number of calendar days before an OXXO invoice expires. For example, if you create an OXXO invoice on Monday and you set expires_after_days to 2, the OXXO invoice will expire on Wednesday at 23:59 America/Mexico_City time.
	ExpiresAfterDays int64 `json:"expires_after_days"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsOXXOSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsP24 struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsP24SetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsPayNow struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsPayNowSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsPaypal struct {
	// Controls when the funds will be captured from the customer's account.
	CaptureMethod PaymentIntentPaymentMethodOptionsPaypalCaptureMethod `json:"capture_method"`
	// Preferred locale of the PayPal checkout page that the customer is redirected to.
	PreferredLocale string `json:"preferred_locale"`
	// A reference of the PayPal transaction visible to customer which is mapped to PayPal's invoice ID. This must be a globally unique ID if you have configured in your PayPal settings to block multiple payments per invoice ID.
	Reference string `json:"reference"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsPaypalSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsPix struct {
	// The number of seconds (between 10 and 1209600) after which Pix payment will expire.
	ExpiresAfterSeconds int64 `json:"expires_after_seconds"`
	// The timestamp at which the Pix expires.
	ExpiresAt int64 `json:"expires_at"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsPixSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsPromptPay struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsPromptPaySetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsSEPADebitMandateOptions struct{}
type PaymentIntentPaymentMethodOptionsSEPADebit struct {
	MandateOptions *PaymentIntentPaymentMethodOptionsSEPADebitMandateOptions `json:"mandate_options"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsSEPADebitSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsSofort struct {
	// Preferred language of the SOFORT authorization page that the customer is redirected to.
	PreferredLanguage string `json:"preferred_language"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsSofortSetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnections struct {
	// The list of permissions to request. The `payment_method` permission must be included.
	Permissions []PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnectionsPermission `json:"permissions"`
	// For webview integrations only. Upon completing OAuth login in the native browser, the user will be redirected to this URL to return to your app.
	ReturnURL string `json:"return_url"`
}
type PaymentIntentPaymentMethodOptionsUSBankAccount struct {
	FinancialConnections *PaymentIntentPaymentMethodOptionsUSBankAccountFinancialConnections `json:"financial_connections"`
	// Preferred transaction settlement speed
	PreferredSettlementSpeed PaymentIntentPaymentMethodOptionsUSBankAccountPreferredSettlementSpeed `json:"preferred_settlement_speed"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsUSBankAccountSetupFutureUsage `json:"setup_future_usage"`
	// Bank account verification method.
	VerificationMethod PaymentIntentPaymentMethodOptionsUSBankAccountVerificationMethod `json:"verification_method"`
}
type PaymentIntentPaymentMethodOptionsWeChatPay struct {
	// The app ID registered with WeChat Pay. Only required when client is ios or android.
	AppID string `json:"app_id"`
	// The client type that the end customer will pay from
	Client PaymentIntentPaymentMethodOptionsWeChatPayClient `json:"client"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsWeChatPaySetupFutureUsage `json:"setup_future_usage"`
}
type PaymentIntentPaymentMethodOptionsZip struct {
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentPaymentMethodOptionsZipSetupFutureUsage `json:"setup_future_usage"`
}

// Payment-method-specific configuration for this PaymentIntent.
type PaymentIntentPaymentMethodOptions struct {
	ACSSDebit        *PaymentIntentPaymentMethodOptionsACSSDebit        `json:"acss_debit"`
	Affirm           *PaymentIntentPaymentMethodOptionsAffirm           `json:"affirm"`
	AfterpayClearpay *PaymentIntentPaymentMethodOptionsAfterpayClearpay `json:"afterpay_clearpay"`
	Alipay           *PaymentIntentPaymentMethodOptionsAlipay           `json:"alipay"`
	AUBECSDebit      *PaymentIntentPaymentMethodOptionsAUBECSDebit      `json:"au_becs_debit"`
	BACSDebit        *PaymentIntentPaymentMethodOptionsBACSDebit        `json:"bacs_debit"`
	Bancontact       *PaymentIntentPaymentMethodOptionsBancontact       `json:"bancontact"`
	BLIK             *PaymentIntentPaymentMethodOptionsBLIK             `json:"blik"`
	Boleto           *PaymentIntentPaymentMethodOptionsBoleto           `json:"boleto"`
	Card             *PaymentIntentPaymentMethodOptionsCard             `json:"card"`
	CardPresent      *PaymentIntentPaymentMethodOptionsCardPresent      `json:"card_present"`
	CashApp          *PaymentIntentPaymentMethodOptionsCashApp          `json:"cashapp"`
	CustomerBalance  *PaymentIntentPaymentMethodOptionsCustomerBalance  `json:"customer_balance"`
	EPS              *PaymentIntentPaymentMethodOptionsEPS              `json:"eps"`
	FPX              *PaymentIntentPaymentMethodOptionsFPX              `json:"fpx"`
	Giropay          *PaymentIntentPaymentMethodOptionsGiropay          `json:"giropay"`
	Grabpay          *PaymentIntentPaymentMethodOptionsGrabpay          `json:"grabpay"`
	IDEAL            *PaymentIntentPaymentMethodOptionsIDEAL            `json:"ideal"`
	InteracPresent   *PaymentIntentPaymentMethodOptionsInteracPresent   `json:"interac_present"`
	Klarna           *PaymentIntentPaymentMethodOptionsKlarna           `json:"klarna"`
	Konbini          *PaymentIntentPaymentMethodOptionsKonbini          `json:"konbini"`
	Link             *PaymentIntentPaymentMethodOptionsLink             `json:"link"`
	OXXO             *PaymentIntentPaymentMethodOptionsOXXO             `json:"oxxo"`
	P24              *PaymentIntentPaymentMethodOptionsP24              `json:"p24"`
	PayNow           *PaymentIntentPaymentMethodOptionsPayNow           `json:"paynow"`
	Paypal           *PaymentIntentPaymentMethodOptionsPaypal           `json:"paypal"`
	Pix              *PaymentIntentPaymentMethodOptionsPix              `json:"pix"`
	PromptPay        *PaymentIntentPaymentMethodOptionsPromptPay        `json:"promptpay"`
	SEPADebit        *PaymentIntentPaymentMethodOptionsSEPADebit        `json:"sepa_debit"`
	Sofort           *PaymentIntentPaymentMethodOptionsSofort           `json:"sofort"`
	USBankAccount    *PaymentIntentPaymentMethodOptionsUSBankAccount    `json:"us_bank_account"`
	WeChatPay        *PaymentIntentPaymentMethodOptionsWeChatPay        `json:"wechat_pay"`
	Zip              *PaymentIntentPaymentMethodOptionsZip              `json:"zip"`
}
type PaymentIntentProcessingCardCustomerNotification struct {
	// Whether customer approval has been requested for this payment. For payments greater than INR 15000 or mandate amount, the customer must provide explicit approval of the payment with their bank.
	ApprovalRequested bool `json:"approval_requested"`
	// If customer approval is required, they need to provide approval before this time.
	CompletesAt int64 `json:"completes_at"`
}
type PaymentIntentProcessingCard struct {
	CustomerNotification *PaymentIntentProcessingCardCustomerNotification `json:"customer_notification"`
}

// If present, this property tells you about the processing state of the payment.
type PaymentIntentProcessing struct {
	Card *PaymentIntentProcessingCard `json:"card"`
	// Type of the payment method for which payment is in `processing` state, one of `card`.
	Type PaymentIntentProcessingType `json:"type"`
}

// The data with which to automatically create a Transfer when the payment is finalized. See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts) for details.
type PaymentIntentTransferData struct {
	// Amount intended to be collected by this PaymentIntent. A positive integer representing how much to charge in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The minimum amount is $0.50 US or [equivalent in charge currency](https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts). The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).
	Amount int64 `json:"amount"`
	// The account (if any) the payment will be attributed to for tax
	// reporting, and where funds from the payment will be transferred to upon
	// payment success.
	Destination *Account `json:"destination"`
}

// A PaymentIntent guides you through the process of collecting a payment from your customer.
// We recommend that you create exactly one PaymentIntent for each order or
// customer session in your system. You can reference the PaymentIntent later to
// see the history of payment attempts for a particular session.
//
// A PaymentIntent transitions through
// [multiple statuses](https://stripe.com/docs/payments/intents#intent-statuses)
// throughout its lifetime as it interfaces with Stripe.js to perform
// authentication flows and ultimately creates at most one successful charge.
//
// Related guide: [Payment Intents API](https://stripe.com/docs/payments/payment-intents)
type PaymentIntent struct {
	APIResource
	// Amount intended to be collected by this PaymentIntent. A positive integer representing how much to charge in the [smallest currency unit](https://stripe.com/docs/currencies#zero-decimal) (e.g., 100 cents to charge $1.00 or 100 to charge ¥100, a zero-decimal currency). The minimum amount is $0.50 US or [equivalent in charge currency](https://stripe.com/docs/currencies#minimum-and-maximum-charge-amounts). The amount value supports up to eight digits (e.g., a value of 99999999 for a USD charge of $999,999.99).
	Amount int64 `json:"amount"`
	// Amount that can be captured from this PaymentIntent.
	AmountCapturable int64                       `json:"amount_capturable"`
	AmountDetails    *PaymentIntentAmountDetails `json:"amount_details"`
	// Amount that was collected by this PaymentIntent.
	AmountReceived int64 `json:"amount_received"`
	// ID of the Connect application that created the PaymentIntent.
	Application *Application `json:"application"`
	// The amount of the application fee (if any) that will be requested to be applied to the payment and transferred to the application owner's Stripe account. The amount of the application fee collected will be capped at the total payment amount. For more information, see the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts).
	ApplicationFeeAmount int64 `json:"application_fee_amount"`
	// Settings to configure compatible payment methods from the [Stripe Dashboard](https://dashboard.stripe.com/settings/payment_methods)
	AutomaticPaymentMethods *PaymentIntentAutomaticPaymentMethods `json:"automatic_payment_methods"`
	// Populated when `status` is `canceled`, this is the time at which the PaymentIntent was canceled. Measured in seconds since the Unix epoch.
	CanceledAt int64 `json:"canceled_at"`
	// Reason for cancellation of this PaymentIntent, either user-provided (`duplicate`, `fraudulent`, `requested_by_customer`, or `abandoned`) or generated by Stripe internally (`failed_invoice`, `void_invoice`, or `automatic`).
	CancellationReason PaymentIntentCancellationReason `json:"cancellation_reason"`
	// Controls when the funds will be captured from the customer's account.
	CaptureMethod PaymentIntentCaptureMethod `json:"capture_method"`
	// The client secret of this PaymentIntent. Used for client-side retrieval using a publishable key.
	//
	// The client secret can be used to complete a payment from your frontend. It should not be stored, logged, or exposed to anyone other than the customer. Make sure that you have TLS enabled on any page that includes the client secret.
	//
	// Refer to our docs to [accept a payment](https://stripe.com/docs/payments/accept-a-payment?ui=elements) and learn about how `client_secret` should be handled.
	ClientSecret       string                          `json:"client_secret"`
	ConfirmationMethod PaymentIntentConfirmationMethod `json:"confirmation_method"`
	// Time at which the object was created. Measured in seconds since the Unix epoch.
	Created int64 `json:"created"`
	// Three-letter [ISO currency code](https://www.iso.org/iso-4217-currency-codes.html), in lowercase. Must be a [supported currency](https://stripe.com/docs/currencies).
	Currency Currency `json:"currency"`
	// ID of the Customer this PaymentIntent belongs to, if one exists.
	//
	// Payment methods attached to other Customers cannot be used with this PaymentIntent.
	//
	// If present in combination with [setup_future_usage](https://stripe.com/docs/api#payment_intent_object-setup_future_usage), this PaymentIntent's payment method will be attached to the Customer after the PaymentIntent has been confirmed and any required actions from the user are complete.
	Customer *Customer `json:"customer"`
	// An arbitrary string attached to the object. Often useful for displaying to users.
	Description string `json:"description"`
	// Unique identifier for the object.
	ID string `json:"id"`
	// ID of the invoice that created this PaymentIntent, if it exists.
	Invoice *Invoice `json:"invoice"`
	// The payment error encountered in the previous PaymentIntent confirmation. It will be cleared if the PaymentIntent is later updated for any reason.
	LastPaymentError *Error `json:"last_payment_error"`
	// The latest charge created by this payment intent.
	LatestCharge *Charge `json:"latest_charge"`
	// Has the value `true` if the object exists in live mode or the value `false` if the object exists in test mode.
	Livemode bool `json:"livemode"`
	// Set of [key-value pairs](https://stripe.com/docs/api/metadata) that you can attach to an object. This can be useful for storing additional information about the object in a structured format. For more information, see the [documentation](https://stripe.com/docs/payments/payment-intents/creating-payment-intents#storing-information-in-metadata).
	Metadata map[string]string `json:"metadata"`
	// If present, this property tells you what actions you need to take in order for your customer to fulfill a payment using the provided source.
	NextAction *PaymentIntentNextAction `json:"next_action"`
	// String representing the object's type. Objects of the same type share the same value.
	Object string `json:"object"`
	// The account (if any) for which the funds of the PaymentIntent are intended. See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts) for details.
	OnBehalfOf *Account `json:"on_behalf_of"`
	// ID of the payment method used in this PaymentIntent.
	PaymentMethod *PaymentMethod `json:"payment_method"`
	// Payment-method-specific configuration for this PaymentIntent.
	PaymentMethodOptions *PaymentIntentPaymentMethodOptions `json:"payment_method_options"`
	// The list of payment method types (e.g. card) that this PaymentIntent is allowed to use.
	PaymentMethodTypes []string `json:"payment_method_types"`
	// If present, this property tells you about the processing state of the payment.
	Processing *PaymentIntentProcessing `json:"processing"`
	// Email address that the receipt for the resulting payment will be sent to. If `receipt_email` is specified for a payment in live mode, a receipt will be sent regardless of your [email settings](https://dashboard.stripe.com/account/emails).
	ReceiptEmail string `json:"receipt_email"`
	// ID of the review associated with this PaymentIntent, if any.
	Review *Review `json:"review"`
	// Indicates that you intend to make future payments with this PaymentIntent's payment method.
	//
	// Providing this parameter will [attach the payment method](https://stripe.com/docs/payments/save-during-payment) to the PaymentIntent's Customer, if present, after the PaymentIntent is confirmed and any required actions from the user are complete. If no Customer was provided, the payment method can still be [attached](https://stripe.com/docs/api/payment_methods/attach) to a Customer after the transaction completes.
	//
	// When processing card payments, Stripe also uses `setup_future_usage` to dynamically optimize your payment flow and comply with regional legislation and network rules, such as [SCA](https://stripe.com/docs/strong-customer-authentication).
	SetupFutureUsage PaymentIntentSetupFutureUsage `json:"setup_future_usage"`
	// Shipping information for this PaymentIntent.
	Shipping *ShippingDetails `json:"shipping"`
	// This is a legacy field that will be removed in the future. It is the ID of the Source object that is associated with this PaymentIntent, if one was supplied.
	Source *PaymentSource `json:"source"`
	// For non-card charges, you can use this value as the complete description that appears on your customers' statements. Must contain at least one letter, maximum 22 characters.
	StatementDescriptor string `json:"statement_descriptor"`
	// Provides information about a card payment that customers see on their statements. Concatenated with the prefix (shortened descriptor) or statement descriptor that's set on the account to form the complete statement descriptor. Maximum 22 characters for the concatenated descriptor.
	StatementDescriptorSuffix string `json:"statement_descriptor_suffix"`
	// Status of this PaymentIntent, one of `requires_payment_method`, `requires_confirmation`, `requires_action`, `processing`, `requires_capture`, `canceled`, or `succeeded`. Read more about each PaymentIntent [status](https://stripe.com/docs/payments/intents#intent-statuses).
	Status PaymentIntentStatus `json:"status"`
	// The data with which to automatically create a Transfer when the payment is finalized. See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts) for details.
	TransferData *PaymentIntentTransferData `json:"transfer_data"`
	// A string that identifies the resulting payment as part of a group. See the PaymentIntents [use case for connected accounts](https://stripe.com/docs/payments/connected-accounts) for details.
	TransferGroup string `json:"transfer_group"`
}

// PaymentIntentList is a list of PaymentIntents as retrieved from a list endpoint.
type PaymentIntentList struct {
	APIResource
	ListMeta
	Data []*PaymentIntent `json:"data"`
}

// PaymentIntentSearchResult is a list of PaymentIntent search results as retrieved from a search endpoint.
type PaymentIntentSearchResult struct {
	APIResource
	SearchMeta
	Data []*PaymentIntent `json:"data"`
}

// UnmarshalJSON handles deserialization of a PaymentIntent.
// This custom unmarshaling is needed because the resulting
// property may be an id or the full struct if it was expanded.
func (p *PaymentIntent) UnmarshalJSON(data []byte) error {
	if id, ok := ParseID(data); ok {
		p.ID = id
		return nil
	}

	type paymentIntent PaymentIntent
	var v paymentIntent
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}

	*p = PaymentIntent(v)
	return nil
}
