// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Gets the documentation parts of an API. The result may be filtered by the
// type, name, or path of API entities (targets).
type GetDocumentationPartsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The status of the API documentation parts to retrieve. Valid values are DOCUMENTED
	// for retrieving DocumentationPart resources with content and UNDOCUMENTED
	// for DocumentationPart resources without content.
	LocationStatus LocationStatusType `location:"querystring" locationName:"locationStatus" type:"string" enum:"true"`

	// The name of API entities of the to-be-retrieved documentation parts.
	NameQuery *string `location:"querystring" locationName:"name" type:"string"`

	// The path of API entities of the to-be-retrieved documentation parts.
	Path *string `location:"querystring" locationName:"path" type:"string"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The type of API entities of the to-be-retrieved documentation parts.
	Type DocumentationPartType `location:"querystring" locationName:"type" type:"string" enum:"true"`
}

// String returns the string representation
func (s GetDocumentationPartsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentationPartsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDocumentationPartsInput"}

	if s.RestApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RestApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDocumentationPartsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "restapi_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "limit", protocol.Int64Value(v), metadata)
	}
	if len(s.LocationStatus) > 0 {
		v := s.LocationStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "locationStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.NameQuery != nil {
		v := *s.NameQuery

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "position", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The collection of documentation parts of an API.
//
// Documenting an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html),
// DocumentationPart
type GetDocumentationPartsOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []DocumentationPart `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetDocumentationPartsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDocumentationPartsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "position", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetDocumentationParts = "GetDocumentationParts"

// GetDocumentationPartsRequest returns a request value for making API operation for
// Amazon API Gateway.
//
//    // Example sending a request using GetDocumentationPartsRequest.
//    req := client.GetDocumentationPartsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetDocumentationPartsRequest(input *GetDocumentationPartsInput) GetDocumentationPartsRequest {
	op := &aws.Operation{
		Name:       opGetDocumentationParts,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/documentation/parts",
	}

	if input == nil {
		input = &GetDocumentationPartsInput{}
	}

	req := c.newRequest(op, input, &GetDocumentationPartsOutput{})
	return GetDocumentationPartsRequest{Request: req, Input: input, Copy: c.GetDocumentationPartsRequest}
}

// GetDocumentationPartsRequest is the request type for the
// GetDocumentationParts API operation.
type GetDocumentationPartsRequest struct {
	*aws.Request
	Input *GetDocumentationPartsInput
	Copy  func(*GetDocumentationPartsInput) GetDocumentationPartsRequest
}

// Send marshals and sends the GetDocumentationParts API request.
func (r GetDocumentationPartsRequest) Send(ctx context.Context) (*GetDocumentationPartsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDocumentationPartsResponse{
		GetDocumentationPartsOutput: r.Request.Data.(*GetDocumentationPartsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDocumentationPartsResponse is the response type for the
// GetDocumentationParts API operation.
type GetDocumentationPartsResponse struct {
	*GetDocumentationPartsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDocumentationParts request.
func (r *GetDocumentationPartsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
